/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.messages.ModbusInputStream;
import com.tridium.modbusCore.messages.ModbusMessageConst;
import com.tridium.modbusCore.messages.ModbusReceivedMessage;
import com.tridium.modbusCore.messages.ModbusResponse;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.sys.BBoolean;
import javax.baja.sys.Property;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ModbusMessage
extends Message
implements ModbusMessageConst {
    static final char[] constCRCHi;
    static final char[] constCRCLo;
    private static Object idLock;
    private static int nextId;
    public int deviceAddress;
    public int functionCode;
    public int startAddress;
    public int numberPoints;
    public int comType;
    public BModbusDevice modbusDevice;
    public int transactionIdentifier;

    public void writeRtu(OutputStream outputStream) throws IOException {
    }

    public void writeAscii(OutputStream outputStream) throws IOException {
    }

    public void writeTcp(OutputStream outputStream) throws IOException {
    }

    public void write(OutputStream outputStream) {
        try {
            switch (this.comType) {
                case 0: {
                    this.writeAscii(outputStream);
                    return;
                }
                case 1: {
                    this.writeRtu(outputStream);
                    return;
                }
                case 2: {
                    this.writeTcp(outputStream);
                    return;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception writing Modbus Message: ");
            exception.printStackTrace();
        }
    }

    public int getResponseMsgSize() {
        switch (this.functionCode) {
            case 3: 
            case 4: {
                return 5 + this.numberPoints * 2;
            }
            case 1: 
            case 2: {
                if (this.numberPoints % 8 == 0) {
                    return 5 + this.numberPoints / 8;
                }
                return 6 + this.numberPoints / 8;
            }
            case 16: {
                return 8;
            }
            case 6: {
                return 8;
            }
            case 5: {
                return 8;
            }
            case 15: {
                return 8;
            }
        }
        return 5;
    }

    protected Message toResponseAscii(ReceivedMessage receivedMessage) {
        ModbusReceivedMessage modbusReceivedMessage = (ModbusReceivedMessage)receivedMessage;
        byte[] byArray = modbusReceivedMessage.getBytes();
        ModbusInputStream modbusInputStream = new ModbusInputStream(byArray);
        ModbusResponse modbusResponse = new ModbusResponse(this.comType, this.modbusDevice);
        if (modbusInputStream.read() != 58) {
            modbusResponse.exceptionCode = -4;
            return modbusResponse;
        }
        int n = modbusReceivedMessage.getLength();
        if (n <= 4) {
            modbusResponse.exceptionCode = -4;
            return modbusResponse;
        }
        byte[] byArray2 = new byte[n - 4];
        System.arraycopy(byArray, 0, byArray2, 0, n - 4);
        int n2 = ModbusMessage.calcLRC(ModbusInputStream.convertAscii2Rtu(byArray2));
        byte[] byArray3 = new byte[]{byArray[n - 4], byArray[n - 3]};
        ModbusInputStream modbusInputStream2 = new ModbusInputStream(byArray3);
        int n3 = modbusInputStream2.readHexByte();
        if (n2 != n3) {
            modbusResponse.exceptionCode = -5;
            if (this.modbusDevice != null) {
                this.modbusDevice.incrementLrcErrors();
            }
            return modbusResponse;
        }
        modbusResponse.deviceAddress = modbusInputStream.readHexByte() & 0xFF;
        modbusResponse.functionCode = modbusInputStream.readHexByte() & 0xFF;
        modbusResponse.startAddress = this.startAddress;
        modbusResponse.numberPoints = this.numberPoints;
        if ((modbusResponse.functionCode & 0x80) != 0) {
            modbusResponse.exceptionCode = modbusInputStream.readHexByte();
            return modbusResponse;
        }
        if (modbusResponse.functionCode != this.functionCode || modbusResponse.deviceAddress != this.deviceAddress) {
            modbusResponse.exceptionCode = -4;
            return modbusResponse;
        }
        modbusResponse.exceptionCode = 0;
        switch (modbusResponse.functionCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 23: {
                modbusResponse.byteCount = modbusInputStream.readHexByte() & 0xFF;
                int n4 = 0;
                while (n4 < modbusResponse.byteCount) {
                    modbusResponse.data[n4] = (byte)(modbusInputStream.readHexByte() & 0xFF);
                    ++n4;
                }
                break;
            }
        }
        return modbusResponse;
    }

    public Message toResponse(ReceivedMessage receivedMessage) {
        int n;
        if (this.comType == 0) {
            return this.toResponseAscii(receivedMessage);
        }
        ModbusReceivedMessage modbusReceivedMessage = (ModbusReceivedMessage)receivedMessage;
        byte[] byArray = modbusReceivedMessage.getBytes();
        ModbusResponse modbusResponse = new ModbusResponse(this.comType, this.modbusDevice);
        modbusResponse.deviceAddress = byArray[0] & 0xFF;
        modbusResponse.functionCode = byArray[1] & 0xFF;
        modbusResponse.startAddress = this.startAddress;
        modbusResponse.numberPoints = this.numberPoints;
        if (this.comType == 1) {
            n = modbusReceivedMessage.getLength();
            if (n <= 2) {
                modbusResponse.exceptionCode = -4;
                return modbusResponse;
            }
            byte[] byArray2 = new byte[n - 2];
            System.arraycopy(byArray, 0, byArray2, 0, n - 2);
            int n2 = ModbusMessage.calcCRC(byArray2);
            int n3 = (byArray[n - 2] & 0xFF) << 8;
            if (n2 != (n3 |= byArray[n - 1] & 0xFF)) {
                modbusResponse.exceptionCode = -1;
                if (this.modbusDevice != null) {
                    this.modbusDevice.incrementCrcErrors();
                }
                return modbusResponse;
            }
        } else if (this.comType == 2) {
            n = 0;
            try {
                if (this.modbusDevice != null) {
                    n = ((BBoolean)this.modbusDevice.get("disableTransactionIdCheck")).getBoolean() ? 1 : 0;
                }
            }
            catch (Exception exception) {}
            if (n == 0 && this.transactionIdentifier != modbusReceivedMessage.getTransactionId()) {
                modbusResponse.exceptionCode = -4;
                if (this.modbusDevice != null) {
                    this.modbusDevice.incrementTransactionIdErrors();
                    if (this.modbusDevice.modbusNet() != null && this.modbusDevice.modbusNet().getModbusLog().isTraceOn()) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("Received invalid transaction ID in response (expected ");
                        stringBuffer.append(this.transactionIdentifier).append(", received ");
                        stringBuffer.append(modbusReceivedMessage.getTransactionId()).append(")");
                        this.modbusDevice.modbusNet().getModbusLog().trace(stringBuffer.toString());
                    }
                }
                return modbusResponse;
            }
            modbusResponse.transactionIdentifier = this.transactionIdentifier;
        }
        try {
            if (byArray[1] < 0) {
                modbusResponse.exceptionCode = byArray[2];
                return modbusResponse;
            }
            if (modbusResponse.functionCode != this.functionCode || modbusResponse.deviceAddress != this.deviceAddress) {
                modbusResponse.exceptionCode = -4;
                return modbusResponse;
            }
            modbusResponse.exceptionCode = 0;
            switch (byArray[1]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 23: {
                    modbusResponse.byteCount = byArray[2] & 0xFF;
                    n = 0;
                    while (n < modbusResponse.byteCount) {
                        modbusResponse.data[n] = byArray[3 + n];
                        ++n;
                    }
                    break;
                }
            }
            return modbusResponse;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            modbusResponse.exceptionCode = -4;
            return modbusResponse;
        }
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "RTU";
        if (this.comType == 0) {
            string = "ASCII";
        } else if (this.comType == 2) {
            string = "TCP";
        }
        stringBuffer.append("Modbus " + string + " Message = " + TextUtil.getClassName(this.getClass()));
        stringBuffer.append("\n  Tag = " + this.getTag());
        stringBuffer.append("\n  Modbus Device Address = " + (this.deviceAddress & 0xFF));
        stringBuffer.append("\n  Modbus Function Code = " + this.functionCode);
        stringBuffer.append("\n  Modbus Data Starting Address = " + this.startAddress);
        stringBuffer.append("\n  Modbus Number of Data Points = " + this.numberPoints);
        return stringBuffer.toString();
    }

    public static int calcLRC(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n += byArray[n2] & 0xFF;
            ++n2;
        }
        n &= 0xFF;
        n = 255 - n & 0xFF;
        return ++n;
    }

    public static boolean verifyLRC(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length - 2) {
            n += byArray[n2] & 0xFF;
            ++n2;
        }
        n &= 0xFF;
        n = 255 - n & 0xFF;
        boolean bl = false;
        if ((++n & 0xFF) == (byArray[byArray.length - 2] & 0xFF)) {
            bl = true;
        }
        return bl;
    }

    public static int calcCRC(byte[] byArray) {
        int n = 255;
        int n2 = 255;
        int n3 = 0;
        while (n3 < byArray.length) {
            int n4 = byArray[n3] & 0xFF;
            int n5 = n ^ n4;
            n = n2 ^ constCRCHi[n5];
            n2 = constCRCLo[n5];
            ++n3;
        }
        return n * 256 + n2;
    }

    public static boolean verifyCRC(byte[] byArray) {
        int n = 255;
        int n2 = 255;
        int n3 = 0;
        while (n3 < byArray.length - 2) {
            int n4 = byArray[n3] & 0xFF;
            int n5 = n ^ n4;
            n = n2 ^ constCRCHi[n5];
            n2 = constCRCLo[n5];
            ++n3;
        }
        boolean bl = false;
        if ((byArray[byArray.length - 2] & 0xFF) == n && (byArray[byArray.length - 1] & 0xFF) == n2) {
            bl = true;
        }
        return bl;
    }

    protected int getMaxTransactionId() {
        int n = -1;
        try {
            Property property = this.modbusDevice.getProperty("maxTransactionId");
            if (property != null) {
                n = this.modbusDevice.getInt(property);
            }
        }
        catch (Exception exception) {}
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static int getNextTransactionId(int n) {
        Object object = idLock;
        synchronized (object) {
            if (nextId >= n) {
                nextId = 0;
            }
            return ++nextId;
        }
    }

    private final /* synthetic */ void this() {
        this.deviceAddress = -1;
        this.transactionIdentifier = -1;
    }

    public ModbusMessage(int n, BModbusDevice bModbusDevice) {
        int n2;
        this.this();
        this.comType = n;
        this.modbusDevice = bModbusDevice;
        this.comType = n2 = bModbusDevice.getModbusMode();
    }

    static {
        char[] cArray = new char[256];
        cArray[1] = 193;
        cArray[2] = 129;
        cArray[3] = 64;
        cArray[4] = '\u0001';
        cArray[5] = 192;
        cArray[6] = 128;
        cArray[7] = 65;
        cArray[8] = '\u0001';
        cArray[9] = 192;
        cArray[10] = 128;
        cArray[11] = 65;
        cArray[13] = 193;
        cArray[14] = 129;
        cArray[15] = 64;
        cArray[16] = '\u0001';
        cArray[17] = 192;
        cArray[18] = 128;
        cArray[19] = 65;
        cArray[21] = 193;
        cArray[22] = 129;
        cArray[23] = 64;
        cArray[25] = 193;
        cArray[26] = 129;
        cArray[27] = 64;
        cArray[28] = '\u0001';
        cArray[29] = 192;
        cArray[30] = 128;
        cArray[31] = 65;
        cArray[32] = '\u0001';
        cArray[33] = 192;
        cArray[34] = 128;
        cArray[35] = 65;
        cArray[37] = 193;
        cArray[38] = 129;
        cArray[39] = 64;
        cArray[41] = 193;
        cArray[42] = 129;
        cArray[43] = 64;
        cArray[44] = '\u0001';
        cArray[45] = 192;
        cArray[46] = 128;
        cArray[47] = 65;
        cArray[49] = 193;
        cArray[50] = 129;
        cArray[51] = 64;
        cArray[52] = '\u0001';
        cArray[53] = 192;
        cArray[54] = 128;
        cArray[55] = 65;
        cArray[56] = '\u0001';
        cArray[57] = 192;
        cArray[58] = 128;
        cArray[59] = 65;
        cArray[61] = 193;
        cArray[62] = 129;
        cArray[63] = 64;
        cArray[64] = '\u0001';
        cArray[65] = 192;
        cArray[66] = 128;
        cArray[67] = 65;
        cArray[69] = 193;
        cArray[70] = 129;
        cArray[71] = 64;
        cArray[73] = 193;
        cArray[74] = 129;
        cArray[75] = 64;
        cArray[76] = '\u0001';
        cArray[77] = 192;
        cArray[78] = 128;
        cArray[79] = 65;
        cArray[81] = 193;
        cArray[82] = 129;
        cArray[83] = 64;
        cArray[84] = '\u0001';
        cArray[85] = 192;
        cArray[86] = 128;
        cArray[87] = 65;
        cArray[88] = '\u0001';
        cArray[89] = 192;
        cArray[90] = 128;
        cArray[91] = 65;
        cArray[93] = 193;
        cArray[94] = 129;
        cArray[95] = 64;
        cArray[97] = 193;
        cArray[98] = 129;
        cArray[99] = 64;
        cArray[100] = '\u0001';
        cArray[101] = 192;
        cArray[102] = 128;
        cArray[103] = 65;
        cArray[104] = '\u0001';
        cArray[105] = 192;
        cArray[106] = 128;
        cArray[107] = 65;
        cArray[109] = 193;
        cArray[110] = 129;
        cArray[111] = 64;
        cArray[112] = '\u0001';
        cArray[113] = 192;
        cArray[114] = 128;
        cArray[115] = 65;
        cArray[117] = 193;
        cArray[118] = 129;
        cArray[119] = 64;
        cArray[121] = 193;
        cArray[122] = 129;
        cArray[123] = 64;
        cArray[124] = '\u0001';
        cArray[125] = 192;
        cArray[126] = 128;
        cArray[127] = 65;
        cArray[128] = '\u0001';
        cArray[129] = 192;
        cArray[130] = 128;
        cArray[131] = 65;
        cArray[133] = 193;
        cArray[134] = 129;
        cArray[135] = 64;
        cArray[137] = 193;
        cArray[138] = 129;
        cArray[139] = 64;
        cArray[140] = '\u0001';
        cArray[141] = 192;
        cArray[142] = 128;
        cArray[143] = 65;
        cArray[145] = 193;
        cArray[146] = 129;
        cArray[147] = 64;
        cArray[148] = '\u0001';
        cArray[149] = 192;
        cArray[150] = 128;
        cArray[151] = 65;
        cArray[152] = '\u0001';
        cArray[153] = 192;
        cArray[154] = 128;
        cArray[155] = 65;
        cArray[157] = 193;
        cArray[158] = 129;
        cArray[159] = 64;
        cArray[161] = 193;
        cArray[162] = 129;
        cArray[163] = 64;
        cArray[164] = '\u0001';
        cArray[165] = 192;
        cArray[166] = 128;
        cArray[167] = 65;
        cArray[168] = '\u0001';
        cArray[169] = 192;
        cArray[170] = 128;
        cArray[171] = 65;
        cArray[173] = 193;
        cArray[174] = 129;
        cArray[175] = 64;
        cArray[176] = '\u0001';
        cArray[177] = 192;
        cArray[178] = 128;
        cArray[179] = 65;
        cArray[181] = 193;
        cArray[182] = 129;
        cArray[183] = 64;
        cArray[185] = 193;
        cArray[186] = 129;
        cArray[187] = 64;
        cArray[188] = '\u0001';
        cArray[189] = 192;
        cArray[190] = 128;
        cArray[191] = 65;
        cArray[193] = 193;
        cArray[194] = 129;
        cArray[195] = 64;
        cArray[196] = '\u0001';
        cArray[197] = 192;
        cArray[198] = 128;
        cArray[199] = 65;
        cArray[200] = '\u0001';
        cArray[201] = 192;
        cArray[202] = 128;
        cArray[203] = 65;
        cArray[205] = 193;
        cArray[206] = 129;
        cArray[207] = 64;
        cArray[208] = '\u0001';
        cArray[209] = 192;
        cArray[210] = 128;
        cArray[211] = 65;
        cArray[213] = 193;
        cArray[214] = 129;
        cArray[215] = 64;
        cArray[217] = 193;
        cArray[218] = 129;
        cArray[219] = 64;
        cArray[220] = '\u0001';
        cArray[221] = 192;
        cArray[222] = 128;
        cArray[223] = 65;
        cArray[224] = '\u0001';
        cArray[225] = 192;
        cArray[226] = 128;
        cArray[227] = 65;
        cArray[229] = 193;
        cArray[230] = 129;
        cArray[231] = 64;
        cArray[233] = 193;
        cArray[234] = 129;
        cArray[235] = 64;
        cArray[236] = '\u0001';
        cArray[237] = 192;
        cArray[238] = 128;
        cArray[239] = 65;
        cArray[241] = 193;
        cArray[242] = 129;
        cArray[243] = 64;
        cArray[244] = '\u0001';
        cArray[245] = 192;
        cArray[246] = 128;
        cArray[247] = 65;
        cArray[248] = '\u0001';
        cArray[249] = 192;
        cArray[250] = 128;
        cArray[251] = 65;
        cArray[253] = 193;
        cArray[254] = 129;
        cArray[255] = 64;
        constCRCHi = cArray;
        char[] cArray2 = new char[256];
        cArray2[1] = 192;
        cArray2[2] = 193;
        cArray2[3] = '\u0001';
        cArray2[4] = 195;
        cArray2[5] = 3;
        cArray2[6] = 2;
        cArray2[7] = 194;
        cArray2[8] = 198;
        cArray2[9] = 6;
        cArray2[10] = 7;
        cArray2[11] = 199;
        cArray2[12] = 5;
        cArray2[13] = 197;
        cArray2[14] = 196;
        cArray2[15] = 4;
        cArray2[16] = 204;
        cArray2[17] = 12;
        cArray2[18] = 13;
        cArray2[19] = 205;
        cArray2[20] = 15;
        cArray2[21] = 207;
        cArray2[22] = 206;
        cArray2[23] = 14;
        cArray2[24] = 10;
        cArray2[25] = 202;
        cArray2[26] = 203;
        cArray2[27] = 11;
        cArray2[28] = 201;
        cArray2[29] = 9;
        cArray2[30] = 8;
        cArray2[31] = 200;
        cArray2[32] = 216;
        cArray2[33] = 24;
        cArray2[34] = 25;
        cArray2[35] = 217;
        cArray2[36] = 27;
        cArray2[37] = 219;
        cArray2[38] = 218;
        cArray2[39] = 26;
        cArray2[40] = 30;
        cArray2[41] = 222;
        cArray2[42] = 223;
        cArray2[43] = 31;
        cArray2[44] = 221;
        cArray2[45] = 29;
        cArray2[46] = 28;
        cArray2[47] = 220;
        cArray2[48] = 20;
        cArray2[49] = 212;
        cArray2[50] = 213;
        cArray2[51] = 21;
        cArray2[52] = 215;
        cArray2[53] = 23;
        cArray2[54] = 22;
        cArray2[55] = 214;
        cArray2[56] = 210;
        cArray2[57] = 18;
        cArray2[58] = 19;
        cArray2[59] = 211;
        cArray2[60] = 17;
        cArray2[61] = 209;
        cArray2[62] = 208;
        cArray2[63] = 16;
        cArray2[64] = 240;
        cArray2[65] = 48;
        cArray2[66] = 49;
        cArray2[67] = 241;
        cArray2[68] = 51;
        cArray2[69] = 243;
        cArray2[70] = 242;
        cArray2[71] = 50;
        cArray2[72] = 54;
        cArray2[73] = 246;
        cArray2[74] = 247;
        cArray2[75] = 55;
        cArray2[76] = 245;
        cArray2[77] = 53;
        cArray2[78] = 52;
        cArray2[79] = 244;
        cArray2[80] = 60;
        cArray2[81] = 252;
        cArray2[82] = 253;
        cArray2[83] = 61;
        cArray2[84] = 255;
        cArray2[85] = 63;
        cArray2[86] = 62;
        cArray2[87] = 254;
        cArray2[88] = 250;
        cArray2[89] = 58;
        cArray2[90] = 59;
        cArray2[91] = 251;
        cArray2[92] = 57;
        cArray2[93] = 249;
        cArray2[94] = 248;
        cArray2[95] = 56;
        cArray2[96] = 40;
        cArray2[97] = 232;
        cArray2[98] = 233;
        cArray2[99] = 41;
        cArray2[100] = 235;
        cArray2[101] = 43;
        cArray2[102] = 42;
        cArray2[103] = 234;
        cArray2[104] = 238;
        cArray2[105] = 46;
        cArray2[106] = 47;
        cArray2[107] = 239;
        cArray2[108] = 45;
        cArray2[109] = 237;
        cArray2[110] = 236;
        cArray2[111] = 44;
        cArray2[112] = 228;
        cArray2[113] = 36;
        cArray2[114] = 37;
        cArray2[115] = 229;
        cArray2[116] = 39;
        cArray2[117] = 231;
        cArray2[118] = 230;
        cArray2[119] = 38;
        cArray2[120] = 34;
        cArray2[121] = 226;
        cArray2[122] = 227;
        cArray2[123] = 35;
        cArray2[124] = 225;
        cArray2[125] = 33;
        cArray2[126] = 32;
        cArray2[127] = 224;
        cArray2[128] = 160;
        cArray2[129] = 96;
        cArray2[130] = 97;
        cArray2[131] = 161;
        cArray2[132] = 99;
        cArray2[133] = 163;
        cArray2[134] = 162;
        cArray2[135] = 98;
        cArray2[136] = 102;
        cArray2[137] = 166;
        cArray2[138] = 167;
        cArray2[139] = 103;
        cArray2[140] = 165;
        cArray2[141] = 101;
        cArray2[142] = 100;
        cArray2[143] = 164;
        cArray2[144] = 108;
        cArray2[145] = 172;
        cArray2[146] = 173;
        cArray2[147] = 109;
        cArray2[148] = 175;
        cArray2[149] = 111;
        cArray2[150] = 110;
        cArray2[151] = 174;
        cArray2[152] = 170;
        cArray2[153] = 106;
        cArray2[154] = 107;
        cArray2[155] = 171;
        cArray2[156] = 105;
        cArray2[157] = 169;
        cArray2[158] = 168;
        cArray2[159] = 104;
        cArray2[160] = 120;
        cArray2[161] = 184;
        cArray2[162] = 185;
        cArray2[163] = 121;
        cArray2[164] = 187;
        cArray2[165] = 123;
        cArray2[166] = 122;
        cArray2[167] = 186;
        cArray2[168] = 190;
        cArray2[169] = 126;
        cArray2[170] = 127;
        cArray2[171] = 191;
        cArray2[172] = 125;
        cArray2[173] = 189;
        cArray2[174] = 188;
        cArray2[175] = 124;
        cArray2[176] = 180;
        cArray2[177] = 116;
        cArray2[178] = 117;
        cArray2[179] = 181;
        cArray2[180] = 119;
        cArray2[181] = 183;
        cArray2[182] = 182;
        cArray2[183] = 118;
        cArray2[184] = 114;
        cArray2[185] = 178;
        cArray2[186] = 179;
        cArray2[187] = 115;
        cArray2[188] = 177;
        cArray2[189] = 113;
        cArray2[190] = 112;
        cArray2[191] = 176;
        cArray2[192] = 80;
        cArray2[193] = 144;
        cArray2[194] = 145;
        cArray2[195] = 81;
        cArray2[196] = 147;
        cArray2[197] = 83;
        cArray2[198] = 82;
        cArray2[199] = 146;
        cArray2[200] = 150;
        cArray2[201] = 86;
        cArray2[202] = 87;
        cArray2[203] = 151;
        cArray2[204] = 85;
        cArray2[205] = 149;
        cArray2[206] = 148;
        cArray2[207] = 84;
        cArray2[208] = 156;
        cArray2[209] = 92;
        cArray2[210] = 93;
        cArray2[211] = 157;
        cArray2[212] = 95;
        cArray2[213] = 159;
        cArray2[214] = 158;
        cArray2[215] = 94;
        cArray2[216] = 90;
        cArray2[217] = 154;
        cArray2[218] = 155;
        cArray2[219] = 91;
        cArray2[220] = 153;
        cArray2[221] = 89;
        cArray2[222] = 88;
        cArray2[223] = 152;
        cArray2[224] = 136;
        cArray2[225] = 72;
        cArray2[226] = 73;
        cArray2[227] = 137;
        cArray2[228] = 75;
        cArray2[229] = 139;
        cArray2[230] = 138;
        cArray2[231] = 74;
        cArray2[232] = 78;
        cArray2[233] = 142;
        cArray2[234] = 143;
        cArray2[235] = 79;
        cArray2[236] = 141;
        cArray2[237] = 77;
        cArray2[238] = 76;
        cArray2[239] = 140;
        cArray2[240] = 68;
        cArray2[241] = 132;
        cArray2[242] = 133;
        cArray2[243] = 69;
        cArray2[244] = 135;
        cArray2[245] = 71;
        cArray2[246] = 70;
        cArray2[247] = 134;
        cArray2[248] = 130;
        cArray2[249] = 66;
        cArray2[250] = 67;
        cArray2[251] = 131;
        cArray2[252] = 65;
        cArray2[253] = 129;
        cArray2[254] = 128;
        cArray2[255] = 64;
        constCRCLo = cArray2;
        idLock = new Object();
        nextId = 0;
    }
}

