/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.messages;

import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.messages.ModbusMessage;
import com.tridium.modbusCore.messages.ModbusOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.util.ByteArrayUtil;

public class ModbusFC23Request
extends ModbusMessage {
    public int byteCount;
    public int wrAddress;
    public int wrNumberPoints;
    public byte[] wrData;

    public int getResponseMsgSize() {
        return 5 + this.numberPoints * 2;
    }

    public final void writeRtu(OutputStream outputStream) throws IOException {
        ModbusOutputStream modbusOutputStream = this.formatMessage();
        modbusOutputStream.writeCRC();
        outputStream.write(modbusOutputStream.toByteArray());
    }

    public final void writeTcp(OutputStream outputStream) throws IOException {
        byte[] byArray = this.formatMessage().toByteArray();
        ModbusOutputStream modbusOutputStream = new ModbusOutputStream();
        if (this.transactionIdentifier < 0) {
            this.transactionIdentifier = ModbusFC23Request.getNextTransactionId(this.getMaxTransactionId());
        }
        modbusOutputStream.write((byte)((this.transactionIdentifier & 0xFF00) >> 8));
        modbusOutputStream.write((byte)(this.transactionIdentifier & 0xFF));
        modbusOutputStream.write((byte)0);
        modbusOutputStream.write((byte)0);
        int n = byArray.length;
        modbusOutputStream.write((byte)((n & 0xFF00) >> 8));
        modbusOutputStream.write((byte)(n & 0xFF));
        modbusOutputStream.write(byArray);
        outputStream.write(modbusOutputStream.toByteArray());
    }

    public final void writeAscii(OutputStream outputStream) throws IOException {
        ModbusOutputStream modbusOutputStream = this.formatMessage();
        modbusOutputStream.writeLRC();
        outputStream.write(modbusOutputStream.toAsciiHexByteArray());
    }

    private final ModbusOutputStream formatMessage() {
        ModbusOutputStream modbusOutputStream = new ModbusOutputStream();
        modbusOutputStream.write((byte)this.deviceAddress);
        modbusOutputStream.write((byte)this.functionCode);
        modbusOutputStream.write((byte)((this.startAddress & 0xFF00) >> 8));
        modbusOutputStream.write((byte)(this.startAddress & 0xFF));
        modbusOutputStream.write((byte)((this.numberPoints & 0xFF00) >> 8));
        modbusOutputStream.write((byte)(this.numberPoints & 0xFF));
        modbusOutputStream.write((byte)((this.wrAddress & 0xFF00) >> 8));
        modbusOutputStream.write((byte)(this.wrAddress & 0xFF));
        modbusOutputStream.write((byte)((this.wrNumberPoints & 0xFF00) >> 8));
        modbusOutputStream.write((byte)(this.wrNumberPoints & 0xFF));
        modbusOutputStream.write((byte)this.wrData.length);
        modbusOutputStream.write(this.wrData, 0, this.wrData.length);
        return modbusOutputStream;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        stringBuffer.append("\n  Modbus Byte Count = " + this.byteCount);
        stringBuffer.append("\n  Modbus Data = " + ByteArrayUtil.toHexString((byte[])this.wrData));
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.write(byteArrayOutputStream);
            stringBuffer.append("\n  Raw Bytes = " + ByteArrayUtil.toHexString((byte[])byteArrayOutputStream.toByteArray()));
        }
        catch (Exception exception) {}
        return stringBuffer.toString();
    }

    public ModbusFC23Request(int n, BModbusDevice bModbusDevice) {
        super(n, bModbusDevice);
    }

    public ModbusFC23Request(int n, BModbusDevice bModbusDevice, int n2, int n3, int n4, int n5, int n6, int n7, byte[] byArray) {
        super(n, bModbusDevice);
        this.deviceAddress = n2;
        this.functionCode = n3;
        this.startAddress = n6;
        this.numberPoints = n7;
        this.wrAddress = n4;
        this.wrNumberPoints = n5;
        this.wrData = byArray;
    }
}

