/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.datatypes;

import com.tridium.modbusCore.enums.BAddressFormatEnum;
import javax.baja.sys.BComplex;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BFlexAddress
extends BStruct {
    public static final Property addressFormat = BFlexAddress.newProperty((int)0, (BValue)BAddressFormatEnum.hex, null);
    public static final Property address = BFlexAddress.newProperty((int)0, (String)"0", null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$modbusCore$datatypes$BFlexAddress;

    public BAddressFormatEnum getAddressFormat() {
        return (BAddressFormatEnum)this.get(addressFormat);
    }

    public void setAddressFormat(BAddressFormatEnum bAddressFormatEnum) {
        this.set(addressFormat, (BValue)bAddressFormatEnum, null);
    }

    public String getAddress() {
        return this.getString(address);
    }

    public void setAddress(String string) {
        this.setString(address, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isHexFormat() {
        boolean bl = false;
        if (this.getAddressFormat() == BAddressFormatEnum.hex) {
            bl = true;
        }
        return bl;
    }

    public boolean isDecimalFormat() {
        boolean bl = false;
        if (this.getAddressFormat() == BAddressFormatEnum.decimal) {
            bl = true;
        }
        return bl;
    }

    public boolean isModbusFormat() {
        boolean bl = false;
        if (this.getAddressFormat() == BAddressFormatEnum.modbus) {
            bl = true;
        }
        return bl;
    }

    public boolean isValid() {
        int n = this.isHexFormat() ? Integer.valueOf(this.getAddress(), 16).intValue() : Integer.valueOf(this.getAddress()).intValue();
        if (this.isModbusFormat()) {
            boolean bl = false;
            if (n >= 0 && n < 50000) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if (n >= 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isModbusAnalogAddress() {
        if (this.isModbusFormat()) {
            int n = Integer.valueOf(this.getAddress());
            boolean bl = false;
            if (n >= 30000 && n < 50000) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public boolean isModbusDigitalAddress() {
        if (this.isModbusFormat()) {
            int n = Integer.valueOf(this.getAddress());
            boolean bl = false;
            if (n < 30000 && n >= 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public boolean isModbusHoldingAddress() {
        if (this.isModbusFormat()) {
            int n = Integer.valueOf(this.getAddress());
            boolean bl = false;
            if (n > 40000 && n < 50000) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public boolean isModbusInputAddress() {
        if (this.isModbusFormat()) {
            int n = Integer.valueOf(this.getAddress());
            boolean bl = false;
            if (n > 30000 && n < 40000) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public boolean isModbusCoilAddress() {
        if (this.isModbusFormat()) {
            int n = Integer.valueOf(this.getAddress());
            boolean bl = false;
            if (n < 10000 && n >= 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public boolean isModbusStatusAddress() {
        if (this.isModbusFormat()) {
            int n = Integer.valueOf(this.getAddress());
            boolean bl = false;
            if (n > 10000 && n < 20000) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public String getFlexAddress() {
        return this.getAddressFormat().getTag() + ':' + this.getAddress();
    }

    public int getDataAddress() {
        if (this.isHexFormat()) {
            return Integer.valueOf(this.getAddress(), 16);
        }
        if (this.isDecimalFormat()) {
            return Integer.valueOf(this.getAddress());
        }
        int n = Integer.valueOf(this.getAddress());
        if (n > 40000) {
            return n - 40001;
        }
        if (n > 30000) {
            return n - 30001;
        }
        if (n > 20000) {
            return n - 20001;
        }
        if (n > 10000) {
            return n - 10001;
        }
        return n - 1;
    }

    public int getDataAddressNoModbusAltering() {
        if (this.isHexFormat()) {
            return Integer.valueOf(this.getAddress(), 16);
        }
        return Integer.valueOf(this.getAddress());
    }

    public void setAddressFromInt(int n) {
        if (this.isHexFormat()) {
            this.setAddress(Integer.toString(n, 16));
        } else {
            this.setAddress(Integer.toString(n));
        }
    }

    public void setAddressFromString(String string) {
        int n;
        if (this.isHexFormat()) {
            try {
                n = Integer.valueOf(string, 16);
                string = "0000" + string;
                string = string.substring(string.length() - 4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Must enter address in Hex.");
            }
        }
        try {
            n = Integer.valueOf(string);
            string = "00000" + string;
            string = string.substring(string.length() - 5);
            if (this.isModbusFormat() && (n == 0 || n == 10000 || n == 30000 || n == 40000 || n >= 50000 || n >= 20000 && n < 30000)) {
                throw new RuntimeException("Illegal Modbus address: Must be 0x, 1x, 3x or 4x format.");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Must enter address in decimal.");
        }
        if (n > (char)-1) {
            if (this.isHexFormat()) {
                throw new RuntimeException("Address must be less than 10000 hex.");
            }
            throw new RuntimeException("Address must be less than 65536.");
        }
        this.setAddress(string);
    }

    public String toString(Context context) {
        return this.getAddressFormat().getTag() + ':' + this.getAddress();
    }

    public String toDebugString() {
        return this.getAddressFormat().getTag() + ':' + this.getAddress();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BFlexAddress() {
    }

    public BFlexAddress(BAddressFormatEnum bAddressFormatEnum, String string) {
        this.setAddressFormat(bAddressFormatEnum);
        this.setAddress(string);
    }

    public BFlexAddress(String string) {
        this.setAddressFormat((BAddressFormatEnum)BAddressFormatEnum.modbus.getRange().get(string.substring(0, string.indexOf(58))));
        this.setAddress(string.substring(string.indexOf(58) + 1, string.length()));
    }

    public BFlexAddress(BFlexAddress bFlexAddress) {
        this.copyFrom((BComplex)bFlexAddress);
    }

    static {
        Class clazz = class$com$tridium$modbusCore$datatypes$BFlexAddress;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$datatypes$BFlexAddress = BFlexAddress.class("[Lcom.tridium.modbusCore.datatypes.BFlexAddress;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

