/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.point;

import com.tridium.modbusCore.ModbusException;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigEntry;
import com.tridium.modbusCore.client.point.BModbusClientProxyExt;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BRegisterTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.messages.ModbusReadRequest;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.point.BIModbusStringProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusClientStringProxyExt
extends BModbusClientProxyExt
implements BIModbusStringProxyExt {
    public static final Property numberRegisters = BModbusClientStringProxyExt.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)Integer.MAX_VALUE));
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$modbusCore$client$point$BModbusClientStringProxyExt;

    public int getNumberRegisters() {
        return this.getInt(numberRegisters);
    }

    public void setNumberRegisters(int n) {
        this.setInt(numberRegisters, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.readonly;
    }

    public void read() {
        if (this.configFault) {
            return;
        }
        BModbusClientDevice bModbusClientDevice = (BModbusClientDevice)this.getDevice();
        int n = bModbusClientDevice.getDeviceAddress();
        int n2 = this.getAbsoluteAddress().getDataAddress();
        int n3 = this.getNumberRegisters();
        int n4 = 3;
        ModbusReadRequest modbusReadRequest = new ModbusReadRequest(((BModbusClientNetwork)bModbusClientDevice.modbusNet()).getModbusMode(), bModbusClientDevice, n, n4, n2, n3);
        ModbusResponse modbusResponse = (ModbusResponse)bModbusClientDevice.sendModbusMessage(modbusReadRequest);
        if (modbusResponse == null) {
            modbusResponse = new ModbusResponse(((BModbusClientNetwork)bModbusClientDevice.modbusNet()).getModbusMode(), bModbusClientDevice);
            modbusResponse.exceptionCode = 9;
        }
        this.setOutValues(modbusResponse);
    }

    public void setOutValues(ModbusResponse modbusResponse) {
        if (!modbusResponse.isError()) {
            this.setStringOutValues(modbusResponse);
        } else {
            this.readFail(modbusResponse.getExceptionString());
        }
    }

    private final void setStringOutValues(ModbusResponse modbusResponse) {
        String string;
        try {
            string = modbusResponse.getString(this.getNumberRegisters());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.readFail("error parsing String value (" + illegalArgumentException + ')');
            return;
        }
        this.readOk((BStatusValue)new BStatusString(string));
    }

    public BRegisterTypesEnum determineRegisterType() {
        return BRegisterTypesEnum.holdingRegister;
    }

    public BEnum getRegisterType() {
        return BRegisterTypeEnum.holding;
    }

    public int determineNumRegisters() {
        return this.getNumberRegisters();
    }

    public boolean isValidAddress(BFlexAddress bFlexAddress) {
        if (bFlexAddress.isModbusFormat() && bFlexAddress.isModbusAnalogAddress()) {
            return bFlexAddress.isModbusHoldingAddress();
        }
        return bFlexAddress.isValid();
    }

    public void devicePoll(BDevicePollConfigEntry bDevicePollConfigEntry) {
        block3: {
            if (this.configFault || this.isUnoperational()) {
                return;
            }
            BModbusClientDevice bModbusClientDevice = (BModbusClientDevice)this.getDevice();
            int n = this.getNumberRegisters();
            ModbusResponse modbusResponse = new ModbusResponse(((BModbusClientNetwork)bModbusClientDevice.modbusNet()).getModbusMode(), bModbusClientDevice);
            int n2 = this.getAbsoluteAddress().getDataAddress();
            try {
                modbusResponse.data = bModbusClientDevice.getHoldingRegisterValues(n2, n, bDevicePollConfigEntry);
                modbusResponse.exceptionCode = bModbusClientDevice.getHoldingRegistersReadStatus(n2, n, bDevicePollConfigEntry).getErrorCode();
                modbusResponse.byteCount = (byte)modbusResponse.data.length;
                modbusResponse.numberPoints = n;
                this.setOutValues(modbusResponse);
            }
            catch (ModbusException modbusException) {
                if (!this.modbusNet().getModbusLog().isTraceOn()) break block3;
                this.modbusNet().getModbusLog().trace(this.getParent().getName() + ">>> devicePoll error", (Throwable)((Object)modbusException));
            }
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            super.changed(property, context);
            return;
        }
        if (property.equals((Object)numberRegisters)) {
            this.setStale(true, null);
            if (this.getDevice() != null) {
                this.adjustPollSubscription();
            }
        } else {
            super.changed(property, context);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$modbusCore$client$point$BModbusClientStringProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$client$point$BModbusClientStringProxyExt = BModbusClientStringProxyExt.class("[Lcom.tridium.modbusCore.client.point.BModbusClientStringProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

