/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.point;

import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.client.point.BModbusClientNumericBitsProxyExt;
import com.tridium.modbusCore.messages.ModbusReadRequest;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import com.tridium.modbusCore.point.BIModbusEnumBitsProxyExt;
import javax.baja.control.BEnumPoint;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusClientEnumBitsProxyExt
extends BModbusClientNumericBitsProxyExt
implements BIModbusEnumBitsProxyExt {
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$modbusCore$client$point$BModbusClientEnumBitsProxyExt;

    public Type getType() {
        return TYPE;
    }

    public void setOutValues(ModbusResponse modbusResponse) {
        if (!modbusResponse.isError()) {
            if (this.isDataTypeInteger()) {
                this.setIntegerOutValues(modbusResponse, 2);
            } else if (this.isDataTypeLong()) {
                this.setIntegerOutValues(modbusResponse, 4);
            } else if (this.isDataTypeFloat()) {
                this.setFloatOutValues(modbusResponse, 4);
            }
        } else {
            this.readFail(modbusResponse.getExceptionString());
        }
    }

    private final void setIntegerOutValues(ModbusResponse modbusResponse, int n) {
        int n2;
        try {
            n2 = this.getBitsValue(modbusResponse.getRegister(0, n, ((BModbusClientDevice)this.getDevice()).isLong3210Order(), this.isDataTypeSigned()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.readFail("error parsing integer value (" + illegalArgumentException + ')');
            return;
        }
        this.readOk((BStatusValue)new BStatusEnum(this.getEnum(n2)));
    }

    private final void setFloatOutValues(ModbusResponse modbusResponse, int n) {
        float f;
        try {
            f = this.getBitsValue(modbusResponse.getFloat(0, n, ((BModbusClientDevice)this.getDevice()).isFloat3210Order()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.readFail("error parsing float value (" + illegalArgumentException + ')');
            return;
        }
        this.readOk((BStatusValue)new BStatusEnum(this.getEnum((int)f)));
    }

    public boolean updateOutput(BStatusValue bStatusValue) {
        ModbusWriteRequest modbusWriteRequest;
        int n = ((BStatusEnum)bStatusValue).getValue().getOrdinal();
        if (n > this.getMask()) {
            this.writeFail("Enum ordinal " + n + " is greater than maximum value of " + this.getMask() + " (" + this.getNumberOfBits() + " bits)");
            return false;
        }
        BModbusClientDevice bModbusClientDevice = (BModbusClientDevice)this.getDevice();
        BModbusClientNetwork bModbusClientNetwork = (BModbusClientNetwork)this.modbusNet();
        int n2 = bModbusClientDevice.getDeviceAddress();
        int n3 = this.getAbsoluteAddress().getDataAddress();
        int n4 = 1;
        if (this.isDataTypeLong() || this.isDataTypeFloat()) {
            n4 *= 2;
        }
        int n5 = this.isHoldingRegisterType() ? 3 : 4;
        ModbusReadRequest modbusReadRequest = new ModbusReadRequest(bModbusClientNetwork.getModbusMode(), bModbusClientDevice, n2, n5, n3, n4);
        ModbusResponse modbusResponse = (ModbusResponse)bModbusClientDevice.sendModbusMessage(modbusReadRequest);
        if (modbusResponse == null) {
            modbusResponse = new ModbusResponse(bModbusClientNetwork.getModbusMode(), bModbusClientDevice);
            modbusResponse.exceptionCode = 9;
        }
        if (modbusResponse.isError() && modbusResponse.exceptionCode != 5) {
            this.writeFail(modbusResponse.getExceptionString());
            return false;
        }
        byte[] byArray = this.isDataTypeInteger() ? this.setIntegerByteArray(this.mergeBitsValue(n, (float)modbusResponse.getRegister(0, 2, ((BModbusClientDevice)this.getDevice()).isLong3210Order(), this.isDataTypeSigned()))) : (this.isDataTypeLong() ? this.setIntegerByteArray(this.mergeBitsValue(n, (float)modbusResponse.getRegister(0, 4, ((BModbusClientDevice)this.getDevice()).isLong3210Order(), this.isDataTypeSigned()))) : this.setFloatByteArray(this.mergeBitsValue(n, modbusResponse.getFloat(0, 4, ((BModbusClientDevice)this.getDevice()).isFloat3210Order()))));
        n5 = 6;
        if (bModbusClientDevice.isPresetMultiple()) {
            n5 = 16;
        }
        if ((modbusResponse = (ModbusResponse)bModbusClientDevice.sendModbusMessage(modbusWriteRequest = new ModbusWriteRequest(bModbusClientNetwork.getModbusMode(), bModbusClientDevice, n2, n5, n3, n4, byArray))) == null) {
            modbusResponse = new ModbusResponse(bModbusClientNetwork.getModbusMode(), bModbusClientDevice);
            modbusResponse.exceptionCode = 9;
        }
        if (modbusResponse.isError() && modbusResponse.exceptionCode != 5) {
            this.writeFail(modbusResponse.getExceptionString());
            return false;
        }
        if (n5 == 6 && n4 > 1) {
            byArray[0] = byArray[2];
            byArray[1] = byArray[3];
            modbusWriteRequest = new ModbusWriteRequest(bModbusClientNetwork.getModbusMode(), bModbusClientDevice, n2, n5, n3 + 1, 1, byArray);
            modbusResponse = (ModbusResponse)bModbusClientDevice.sendModbusMessage(modbusWriteRequest);
            if (modbusResponse == null) {
                modbusResponse = new ModbusResponse(bModbusClientNetwork.getModbusMode(), bModbusClientDevice);
                modbusResponse.exceptionCode = 9;
            }
            if (modbusResponse.isError() && modbusResponse.exceptionCode != 5) {
                this.writeFail(modbusResponse.getExceptionString());
                return false;
            }
        }
        this.writeOk(bStatusValue);
        return true;
    }

    private final BEnum getEnum(int n) {
        BEnumRange bEnumRange = (BEnumRange)((BEnumPoint)this.getParent()).getFacets().get("range");
        if (bEnumRange == null) {
            return BDynamicEnum.make((int)n);
        }
        return bEnumRange.get(n, true);
    }

    public float mergeBitsValue(float f, float f2) {
        return this.mergeBitsValue((int)f, f2);
    }

    public float mergeBitsValue(int n, float f) {
        float f2 = ((BEnumPoint)this.getParent()).getOut().getValue().getOrdinal();
        return (int)f & ~this.getRegisterMask() | n << this.getBeginningBit();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$modbusCore$client$point$BModbusClientEnumBitsProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$client$point$BModbusClientEnumBitsProxyExt = BModbusClientEnumBitsProxyExt.class("[Lcom.tridium.modbusCore.client.point.BModbusClientEnumBitsProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

