/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.datatypes;

import com.tridium.basicdriver.MessageListener;
import com.tridium.basicdriver.message.Message;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.client.datatypes.BCommStatus;
import com.tridium.modbusCore.client.datatypes.BModbusClientPresetComponent;
import com.tridium.modbusCore.client.datatypes.BModbusClientPresetRegister;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BDataTypeEnum;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ICoalesceable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusClientPresetRegisters
extends BModbusClientPresetComponent
implements MessageListener {
    public static final Property dataType = BModbusClientPresetRegisters.newProperty((int)0, (BValue)BDataTypeEnum.integerType, null);
    public static final Action addPresetRegisterValue = BModbusClientPresetRegisters.newAction((int)0, (BValue)new BModbusClientPresetRegister(), null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$modbusCore$client$datatypes$BModbusClientPresetRegisters;
    static /* synthetic */ Class class$com$tridium$modbusCore$client$datatypes$BModbusClientPresetRegister;

    public BDataTypeEnum getDataType() {
        return (BDataTypeEnum)this.get(dataType);
    }

    public void setDataType(BDataTypeEnum bDataTypeEnum) {
        this.set(dataType, (BValue)bDataTypeEnum, null);
    }

    public void addPresetRegisterValue(BModbusClientPresetRegister bModbusClientPresetRegister) {
        this.invoke(addPresetRegisterValue, (BValue)bModbusClientPresetRegister, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void writePresetValues() {
        byte[] byArray;
        BModbusClientPresetRegister[] bModbusClientPresetRegisterArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = this.getDevice().getDeviceAddress();
        int n2 = this.getAbsoluteStartingAddress().getDataAddress();
        boolean bl = this.getDevice().isPresetMultiple();
        Class clazz = class$com$tridium$modbusCore$client$datatypes$BModbusClientPresetRegister;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$client$datatypes$BModbusClientPresetRegister = BModbusClientPresetRegisters.class("[Lcom.tridium.modbusCore.client.datatypes.BModbusClientPresetRegister;", false);
        }
        if ((bModbusClientPresetRegisterArray = (BModbusClientPresetRegister[])this.getChildren(clazz)) == null || bModbusClientPresetRegisterArray.length <= 0) {
            return;
        }
        int n3 = 0;
        while (n3 < bModbusClientPresetRegisterArray.length) {
            BModbusClientPresetRegister bModbusClientPresetRegister = bModbusClientPresetRegisterArray[n3];
            float f = bModbusClientPresetRegister.getValue();
            byArray = this.isDataTypeInteger() ? this.setIntegerByteArray(f) : (this.isDataTypeLong() ? this.setLongByteArray(f) : this.setFloatByteArray(f));
            if (!bl) {
                int n4 = 1;
                int n5 = n2 + n3;
                if (this.isDataTypeLong() || this.isDataTypeFloat()) {
                    n4 *= 2;
                    n5 = n2 + n3 * 2;
                }
                int n6 = 6;
                ModbusWriteRequest modbusWriteRequest = new ModbusWriteRequest(this.getNetwork().getModbusMode(), this.getDevice(), n, n6, n5, 1, byArray);
                if (n4 > 1) {
                    BModbusClientNetwork bModbusClientNetwork = this.getNetwork();
                    boolean bl2 = false;
                    if (n3 == bModbusClientPresetRegisterArray.length - 1) {
                        bl2 = true;
                    }
                    bModbusClientNetwork.postWrite(new ModbusWriteFloatRequest(bModbusClientPresetRegister, modbusWriteRequest, byArray, bl2));
                } else {
                    boolean bl3 = false;
                    if (n3 == bModbusClientPresetRegisterArray.length - 1) {
                        bl3 = true;
                    }
                    bModbusClientPresetRegister.setLastChild(bl3);
                    this.getNetwork().postWrite(new BModbusClientPresetComponent.ModbusClientWriteRequest(modbusWriteRequest, bModbusClientPresetRegister));
                }
            } else {
                try {
                    byteArrayOutputStream.write(byArray);
                }
                catch (IOException iOException) {}
            }
            ++n3;
        }
        if (bl) {
            n3 = bModbusClientPresetRegisterArray.length;
            int n7 = n2;
            if (this.isDataTypeLong() || this.isDataTypeFloat()) {
                n3 *= 2;
            }
            int n8 = 16;
            byArray = byteArrayOutputStream.toByteArray();
            ModbusWriteRequest modbusWriteRequest = new ModbusWriteRequest(this.getNetwork().getModbusMode(), this.getDevice(), n, n8, n7, n3, byArray);
            this.getNetwork().postWrite(new BModbusClientPresetComponent.ModbusClientWriteRequest(modbusWriteRequest, this));
        }
    }

    protected Property getBaseAddressProperty() {
        return BModbusClientDevice.holdingRegisterBaseAddress;
    }

    protected boolean isValidAddress(BFlexAddress bFlexAddress) {
        if (!bFlexAddress.isModbusFormat()) {
            return bFlexAddress.isValid();
        }
        if (bFlexAddress.isModbusAnalogAddress()) {
            return bFlexAddress.isModbusHoldingAddress();
        }
        return false;
    }

    public void doAddPresetRegisterValue(BModbusClientPresetRegister bModbusClientPresetRegister) {
        this.add(null, (BValue)bModbusClientPresetRegister);
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace != null) {
            bComponentSpace.update((BComponent)this, 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void processMessage(Message var1_1) {
        var2_2 = 0;
        var2_2 = var1_1 == null ? 9 : ((ModbusResponse)var1_1).exceptionCode;
        v0 = false;
        if (var2_2 != 0 && var2_2 != -2 && var2_2 != 5) {
            v0 = true;
        }
        this.setStatusFault(v0);
        var3_3 = new BCommStatus(var2_2);
        var4_4 = Clock.time();
        var5_5 = this.getProperties();
        if (true) ** GOTO lbl19
        do {
            var6_6 = (BModbusClientPresetRegister)var5_5.get();
            var6_6.getWriteStatus().setErrorCode(var3_3.getErrorCode());
            var6_6.getWriteStatus().setErrorDescription(var3_3.getErrorDescription());
            if (var2_2 != 0 && var2_2 != 5) {
                var6_6.setLastFailedWrite(var4_4);
            } else {
                var6_6.setLastSuccessfulWrite(var4_4);
            }
lbl19:
            // 3 sources

            if ((v1 = BModbusClientPresetRegisters.class$com$tridium$modbusCore$client$datatypes$BModbusClientPresetRegister) != null) continue;
            v1 = BModbusClientPresetRegisters.class("[Lcom.tridium.modbusCore.client.datatypes.BModbusClientPresetRegister;", false);
        } while (var5_5.next(v1));
        if (var2_2 == 0 || var2_2 == 5) {
            this.fireWriteSuccessful(null);
            if (this.getNetwork().getModbusLog().isTraceOn()) {
                this.getNetwork().getModbusLog().trace(this.getName() + " write successful.");
            }
        } else if (this.getNetwork().getModbusLog().isTraceOn()) {
            this.getNetwork().getModbusLog().trace(this.getName() + " write unsuccessful.");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void computeStatus(boolean var1_1) {
        var2_2 = this.getProperties();
        if (true) ** GOTO lbl9
        do {
            if ((var4_4 = (var3_3 = (BModbusClientPresetRegister)var2_2.get()).getWriteStatus().getErrorCode()) != 0 && var4_4 != -2 && var4_4 != 5) {
                this.setStatusFault(true);
                if (var1_1 && this.getNetwork().getModbusLog().isTraceOn()) {
                    this.getNetwork().getModbusLog().trace(this.getName() + " write unsuccessful.");
                }
                return;
            }
lbl9:
            // 3 sources

            if ((v0 = BModbusClientPresetRegisters.class$com$tridium$modbusCore$client$datatypes$BModbusClientPresetRegister) != null) continue;
            v0 = BModbusClientPresetRegisters.class("[Lcom.tridium.modbusCore.client.datatypes.BModbusClientPresetRegister;", false);
        } while (var2_2.next(v0));
        this.setStatusFault(false);
        if (var1_1) {
            this.fireWriteSuccessful(null);
            if (this.getNetwork().getModbusLog().isTraceOn()) {
                this.getNetwork().getModbusLog().trace(this.getName() + " write successful.");
            }
        }
    }

    private final boolean isDataTypeInteger() {
        if (this.getDataType().equals((Object)BDataTypeEnum.integerType)) {
            return true;
        }
        return this.getDataType().equals((Object)BDataTypeEnum.signedInteger);
    }

    private final boolean isDataTypeLong() {
        return this.getDataType().equals((Object)BDataTypeEnum.longType);
    }

    private final boolean isDataTypeFloat() {
        return this.getDataType().equals((Object)BDataTypeEnum.floatType);
    }

    private final boolean isDataTypeSigned() {
        if (this.getDataType().equals((Object)BDataTypeEnum.signedInteger)) {
            return true;
        }
        return this.getDataType().equals((Object)BDataTypeEnum.longType);
    }

    private final byte[] setIntegerByteArray(float f) {
        byte[] byArray = new byte[2];
        f = f >= 0.0f ? (float)((double)f + 0.5) : (float)((double)f - 0.5);
        float f2 = 65535.0f;
        float f3 = 0.0f;
        if (this.isDataTypeSigned()) {
            f2 = 32767.0f;
            f3 = -32768.0f;
        }
        if (f > f2) {
            f = f2;
        } else if (f < f3) {
            f = f3;
        }
        int n = (int)f;
        byArray[0] = (byte)((n & 0xFF00) >> 8);
        byArray[1] = (byte)(n & 0xFF);
        return byArray;
    }

    private final byte[] setLongByteArray(float f) {
        byte[] byArray = new byte[4];
        f = f >= 0.0f ? (float)((double)f + 0.5) : (float)((double)f - 0.5);
        float f2 = 2.1474836E9f;
        float f3 = -2.1474836E9f;
        if (f > f2) {
            f = f2;
        } else if (f < f3) {
            f = f3;
        }
        int n = (int)f;
        if (this.getDevice().isFloat3210Order()) {
            byArray[0] = (byte)((n & 0xFF000000) >> 24);
            byArray[1] = (byte)((n & 0xFF0000) >> 16);
            byArray[2] = (byte)((n & 0xFF00) >> 8);
            byArray[3] = (byte)(n & 0xFF);
        } else {
            byArray[0] = (byte)((n & 0xFF00) >> 8);
            byArray[1] = (byte)(n & 0xFF);
            byArray[2] = (byte)((n & 0xFF000000) >> 24);
            byArray[3] = (byte)((n & 0xFF0000) >> 16);
        }
        return byArray;
    }

    private final byte[] setFloatByteArray(float f) {
        byte[] byArray = new byte[4];
        int n = Float.floatToIntBits(f);
        if (this.getDevice().isFloat3210Order()) {
            byArray[0] = (byte)((n & 0xFF000000) >> 24);
            byArray[1] = (byte)((n & 0xFF0000) >> 16);
            byArray[2] = (byte)((n & 0xFF00) >> 8);
            byArray[3] = (byte)(n & 0xFF);
        } else {
            byArray[0] = (byte)((n & 0xFF00) >> 8);
            byArray[1] = (byte)(n & 0xFF);
            byArray[2] = (byte)((n & 0xFF000000) >> 24);
            byArray[3] = (byte)((n & 0xFF0000) >> 16);
        }
        return byArray;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$modbusCore$client$datatypes$BModbusClientPresetRegisters;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$client$datatypes$BModbusClientPresetRegisters = BModbusClientPresetRegisters.class("[Lcom.tridium.modbusCore.client.datatypes.BModbusClientPresetRegisters;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ModbusWriteFloatRequest
    implements Runnable,
    ICoalesceable {
        private int hashCode;
        private BModbusClientPresetRegister source;
        private ModbusWriteRequest req;
        private byte[] dataOut;
        private boolean lastChild;

        public void run() {
            this.source.setLastChild(false);
            this.source.processMessage(BModbusClientPresetRegisters.this.getDevice().sendModbusMessage(this.req));
            if (this.source.getWriteStatus().getErrorCode() != 0 && this.source.getWriteStatus().getErrorCode() != 5) {
                return;
            }
            this.dataOut[0] = this.dataOut[2];
            this.dataOut[1] = this.dataOut[3];
            ++this.req.startAddress;
            this.req.data = this.dataOut;
            this.source.setLastChild(this.lastChild);
            this.source.processMessage(BModbusClientPresetRegisters.this.getDevice().sendModbusMessage(this.req));
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof ModbusWriteFloatRequest) {
                ModbusWriteFloatRequest modbusWriteFloatRequest = (ModbusWriteFloatRequest)object;
                boolean bl = false;
                if (this.source == modbusWriteFloatRequest.source) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public Object getCoalesceKey() {
            return this;
        }

        public ICoalesceable coalesce(ICoalesceable iCoalesceable) {
            return iCoalesceable;
        }

        public ModbusWriteFloatRequest(BModbusClientPresetRegister bModbusClientPresetRegister, ModbusWriteRequest modbusWriteRequest, byte[] byArray, boolean bl) {
            this.hashCode = bModbusClientPresetRegister.hashCode();
            this.source = bModbusClientPresetRegister;
            this.req = modbusWriteRequest;
            this.dataOut = byArray;
            this.lastChild = bl;
        }
    }
}

