/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.datatypes;

import com.tridium.basicdriver.MessageListener;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BModbusClientPresetComponent
extends BComponent {
    public static final Property startingAddress = BModbusClientPresetComponent.newProperty((int)0, (BValue)new BFlexAddress(), null);
    public static final Property absoluteStartingAddress = BModbusClientPresetComponent.newProperty((int)3, (BValue)new BFlexAddress(), null);
    public static final Property status = BModbusClientPresetComponent.newProperty((int)67, (BValue)BStatus.down, null);
    public static final Property writeOnInputChange = BModbusClientPresetComponent.newProperty((int)0, (boolean)false, null);
    public static final Action write = BModbusClientPresetComponent.newAction((int)24, null);
    public static final Topic writeSuccessful = BModbusClientPresetComponent.newTopic((int)8, null);
    public static final Type TYPE;
    private Subscriber subscriber;
    static /* synthetic */ Class class$com$tridium$modbusCore$client$datatypes$BModbusClientPresetComponent;

    public BFlexAddress getStartingAddress() {
        return (BFlexAddress)this.get(startingAddress);
    }

    public void setStartingAddress(BFlexAddress bFlexAddress) {
        this.set(startingAddress, (BValue)bFlexAddress, null);
    }

    public BFlexAddress getAbsoluteStartingAddress() {
        return (BFlexAddress)this.get(absoluteStartingAddress);
    }

    public void setAbsoluteStartingAddress(BFlexAddress bFlexAddress) {
        this.set(absoluteStartingAddress, (BValue)bFlexAddress, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public boolean getWriteOnInputChange() {
        return this.getBoolean(writeOnInputChange);
    }

    public void setWriteOnInputChange(boolean bl) {
        this.setBoolean(writeOnInputChange, bl, null);
    }

    public void write() {
        this.invoke(write, null, null);
    }

    public void fireWriteSuccessful(BValue bValue) {
        this.fire(writeSuccessful, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.subscriber = new BaseAddressSubscriber();
        BModbusClientDevice bModbusClientDevice = this.getDevice();
        if (bModbusClientDevice == null) {
            return;
        }
        this.subscriber.subscribe((BComponent)bModbusClientDevice);
        this.setCurrentAbsoluteAddress();
    }

    public void stopped() throws Exception {
        this.subscriber.unsubscribeAll();
        this.subscriber = null;
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)startingAddress) && this.getDevice() != null && context != Context.commit) {
            this.setCurrentAbsoluteAddress();
        }
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)write)) {
            return this.getNetwork().postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    private final void setCurrentAbsoluteAddress() {
        if (!this.isValidAddress(this.getStartingAddress())) {
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)true));
            this.getNetwork().getModbusLog().error("Illegal Modbus address for preset component " + this.getName() + ": Modbus Address does not match preset type.");
            return;
        }
        this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)this.getDevice().isDown()));
        int n = 0;
        try {
            n = ((BFlexAddress)this.getDevice().get(this.getBaseAddressProperty())).getDataAddress();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        try {
            BFlexAddress bFlexAddress = (BFlexAddress)this.getStartingAddress().newCopy();
            int n2 = bFlexAddress.isModbusFormat() ? Integer.valueOf(bFlexAddress.getAddress()).intValue() : bFlexAddress.getDataAddress();
            bFlexAddress.setAddressFromInt(n2 + n);
            this.setAbsoluteStartingAddress(bFlexAddress);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException numberFormatException) {
            BFlexAddress bFlexAddress = (BFlexAddress)this.getStartingAddress().newCopy();
            bFlexAddress.setAddressFromInt(n);
            this.setAbsoluteStartingAddress(bFlexAddress);
        }
    }

    public void doWrite() {
        if (this.isDown() || this.isDisabled()) {
            return;
        }
        this.writePresetValues();
    }

    protected abstract void writePresetValues();

    protected abstract Property getBaseAddressProperty();

    protected abstract boolean isValidAddress(BFlexAddress var1);

    public void setStatusFault(boolean bl) {
        this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)2, (boolean)bl));
    }

    public boolean isDown() {
        return this.getStatus().isDown();
    }

    public boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public BModbusClientDevice getDevice() {
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BModbusClientDevice) {
                if (this.isDisabled()) {
                    this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)1, (boolean)((BModbusClientDevice)bComplex).isDisabled()));
                    if (!this.subscriber.isSubscribed((BComponent)bComplex)) {
                        this.subscriber.subscribe((BComponent)bComplex);
                    }
                }
                return (BModbusClientDevice)bComplex;
            }
            bComplex = bComplex.getParent();
        }
        if (!this.isDisabled()) {
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)1, (boolean)true));
        }
        return null;
    }

    public BModbusClientNetwork getNetwork() {
        BModbusClientDevice bModbusClientDevice = this.getDevice();
        if (bModbusClientDevice == null) {
            return null;
        }
        return (BModbusClientNetwork)bModbusClientDevice.modbusNet();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$modbusCore$client$datatypes$BModbusClientPresetComponent;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$client$datatypes$BModbusClientPresetComponent = BModbusClientPresetComponent.class("[Lcom.tridium.modbusCore.client.datatypes.BModbusClientPresetComponent;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class BaseAddressSubscriber
    extends Subscriber {
        public void event(BComponentEvent bComponentEvent) {
            if (bComponentEvent.getId() == 0) {
                if (bComponentEvent.getSlot().equals((Object)BModbusClientPresetComponent.this.getBaseAddressProperty())) {
                    BModbusClientPresetComponent.this.setCurrentAbsoluteAddress();
                } else if (bComponentEvent.getSlot().equals((Object)BModbusClientDevice.status)) {
                    if (BModbusClientPresetComponent.this.getDevice().isDown()) {
                        BModbusClientPresetComponent.this.setStatus(BStatus.make((BStatus)BModbusClientPresetComponent.this.getStatus(), (int)4, (boolean)true));
                    } else {
                        BModbusClientPresetComponent.this.setStatus(BStatus.make((BStatus)BModbusClientPresetComponent.this.getStatus(), (int)4, (boolean)(BModbusClientPresetComponent.this.isValidAddress(BModbusClientPresetComponent.this.getStartingAddress()) ^ true)));
                    }
                    BModbusClientPresetComponent.this.setStatus(BStatus.make((BStatus)BModbusClientPresetComponent.this.getStatus(), (int)1, (boolean)BModbusClientPresetComponent.this.getDevice().isDisabled()));
                }
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ModbusClientWriteRequest
    implements Runnable {
        private MessageListener source;
        private ModbusWriteRequest req;

        public void run() {
            this.source.processMessage(BModbusClientPresetComponent.this.getDevice().sendModbusMessage(this.req));
        }

        public ModbusClientWriteRequest(ModbusWriteRequest modbusWriteRequest, MessageListener messageListener) {
            this.source = messageListener;
            this.req = modbusWriteRequest;
        }
    }
}

