/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.datatypes;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.client.datatypes.BCommStatus;
import com.tridium.modbusCore.messages.ModbusReadExceptionStatusRequest;
import com.tridium.modbusCore.messages.ModbusReadExceptionStatusResponse;
import com.tridium.modbusCore.messages.ModbusResponse;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusClientExceptionStatus
extends BComponent
implements BIStatus,
BIBasicPollable {
    public static final Property status = BModbusClientExceptionStatus.newProperty((int)11, (BValue)BStatus.make((int)0), null);
    public static final Property enabled = BModbusClientExceptionStatus.newProperty((int)0, (boolean)true, null);
    public static final Property faultCause = BModbusClientExceptionStatus.newProperty((int)3, (String)"", null);
    public static final Property pollFrequency = BModbusClientExceptionStatus.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property bytesReturned = BModbusClientExceptionStatus.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt((int)1, (int)2));
    public static final Property lastSuccessfulRead = BModbusClientExceptionStatus.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    public static final Property lastFailedRead = BModbusClientExceptionStatus.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    public static final Property readStatus = BModbusClientExceptionStatus.newProperty((int)67, (BValue)new BCommStatus(-2), null);
    public static final Property out = BModbusClientExceptionStatus.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property bit0 = BModbusClientExceptionStatus.newProperty((int)3, (BValue)new BStatusBoolean(), null);
    public static final Property bit1 = BModbusClientExceptionStatus.newProperty((int)3, (BValue)new BStatusBoolean(), null);
    public static final Property bit2 = BModbusClientExceptionStatus.newProperty((int)3, (BValue)new BStatusBoolean(), null);
    public static final Property bit3 = BModbusClientExceptionStatus.newProperty((int)3, (BValue)new BStatusBoolean(), null);
    public static final Property bit4 = BModbusClientExceptionStatus.newProperty((int)3, (BValue)new BStatusBoolean(), null);
    public static final Property bit5 = BModbusClientExceptionStatus.newProperty((int)3, (BValue)new BStatusBoolean(), null);
    public static final Property bit6 = BModbusClientExceptionStatus.newProperty((int)3, (BValue)new BStatusBoolean(), null);
    public static final Property bit7 = BModbusClientExceptionStatus.newProperty((int)3, (BValue)new BStatusBoolean(), null);
    public static final Property bit8 = BModbusClientExceptionStatus.newProperty((int)3, (BValue)new BStatusBoolean(), null);
    public static final Property bit9 = BModbusClientExceptionStatus.newProperty((int)3, (BValue)new BStatusBoolean(), null);
    public static final Property bit10 = BModbusClientExceptionStatus.newProperty((int)3, (BValue)new BStatusBoolean(), null);
    public static final Property bit11 = BModbusClientExceptionStatus.newProperty((int)3, (BValue)new BStatusBoolean(), null);
    public static final Property bit12 = BModbusClientExceptionStatus.newProperty((int)3, (BValue)new BStatusBoolean(), null);
    public static final Property bit13 = BModbusClientExceptionStatus.newProperty((int)3, (BValue)new BStatusBoolean(), null);
    public static final Property bit14 = BModbusClientExceptionStatus.newProperty((int)3, (BValue)new BStatusBoolean(), null);
    public static final Property bit15 = BModbusClientExceptionStatus.newProperty((int)3, (BValue)new BStatusBoolean(), null);
    public static final Action poll = BModbusClientExceptionStatus.newAction((int)16, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$modbusCore$client$datatypes$BModbusClientExceptionStatus;
    static /* synthetic */ Class class$javax$baja$status$BStatusValue;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public int getBytesReturned() {
        return this.getInt(bytesReturned);
    }

    public void setBytesReturned(int n) {
        this.setInt(bytesReturned, n, null);
    }

    public BAbsTime getLastSuccessfulRead() {
        return (BAbsTime)this.get(lastSuccessfulRead);
    }

    public void setLastSuccessfulRead(BAbsTime bAbsTime) {
        this.set(lastSuccessfulRead, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastFailedRead() {
        return (BAbsTime)this.get(lastFailedRead);
    }

    public void setLastFailedRead(BAbsTime bAbsTime) {
        this.set(lastFailedRead, (BValue)bAbsTime, null);
    }

    public BCommStatus getReadStatus() {
        return (BCommStatus)this.get(readStatus);
    }

    public void setReadStatus(BCommStatus bCommStatus) {
        this.set(readStatus, (BValue)bCommStatus, null);
    }

    public BStatusNumeric getOut() {
        return (BStatusNumeric)this.get(out);
    }

    public void setOut(BStatusNumeric bStatusNumeric) {
        this.set(out, (BValue)bStatusNumeric, null);
    }

    public BStatusBoolean getBit0() {
        return (BStatusBoolean)this.get(bit0);
    }

    public void setBit0(BStatusBoolean bStatusBoolean) {
        this.set(bit0, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getBit1() {
        return (BStatusBoolean)this.get(bit1);
    }

    public void setBit1(BStatusBoolean bStatusBoolean) {
        this.set(bit1, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getBit2() {
        return (BStatusBoolean)this.get(bit2);
    }

    public void setBit2(BStatusBoolean bStatusBoolean) {
        this.set(bit2, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getBit3() {
        return (BStatusBoolean)this.get(bit3);
    }

    public void setBit3(BStatusBoolean bStatusBoolean) {
        this.set(bit3, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getBit4() {
        return (BStatusBoolean)this.get(bit4);
    }

    public void setBit4(BStatusBoolean bStatusBoolean) {
        this.set(bit4, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getBit5() {
        return (BStatusBoolean)this.get(bit5);
    }

    public void setBit5(BStatusBoolean bStatusBoolean) {
        this.set(bit5, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getBit6() {
        return (BStatusBoolean)this.get(bit6);
    }

    public void setBit6(BStatusBoolean bStatusBoolean) {
        this.set(bit6, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getBit7() {
        return (BStatusBoolean)this.get(bit7);
    }

    public void setBit7(BStatusBoolean bStatusBoolean) {
        this.set(bit7, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getBit8() {
        return (BStatusBoolean)this.get(bit8);
    }

    public void setBit8(BStatusBoolean bStatusBoolean) {
        this.set(bit8, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getBit9() {
        return (BStatusBoolean)this.get(bit9);
    }

    public void setBit9(BStatusBoolean bStatusBoolean) {
        this.set(bit9, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getBit10() {
        return (BStatusBoolean)this.get(bit10);
    }

    public void setBit10(BStatusBoolean bStatusBoolean) {
        this.set(bit10, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getBit11() {
        return (BStatusBoolean)this.get(bit11);
    }

    public void setBit11(BStatusBoolean bStatusBoolean) {
        this.set(bit11, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getBit12() {
        return (BStatusBoolean)this.get(bit12);
    }

    public void setBit12(BStatusBoolean bStatusBoolean) {
        this.set(bit12, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getBit13() {
        return (BStatusBoolean)this.get(bit13);
    }

    public void setBit13(BStatusBoolean bStatusBoolean) {
        this.set(bit13, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getBit14() {
        return (BStatusBoolean)this.get(bit14);
    }

    public void setBit14(BStatusBoolean bStatusBoolean) {
        this.set(bit14, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getBit15() {
        return (BStatusBoolean)this.get(bit15);
    }

    public void setBit15(BStatusBoolean bStatusBoolean) {
        this.set(bit15, (BValue)bStatusBoolean, null);
    }

    public void poll() {
        this.invoke(poll, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void stopped() throws Exception {
        try {
            this.unsubscribed();
        }
        catch (Exception exception) {}
    }

    public BModbusClientNetwork getNetwork() {
        try {
            return (BModbusClientNetwork)this.getDevice().getNetwork();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BModbusClientDevice getDevice() {
        try {
            return (BModbusClientDevice)this.getParent();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void changed(Property property, Context context) {
        if (property.equals((Object)enabled)) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)(this.getEnabled() ^ true)));
        }
        if (property.equals((Object)status)) {
            Class clazz = class$javax$baja$status$BStatusValue;
            if (clazz == null) {
                clazz = class$javax$baja$status$BStatusValue = BModbusClientExceptionStatus.class("[Ljavax.baja.status.BStatusValue;", false);
            }
            BStatusValue[] bStatusValueArray = (BStatusValue[])this.getChildren(clazz);
            int n = 0;
            while (n < bStatusValueArray.length) {
                bStatusValueArray[n].setStatusDown(this.getStatus().isDown());
                bStatusValueArray[n].setStatusFault(this.getStatus().isFault());
                bStatusValueArray[n].setStatusDisabled(this.getStatus().isDisabled());
                ++n;
            }
        }
    }

    public void subscribed() {
        if (!this.isRunning()) {
            return;
        }
        ((BBasicNetwork)this.getDevice().getNetwork()).getPollScheduler().subscribe((BIPollable)this);
    }

    public void unsubscribed() {
        try {
            ((BBasicNetwork)this.getDevice().getNetwork()).getPollScheduler().unsubscribe((BIPollable)this);
        }
        catch (Exception exception) {}
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)poll)) {
            return this.getNetwork().postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public void doPoll() {
        BModbusClientDevice bModbusClientDevice = this.getDevice();
        if (bModbusClientDevice == null || bModbusClientDevice.isFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            BCommStatus bCommStatus = new BCommStatus(-7);
            this.getReadStatus().setErrorCode(bCommStatus.getErrorCode());
            this.getReadStatus().setErrorDescription(bCommStatus.getErrorDescription());
            return;
        }
        if (bModbusClientDevice.isDown()) {
            this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
            BCommStatus bCommStatus = new BCommStatus(-6);
            this.getReadStatus().setErrorCode(bCommStatus.getErrorCode());
            this.getReadStatus().setErrorDescription(bCommStatus.getErrorDescription());
            return;
        }
        if (bModbusClientDevice.isDisabled() || !this.getEnabled()) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            BCommStatus bCommStatus = new BCommStatus(-8);
            this.getReadStatus().setErrorCode(bCommStatus.getErrorCode());
            this.getReadStatus().setErrorDescription(bCommStatus.getErrorDescription());
            return;
        }
        this.setStatus(BStatus.ok);
        if (bModbusClientDevice instanceof BModbusClientDevice) {
            this.pollForData(bModbusClientDevice);
        }
    }

    private final void pollForData(BModbusClientDevice bModbusClientDevice) {
        BModbusClientNetwork bModbusClientNetwork = this.getNetwork();
        ModbusReadExceptionStatusRequest modbusReadExceptionStatusRequest = new ModbusReadExceptionStatusRequest(bModbusClientNetwork.getModbusMode(), bModbusClientDevice, bModbusClientDevice.getDeviceAddress(), this.getBytesReturned());
        ModbusResponse modbusResponse = (ModbusResponse)bModbusClientDevice.sendModbusMessage(modbusReadExceptionStatusRequest);
        if (modbusResponse == null) {
            modbusResponse = new ModbusResponse(bModbusClientNetwork.getModbusMode(), bModbusClientDevice);
            modbusResponse.exceptionCode = 9;
        }
        if (modbusResponse.isError()) {
            BCommStatus bCommStatus = new BCommStatus(modbusResponse.exceptionCode);
            this.getReadStatus().setErrorCode(bCommStatus.getErrorCode());
            this.getReadStatus().setErrorDescription(bCommStatus.getErrorDescription());
            this.setLastFailedRead(Clock.time());
            return;
        }
        ModbusReadExceptionStatusResponse modbusReadExceptionStatusResponse = (ModbusReadExceptionStatusResponse)modbusResponse;
        this.setOut(new BStatusNumeric(modbusReadExceptionStatusResponse.getDouble()));
        this.setBit0(new BStatusBoolean(modbusReadExceptionStatusResponse.getStatusBit(0)));
        this.setBit1(new BStatusBoolean(modbusReadExceptionStatusResponse.getStatusBit(1)));
        this.setBit2(new BStatusBoolean(modbusReadExceptionStatusResponse.getStatusBit(2)));
        this.setBit3(new BStatusBoolean(modbusReadExceptionStatusResponse.getStatusBit(3)));
        this.setBit4(new BStatusBoolean(modbusReadExceptionStatusResponse.getStatusBit(4)));
        this.setBit5(new BStatusBoolean(modbusReadExceptionStatusResponse.getStatusBit(5)));
        this.setBit6(new BStatusBoolean(modbusReadExceptionStatusResponse.getStatusBit(6)));
        this.setBit7(new BStatusBoolean(modbusReadExceptionStatusResponse.getStatusBit(7)));
        this.setBit8(new BStatusBoolean(modbusReadExceptionStatusResponse.getStatusBit(8)));
        this.setBit9(new BStatusBoolean(modbusReadExceptionStatusResponse.getStatusBit(9)));
        this.setBit10(new BStatusBoolean(modbusReadExceptionStatusResponse.getStatusBit(10)));
        this.setBit11(new BStatusBoolean(modbusReadExceptionStatusResponse.getStatusBit(11)));
        this.setBit12(new BStatusBoolean(modbusReadExceptionStatusResponse.getStatusBit(12)));
        this.setBit13(new BStatusBoolean(modbusReadExceptionStatusResponse.getStatusBit(13)));
        this.setBit14(new BStatusBoolean(modbusReadExceptionStatusResponse.getStatusBit(14)));
        this.setBit15(new BStatusBoolean(modbusReadExceptionStatusResponse.getStatusBit(15)));
        BCommStatus bCommStatus = new BCommStatus(0);
        this.getReadStatus().setErrorCode(bCommStatus.getErrorCode());
        this.getReadStatus().setErrorDescription(bCommStatus.getErrorDescription());
        this.setLastSuccessfulRead(Clock.time());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$modbusCore$client$datatypes$BModbusClientExceptionStatus;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$client$datatypes$BModbusClientExceptionStatus = BModbusClientExceptionStatus.class("[Lcom.tridium.modbusCore.client.datatypes.BModbusClientExceptionStatus;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

