/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client;

import com.tridium.basicdriver.message.Message;
import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.ModbusErrorCodes;
import com.tridium.modbusCore.ModbusException;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.client.datatypes.BCommStatus;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigEntry;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigTable;
import com.tridium.modbusCore.client.datatypes.BModbusClientConfig;
import com.tridium.modbusCore.client.point.BModbusClientBooleanProxyExt;
import com.tridium.modbusCore.client.point.BModbusClientNumericBitsProxyExt;
import com.tridium.modbusCore.client.point.BModbusClientNumericProxyExt;
import com.tridium.modbusCore.client.point.BModbusClientPointDeviceExt;
import com.tridium.modbusCore.client.point.BModbusClientProxyExt;
import com.tridium.modbusCore.client.point.BModbusClientRegisterBitProxyExt;
import com.tridium.modbusCore.client.point.BModbusClientStringProxyExt;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.datatypes.BModbusConfig;
import com.tridium.modbusCore.enums.BAddressFormatEnum;
import com.tridium.modbusCore.enums.BDataTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.enums.BStatusTypeEnum;
import com.tridium.modbusCore.messages.ModbusMessageConst;
import com.tridium.modbusCore.messages.ModbusReadRequest;
import com.tridium.modbusCore.messages.ModbusResponse;
import java.util.Arrays;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BModbusClientDevice
extends BModbusDevice
implements ModbusMessageConst,
ModbusErrorCodes {
    public static final Property modbusConfig = BModbusClientDevice.newProperty((int)0, (BValue)new BModbusClientConfig(), null);
    public static final Property pingAddress = BModbusClientDevice.newProperty((int)0, (BValue)new BFlexAddress(), null);
    public static final Property pingAddressDataType = BModbusClientDevice.newProperty((int)0, (BValue)BDataTypeEnum.integerType, null);
    public static final Property pingAddressRegType = BModbusClientDevice.newProperty((int)0, (BValue)BRegisterTypeEnum.holding, null);
    public static final Property pollFrequency = BModbusClientDevice.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property inputRegisterBaseAddress = BModbusClientDevice.newProperty((int)0, (BValue)new BFlexAddress(), null);
    public static final Property holdingRegisterBaseAddress = BModbusClientDevice.newProperty((int)0, (BValue)new BFlexAddress(), null);
    public static final Property coilStatusBaseAddress = BModbusClientDevice.newProperty((int)0, (BValue)new BFlexAddress(), null);
    public static final Property inputStatusBaseAddress = BModbusClientDevice.newProperty((int)0, (BValue)new BFlexAddress(), null);
    public static final Property devicePollConfig = BModbusClientDevice.newProperty((int)0, (BValue)new BDevicePollConfigTable(), null);
    public static final Property points = BModbusClientDevice.newProperty((int)0, (BValue)new BModbusClientPointDeviceExt(), null);
    public static final Type TYPE;
    private Vector writableProxies;
    private int pingsFailed;
    private boolean rdCommError;
    private boolean pollRegistered;
    static /* synthetic */ Class class$com$tridium$modbusCore$client$BModbusClientDevice;

    public BModbusConfig getModbusConfig() {
        return (BModbusConfig)this.get(modbusConfig);
    }

    public void setModbusConfig(BModbusConfig bModbusConfig) {
        this.set(modbusConfig, (BValue)bModbusConfig, null);
    }

    public BFlexAddress getPingAddress() {
        return (BFlexAddress)this.get(pingAddress);
    }

    public void setPingAddress(BFlexAddress bFlexAddress) {
        this.set(pingAddress, (BValue)bFlexAddress, null);
    }

    public BDataTypeEnum getPingAddressDataType() {
        return (BDataTypeEnum)this.get(pingAddressDataType);
    }

    public void setPingAddressDataType(BDataTypeEnum bDataTypeEnum) {
        this.set(pingAddressDataType, (BValue)bDataTypeEnum, null);
    }

    public BRegisterTypeEnum getPingAddressRegType() {
        return (BRegisterTypeEnum)this.get(pingAddressRegType);
    }

    public void setPingAddressRegType(BRegisterTypeEnum bRegisterTypeEnum) {
        this.set(pingAddressRegType, (BValue)bRegisterTypeEnum, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public BFlexAddress getInputRegisterBaseAddress() {
        return (BFlexAddress)this.get(inputRegisterBaseAddress);
    }

    public void setInputRegisterBaseAddress(BFlexAddress bFlexAddress) {
        this.set(inputRegisterBaseAddress, (BValue)bFlexAddress, null);
    }

    public BFlexAddress getHoldingRegisterBaseAddress() {
        return (BFlexAddress)this.get(holdingRegisterBaseAddress);
    }

    public void setHoldingRegisterBaseAddress(BFlexAddress bFlexAddress) {
        this.set(holdingRegisterBaseAddress, (BValue)bFlexAddress, null);
    }

    public BFlexAddress getCoilStatusBaseAddress() {
        return (BFlexAddress)this.get(coilStatusBaseAddress);
    }

    public void setCoilStatusBaseAddress(BFlexAddress bFlexAddress) {
        this.set(coilStatusBaseAddress, (BValue)bFlexAddress, null);
    }

    public BFlexAddress getInputStatusBaseAddress() {
        return (BFlexAddress)this.get(inputStatusBaseAddress);
    }

    public void setInputStatusBaseAddress(BFlexAddress bFlexAddress) {
        this.set(inputStatusBaseAddress, (BValue)bFlexAddress, null);
    }

    public BDevicePollConfigTable getDevicePollConfig() {
        return (BDevicePollConfigTable)this.get(devicePollConfig);
    }

    public void setDevicePollConfig(BDevicePollConfigTable bDevicePollConfigTable) {
        this.set(devicePollConfig, (BValue)bDevicePollConfigTable, null);
    }

    public BModbusClientPointDeviceExt getPoints() {
        return (BModbusClientPointDeviceExt)this.get(points);
    }

    public void setPoints(BModbusClientPointDeviceExt bModbusClientPointDeviceExt) {
        this.set(points, (BValue)bModbusClientPointDeviceExt, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)inputRegisterBaseAddress)) {
            if (this.getInputRegisterBaseAddress().isModbusFormat() && !this.getInputRegisterBaseAddress().isModbusInputAddress()) {
                this.setInputRegisterBaseAddress((BFlexAddress)inputRegisterBaseAddress.getDefaultValue());
                if (this.modbusNet() != null) {
                    this.modbusNet().getModbusLog().error("Illegal input register base address on " + this.getName() + ".  Must be an Input register address 3x");
                }
            }
            this.updateProxyPointSubscriptions();
        } else if (property.equals((Object)devicePollConfig)) {
            this.updateProxyPointSubscriptions();
        } else if (property.equals((Object)holdingRegisterBaseAddress)) {
            if (this.getHoldingRegisterBaseAddress().isModbusFormat() && !this.getHoldingRegisterBaseAddress().isModbusHoldingAddress()) {
                this.setHoldingRegisterBaseAddress((BFlexAddress)holdingRegisterBaseAddress.getDefaultValue());
                if (this.modbusNet() != null) {
                    this.modbusNet().getModbusLog().error("Illegal holding register base address on " + this.getName() + ".  Must be a Holding register address 4x");
                }
            }
            this.updateProxyPointSubscriptions();
        } else if (property.equals((Object)coilStatusBaseAddress)) {
            if (this.getCoilStatusBaseAddress().isModbusFormat() && !this.getCoilStatusBaseAddress().isModbusCoilAddress()) {
                this.setCoilStatusBaseAddress((BFlexAddress)coilStatusBaseAddress.getDefaultValue());
                if (this.modbusNet() != null) {
                    this.modbusNet().getModbusLog().error("Illegal coil status base address on " + this.getName() + ".  Must be a Coil address 0x");
                }
            }
            this.updateProxyPointSubscriptions();
        } else if (property.equals((Object)inputStatusBaseAddress)) {
            if (this.getInputStatusBaseAddress().isModbusFormat() && !this.getInputStatusBaseAddress().isModbusStatusAddress()) {
                this.setInputStatusBaseAddress((BFlexAddress)inputStatusBaseAddress.getDefaultValue());
                if (this.modbusNet() != null) {
                    this.modbusNet().getModbusLog().error("Illegal input status base address on " + this.getName() + ".  Must be a Status address 1x");
                }
            }
            this.updateProxyPointSubscriptions();
        }
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName()).append("[" + this.getDeviceAddress() + ']');
        return stringBuffer.toString();
    }

    public abstract Message sendModbusMessage(Message var1);

    private final void setCommStatusOutput(BDevicePollConfigEntry bDevicePollConfigEntry, int n) {
        if (!this.isDisabled()) {
            boolean bl = false;
            if (n != 0 && n != -2) {
                bl = this.rdCommError = true;
            }
        }
        if (bDevicePollConfigEntry != null) {
            bDevicePollConfigEntry.setReadStatus(new BCommStatus(n));
        }
    }

    public void doPing() {
        ModbusReadRequest modbusReadRequest;
        if (this.isDisabled() || this.isFault()) {
            return;
        }
        if (this.modbusNet() == null) {
            this.pingFail("No modbus network found");
            return;
        }
        if (!this.modbusNet().isCommActive()) {
            return;
        }
        try {
            modbusReadRequest = this.getPingRequest();
        }
        catch (Exception exception) {
            this.modbusNet().getModbusLog().error("Error in " + this.getName() + " pinging.  Check Device Status Monitor Address: ", (Throwable)exception);
            return;
        }
        ModbusResponse modbusResponse = (ModbusResponse)this.sendModbusMessage(modbusReadRequest);
        if (this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace("ping(): " + this.getName() + '[' + this.getDeviceAddress() + "] is " + (modbusResponse == null ? "down" : "up"));
        }
        if (modbusResponse != null && modbusResponse.exceptionCode != 10 && modbusResponse.exceptionCode != 11) {
            this.pingOk();
            this.resetPingsFailed();
        } else if (this.incrementPingsFailed() > ((BModbusClientNetwork)this.modbusNet()).getMaxFailsUntilDeviceDown()) {
            String string = this.getLexicon().getText("pingFail");
            if (modbusResponse != null) {
                string = string + ": " + modbusResponse.getExceptionString();
            }
            this.pingFail(string);
        }
    }

    private final ModbusReadRequest getPingRequest() {
        int n = this.getDeviceAddress();
        int n2 = this.getPointAddress();
        int n3 = 1;
        int n4 = this.getModbusMode();
        if (this.isDataTypeLong()) {
            n3 *= 2;
        } else if (this.isDataTypeFloat()) {
            n3 *= 2;
        }
        int n5 = this.isHoldingRegisterType() ? 3 : 4;
        ModbusReadRequest modbusReadRequest = new ModbusReadRequest(n4, this, n, n5, n2, n3);
        return modbusReadRequest;
    }

    public boolean isPresetMultiple() {
        if (this.getModbusConfig().getOverrideNetwork()) {
            return ((BModbusClientConfig)this.getModbusConfig()).getUsePresetMultipleRegister();
        }
        return ((BModbusClientNetwork)this.getNetwork()).getUsePresetMultipleRegister();
    }

    public boolean isForceMultiple() {
        if (this.getModbusConfig().getOverrideNetwork()) {
            return ((BModbusClientConfig)this.getModbusConfig()).getUseForceMultipleCoil();
        }
        return ((BModbusClientNetwork)this.getNetwork()).getUseForceMultipleCoil();
    }

    public int getPointAddress() {
        return this.getPingAddress().getDataAddress();
    }

    public boolean isHoldingRegisterType() {
        boolean bl = false;
        if (this.getPingAddressRegType() == BRegisterTypeEnum.holding) {
            bl = true;
        }
        return bl;
    }

    public boolean isDataTypeInteger() {
        if (this.getPingAddressDataType() == BDataTypeEnum.integerType) {
            return true;
        }
        return this.getPingAddressDataType() == BDataTypeEnum.signedInteger;
    }

    public boolean isDataTypeLong() {
        boolean bl = false;
        if (this.getPingAddressDataType() == BDataTypeEnum.longType) {
            bl = true;
        }
        return bl;
    }

    public boolean isDataTypeFloat() {
        boolean bl = false;
        if (this.getPingAddressDataType() == BDataTypeEnum.floatType) {
            bl = true;
        }
        return bl;
    }

    public int getRegisterBaseAddress(BEnum bEnum) {
        if (bEnum.equals((Object)BRegisterTypeEnum.holding)) {
            return this.getHoldingRegisterBaseAddress().getDataAddress();
        }
        if (bEnum.equals((Object)BRegisterTypeEnum.input)) {
            return this.getInputRegisterBaseAddress().getDataAddress();
        }
        if (bEnum.equals((Object)BStatusTypeEnum.coil)) {
            return this.getCoilStatusBaseAddress().getDataAddress();
        }
        return this.getInputStatusBaseAddress().getDataAddress();
    }

    protected int getRegisterBaseAddressFromType(BRegisterTypesEnum bRegisterTypesEnum) {
        if (bRegisterTypesEnum.equals((Object)BRegisterTypesEnum.holdingRegister)) {
            return this.getHoldingRegisterBaseAddress().getDataAddress();
        }
        if (bRegisterTypesEnum.equals((Object)BRegisterTypesEnum.inputRegister)) {
            return this.getInputRegisterBaseAddress().getDataAddress();
        }
        if (bRegisterTypesEnum.equals((Object)BRegisterTypesEnum.discreteCoil)) {
            return this.getCoilStatusBaseAddress().getDataAddress();
        }
        return this.getInputStatusBaseAddress().getDataAddress();
    }

    private final void updateProxyPointSubscriptions() {
        BControlPoint[] bControlPointArray = this.getPoints().getPoints();
        int n = 0;
        while (n < bControlPointArray.length) {
            BAbstractProxyExt bAbstractProxyExt = bControlPointArray[n].getProxyExt();
            if (bAbstractProxyExt instanceof BModbusClientProxyExt) {
                ((BModbusClientProxyExt)bAbstractProxyExt).adjustPollSubscription();
            }
            ++n;
        }
    }

    public BCommStatus getHoldingRegistersReadStatus(int n, int n2, BDevicePollConfigEntry bDevicePollConfigEntry) throws ModbusException {
        if (bDevicePollConfigEntry == null) {
            throw new ModbusException(102);
        }
        return bDevicePollConfigEntry.getReadStatus();
    }

    public BCommStatus getInputRegistersReadStatus(int n, int n2, BDevicePollConfigEntry bDevicePollConfigEntry) throws ModbusException {
        if (bDevicePollConfigEntry == null) {
            throw new ModbusException(102);
        }
        return bDevicePollConfigEntry.getReadStatus();
    }

    public BCommStatus getBinaryCoilsReadStatus(int n, int n2, BDevicePollConfigEntry bDevicePollConfigEntry) throws ModbusException {
        if (bDevicePollConfigEntry == null) {
            throw new ModbusException(102);
        }
        return bDevicePollConfigEntry.getReadStatus();
    }

    public BCommStatus getBinaryInputsReadStatus(int n, int n2, BDevicePollConfigEntry bDevicePollConfigEntry) throws ModbusException {
        if (bDevicePollConfigEntry == null) {
            throw new ModbusException(102);
        }
        return bDevicePollConfigEntry.getReadStatus();
    }

    public byte[] getHoldingRegisterValues(int n, int n2, BDevicePollConfigEntry bDevicePollConfigEntry) throws ModbusException {
        int n3;
        byte[] byArray = new byte[n2 * 2];
        try {
            n3 = bDevicePollConfigEntry.getStartAddress().getDataAddress();
        }
        catch (Exception exception) {
            throw new ModbusException(103);
        }
        if (n < n3) {
            throw new ModbusException(102);
        }
        int n4 = n - n3;
        if (n4 + n2 > bDevicePollConfigEntry.getConsecutivePointsToPoll()) {
            throw new ModbusException(102);
        }
        int n5 = n4 * 2;
        if (bDevicePollConfigEntry.getByteArray() == null) {
            throw new ModbusException(103);
        }
        if (bDevicePollConfigEntry.getByteArray().length < bDevicePollConfigEntry.getConsecutivePointsToPoll() * 2) {
            throw new ModbusException(103);
        }
        byte[] byArray2 = bDevicePollConfigEntry.getByteArray();
        int n6 = 0;
        while (n6 < n2 * 2) {
            byArray[n6] = byArray2[n5 + n6];
            ++n6;
        }
        return byArray;
    }

    public byte[] getInputRegisterValues(int n, int n2, BDevicePollConfigEntry bDevicePollConfigEntry) throws ModbusException {
        int n3;
        byte[] byArray = new byte[n2 * 2];
        try {
            n3 = bDevicePollConfigEntry.getStartAddress().getDataAddress();
        }
        catch (Exception exception) {
            throw new ModbusException(103);
        }
        if (n < n3) {
            throw new ModbusException(102);
        }
        int n4 = n - n3;
        if (n4 + n2 > bDevicePollConfigEntry.getConsecutivePointsToPoll()) {
            throw new ModbusException(102);
        }
        int n5 = n4 * 2;
        if (bDevicePollConfigEntry.getByteArray() == null) {
            throw new ModbusException(103);
        }
        if (bDevicePollConfigEntry.getByteArray().length < bDevicePollConfigEntry.getConsecutivePointsToPoll() * 2) {
            throw new ModbusException(103);
        }
        byte[] byArray2 = bDevicePollConfigEntry.getByteArray();
        int n6 = 0;
        while (n6 < n2 * 2) {
            byArray[n6] = byArray2[n5 + n6];
            ++n6;
        }
        return byArray;
    }

    public byte[] getCoilStatusValues(int n, int n2, BDevicePollConfigEntry bDevicePollConfigEntry) throws ModbusException {
        int n3;
        int n4 = 1;
        byte[] byArray = new byte[n4];
        try {
            n3 = bDevicePollConfigEntry.getStartAddress().getDataAddress();
        }
        catch (Exception exception) {
            throw new ModbusException(103);
        }
        if (n < n3) {
            throw new ModbusException(102);
        }
        int n5 = n - n3;
        if (n5 + n2 > bDevicePollConfigEntry.getConsecutivePointsToPoll()) {
            throw new ModbusException(102);
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 255 >> 8 - n2;
        if (n5 != 0) {
            n7 = n5 % 8;
            n6 = n5 / 8;
        }
        if (bDevicePollConfigEntry.getByteArray() == null) {
            throw new ModbusException(103);
        }
        if (bDevicePollConfigEntry.getByteArray().length < n4) {
            throw new ModbusException(103);
        }
        byte[] byArray2 = bDevicePollConfigEntry.getByteArray();
        if (n7 == 0) {
            byArray[0] = (byte)(byArray2[n6] & n8);
        } else {
            int n9 = byArray2[n6] & 0xFF;
            if (n7 + n2 > 8) {
                n9 |= (byArray2[n6 + 1] & 0xFF) << 8;
            }
            byArray[0] = (byte)((n9 >>= n7) & n8);
        }
        return byArray;
    }

    public byte[] getInputStatusValues(int n, int n2, BDevicePollConfigEntry bDevicePollConfigEntry) throws ModbusException {
        byte[] byArray;
        int n3;
        int n4 = 1;
        byte[] byArray2 = new byte[n4];
        try {
            n3 = bDevicePollConfigEntry.getStartAddress().getDataAddress();
        }
        catch (Exception exception) {
            throw new ModbusException(103);
        }
        if (n < n3) {
            throw new ModbusException(102);
        }
        int n5 = n - n3;
        if (n5 + n2 > bDevicePollConfigEntry.getConsecutivePointsToPoll()) {
            throw new ModbusException(102);
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 255 >> 8 - n2;
        if (n5 != 0) {
            n7 = n5 % 8;
            n6 = n5 / 8;
        }
        if ((byArray = bDevicePollConfigEntry.getByteArray()) == null) {
            throw new ModbusException(103);
        }
        if (byArray.length < n4) {
            throw new ModbusException(103);
        }
        if (n7 == 0) {
            byArray2[0] = (byte)(byArray[n6] & n8);
        } else {
            int n9 = byArray[n6] & 0xFF;
            if (n7 + n2 > 8) {
                n9 |= (byArray[n6 + 1] & 0xFF) << 8;
            }
            byArray2[0] = (byte)((n9 >>= n7) & n8);
        }
        return byArray2;
    }

    public byte[] readRegisters(int n, int n2, int n3, int n4, BDevicePollConfigEntry bDevicePollConfigEntry) throws ModbusException {
        int n5 = this.getDeviceAddress();
        byte[] byArray = new byte[(n3 / n4 + 1) * n4 * 2];
        int n6 = 125 - 125 % n4;
        int n7 = this.getModbusMode();
        if (n7 == 0) {
            n6 /= 2;
        }
        int n8 = 0;
        int n9 = 0;
        if (n3 == 0) {
            this.setCommStatusOutput(bDevicePollConfigEntry, -2);
            return byArray;
        }
        if (n != 3 && n != 4) {
            throw new ModbusException(100);
        }
        do {
            ModbusReadRequest modbusReadRequest;
            ModbusResponse modbusResponse;
            if ((modbusResponse = (ModbusResponse)this.sendModbusMessage(modbusReadRequest = new ModbusReadRequest(n7, this, n5, n, n2, n8 = n3 > n6 ? n6 : n3 + n3 % n4))) == null) {
                modbusResponse = new ModbusResponse(n7, this);
                modbusResponse.exceptionCode = 9;
                this.setCommStatusOutput(bDevicePollConfigEntry, modbusResponse.exceptionCode);
                throw new ModbusException(101);
            }
            int n10 = 0;
            while (n10 < modbusResponse.byteCount) {
                byArray[n9] = modbusResponse.data[n10];
                ++n9;
                ++n10;
            }
            this.setCommStatusOutput(bDevicePollConfigEntry, modbusResponse.exceptionCode);
            n2 += n6;
        } while ((n3 -= n6) >= 0);
        return byArray;
    }

    public byte[] readStatusRegisters(int n, int n2, int n3, BDevicePollConfigEntry bDevicePollConfigEntry) throws ModbusException {
        int n4 = this.getDeviceAddress();
        int n5 = 0;
        int n6 = 2000;
        int n7 = this.getModbusMode();
        if (n7 == 0) {
            n6 /= 2;
        }
        int n8 = 0;
        n8 = n3 % 8 > 0 ? n3 / 8 + 1 : n3 / 8;
        byte[] byArray = new byte[n8];
        int n9 = 0;
        if (n3 == 0) {
            this.setCommStatusOutput(bDevicePollConfigEntry, -2);
            return byArray;
        }
        if (n != 2 && n != 1) {
            throw new ModbusException(100);
        }
        do {
            ModbusReadRequest modbusReadRequest;
            ModbusResponse modbusResponse;
            if ((modbusResponse = (ModbusResponse)this.sendModbusMessage(modbusReadRequest = new ModbusReadRequest(n7, this, n4, n, n2, n5 = n3 > n6 ? n6 : n3))) == null) {
                modbusResponse = new ModbusResponse(n7, this);
                modbusResponse.exceptionCode = 9;
                this.setCommStatusOutput(bDevicePollConfigEntry, modbusResponse.exceptionCode);
                throw new ModbusException(101);
            }
            int n10 = 0;
            while (n10 < modbusResponse.byteCount) {
                byArray[n9] = modbusResponse.data[n10];
                ++n9;
                ++n10;
            }
            this.setCommStatusOutput(bDevicePollConfigEntry, modbusResponse.exceptionCode);
            n2 += n6;
        } while ((n3 -= n6) > 0);
        return byArray;
    }

    public BDevicePollConfigEntry[] getOptimumDevicePollConfigEntryList() {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int n;
        int n2;
        int n3;
        int[] nArray4;
        BControlPoint[] bControlPointArray = this.getPoints().getPoints();
        if (bControlPointArray == null || bControlPointArray.length < 1) {
            return null;
        }
        BDevicePollConfigEntry[] bDevicePollConfigEntryArray = new BDevicePollConfigEntry[bControlPointArray.length];
        int n4 = 0;
        Vector<BAbstractProxyExt> vector = new Vector<BAbstractProxyExt>();
        Vector<BAbstractProxyExt> vector2 = new Vector<BAbstractProxyExt>();
        Vector<BAbstractProxyExt> vector3 = new Vector<BAbstractProxyExt>();
        Vector<BAbstractProxyExt> vector4 = new Vector<BAbstractProxyExt>();
        int n5 = 0;
        while (n5 < bControlPointArray.length) {
            BAbstractProxyExt bAbstractProxyExt = bControlPointArray[n5].getProxyExt();
            if (bAbstractProxyExt instanceof BModbusClientProxyExt) {
                BRegisterTypesEnum bRegisterTypesEnum = ((BModbusClientProxyExt)bAbstractProxyExt).determineRegisterType();
                if (bRegisterTypesEnum.equals((Object)BRegisterTypesEnum.holdingRegister)) {
                    vector.addElement(bAbstractProxyExt);
                } else if (bRegisterTypesEnum.equals((Object)BRegisterTypesEnum.inputRegister)) {
                    vector2.addElement(bAbstractProxyExt);
                } else if (bRegisterTypesEnum.equals((Object)BRegisterTypesEnum.discreteCoil)) {
                    vector3.addElement(bAbstractProxyExt);
                } else if (bRegisterTypesEnum.equals((Object)BRegisterTypesEnum.discreteInput)) {
                    vector4.addElement(bAbstractProxyExt);
                }
            }
            ++n5;
        }
        if (vector.size() > 0 && (nArray4 = BModbusClientDevice.sortByAbsoluteAddress(vector)) != null && nArray4.length > 0) {
            int n6 = 0;
            while (n6 < nArray4.length) {
                int n7 = nArray4[n6];
                n3 = 1;
                int n8 = n2 = n6 + 1;
                while (n8 < nArray4.length) {
                    n6 = n8;
                    n = nArray4[n8] - nArray4[n8 - 1];
                    if (n > 0) {
                        if (n != 1) break;
                        ++n3;
                    }
                    ++n8;
                }
                if (n3 > 1) {
                    BFlexAddress bFlexAddress = new BFlexAddress();
                    bFlexAddress.setAddressFormat(BAddressFormatEnum.modbus);
                    bFlexAddress.setAddressFromInt(n7 + 40001);
                    bDevicePollConfigEntryArray[n4] = new BDevicePollConfigEntry(true, BRegisterTypesEnum.holdingRegister, bFlexAddress, n3, 1);
                    ++n4;
                }
                if (n2 < nArray4.length) continue;
                ++n6;
            }
        }
        if (vector2.size() > 0 && (nArray3 = BModbusClientDevice.sortByAbsoluteAddress(vector2)) != null && nArray3.length > 0) {
            int n9 = 0;
            while (n9 < nArray3.length) {
                int n10 = nArray3[n9];
                n3 = 1;
                int n11 = n2 = n9 + 1;
                while (n11 < nArray3.length) {
                    n9 = n11;
                    n = nArray3[n11] - nArray3[n11 - 1];
                    if (n > 0) {
                        if (n != 1) break;
                        ++n3;
                    }
                    ++n11;
                }
                if (n3 > 1) {
                    BFlexAddress bFlexAddress = new BFlexAddress();
                    bFlexAddress.setAddressFormat(BAddressFormatEnum.modbus);
                    bFlexAddress.setAddressFromInt(n10 + 30001);
                    bDevicePollConfigEntryArray[n4] = new BDevicePollConfigEntry(true, BRegisterTypesEnum.inputRegister, bFlexAddress, n3, 1);
                    ++n4;
                }
                if (n2 < nArray3.length) continue;
                ++n9;
            }
        }
        if (vector3.size() > 0 && (nArray2 = BModbusClientDevice.sortByAbsoluteAddress(vector3)) != null && nArray2.length > 0) {
            int n12 = 0;
            while (n12 < nArray2.length) {
                int n13 = nArray2[n12];
                n3 = 1;
                int n14 = n2 = n12 + 1;
                while (n14 < nArray2.length) {
                    n12 = n14;
                    n = nArray2[n14] - nArray2[n14 - 1];
                    if (n > 0) {
                        if (n != 1) break;
                        ++n3;
                    }
                    ++n14;
                }
                if (n3 > 1) {
                    BFlexAddress bFlexAddress = new BFlexAddress();
                    bFlexAddress.setAddressFormat(BAddressFormatEnum.modbus);
                    bFlexAddress.setAddressFromInt(n13 + 1);
                    bDevicePollConfigEntryArray[n4] = new BDevicePollConfigEntry(true, BRegisterTypesEnum.discreteCoil, bFlexAddress, n3, 1);
                    ++n4;
                }
                if (n2 < nArray2.length) continue;
                ++n12;
            }
        }
        if (vector4.size() > 0 && (nArray = BModbusClientDevice.sortByAbsoluteAddress(vector4)) != null && nArray.length > 0) {
            int n15 = 0;
            while (n15 < nArray.length) {
                int n16 = nArray[n15];
                n3 = 1;
                int n17 = n2 = n15 + 1;
                while (n17 < nArray.length) {
                    n15 = n17;
                    n = nArray[n17] - nArray[n17 - 1];
                    if (n > 0) {
                        if (n != 1) break;
                        ++n3;
                    }
                    ++n17;
                }
                if (n3 > 1) {
                    BFlexAddress bFlexAddress = new BFlexAddress();
                    bFlexAddress.setAddressFormat(BAddressFormatEnum.modbus);
                    bFlexAddress.setAddressFromInt(n16 + 10001);
                    bDevicePollConfigEntryArray[n4] = new BDevicePollConfigEntry(true, BRegisterTypesEnum.discreteInput, bFlexAddress, n3, 1);
                    ++n4;
                }
                if (n2 < nArray.length) continue;
                ++n15;
            }
        }
        BDevicePollConfigEntry[] bDevicePollConfigEntryArray2 = new BDevicePollConfigEntry[n4];
        System.arraycopy(bDevicePollConfigEntryArray, 0, bDevicePollConfigEntryArray2, 0, n4);
        return bDevicePollConfigEntryArray2;
    }

    private static final int[] sortByAbsoluteAddress(Vector vector) {
        Vector<Integer> vector2 = new Vector<Integer>();
        Object[] objectArray = vector.toArray();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof BModbusClientStringProxyExt) {
                vector2.addElement(new Integer(((BModbusClientStringProxyExt)objectArray[n]).getAbsoluteAddress().getDataAddress()));
                int n2 = 1;
                while (n2 < ((BModbusClientStringProxyExt)objectArray[n]).getNumberRegisters()) {
                    vector2.addElement(new Integer(((BModbusClientStringProxyExt)objectArray[n]).getAbsoluteAddress().getDataAddress() + n2));
                    ++n2;
                }
            } else if (objectArray[n] instanceof BModbusClientNumericProxyExt) {
                vector2.addElement(new Integer(((BModbusClientNumericProxyExt)objectArray[n]).getAbsoluteAddress().getDataAddress()));
                if (((BModbusClientNumericProxyExt)objectArray[n]).getDataType().equals((Object)BDataTypeEnum.floatType) || ((BModbusClientNumericProxyExt)objectArray[n]).getDataType().equals((Object)BDataTypeEnum.longType)) {
                    vector2.addElement(new Integer(((BModbusClientNumericProxyExt)objectArray[n]).getAbsoluteAddress().getDataAddress() + 1));
                }
            } else if (objectArray[n] instanceof BModbusClientProxyExt) {
                vector2.addElement(new Integer(((BModbusClientProxyExt)objectArray[n]).getAbsoluteAddress().getDataAddress()));
            }
            ++n;
        }
        if (vector2.size() < 1) {
            return null;
        }
        Object[] objectArray2 = vector2.toArray();
        int[] nArray = new int[objectArray2.length];
        int n3 = 0;
        while (n3 < objectArray2.length) {
            nArray[n3] = (Integer)objectArray2[n3];
            ++n3;
        }
        Arrays.sort(nArray);
        return nArray;
    }

    public BPointDeviceExt getPointDeviceExt() {
        return this.getPoints();
    }

    public int incrementPingsFailed() {
        ++this.pingsFailed;
        return this.pingsFailed;
    }

    public void resetPingsFailed() {
        this.pingsFailed = 0;
    }

    public void addWritableProxy(BModbusClientProxyExt bModbusClientProxyExt) {
        if (this.writableProxies.contains(bModbusClientProxyExt)) {
            return;
        }
        this.writableProxies.add(bModbusClientProxyExt);
    }

    public void removeWritableProxy(BModbusClientProxyExt bModbusClientProxyExt) {
        this.writableProxies.remove(bModbusClientProxyExt);
    }

    public boolean writablePointAlreadyExists(BModbusClientProxyExt bModbusClientProxyExt) {
        int n;
        if (bModbusClientProxyExt == null) {
            return false;
        }
        if (this.writableProxies.size() <= 0) {
            return false;
        }
        int n2 = 0;
        if (bModbusClientProxyExt instanceof BModbusClientNumericProxyExt && (((BModbusClientNumericProxyExt)bModbusClientProxyExt).isDataTypeLong() || ((BModbusClientNumericProxyExt)bModbusClientProxyExt).isDataTypeFloat())) {
            n2 = 1;
        }
        if ((n = bModbusClientProxyExt.getDataAddress().getDataAddress()) < 0) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.writableProxies.size()) {
            BModbusClientProxyExt bModbusClientProxyExt2 = (BModbusClientProxyExt)this.writableProxies.elementAt(n3);
            if (!bModbusClientProxyExt2.equals(bModbusClientProxyExt) && bModbusClientProxyExt2 instanceof BModbusClientProxyExt) {
                int n4 = bModbusClientProxyExt2.getDataAddress().getDataAddress();
                if (bModbusClientProxyExt2 instanceof BModbusClientRegisterBitProxyExt && bModbusClientProxyExt instanceof BModbusClientRegisterBitProxyExt) {
                    if (bModbusClientProxyExt2.determineRegisterType().equals((Object)bModbusClientProxyExt.determineRegisterType()) && n4 == n && ((BModbusClientRegisterBitProxyExt)bModbusClientProxyExt2).getBitNumber() == ((BModbusClientRegisterBitProxyExt)bModbusClientProxyExt).getBitNumber()) {
                        return true;
                    }
                } else if (bModbusClientProxyExt2 instanceof BModbusClientNumericBitsProxyExt && bModbusClientProxyExt instanceof BModbusClientNumericBitsProxyExt) {
                    if (bModbusClientProxyExt2.determineRegisterType().equals((Object)bModbusClientProxyExt.determineRegisterType()) && n4 == n && (((BModbusClientNumericBitsProxyExt)bModbusClientProxyExt2).getRegisterMask() & ((BModbusClientNumericBitsProxyExt)bModbusClientProxyExt).getRegisterMask()) != 0) {
                        return true;
                    }
                } else if (bModbusClientProxyExt2 instanceof BModbusClientNumericBitsProxyExt && bModbusClientProxyExt instanceof BModbusClientRegisterBitProxyExt) {
                    if (bModbusClientProxyExt2.determineRegisterType().equals((Object)bModbusClientProxyExt.determineRegisterType()) && n4 == n && (((BModbusClientNumericBitsProxyExt)bModbusClientProxyExt2).getRegisterMask() & 1 << ((BModbusClientRegisterBitProxyExt)bModbusClientProxyExt).getBitNumber()) != 0) {
                        return true;
                    }
                } else if (bModbusClientProxyExt2 instanceof BModbusClientRegisterBitProxyExt && bModbusClientProxyExt instanceof BModbusClientNumericBitsProxyExt) {
                    if (bModbusClientProxyExt2.determineRegisterType().equals((Object)bModbusClientProxyExt.determineRegisterType()) && n4 == n && (((BModbusClientNumericBitsProxyExt)bModbusClientProxyExt).getRegisterMask() & 1 << ((BModbusClientRegisterBitProxyExt)bModbusClientProxyExt2).getBitNumber()) != 0) {
                        return true;
                    }
                } else {
                    int n5 = 0;
                    if (bModbusClientProxyExt2 instanceof BModbusClientNumericProxyExt && (((BModbusClientNumericProxyExt)bModbusClientProxyExt2).isDataTypeLong() || ((BModbusClientNumericProxyExt)bModbusClientProxyExt2).isDataTypeFloat())) {
                        n5 = 1;
                    }
                    if (bModbusClientProxyExt2.determineRegisterType().equals((Object)bModbusClientProxyExt.determineRegisterType()) && (n4 == n || n4 == n + n2 || n4 + n5 == n || n4 + n5 == n + n2)) {
                        return true;
                    }
                }
            }
            ++n3;
        }
        return false;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        try {
            spyWriter.startProps();
            spyWriter.trTitle((Object)"WritablePoint Cache", 1);
            int n = 0;
            while (n < this.writableProxies.size()) {
                BModbusClientProxyExt bModbusClientProxyExt = (BModbusClientProxyExt)this.writableProxies.elementAt(n);
                BControlPoint bControlPoint = bModbusClientProxyExt.getParentPoint();
                String string = "";
                string = bModbusClientProxyExt.getType().is(BModbusClientBooleanProxyExt.TYPE) ? "Coil   : 0x" : "Holding: 0x";
                string = string + Integer.toHexString(bModbusClientProxyExt.getDataAddress().getDataAddress()) + ": ";
                spyWriter.prop((Object)string, (Object)bModbusClientProxyExt.getParentPoint().getSlotPath());
                ++n;
            }
            spyWriter.endProps();
        }
        catch (Exception exception) {
            spyWriter.endProps();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.writableProxies = new Vector();
        this.pingsFailed = 0;
        this.rdCommError = false;
        this.pollRegistered = false;
    }

    public BModbusClientDevice() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$modbusCore$client$BModbusClientDevice;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$client$BModbusClientDevice = BModbusClientDevice.class("[Lcom.tridium.modbusCore.client.BModbusClientDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

