/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.modbusCore.enums.BDataByteOrderEnum;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BModbusNetwork
extends BBasicNetwork {
    public static final Property floatByteOrder = BModbusNetwork.newProperty((int)0, (BValue)BDataByteOrderEnum.order3210, null);
    public static final Property longByteOrder = BModbusNetwork.newProperty((int)0, (BValue)BDataByteOrderEnum.order3210, null);
    public static final Type TYPE;
    protected Subscriber subscriber;
    protected Log modbusLog;
    private long totalCrcErrors;
    private long totalLrcErrors;
    private long totalTransactionIdErrors;
    static /* synthetic */ Class class$com$tridium$modbusCore$BModbusNetwork;

    public BDataByteOrderEnum getFloatByteOrder() {
        return (BDataByteOrderEnum)this.get(floatByteOrder);
    }

    public void setFloatByteOrder(BDataByteOrderEnum bDataByteOrderEnum) {
        this.set(floatByteOrder, (BValue)bDataByteOrderEnum, null);
    }

    public BDataByteOrderEnum getLongByteOrder() {
        return (BDataByteOrderEnum)this.get(longByteOrder);
    }

    public void setLongByteOrder(BDataByteOrderEnum bDataByteOrderEnum) {
        this.set(longByteOrder, (BValue)bDataByteOrderEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        this.subscriber = new NameSubscriber(this);
        this.subscriber.subscribe((BComponent)this.getParent());
    }

    public void serviceStopped() throws Exception {
        this.subscriber.unsubscribeAll();
        this.subscriber = null;
        super.serviceStopped();
    }

    public abstract int getModbusMode();

    public Log getModbusLog() {
        String string = this.getName();
        if (!SlotPath.isValidName((String)string)) {
            string = SlotPath.escape((String)string);
        }
        return Log.getLog((String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateLog() {
        String string = this.getName();
        if (!SlotPath.isValidName((String)string)) {
            string = SlotPath.escape((String)string);
        }
        Log log = Log.getLog((String)string);
        if (this.modbusLog == null) {
            this.modbusLog = this.getModbusLog();
        }
        Log log2 = this.modbusLog;
        synchronized (log2) {
            if (this.modbusLog != null) {
                log.setSeverity(this.modbusLog.getSeverity());
                if (!log.getLogName().equals(this.modbusLog.getLogName())) {
                    Log.deleteLog((String)this.modbusLog.getLogName());
                }
            }
            this.modbusLog = log;
            return;
        }
    }

    protected void processNameSubscriberEvent(BComponentEvent bComponentEvent) {
        try {
            if (bComponentEvent.getId() == 3 && bComponentEvent.getSlot().equals((Object)this.getPropertyInParent())) {
                this.updateLog();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Subscriber getNameSubscriber() {
        return this.subscriber;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"ModbusNetwork", 2);
        spyWriter.prop((Object)"Total CRC Errors", (Object)new Long(this.totalCrcErrors));
        spyWriter.prop((Object)"Total LRC Errors", (Object)new Long(this.totalLrcErrors));
        spyWriter.prop((Object)"Total Transaction ID Errors", (Object)new Long(this.totalTransactionIdErrors));
        spyWriter.endProps();
    }

    public final void incrementCrcErrors() {
        ++this.totalCrcErrors;
    }

    public final void incrementLrcErrors() {
        ++this.totalLrcErrors;
    }

    public final void incrementTransactionIdErrors() {
        ++this.totalTransactionIdErrors;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.modbusLog = null;
        this.totalCrcErrors = 0L;
        this.totalLrcErrors = 0L;
        this.totalTransactionIdErrors = 0L;
    }

    public BModbusNetwork() {
        this.this();
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
    }

    static {
        Class clazz = class$com$tridium$modbusCore$BModbusNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$BModbusNetwork = BModbusNetwork.class("[Lcom.tridium.modbusCore.BModbusNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NameSubscriber
    extends Subscriber {
        private BModbusNetwork net;

        public void event(BComponentEvent bComponentEvent) {
            this.net.processNameSubscriberEvent(bComponentEvent);
        }

        public NameSubscriber(BModbusNetwork bModbusNetwork2) {
            this.net = bModbusNetwork2;
        }
    }
}

