/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore;

import com.tridium.basicdriver.BBasicDevice;
import com.tridium.modbusCore.BModbusNetwork;
import com.tridium.modbusCore.datatypes.BModbusConfig;
import com.tridium.modbusCore.enums.BDataByteOrderEnum;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BModbusDevice
extends BBasicDevice {
    public static final Property deviceAddress = BModbusDevice.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)247));
    public static final Property modbusConfig = BModbusDevice.newProperty((int)0, (BValue)new BModbusConfig(), null);
    public static final Type TYPE;
    private long totalCrcErrors;
    private long totalLrcErrors;
    private long totalTransactionIdErrors;
    static /* synthetic */ Class class$com$tridium$modbusCore$BModbusDevice;

    public int getDeviceAddress() {
        return this.getInt(deviceAddress);
    }

    public void setDeviceAddress(int n) {
        this.setInt(deviceAddress, n, null);
    }

    public BModbusConfig getModbusConfig() {
        return (BModbusConfig)this.get(modbusConfig);
    }

    public void setModbusConfig(BModbusConfig bModbusConfig) {
        this.set(modbusConfig, (BValue)bModbusConfig, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isFloat3210Order() {
        if (this.getModbusConfig().getOverrideNetwork()) {
            boolean bl = false;
            if (this.getModbusConfig().getFloatByteOrder() == BDataByteOrderEnum.order3210) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if (((BModbusNetwork)this.getNetwork()).getFloatByteOrder() == BDataByteOrderEnum.order3210) {
            bl = true;
        }
        return bl;
    }

    public boolean isLong3210Order() {
        if (this.getModbusConfig().getOverrideNetwork()) {
            boolean bl = false;
            if (this.getModbusConfig().getLongByteOrder() == BDataByteOrderEnum.order3210) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if (((BModbusNetwork)this.getNetwork()).getLongByteOrder() == BDataByteOrderEnum.order3210) {
            bl = true;
        }
        return bl;
    }

    public BModbusNetwork modbusNet() {
        return (BModbusNetwork)this.getNetwork();
    }

    public abstract BPointDeviceExt getPointDeviceExt();

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"ModbusDevice", 2);
        spyWriter.prop((Object)"Total CRC Errors", (Object)new Long(this.totalCrcErrors));
        spyWriter.prop((Object)"Total LRC Errors", (Object)new Long(this.totalLrcErrors));
        spyWriter.prop((Object)"Total Transaction ID Errors", (Object)new Long(this.totalTransactionIdErrors));
        spyWriter.endProps();
    }

    public final void incrementCrcErrors() {
        ++this.totalCrcErrors;
        if (this.modbusNet() != null) {
            this.modbusNet().incrementCrcErrors();
        }
    }

    public final void incrementLrcErrors() {
        ++this.totalLrcErrors;
        if (this.modbusNet() != null) {
            this.modbusNet().incrementLrcErrors();
        }
    }

    public final void incrementTransactionIdErrors() {
        ++this.totalTransactionIdErrors;
        if (this.modbusNet() != null) {
            this.modbusNet().incrementTransactionIdErrors();
        }
    }

    public int getModbusMode() {
        return 0;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.totalCrcErrors = 0L;
        this.totalLrcErrors = 0L;
        this.totalTransactionIdErrors = 0L;
    }

    public BModbusDevice() {
        this.this();
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
    }

    static {
        Class clazz = class$com$tridium$modbusCore$BModbusDevice;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$BModbusDevice = BModbusDevice.class("[Lcom.tridium.modbusCore.BModbusDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

