/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.virtual;

import com.tridium.bacnet.asn.NErrorType;
import javax.baja.bacnet.datatypes.BBacnetPropertyReference;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.LocalBacnetPoll;
import javax.baja.bacnet.util.PollListEntry;
import javax.baja.bacnet.virtual.BLocalBacnetVirtualGateway;
import javax.baja.bacnet.virtual.BLocalBacnetVirtualObject;
import javax.baja.bacnet.virtual.BLocalBacnetVirtualProperty;
import javax.baja.status.BStatus;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LocalBacnetVirtualPoll
extends LocalBacnetPoll {
    private BLocalBacnetVirtualGateway gateway;

    protected BRelTime getPollRate() {
        return this.gateway.getPollRate();
    }

    protected String getThreadName() {
        return "Local Bacnet Virtual Poll";
    }

    protected Type getPolledType() {
        return BLocalBacnetVirtualProperty.TYPE;
    }

    protected boolean poll(BObject bObject) throws Exception {
        BLocalBacnetVirtualProperty bLocalBacnetVirtualProperty = (BLocalBacnetVirtualProperty)bObject;
        BIBacnetExportObject bIBacnetExportObject = ((BLocalBacnetVirtualObject)bLocalBacnetVirtualProperty.getParent()).getExport();
        PollListEntry[] pollListEntryArray = bLocalBacnetVirtualProperty.getPollListEntries();
        int n = 0;
        while (n < pollListEntryArray.length) {
            PollListEntry pollListEntry = pollListEntryArray[n];
            try {
                BBacnetPropertyReference bBacnetPropertyReference = new BBacnetPropertyReference(pollListEntry.getPropertyId(), pollListEntry.getPropertyArrayIndex());
                PropertyValue propertyValue = bIBacnetExportObject.readProperty(bBacnetPropertyReference);
                if (!propertyValue.isError()) {
                    bLocalBacnetVirtualProperty.fromEncodedValue(propertyValue.getPropertyValue(), BStatus.ok, pollListEntry);
                } else {
                    bLocalBacnetVirtualProperty.readFail(NErrorType.toString(propertyValue.getErrorClass(), propertyValue.getErrorCode()));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bLocalBacnetVirtualProperty.readFail(exception.toString());
            }
            ++n;
        }
        return true;
    }

    private final /* synthetic */ void this() {
        this.gateway = null;
    }

    LocalBacnetVirtualPoll(BLocalBacnetVirtualGateway bLocalBacnetVirtualGateway) {
        this.this();
        this.gateway = bLocalBacnetVirtualGateway;
    }
}

