/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.virtual;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.virtual.BVirtualComponent;

public class BacnetVirtualUtil
implements BacnetConst {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static BValue readValue(AsnInputStream asnInputStream, BValue bValue) throws AsnException {
        AsnInputStream asnInputStream2 = asnInputStream;
        synchronized (asnInputStream2) {
            Object object;
            block20: {
                block19: {
                    object = bValue;
                    if (!(object instanceof BIBacnetDataType)) break block19;
                    BIBacnetDataType bIBacnetDataType = (BIBacnetDataType)object;
                    bIBacnetDataType.readAsn(asnInputStream);
                    break block20;
                }
                int n = asnInputStream.peekApplicationTag();
                switch (n) {
                    case 0: {
                        return BBacnetNull.DEFAULT;
                    }
                    case 1: {
                        return BBoolean.make((boolean)asnInputStream.readBoolean());
                    }
                    case 2: {
                        return asnInputStream.readUnsigned();
                    }
                    case 3: {
                        return asnInputStream.readSigned();
                    }
                    case 4: {
                        return asnInputStream.readFloat();
                    }
                    case 5: {
                        return BDouble.make((double)asnInputStream.readDouble());
                    }
                    case 6: {
                        return BBacnetOctetString.make(asnInputStream.readOctetString());
                    }
                    case 7: {
                        return BString.make((String)asnInputStream.readCharacterString());
                    }
                    case 8: {
                        return asnInputStream.readBitString();
                    }
                    case 9: {
                        if (!(object instanceof BEnum)) return BInteger.make((int)asnInputStream.readEnumerated());
                        return ((BEnum)object).getRange().get(asnInputStream.readEnumerated());
                    }
                    case 10: {
                        return asnInputStream.readDate();
                    }
                    case 11: {
                        return asnInputStream.readTime();
                    }
                    case 12: {
                        return asnInputStream.readObjectIdentifier();
                    }
                    case 13: 
                    case 14: 
                    case 15: {
                        break;
                    }
                    default: {
                        return AsnUtil.asnToValue(asnInputStream, -1);
                    }
                }
            }
            return object;
        }
    }

    public static boolean isVirtual(BComponent bComponent) {
        if (bComponent.getComponentSpace() == null) {
            return false;
        }
        BComponent bComponent2 = bComponent.getComponentSpace().getRootComponent();
        return bComponent2 instanceof BVirtualComponent;
    }

    public static BBacnetVirtualProperty getVirtualProperty(BComponent bComponent) {
        if (!BacnetVirtualUtil.isVirtual(bComponent)) {
            return null;
        }
        BComplex bComplex = bComponent.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BBacnetVirtualProperty) {
                return (BBacnetVirtualProperty)bComplex;
            }
            bComplex = bComplex.getParent();
        }
        return null;
    }
}

