/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.util.worker;

import java.util.ArrayList;
import java.util.List;
import javax.baja.bacnet.util.worker.BBacnetWorkerPool;
import javax.baja.bacnet.util.worker.IBacnetAddress;
import javax.baja.bacnet.util.worker.IWorkerPool;
import javax.baja.bacnet.util.worker.IWorkerPoolAware;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetAddressWorkerPool
extends BComponent
implements IWorkerPool {
    private static final int DEFAULT_POOLS = 4;
    private static final int DEFAULT_WORKERS_PER_POOL = 2;
    public static final Property addressPools = BBacnetAddressWorkerPool.newProperty((int)0, (int)4, null);
    public static final Property workersPerAddressPool = BBacnetAddressWorkerPool.newProperty((int)0, (int)2, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private List addressWorkers;
    private Object lock;
    static /* synthetic */ Class class$javax$baja$bacnet$util$worker$BBacnetAddressWorkerPool;

    public int getAddressPools() {
        return this.getInt(addressPools);
    }

    public void setAddressPools(int n) {
        this.setInt(addressPools, n, null);
    }

    public int getWorkersPerAddressPool() {
        return this.getInt(workersPerAddressPool);
    }

    public void setWorkersPerAddressPool(int n) {
        this.setInt(workersPerAddressPool, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return BBacnetWorkerPool.isLegalParent(bComponent);
    }

    public void started() {
        this.startPools();
    }

    public void stopped() {
        this.stopPools();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)addressPools) || property.equals((Object)workersPerAddressPool)) {
            this.restartPools();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void restartPools() {
        Object object = this.lock;
        synchronized (object) {
            this.stopPools();
            this.startPools();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void startPools() {
        Object object = this.lock;
        synchronized (object) {
            int n = this.getAddressPools();
            this.addressWorkers = new ArrayList(n);
            IWorkerPoolAware iWorkerPoolAware = (IWorkerPoolAware)this.getParent();
            int n2 = iWorkerPoolAware.getQueue().maxSize();
            String string = iWorkerPoolAware.getWorkerThreadName();
            int n3 = 0;
            while (true) {
                if (n3 >= n) {
                    iWorkerPoolAware.stopWorker();
                    return;
                }
                CoalesceQueue coalesceQueue = new CoalesceQueue(n2);
                ThreadPoolWorker threadPoolWorker = new ThreadPoolWorker((Worker.ITodo)coalesceQueue);
                threadPoolWorker.setMaxThreads(this.getWorkersPerAddressPool());
                threadPoolWorker.start(string + n3);
                this.addressWorkers.add(new AddressWorker(threadPoolWorker, (Queue)coalesceQueue));
                ++n3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void stopPools() {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (this.addressWorkers == null) break block5;
                int n = this.addressWorkers.size();
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        this.addressWorkers.clear();
                        break;
                    }
                    AddressWorker addressWorker = (AddressWorker)this.addressWorkers.get(n2);
                    addressWorker.stop();
                    ++n2;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IFuture post(Runnable runnable) {
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        Object object = this.lock;
        synchronized (object) {
            block6: {
                block5: {
                    if (!(runnable instanceof IBacnetAddress)) break block5;
                    IBacnetAddress iBacnetAddress = (IBacnetAddress)((Object)runnable);
                    int n = iBacnetAddress.getAddress().hash() % this.addressWorkers.size();
                    AddressWorker addressWorker = (AddressWorker)this.addressWorkers.get(n);
                    addressWorker.enqueue(runnable);
                    break block6;
                }
                if (this.addressWorkers.size() > 0) {
                    AddressWorker addressWorker = (AddressWorker)this.addressWorkers.get(0);
                    addressWorker.enqueue(runnable);
                }
            }
            return null;
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lock = new Object();
    }

    public BBacnetAddressWorkerPool() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$bacnet$util$worker$BBacnetAddressWorkerPool;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$util$worker$BBacnetAddressWorkerPool = BBacnetAddressWorkerPool.class("[Ljavax.baja.bacnet.util.worker.BBacnetAddressWorkerPool;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"gears.png");
    }

    private static class AddressWorker {
        private ThreadPoolWorker worker;
        private Queue queue;

        public void stop() {
            if (this.worker != null) {
                this.worker.stop();
            }
        }

        public void enqueue(Runnable runnable) {
            this.queue.enqueue((Object)runnable);
        }

        public AddressWorker(ThreadPoolWorker threadPoolWorker, Queue queue) {
            this.worker = threadPoolWorker;
            this.queue = queue;
        }
    }
}

