/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.util;

import com.tridium.bacnet.asn.AsnUtil;
import javax.baja.bacnet.BacnetConst;
import javax.baja.xml.XElem;

public class PropertyInfo
implements BacnetConst {
    private String name;
    private int id;
    private int asnType;
    private boolean extensible;
    private String bs;
    private String type;
    private int size;
    private boolean facet;
    private String facetControl;

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public int getAsnType() {
        return this.asnType;
    }

    public String getDataType() {
        return AsnUtil.getAsnTypeName(this.asnType);
    }

    public boolean isExtensible() {
        if (!this.isEnum()) {
            throw new IllegalStateException();
        }
        return this.extensible;
    }

    public String getBitStringName() {
        if (!this.isBitString()) {
            throw new IllegalStateException();
        }
        return this.bs;
    }

    public String getType() {
        return this.type;
    }

    public int getSize() {
        if (!this.isArray()) {
            throw new IllegalStateException();
        }
        return this.size;
    }

    public boolean isEnum() {
        boolean bl = false;
        if (this.asnType == 9) {
            bl = true;
        }
        return bl;
    }

    public boolean isBitString() {
        boolean bl = false;
        if (this.asnType == 8) {
            bl = true;
        }
        return bl;
    }

    public boolean isConstructed() {
        boolean bl = false;
        if (this.asnType == -1) {
            bl = true;
        }
        return bl;
    }

    public boolean isArray() {
        boolean bl = false;
        if (this.asnType == -2) {
            bl = true;
        }
        return bl;
    }

    public boolean isList() {
        boolean bl = false;
        if (this.asnType == -3) {
            bl = true;
        }
        return bl;
    }

    public boolean isChoice() {
        boolean bl = false;
        if (this.asnType == -5) {
            bl = true;
        }
        return bl;
    }

    public boolean isFacet() {
        return this.facet;
    }

    public String getFacetControl() {
        return this.facetControl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n n=" + this.name).append("\n i=" + this.id).append("\n a=" + this.asnType);
        if (this.facet) {
            stringBuffer.append("\n f=" + this.facet);
        }
        stringBuffer.append("\n c=" + this.facetControl);
        stringBuffer.append("\n t=" + this.type);
        if (this.isEnum()) {
            stringBuffer.append("\n e=" + this.extensible);
        } else if (this.isBitString()) {
            stringBuffer.append("\n b=" + this.bs);
        } else if (this.isArray()) {
            stringBuffer.append("\n s=" + this.size);
        }
        return stringBuffer.toString();
    }

    public boolean isAws() {
        boolean bl = false;
        if (this.type != null && this.type.indexOf("Aws") > 0) {
            bl = true;
        }
        return bl;
    }

    public PropertyInfo(String string, int n, int n2) {
        this.name = string;
        this.id = n;
        this.asnType = n2;
        this.facet = false;
        this.facetControl = "no";
    }

    public PropertyInfo(XElem xElem) {
        this.name = xElem.get("n");
        this.id = xElem.geti("i");
        this.asnType = xElem.geti("a", -6);
        switch (this.asnType) {
            case 0: {
                this.type = "bacnet:BacnetNull";
                break;
            }
            case 1: {
                this.type = "baja:Boolean";
                break;
            }
            case 2: {
                this.type = "bacnet:BacnetUnsigned";
                break;
            }
            case 3: {
                this.type = "baja:Integer";
                break;
            }
            case 4: {
                this.type = "baja:Float";
                break;
            }
            case 5: {
                this.type = "baja:Double";
                break;
            }
            case 6: {
                this.type = "bacnet:BacnetOctetString";
                break;
            }
            case 7: {
                this.type = "baja:String";
                break;
            }
            case 8: {
                this.type = "bacnet:BacnetBitString";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                this.type = "bacnet:BacnetDate";
                break;
            }
            case 11: {
                this.type = "bacnet:BacnetTime";
                break;
            }
            case 12: {
                this.type = "bacnet:BacnetObjectIdentifier";
                break;
            }
            case -4: {
                this.type = "bacnet:BacnetAny";
                break;
            }
        }
        this.facet = xElem.getb("f", false);
        this.facetControl = xElem.get("c", "no");
        if (this.isEnum()) {
            this.extensible = xElem.getb("e", false);
            this.type = xElem.get("t");
            this.facetControl = "enum";
        } else if (this.isBitString()) {
            this.bs = xElem.get("b");
        } else if (this.isConstructed()) {
            this.type = xElem.get("t");
        } else if (this.isArray()) {
            this.type = xElem.get("t");
            this.size = xElem.geti("s", -1);
        } else if (this.isList()) {
            this.type = xElem.get("t");
        } else if (this.isChoice()) {
            this.type = xElem.get("t");
        }
    }

    public PropertyInfo(String string, int n, int n2, boolean bl, String string2) {
        this.name = string;
        this.id = n;
        this.asnType = n2;
        this.facet = bl;
        this.facetControl = string2;
    }

    public PropertyInfo(String string, int n, int n2, boolean bl, String string2, boolean bl2, String string3) {
        this.name = string;
        this.id = n;
        this.asnType = n2;
        this.extensible = bl;
        this.type = string2;
        this.facet = bl2;
        this.facetControl = string3;
    }

    public PropertyInfo(String string, int n, int n2, String string2, boolean bl, boolean bl2, String string3) {
        this.name = string;
        this.id = n;
        this.asnType = n2;
        if (bl) {
            this.bs = string2;
        } else {
            this.type = string2;
        }
        this.facet = bl2;
        this.facetControl = string3;
    }

    public PropertyInfo(String string, int n, int n2, String string2, int n3, boolean bl, String string3) {
        this.name = string;
        this.id = n;
        this.asnType = n2;
        this.type = string2;
        this.size = n3;
        this.facet = bl;
        this.facetControl = string3;
    }
}

