/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.util;

import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.bacnet.util.BIBacnetPollable;
import javax.baja.bacnet.util.PollList;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.user.BUser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PollListEntry
implements Context {
    public static final int DEFAULT_DATASIZE = 11;
    public static final Context pointCx = new BasicContext(){

        public final boolean equals(Object object) {
            boolean bl = false;
            if (this == object) {
                bl = true;
            }
            return bl;
        }

        public final String toString() {
            return "Bacnet:pointCx";
        }
    };
    public static final Context forceCx = new BasicContext(){

        public final boolean equals(Object object) {
            boolean bl = false;
            if (this == object) {
                bl = true;
            }
            return bl;
        }

        public final String toString() {
            return "Bacnet:forceCx";
        }
    };
    public static final Context metaCx = new BasicContext(){

        public final boolean equals(Object object) {
            boolean bl = false;
            if (this == object) {
                bl = true;
            }
            return bl;
        }

        public final String toString() {
            return "Bacnet:metaCx";
        }
    };
    private BBacnetObjectIdentifier objectId;
    private int propertyId;
    private int propertyArrayIndex;
    private BBacnetDevice device;
    private BIBacnetPollable pollable;
    private int dataSize;
    private Context context;
    private PollList pollList;

    public final BBacnetObjectIdentifier getObjectId() {
        return this.objectId;
    }

    public final int getPropertyId() {
        return this.propertyId;
    }

    public final int getPropertyArrayIndex() {
        return this.propertyArrayIndex;
    }

    public final BBacnetDevice getDevice() {
        return this.device;
    }

    public final int getAddressHash() {
        int n = 0;
        if (this.device != null) {
            n = this.device.getAddress().hash();
        }
        return n;
    }

    public final BIBacnetPollable getPollable() {
        return this.pollable;
    }

    public final int getDataSize() {
        return this.dataSize;
    }

    public final void setDataSize(int n) {
        this.dataSize = n;
    }

    public final void doubleDataSize(int n) {
        this.dataSize = Math.min(n, this.dataSize * 2);
    }

    public final Context getContext() {
        return this.context == null ? this : this.context;
    }

    public final void setContext(Context context) {
        this.context = context;
    }

    public final PollList getPollList() {
        return this.pollList;
    }

    public final void setPollList(PollList pollList) {
        this.pollList = pollList;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof PollListEntry)) {
            return false;
        }
        PollListEntry pollListEntry = (PollListEntry)object;
        if (this.propertyId != pollListEntry.propertyId) {
            return false;
        }
        if (this.propertyArrayIndex != pollListEntry.propertyArrayIndex) {
            return false;
        }
        if (this.context == null ? pollListEntry.context != null : !this.context.equals(pollListEntry.context)) {
            return false;
        }
        if (this.objectId == null) {
            if (pollListEntry.objectId != null) {
                return false;
            }
        } else {
            if (pollListEntry.objectId == null) {
                return false;
            }
            if (this.objectId.hashCode() != pollListEntry.objectId.hashCode()) {
                return false;
            }
        }
        return !(this.pollable == null ? pollListEntry.pollable != null : !this.pollable.equals(pollListEntry.pollable));
    }

    public String toString() {
        return this.string(false);
    }

    public String debugString() {
        return this.string(true);
    }

    private final String string(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.objectId.toString()).append(' ').append(BBacnetPropertyIdentifier.tag(this.propertyId));
        if (this.propertyArrayIndex >= 0) {
            stringBuffer.append(" [").append(this.propertyArrayIndex).append(']');
        }
        if (bl) {
            stringBuffer.append(" in " + this.device.getName()).append(" [").append(this.getAddressHash()).append(']').append(" -> " + this.pollable).append(" {").append(this.dataSize).append("}; ").append(this.context);
        }
        return stringBuffer.toString();
    }

    public Context getBase() {
        return this.context;
    }

    public BUser getUser() {
        return this.context == null ? null : this.context.getUser();
    }

    public BFacets getFacets() {
        return this.context == null ? null : this.context.getFacets();
    }

    public BObject getFacet(String string) {
        return this.context == null ? null : this.context.getFacet(string);
    }

    public String getLanguage() {
        return this.context == null ? null : this.context.getLanguage();
    }

    private final /* synthetic */ void this() {
        this.dataSize = 11;
    }

    public PollListEntry(BBacnetProxyExt bBacnetProxyExt) {
        this.this();
        this.objectId = bBacnetProxyExt.getObjectId();
        this.propertyId = bBacnetProxyExt.getPropertyId().getOrdinal();
        this.propertyArrayIndex = bBacnetProxyExt.getPropertyArrayIndex();
        this.device = bBacnetProxyExt.device();
        this.pollable = bBacnetProxyExt;
        this.context = pointCx;
    }

    public PollListEntry(BBacnetProxyExt bBacnetProxyExt, int n) {
        this.this();
        this.objectId = bBacnetProxyExt.getObjectId();
        this.propertyId = n;
        this.propertyArrayIndex = bBacnetProxyExt.getPropertyArrayIndex();
        this.device = bBacnetProxyExt.device();
        this.pollable = bBacnetProxyExt;
        this.context = null;
    }

    public PollListEntry(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, BBacnetDevice bBacnetDevice, BIBacnetPollable bIBacnetPollable) {
        this.this();
        this.objectId = bBacnetObjectIdentifier;
        this.propertyId = n;
        this.propertyArrayIndex = -1;
        this.device = bBacnetDevice;
        this.pollable = bIBacnetPollable;
        this.context = null;
    }

    public PollListEntry(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, BBacnetDevice bBacnetDevice, BIBacnetPollable bIBacnetPollable) {
        this.this();
        this.objectId = bBacnetObjectIdentifier;
        this.propertyId = n;
        this.propertyArrayIndex = n2;
        this.device = bBacnetDevice;
        this.pollable = bIBacnetPollable;
        this.context = null;
    }

    public PollListEntry(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, BBacnetDevice bBacnetDevice, BIBacnetPollable bIBacnetPollable, Context context) {
        this.this();
        this.objectId = bBacnetObjectIdentifier;
        this.propertyId = n;
        this.propertyArrayIndex = n2;
        this.device = bBacnetDevice;
        this.pollable = bIBacnetPollable;
        this.context = context;
    }
}

