/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.util;

import java.util.ListIterator;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.util.PollListEntry;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PollList {
    private static final int IS_POLLING = 1;
    private static final int DONE = 2;
    private static final int OBJECT_ID_SIZE = 5;
    int addressHash;
    int dataSize;
    BBacnetDevice device;
    Array entries;
    private int polstat;
    private long sleep;
    public int polcnt;
    static /* synthetic */ Class class$javax$baja$bacnet$util$PollListEntry;

    public synchronized void add(PollListEntry pollListEntry) {
        if (pollListEntry == null) {
            return;
        }
        if (pollListEntry.getAddressHash() != this.addressHash) {
            throw new IllegalArgumentException("PollList.add:ple addrHash (" + pollListEntry.getAddressHash() + ") != pl addrHash (" + this.addressHash + ')');
        }
        pollListEntry.setPollList(this);
        this.dataSize += pollListEntry.getDataSize();
        ListIterator listIterator = this.entries.iterator();
        boolean bl = false;
        int n = pollListEntry.getObjectId().hashCode();
        int n2 = 0;
        while (listIterator.hasNext()) {
            if (n == ((PollListEntry)listIterator.next()).getObjectId().hashCode()) {
                this.entries.add(n2, (Object)pollListEntry);
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            this.entries.add((Object)pollListEntry);
            this.dataSize += 5;
        }
    }

    public synchronized boolean remove(PollListEntry pollListEntry) {
        if (pollListEntry == null) {
            return false;
        }
        if (pollListEntry.getAddressHash() != this.addressHash) {
            throw new IllegalArgumentException("PollList.remove:ple addrHash (" + pollListEntry.getAddressHash() + ") != pl addrHash (" + this.addressHash + ')');
        }
        int n = pollListEntry.getObjectId().hashCode();
        int n2 = this.entries.size();
        int n3 = this.entries.indexOf((Object)pollListEntry);
        if (n3 >= 0) {
            this.entries.remove(n3);
            this.dataSize -= pollListEntry.getDataSize();
            boolean bl = false;
            if (n3 > 0 && ((PollListEntry)this.entries.get(n3 - 1)).getObjectId().hashCode() == n) {
                bl = true;
            }
            if (!bl && n3 < n2 - 1 && ((PollListEntry)this.entries.get(n3)).getObjectId().hashCode() == n) {
                bl = true;
            }
            if (!bl) {
                this.dataSize -= 5;
            }
            return true;
        }
        return false;
    }

    public synchronized int size() {
        return this.entries.size();
    }

    public final int getAddressHash() {
        return this.addressHash;
    }

    public final int getDataSize() {
        return this.dataSize;
    }

    public final BBacnetDevice getDevice() {
        return this.device;
    }

    public synchronized PollListEntry[] getPollEntries() {
        return (PollListEntry[])this.entries.trim();
    }

    public final synchronized boolean contains(PollListEntry pollListEntry) {
        return this.entries.contains((Object)pollListEntry);
    }

    public String toString() {
        return this.string(false);
    }

    public String debug() {
        return this.string(true);
    }

    private final String string(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(this.polcnt + " PollList [");
        if (this.device != null) {
            stringBuffer.append(this.device.getName()).append(' ').append((Object)this.device.getObjectId()).append(' ').append(this.device.getAddress());
        }
        stringBuffer.append("] ").append(Integer.toHexString(this.addressHash)).append(" {").append(this.dataSize).append("} ");
        stringBuffer.append(this.isPolling() ? "P" : "-");
        stringBuffer.append(this.isDone() ? "D " : "- ");
        int n = this.entries.size();
        stringBuffer.append(n).append(n == 1 ? " PLE" : " PLEs");
        if (bl) {
            stringBuffer.append("\n");
            ListIterator listIterator = this.entries.iterator();
            while (listIterator.hasNext()) {
                stringBuffer.append("  " + ((PollListEntry)listIterator.next()).debugString() + '\n');
            }
        }
        return stringBuffer.toString();
    }

    public synchronized int getPollFrequency() {
        if (this.entries.size() > 0) {
            return ((PollListEntry)this.entries.get(0)).getPollable().getPollFrequency().getOrdinal();
        }
        return -1;
    }

    public void setIsPolling(boolean bl) {
        this.polstat = bl ? (this.polstat |= 1) : (this.polstat &= 0xFFFFFFFE);
    }

    public boolean isPolling() {
        boolean bl = false;
        if ((this.polstat & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public void setDone(boolean bl) {
        this.polstat = bl ? (this.polstat |= 2) : (this.polstat &= 0xFFFFFFFD);
    }

    public boolean isDone() {
        boolean bl = false;
        if ((this.polstat & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public long getSleep() {
        return this.sleep;
    }

    public void setSleep(long l) {
        this.sleep = l;
    }

    public static void main(String[] stringArray) {
        PollListEntry pollListEntry = new PollListEntry(BBacnetObjectIdentifier.make(0, 0), 85, null, null);
        PollListEntry pollListEntry2 = new PollListEntry(BBacnetObjectIdentifier.make(0, 0), 111, null, null);
        PollListEntry pollListEntry3 = new PollListEntry(BBacnetObjectIdentifier.make(0, 1), 85, null, null);
        PollListEntry pollListEntry4 = new PollListEntry(BBacnetObjectIdentifier.make(0, 0), 36, null, null);
        PollListEntry pollListEntry5 = new PollListEntry(BBacnetObjectIdentifier.make(0, 2), 85, null, null);
        PollListEntry pollListEntry6 = new PollListEntry(BBacnetObjectIdentifier.make(0, 3), 36, null, null);
        PollListEntry pollListEntry7 = new PollListEntry(BBacnetObjectIdentifier.make(0, 0), 77, null, null);
        PollListEntry pollListEntry8 = new PollListEntry(BBacnetObjectIdentifier.make(0, 2), 111, null, null);
        PollListEntry pollListEntry9 = new PollListEntry(BBacnetObjectIdentifier.make(0, 2), 103, null, null);
        PollListEntry pollListEntry10 = new PollListEntry(BBacnetObjectIdentifier.make(0, 0), 103, null, null);
        PollList pollList = new PollList();
        pollList.add(pollListEntry);
        System.out.println("\n\nAfter ple0:" + pollList.debug());
        pollList.add(pollListEntry2);
        System.out.println("\n\nAfter ple1:" + pollList.debug());
        pollList.add(pollListEntry3);
        System.out.println("\n\nAfter ple2:" + pollList.debug());
        pollList.add(pollListEntry4);
        System.out.println("\n\nAfter ple3:" + pollList.debug());
        pollList.add(pollListEntry5);
        System.out.println("\n\nAfter ple4:" + pollList.debug());
        pollList.add(pollListEntry6);
        System.out.println("\n\nAfter ple5:" + pollList.debug());
        pollList.add(pollListEntry7);
        System.out.println("\n\nAfter ple6:" + pollList.debug());
        pollList.add(pollListEntry8);
        System.out.println("\n\nAfter ple7:" + pollList.debug());
        pollList.add(pollListEntry9);
        System.out.println("\n\nAfter ple8:" + pollList.debug());
        pollList.add(pollListEntry10);
        System.out.println("\n\nAfter ple9:" + pollList.debug());
        pollList.remove(pollListEntry);
        System.out.println("\n\nAfter REMOVE ple0:" + pollList.debug());
        pollList.remove(pollListEntry6);
        System.out.println("\n\nAfter REMOVE ple5:" + pollList.debug());
        pollList.remove(pollListEntry3);
        System.out.println("\n\nAfter REMOVE ple2:" + pollList.debug());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.addressHash = 0;
        this.dataSize = 0;
        this.device = null;
        Class clazz = class$javax$baja$bacnet$util$PollListEntry;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$util$PollListEntry = PollList.class("[Ljavax.baja.bacnet.util.PollListEntry;", false);
        }
        this.entries = new Array(clazz);
        this.polstat = 0;
        this.sleep = 0L;
        this.polcnt = 0;
    }

    private PollList() {
        this.this();
    }

    public PollList(PollListEntry pollListEntry) {
        this.this();
        this.addressHash = pollListEntry.getAddressHash();
        this.dataSize = pollListEntry.getDataSize();
        this.device = pollListEntry.getDevice();
        this.add(pollListEntry);
    }
}

