/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.ext.BLimitEnable;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.nre.util.IntHashMap;
import javax.baja.status.BStatus;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BacnetBitStringUtil {
    private static final Lexicon lexicon;
    private static final HashMap bitStringSizes;
    private static final HashMap bitStringsMap;
    private static final HashMap bitStringsIndexMap;
    private static final IntHashMap propIdToTags;
    public static final String BACNET_DAYS_OF_WEEK = "BacnetDaysOfWeek";
    public static final String BACNET_EVENT_TRANSITION_BITS = "BacnetEventTransitionBits";
    public static final String BACNET_LIMIT_ENABLE = "BacnetLimitEnable";
    public static final String BACNET_LOG_STATUS = "BacnetLogStatus";
    public static final String BACNET_OBJECT_TYPES_SUPPORTED = "BacnetObjectTypesSupported";
    public static final String BACNET_RESULT_FLAGS = "BacnetResultFlags";
    public static final String BACNET_SERVICES_SUPPORTED = "BacnetServicesSupported";
    public static final String BACNET_STATUS_FLAGS = "BacnetStatusFlags";
    public static final HashMap BACNET_DAYS_OF_WEEK_MAP;
    public static final HashMap BACNET_EVENT_TRANSITION_BITS_MAP;
    public static final HashMap BACNET_LIMIT_ENABLE_MAP;
    public static final HashMap BACNET_LOG_STATUS_MAP;
    public static final HashMap BACNET_OBJECT_TYPES_SUPPORTED_MAP;
    public static final HashMap BACNET_RESULT_FLAGS_MAP;
    public static final HashMap BACNET_SERVICES_SUPPORTED_MAP;
    public static final HashMap BACNET_STATUS_FLAGS_MAP;
    public static final HashMap BACNET_DAYS_OF_WEEK_INDEX_MAP;
    public static final HashMap BACNET_EVENT_TRANSITION_BITS_INDEX_MAP;
    public static final HashMap BACNET_LIMIT_ENABLE_INDEX_MAP;
    public static final HashMap BACNET_LOG_STATUS_INDEX_MAP;
    public static final HashMap BACNET_OBJECT_TYPES_SUPPORTED_INDEX_MAP;
    public static final HashMap BACNET_RESULT_FLAGS_INDEX_MAP;
    public static final HashMap BACNET_SERVICES_SUPPORTED_INDEX_MAP;
    public static final HashMap BACNET_STATUS_FLAGS_INDEX_MAP;
    public static final BFacets BACNET_DAYS_OF_WEEK_FACETS;
    public static final BFacets BACNET_EVENT_TRANSITION_BITS_FACETS;
    public static final BFacets BACNET_LIMIT_ENABLE_FACETS;
    public static final BFacets BACNET_LOG_STATUS_FACETS;
    public static final BFacets BACNET_OBJECT_TYPES_SUPPORTED_FACETS;
    public static final BFacets BACNET_RESULT_FLAGS_FACETS;
    public static final BFacets BACNET_SERVICES_SUPPORTED_FACETS;
    public static final BFacets BACNET_STATUS_FLAGS_FACETS;
    public static final Context BacnetDaysOfWeek;
    public static final Context BacnetEventTransitionBits;
    public static final Context BacnetLimitEnable;
    public static final Context BacnetLogStatus;
    public static final Context BacnetObjectTypesSupported;
    public static final Context BacnetResultFlags;
    public static final Context BacnetServicesSupported;
    public static final Context BacnetStatusFlags;
    static /* synthetic */ Class class$javax$baja$bacnet$util$BacnetBitStringUtil;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmTransitionBits;

    public static BDaysOfWeekBits getBDaysOfWeekBits(BBacnetBitString bBacnetBitString) {
        return BacnetBitStringUtil.getBDaysOfWeekBits(bBacnetBitString.getBits());
    }

    public static BDaysOfWeekBits getBDaysOfWeekBits(boolean[] blArray) {
        int n = 7;
        if (blArray.length != n) {
            throw new IllegalArgumentException("Invalid bit string length!");
        }
        int n2 = 2;
        int n3 = blArray[6];
        int n4 = 0;
        while (n4 < blArray.length - 1) {
            if (blArray[n4]) {
                n3 |= n2;
            }
            n2 <<= 1;
            ++n4;
        }
        return BDaysOfWeekBits.make((int)n3);
    }

    public static BBacnetBitString getBacnetDaysOfWeek(BDaysOfWeekBits bDaysOfWeekBits) {
        boolean[] blArray = new boolean[7];
        int n = bDaysOfWeekBits.getBits();
        int n2 = 2;
        int n3 = 0;
        while (n3 < 6) {
            boolean bl = false;
            if ((n & n2) != 0) {
                bl = true;
            }
            blArray[n3] = bl;
            n2 <<= 1;
            ++n3;
        }
        boolean bl = false;
        if ((n & 1) != 0) {
            bl = true;
        }
        blArray[6] = bl;
        return BBacnetBitString.make(blArray, BACNET_DAYS_OF_WEEK_FACETS);
    }

    public static BAlarmTransitionBits getBAlarmTransitionBits(BBacnetBitString bBacnetBitString) {
        return BacnetBitStringUtil.getBAlarmTransitionBits(bBacnetBitString.getBits());
    }

    public static BAlarmTransitionBits getBAlarmTransitionBits(boolean[] blArray) {
        Class clazz = class$javax$baja$alarm$BAlarmTransitionBits;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmTransitionBits = BacnetBitStringUtil.class("[Ljavax.baja.alarm.BAlarmTransitionBits;", false);
        }
        return (BAlarmTransitionBits)BacnetBitStringUtil.getNiagaraBitString(blArray, BACNET_EVENT_TRANSITION_BITS, clazz);
    }

    public static BBacnetBitString getBacnetEventTransitionBits(BAlarmTransitionBits bAlarmTransitionBits) {
        Class clazz = class$javax$baja$alarm$BAlarmTransitionBits;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmTransitionBits = BacnetBitStringUtil.class("[Ljavax.baja.alarm.BAlarmTransitionBits;", false);
        }
        return BacnetBitStringUtil.getBacnetBitString((BSimple)bAlarmTransitionBits, BACNET_EVENT_TRANSITION_BITS, clazz, BACNET_EVENT_TRANSITION_BITS_FACETS);
    }

    public static BLimitEnable getBLimitEnable(BBacnetBitString bBacnetBitString) {
        return BacnetBitStringUtil.getBLimitEnable(bBacnetBitString.getBits());
    }

    public static BLimitEnable getBLimitEnable(boolean[] blArray) {
        BLimitEnable bLimitEnable = new BLimitEnable();
        bLimitEnable.setLowLimitEnable(blArray[0]);
        bLimitEnable.setHighLimitEnable(blArray[1]);
        return bLimitEnable;
    }

    public static BBacnetBitString getBacnetLimitEnable(BLimitEnable bLimitEnable) {
        return BBacnetBitString.make(new boolean[]{bLimitEnable.getLowLimitEnable(), bLimitEnable.getHighLimitEnable()}, BACNET_LIMIT_ENABLE_FACETS);
    }

    public static BStatus getBStatus(BBacnetBitString bBacnetBitString) {
        return BacnetBitStringUtil.getBStatus(bBacnetBitString.getBits());
    }

    public static BStatus getBStatus(boolean[] blArray) {
        int n = 0;
        if (blArray[0]) {
            n |= 8;
        }
        if (blArray[1]) {
            n |= 2;
        }
        if (blArray[2]) {
            n |= 0x20;
        }
        if (blArray[3]) {
            n |= 1;
        }
        return BStatus.make((int)n);
    }

    public static BBacnetBitString getBacnetStatusFlags(BStatus bStatus) {
        return BBacnetBitString.make(new boolean[]{bStatus.isAlarm(), bStatus.isFault(), bStatus.isOverridden(), bStatus.isDisabled()});
    }

    public static BBacnetBitString getBacnetStatusFlags(String string) {
        boolean[] blArray = new boolean[4];
        boolean bl = false;
        if (string.indexOf("alarm") >= 0) {
            bl = true;
        }
        blArray[0] = bl;
        boolean bl2 = false;
        if (string.indexOf("fault") >= 0) {
            bl2 = true;
        }
        blArray[1] = bl2;
        boolean bl3 = false;
        if (string.indexOf("overridden") >= 0) {
            bl3 = true;
        }
        blArray[2] = bl3;
        boolean bl4 = false;
        if (string.indexOf("outOfService") >= 0) {
            bl4 = true;
        }
        blArray[3] = bl4;
        return BBacnetBitString.make(blArray);
    }

    private static final Object getNiagaraBitString(boolean[] blArray, String string, Class clazz) {
        int n = 0;
        try {
            int n2 = BacnetBitStringUtil.getBitStringLength(string);
            if (blArray.length != n2) {
                throw new IllegalArgumentException("Invalid bit string length!" + blArray.length + " != " + n2);
            }
            int n3 = 1;
            int n4 = 0;
            while (n4 < n2) {
                if (blArray[n4]) {
                    n |= n3;
                }
                n3 <<= 1;
                ++n4;
            }
            Method method = clazz.getMethod("make", Integer.TYPE);
            return method.invoke(null, new Integer(n));
        }
        catch (Exception exception) {
            System.out.println("Error creating Niagara bit string!");
            return null;
        }
    }

    private static final BBacnetBitString getBacnetBitString(BSimple bSimple, String string, Class clazz, BFacets bFacets) {
        try {
            int n = BacnetBitStringUtil.getBitStringLength(string);
            boolean[] blArray = new boolean[n];
            Method method = clazz.getMethod("getBits", null);
            int n2 = (Integer)method.invoke((Object)bSimple, null);
            int n3 = 1;
            int n4 = 0;
            while (n4 < n) {
                boolean bl = false;
                if ((n2 & n3) != 0) {
                    bl = true;
                }
                blArray[n4] = bl;
                n3 <<= 1;
                ++n4;
            }
            return BBacnetBitString.make(blArray, bFacets);
        }
        catch (Exception exception) {
            System.out.println("Error creating Bacnet bit string!");
            return BBacnetBitString.make(new boolean[0]);
        }
    }

    public static BBacnetBitString decode(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        HashMap hashMap = BacnetBitStringUtil.getBitStringIndexMap(string2);
        if (hashMap == null) {
            throw new IllegalArgumentException("Bit String " + string2 + " not known to BacnetBitStringUtil!");
        }
        boolean[] blArray = new boolean[BacnetBitStringUtil.getBitStringLength(string2)];
        while (stringTokenizer.hasMoreTokens()) {
            Integer n = (Integer)hashMap.get(stringTokenizer.nextToken());
            if (n == null) continue;
            blArray[n.intValue()] = true;
        }
        return BBacnetBitString.make(blArray, BFacets.make((Map)BacnetBitStringUtil.getBitStringMap(string2)));
    }

    public static Context getBitStringTags(int n, int n2) {
        return (Context)propIdToTags.get(n2);
    }

    public static int getBitStringLength(String string) {
        Integer n = (Integer)bitStringSizes.get(string);
        int n2 = 0;
        if (n != null) {
            n2 = n;
        }
        return n2;
    }

    public static String[] getTags(Context context) {
        if (context == null) {
            return new String[0];
        }
        int n = 0;
        BString bString = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            if ((bString = (BString)context.getFacet("bit" + n)) != null) {
                arrayList.add(bString.getString());
            }
            ++n;
        } while (bString != null);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static int getBitIndex(String string, String string2) {
        Integer n;
        HashMap hashMap = BacnetBitStringUtil.getBitStringIndexMap(string);
        if (hashMap != null && (n = (Integer)hashMap.get(string2)) != null) {
            return n;
        }
        return -1;
    }

    public static HashMap getBitStringMap(String string) {
        return (HashMap)bitStringsMap.get(string);
    }

    public static HashMap getBitStringIndexMap(String string) {
        return (HashMap)bitStringsIndexMap.get(string);
    }

    private static final HashMap generateMap1(Lexicon lexicon, String string) {
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("bsName", BString.make((String)string));
        try {
            int n = Integer.parseInt(lexicon.get(string + ".numBits"));
            bitStringSizes.put(string, new Integer(n));
            int n2 = 0;
            while (n2 < n) {
                String string2 = "bit" + n2;
                BString bString = BString.make((String)lexicon.get(string + '.' + string2));
                hashMap.put(string2, bString);
                ++n2;
            }
            bitStringsMap.put(string, hashMap);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Error creating bit string map: " + string);
        }
        return hashMap;
    }

    private static final HashMap generateMap2(Lexicon lexicon, String string) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        try {
            int n = Integer.parseInt(lexicon.get(string + ".numBits"));
            int n2 = 0;
            while (n2 < n) {
                String string2 = "bit" + n2;
                String string3 = lexicon.get(string + '.' + string2);
                hashMap.put(string3, new Integer(n2));
                ++n2;
            }
            bitStringsIndexMap.put(string, hashMap);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Error creating bit string index map: " + string);
        }
        return hashMap;
    }

    public static void main(String[] stringArray) {
        int n = BacnetBitStringUtil.getBitIndex(BACNET_SERVICES_SUPPORTED, "readPropertyMultiple");
        System.out.println("rpm=" + n);
        n = BacnetBitStringUtil.getBitIndex(BACNET_SERVICES_SUPPORTED, "subscribeCov");
        System.out.println("scov=" + n);
        n = BacnetBitStringUtil.getBitIndex(BACNET_SERVICES_SUPPORTED, "confirmedCovNotification");
        System.out.println("ccovn=" + n);
        BAlarmTransitionBits bAlarmTransitionBits = BAlarmTransitionBits.make((int)3);
        BBacnetBitString bBacnetBitString = BacnetBitStringUtil.getBacnetEventTransitionBits(bAlarmTransitionBits);
        System.out.println("atbits:" + bAlarmTransitionBits);
        System.out.println("eventEnable:" + (Object)((Object)bBacnetBitString));
        BStatus bStatus = BStatus.make((int)10);
        BBacnetBitString bBacnetBitString2 = BacnetBitStringUtil.getBacnetStatusFlags(bStatus);
        BStatus bStatus2 = BacnetBitStringUtil.getBStatus(bBacnetBitString2);
        System.out.println("s=" + bStatus + "\nbs=" + (Object)((Object)bBacnetBitString2) + "\nss=" + bStatus2);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$util$BacnetBitStringUtil;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$util$BacnetBitStringUtil = BacnetBitStringUtil.class("[Ljavax.baja.bacnet.util.BacnetBitStringUtil;", false);
        }
        lexicon = Lexicon.make((BModule)Sys.getModuleForClass((Class)clazz), (String)Sys.getLanguage());
        bitStringSizes = new HashMap();
        bitStringsMap = new HashMap();
        bitStringsIndexMap = new HashMap();
        propIdToTags = new IntHashMap();
        BACNET_DAYS_OF_WEEK_MAP = BacnetBitStringUtil.generateMap1(lexicon, BACNET_DAYS_OF_WEEK);
        BACNET_EVENT_TRANSITION_BITS_MAP = BacnetBitStringUtil.generateMap1(lexicon, BACNET_EVENT_TRANSITION_BITS);
        BACNET_LIMIT_ENABLE_MAP = BacnetBitStringUtil.generateMap1(lexicon, BACNET_LIMIT_ENABLE);
        BACNET_LOG_STATUS_MAP = BacnetBitStringUtil.generateMap1(lexicon, BACNET_LOG_STATUS);
        BACNET_OBJECT_TYPES_SUPPORTED_MAP = BacnetBitStringUtil.generateMap1(lexicon, BACNET_OBJECT_TYPES_SUPPORTED);
        BACNET_RESULT_FLAGS_MAP = BacnetBitStringUtil.generateMap1(lexicon, BACNET_RESULT_FLAGS);
        BACNET_SERVICES_SUPPORTED_MAP = BacnetBitStringUtil.generateMap1(lexicon, BACNET_SERVICES_SUPPORTED);
        BACNET_STATUS_FLAGS_MAP = BacnetBitStringUtil.generateMap1(lexicon, BACNET_STATUS_FLAGS);
        BACNET_DAYS_OF_WEEK_INDEX_MAP = BacnetBitStringUtil.generateMap2(lexicon, BACNET_DAYS_OF_WEEK);
        BACNET_EVENT_TRANSITION_BITS_INDEX_MAP = BacnetBitStringUtil.generateMap2(lexicon, BACNET_EVENT_TRANSITION_BITS);
        BACNET_LIMIT_ENABLE_INDEX_MAP = BacnetBitStringUtil.generateMap2(lexicon, BACNET_LIMIT_ENABLE);
        BACNET_LOG_STATUS_INDEX_MAP = BacnetBitStringUtil.generateMap2(lexicon, BACNET_LOG_STATUS);
        BACNET_OBJECT_TYPES_SUPPORTED_INDEX_MAP = BacnetBitStringUtil.generateMap2(lexicon, BACNET_OBJECT_TYPES_SUPPORTED);
        BACNET_RESULT_FLAGS_INDEX_MAP = BacnetBitStringUtil.generateMap2(lexicon, BACNET_RESULT_FLAGS);
        BACNET_SERVICES_SUPPORTED_INDEX_MAP = BacnetBitStringUtil.generateMap2(lexicon, BACNET_SERVICES_SUPPORTED);
        BACNET_STATUS_FLAGS_INDEX_MAP = BacnetBitStringUtil.generateMap2(lexicon, BACNET_STATUS_FLAGS);
        BACNET_DAYS_OF_WEEK_FACETS = BFacets.make((Map)BACNET_DAYS_OF_WEEK_MAP);
        BACNET_EVENT_TRANSITION_BITS_FACETS = BFacets.make((Map)BACNET_EVENT_TRANSITION_BITS_MAP);
        BACNET_LIMIT_ENABLE_FACETS = BFacets.make((Map)BACNET_LIMIT_ENABLE_MAP);
        BACNET_LOG_STATUS_FACETS = BFacets.make((Map)BACNET_LOG_STATUS_MAP);
        BACNET_OBJECT_TYPES_SUPPORTED_FACETS = BFacets.make((Map)BACNET_OBJECT_TYPES_SUPPORTED_MAP);
        BACNET_RESULT_FLAGS_FACETS = BFacets.make((Map)BACNET_RESULT_FLAGS_MAP);
        BACNET_SERVICES_SUPPORTED_FACETS = BFacets.make((Map)BACNET_SERVICES_SUPPORTED_MAP);
        BACNET_STATUS_FLAGS_FACETS = BFacets.make((Map)BACNET_STATUS_FLAGS_MAP);
        BacnetDaysOfWeek = BACNET_DAYS_OF_WEEK_FACETS;
        BacnetEventTransitionBits = BACNET_EVENT_TRANSITION_BITS_FACETS;
        BacnetLimitEnable = BACNET_LIMIT_ENABLE_FACETS;
        BacnetLogStatus = BACNET_LOG_STATUS_FACETS;
        BacnetObjectTypesSupported = BACNET_OBJECT_TYPES_SUPPORTED_FACETS;
        BacnetResultFlags = BACNET_RESULT_FLAGS_FACETS;
        BacnetServicesSupported = BACNET_SERVICES_SUPPORTED_FACETS;
        BacnetStatusFlags = BACNET_STATUS_FLAGS_FACETS;
        propIdToTags.put(35, (Object)BacnetEventTransitionBits);
        propIdToTags.put(0, (Object)BacnetEventTransitionBits);
        propIdToTags.put(1, (Object)BacnetEventTransitionBits);
        propIdToTags.put(52, (Object)BacnetLimitEnable);
        propIdToTags.put(96, (Object)BacnetObjectTypesSupported);
        propIdToTags.put(97, (Object)BacnetServicesSupported);
        propIdToTags.put(111, (Object)BacnetStatusFlags);
    }
}

