/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.CovNotificationParameters;
import com.tridium.bacnet.asn.NBacnetPropertyReference;
import com.tridium.bacnet.asn.NBacnetPropertyValue;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.DeviceRegistry;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetCovSubscription;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetRecipient;
import javax.baja.bacnet.export.BIBacnetCovSource;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RejectException;
import javax.baja.control.BControlPoint;
import javax.baja.log.Log;
import javax.baja.util.ICoalesceable;

public class Cov
implements Runnable,
ICoalesceable {
    private BBacnetCovSubscription sub;
    private PropertyValue[] propertyValues;
    private BIBacnetCovSource covSrc;
    private BControlPoint pt;
    private BBacnetAddress address;

    public String toString() {
        return "Cov:" + this.sub + " on " + this.covSrc + " to " + this.pt.getName() + ':' + this.pt;
    }

    public Object getCoalesceKey() {
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof Cov) {
            Cov cov = (Cov)object;
            BIBacnetCovSource bIBacnetCovSource = cov.covSrc;
            if (this.sub.equivalent(cov.sub) && this.covSrc.getExport().getObjectId().equals((Object)bIBacnetCovSource.getExport().getObjectId()) && this.pt == cov.pt) {
                return true;
            }
        }
        return false;
    }

    public ICoalesceable coalesce(ICoalesceable iCoalesceable) {
        this.sub = ((Cov)iCoalesceable).sub;
        this.covSrc = ((Cov)iCoalesceable).covSrc;
        this.pt = ((Cov)iCoalesceable).pt;
        return this;
    }

    public void run() {
        try {
            int n = this.sub.getTimeRemaining();
            if (n < 0) {
                return;
            }
            BBacnetNetwork bBacnetNetwork = BBacnetNetwork.bacnet();
            BBacnetRecipient bBacnetRecipient = this.sub.getRecipient().getRecipient();
            this.address = bBacnetRecipient.getChoice() == 0 ? DeviceRegistry.getDeviceAddress(bBacnetRecipient.getDevice()) : bBacnetRecipient.getAddress();
            if (this.log().isTraceOn()) {
                this.log().trace("Sending Cov notification to address:" + this.address);
            }
            BBacnetObjectIdentifier bBacnetObjectIdentifier = BBacnetNetwork.localDevice().getObjectId();
            BIBacnetExportObject bIBacnetExportObject = this.covSrc.getExport();
            this.buildPropertyValues(bIBacnetExportObject);
            CovNotificationParameters covNotificationParameters = new CovNotificationParameters(this.sub.getRecipient().getProcessIdentifier().getUnsigned(), bBacnetObjectIdentifier, this.sub.getMonitoredPropertyReference().getObjectId(), n, this.propertyValues);
            if (this.sub.getIssueConfirmedNotifications()) {
                ((BBacnetStack)bBacnetNetwork.getBacnetComm()).getClient().confirmedCovNotification(this.address, covNotificationParameters);
            } else {
                ((BBacnetStack)bBacnetNetwork.getBacnetComm()).getClient().unconfirmedCovNotification(this.address, covNotificationParameters);
            }
        }
        catch (BacnetException bacnetException) {
            this.log().error("BacnetException sending COV Notification:" + (Object)((Object)bacnetException), (Throwable)((Object)bacnetException));
        }
        catch (Exception exception) {
            this.log().error("Unable to send COV notification to Bacnet!", (Throwable)exception);
        }
    }

    private final void buildPropertyValues(BIBacnetExportObject bIBacnetExportObject) throws RejectException {
        if (bIBacnetExportObject.getObjectId().getObjectType() == 12) {
            NBacnetPropertyValue nBacnetPropertyValue = new NBacnetPropertyValue(bIBacnetExportObject.readProperty(new NBacnetPropertyReference(this.sub.getMonitoredPropertyReference().getPropertyId(), this.sub.getMonitoredPropertyReference().getPropertyArrayIndex())));
            NBacnetPropertyValue nBacnetPropertyValue2 = new NBacnetPropertyValue(bIBacnetExportObject.readProperty(new NBacnetPropertyReference(111, -1)));
            NBacnetPropertyValue nBacnetPropertyValue3 = new NBacnetPropertyValue(bIBacnetExportObject.readProperty(new NBacnetPropertyReference(108, -1)));
            NBacnetPropertyValue nBacnetPropertyValue4 = new NBacnetPropertyValue(bIBacnetExportObject.readProperty(new NBacnetPropertyReference(21, -1)));
            this.propertyValues = new PropertyValue[]{nBacnetPropertyValue, nBacnetPropertyValue2, nBacnetPropertyValue3, nBacnetPropertyValue4};
        } else {
            NBacnetPropertyValue nBacnetPropertyValue = new NBacnetPropertyValue(bIBacnetExportObject.readProperty(new NBacnetPropertyReference(this.sub.getMonitoredPropertyReference().getPropertyId(), this.sub.getMonitoredPropertyReference().getPropertyArrayIndex())));
            NBacnetPropertyValue nBacnetPropertyValue5 = new NBacnetPropertyValue(bIBacnetExportObject.readProperty(new NBacnetPropertyReference(111, -1)));
            this.propertyValues = new PropertyValue[]{nBacnetPropertyValue, nBacnetPropertyValue5};
        }
    }

    public BBacnetCovSubscription getSub() {
        return this.sub;
    }

    private final Log log() {
        return Log.getLog((String)"bacnet.server");
    }

    public Cov(BBacnetCovSubscription bBacnetCovSubscription, BIBacnetCovSource bIBacnetCovSource, BControlPoint bControlPoint) {
        this.sub = bBacnetCovSubscription;
        this.covSrc = bIBacnetCovSource;
        this.pt = bControlPoint;
    }
}

