/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.history.BBacnetActivePeriod;
import com.tridium.bacnet.history.BBacnetTrendLogAlarmSourceExt;
import com.tridium.bacnet.history.BIBacnetTrendLogExt;
import com.tridium.bacnet.history.BacnetTrendLogUtil;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.services.error.NChangeListError;
import java.util.ArrayList;
import java.util.Vector;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetEventSource;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.point.BBacnetProxyExt;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.ext.BCovHistoryExt;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.history.ext.BNumericCovHistoryExt;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetTrendLogDescriptor
extends BBacnetEventSource {
    public static final Property logOrd = BBacnetTrendLogDescriptor.newProperty((int)65, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"targetType", (String)"baja:Component"));
    public static final Property objectId = BBacnetTrendLogDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(20), null);
    public static final Property historyOrd = BBacnetTrendLogDescriptor.newProperty((int)69, (BValue)BOrd.DEFAULT, null);
    public static final Property objectName = BBacnetTrendLogDescriptor.newProperty((int)0, (String)"", null);
    public static final Property description = BBacnetTrendLogDescriptor.newProperty((int)0, (String)"", null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static AsnOutputStream asnOut;
    private static final BBacnetDeviceObjectPropertyReference NULL_DOPR;
    private static final int[] REQUIRED_PROPS;
    static Log log;
    private BIBacnetTrendLogExt tlog;
    private int[] optionalProps;
    private BacnetTrendLogSubscriber logSubscriber;
    private BBacnetObjectIdentifier oldId;
    private String oldName;
    private boolean duplicate;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetTrendLogDescriptor;
    static /* synthetic */ Class class$javax$baja$bacnet$point$BBacnetProxyExt;

    public BOrd getLogOrd() {
        return (BOrd)this.get(logOrd);
    }

    public void setLogOrd(BOrd bOrd) {
        this.set(logOrd, (BValue)bOrd, null);
    }

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public BOrd getHistoryOrd() {
        return (BOrd)this.get(historyOrd);
    }

    public void setHistoryOrd(BOrd bOrd) {
        this.set(historyOrd, (BValue)bOrd, null);
    }

    public String getObjectName() {
        return this.getString(objectName);
    }

    public void setObjectName(String string) {
        this.setString(objectName, string, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String string) {
        this.setString(description, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        super.started();
        this.oldId = this.getObjectId();
        this.oldName = this.getObjectName();
        this.logSubscriber = new BacnetTrendLogSubscriber(this, this.getLog());
        this.checkConfiguration();
        if (Sys.isStationStarted() && this.getStatus().isOk()) {
            BBacnetNetwork.localDevice().incrementDatabaseRevision();
        }
    }

    public final void stopped() throws Exception {
        super.stopped();
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        bLocalBacnetDevice.unexport(this.oldId, this.oldName, this);
        this.logSubscriber.unsubscribeAll();
        this.optionalProps = null;
        this.logSubscriber = null;
        this.tlog = null;
        this.oldId = null;
        this.oldName = null;
        if (this.getStatus().isOk() && bLocalBacnetDevice.isRunning()) {
            bLocalBacnetDevice.incrementDatabaseRevision();
        }
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)objectId)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldId = this.getObjectId();
            try {
                ((BComponent)this.getParent()).rename(this.getPropertyInParent(), this.getObjectId().toString(BacnetConst.nameContext));
            }
            catch (DuplicateSlotException duplicateSlotException) {}
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)objectName)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldName = this.getObjectName();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)logOrd)) {
            this.checkConfiguration();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        }
    }

    public final BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)objectId)) {
            return BBacnetObjectType.getObjectIdFacets(20);
        }
        return super.getSlotFacets(slot);
    }

    public final BObject getObject() {
        return (BObject)this.getLog();
    }

    public final BOrd getObjectOrd() {
        return this.getLogOrd();
    }

    public final void setObjectOrd(BOrd bOrd, Context context) {
        this.set(logOrd, (BValue)bOrd, context);
    }

    public void checkConfiguration() {
        if (this.isFatalFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        this.logSubscriber.unsubscribeAll();
        boolean bl = true;
        if (this.getLog() == null) {
            this.setFaultCause("Cannot find exported history");
            bl = false;
        } else {
            this.logSubscriber.config = this.tlog.getHistoryConfig();
            this.logSubscriber.subscribe((BComponent)this.tlog.getHistoryConfig());
            this.logSubscriber.subscribe((BComponent)((BComplex)this.tlog).getParent());
            if (objectName.isEquivalentToDefaultValue(this.get(objectName))) {
                this.setObjectName(this.tlog.getHistoryConfig().getId().getHistoryName());
            }
            this.setHistoryOrd(BOrd.make((String)("history:" + this.tlog.getHistoryConfig().getId().toString())));
        }
        if (!this.getObjectId().isValid()) {
            this.setFaultCause("Invalid Object ID");
            bl = false;
        }
        if (bl) {
            String string = BBacnetNetwork.localDevice().export(this);
            if (string != null) {
                this.duplicate = true;
                this.setFaultCause(string);
                bl = false;
            } else {
                this.duplicate = false;
            }
        }
        if (bl) {
            this.setFaultCause("");
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)(bl ^ true)));
    }

    public boolean isValidAlarmExt(BIAlarmSource bIAlarmSource) {
        return bIAlarmSource instanceof BBacnetTrendLogAlarmSourceExt;
    }

    public final boolean isEventInitiationEnabled() {
        boolean bl = false;
        if (this.getNotificationClass() != null) {
            bl = true;
        }
        return bl;
    }

    public final BEnum getEventState() {
        BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = this.getAlarmExt();
        if (bBacnetTrendLogAlarmSourceExt == null) {
            return null;
        }
        return BBacnetEventState.make(bBacnetTrendLogAlarmSourceExt.getAlarmState());
    }

    public final BBacnetBitString getAckedTransitions() {
        BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = this.getAlarmExt();
        if (bBacnetTrendLogAlarmSourceExt == null) {
            return null;
        }
        return BacnetBitStringUtil.getBacnetEventTransitionBits(bBacnetTrendLogAlarmSourceExt.getAckedTransitions());
    }

    public final BBacnetTimeStamp[] getEventTimeStamps() {
        BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = this.getAlarmExt();
        if (bBacnetTrendLogAlarmSourceExt == null) {
            return null;
        }
        BBacnetTimeStamp[] bBacnetTimeStampArray = new BBacnetTimeStamp[3];
        BAbsTime bAbsTime = bBacnetTrendLogAlarmSourceExt.getToOffnormalTimes().getAlarmTime();
        bBacnetTimeStampArray[0] = BAbsTime.DEFAULT.equals((Object)bAbsTime) ? new BBacnetTimeStamp(new BBacnetDateTime()) : new BBacnetTimeStamp(bAbsTime);
        bAbsTime = bBacnetTrendLogAlarmSourceExt.getToFaultTimes().getAlarmTime();
        bBacnetTimeStampArray[1] = BAbsTime.DEFAULT.equals((Object)bAbsTime) ? new BBacnetTimeStamp(new BBacnetDateTime()) : new BBacnetTimeStamp(bAbsTime);
        bAbsTime = bBacnetTrendLogAlarmSourceExt.getToNormalTimes().getAlarmTime();
        bBacnetTimeStampArray[2] = BAbsTime.DEFAULT.equals((Object)bAbsTime) ? new BBacnetTimeStamp(new BBacnetDateTime()) : new BBacnetTimeStamp(bAbsTime);
        return bBacnetTimeStampArray;
    }

    public final BBacnetNotifyType getNotifyType() {
        BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = this.getAlarmExt();
        if (bBacnetTrendLogAlarmSourceExt == null) {
            return null;
        }
        return bBacnetTrendLogAlarmSourceExt.getNotifyType();
    }

    public final BBacnetBitString getEventEnable() {
        BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = this.getAlarmExt();
        if (bBacnetTrendLogAlarmSourceExt == null) {
            return null;
        }
        return BacnetBitStringUtil.getBacnetEventTransitionBits(bBacnetTrendLogAlarmSourceExt.getAlarmEnable());
    }

    public final int[] getEventPriorities() {
        BBacnetNotificationClassDescriptor bBacnetNotificationClassDescriptor = this.getNotificationClass();
        if (bBacnetNotificationClassDescriptor == null) {
            return null;
        }
        return bBacnetNotificationClassDescriptor.getEventPriorities();
    }

    public BBacnetNotificationClassDescriptor getNotificationClass() {
        return BacnetTrendLogUtil.getNotificationClass(this.tlog);
    }

    public BEnum getEventType() {
        return BBacnetEventType.bufferReady;
    }

    public final PropertyValue readProperty(PropertyReference propertyReference) throws RejectException {
        this.getLog();
        return this.readProperty(propertyReference.getPropertyId(), propertyReference.getPropertyArrayIndex());
    }

    public final PropertyValue[] readPropertyMultiple(PropertyReference[] propertyReferenceArray) throws RejectException {
        this.getLog();
        PropertyValue[] propertyValueArray = new PropertyValue[]{};
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(propertyReferenceArray.length);
        int n = 0;
        while (n < propertyReferenceArray.length) {
            switch (propertyReferenceArray[n].getPropertyId()) {
                case 8: {
                    int[] nArray = REQUIRED_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    nArray = this.getOptionalProps();
                    n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                case 80: {
                    int[] nArray = this.getOptionalProps();
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                case 105: {
                    int[] nArray = REQUIRED_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                default: {
                    arrayList.add(this.readProperty(propertyReferenceArray[n].getPropertyId(), propertyReferenceArray[n].getPropertyArrayIndex()));
                }
            }
            ++n;
        }
        return arrayList.toArray(propertyValueArray);
    }

    public final RangeData readRange(RangeReference rangeReference) throws RejectException {
        this.getLog();
        if (this.tlog == null) {
            return new ReadRangeAck(1, 1000);
        }
        int n = rangeReference.getPropertyId();
        if (n == 131) {
            Integer n2 = null;
            BAbstractProxyExt bAbstractProxyExt = this.getPoint().getProxyExt();
            if (bAbstractProxyExt instanceof BBacnetProxyExt) {
                BBacnetProxyExt bBacnetProxyExt = (BBacnetProxyExt)bAbstractProxyExt;
                n2 = new Integer(AsnUtil.getAsnType(bBacnetProxyExt.getDataType()));
            }
            int n3 = -1;
            if (rangeReference instanceof BacnetConfirmedRequest) {
                n3 = ((BacnetConfirmedRequest)((Object)rangeReference)).getMaxDataLength();
                n3 -= 17;
            }
            switch (rangeReference.getRangeType()) {
                case 3: {
                    long l = rangeReference.getReferenceIndex();
                    int n4 = rangeReference.getCount();
                    try {
                        RangeData rangeData = BacnetTrendLogUtil.readRangeByPosition(this.tlog, l, n4, n3, n2);
                        return new ReadRangeAck(this.getObjectId(), n, -1, rangeData.getResultFlags(), rangeData.getItemCount(), -1, rangeData.getItemData());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return new ReadRangeAck(2, 0);
                    }
                }
                case 7: {
                    n3 -= 5;
                    BBacnetDateTime bBacnetDateTime = rangeReference.getReferenceTime();
                    int n5 = rangeReference.getCount();
                    try {
                        RangeData rangeData = BacnetTrendLogUtil.readRangeByTime(this.tlog, bBacnetDateTime, n5, n3, n2);
                        return new ReadRangeAck(this.getObjectId(), n, -1, rangeData.getResultFlags(), rangeData.getItemCount(), rangeData.getItemCount() > 0L ? rangeData.getFirstSequenceNumber() : (long)-1, rangeData.getItemData());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return new ReadRangeAck(2, 0);
                    }
                }
                case 6: {
                    n3 -= 5;
                    long l = rangeReference.getReferenceIndex();
                    int n6 = rangeReference.getCount();
                    try {
                        RangeData rangeData = BacnetTrendLogUtil.readRangeBySequence(this.tlog, l, n6, n3, n2);
                        return new ReadRangeAck(this.getObjectId(), n, -1, rangeData.getResultFlags(), rangeData.getItemCount(), rangeData.getItemCount() > 0L ? rangeData.getFirstSequenceNumber() : (long)-1, rangeData.getItemData());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return new ReadRangeAck(2, 0);
                    }
                }
                case -1: {
                    try {
                        RangeData rangeData = BacnetTrendLogUtil.readRangeAll(this.tlog, n3, n2);
                        return new ReadRangeAck(this.getObjectId(), n, -1, rangeData.getResultFlags(), rangeData.getItemCount(), rangeData.getItemCount() > 0L ? rangeData.getFirstSequenceNumber() : (long)-1, rangeData.getItemData());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return new ReadRangeAck(2, 0);
                    }
                }
            }
            log.message("Unsupported ReadRange Range Type: " + rangeReference.getRangeType());
            return new ReadRangeAck(2, 0);
        }
        int n7 = 0;
        while (n7 < REQUIRED_PROPS.length) {
            if (n == REQUIRED_PROPS[n7]) {
                return new ReadRangeAck(5, 22);
            }
            ++n7;
        }
        int[] nArray = this.getOptionalProps();
        int n8 = 0;
        while (n8 < nArray.length) {
            if (n == nArray[n8]) {
                return new ReadRangeAck(5, 22);
            }
            ++n8;
        }
        return new ReadRangeAck(2, 32);
    }

    public final ErrorType writeProperty(PropertyValue propertyValue) throws BacnetException {
        this.getLog();
        return this.writeProperty(propertyValue.getPropertyId(), propertyValue.getPropertyArrayIndex(), propertyValue.getPropertyValue(), propertyValue.getPriority());
    }

    public final ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        this.getLog();
        if (this.tlog == null) {
            return new NChangeListError(8, new NErrorType(1, 1000), 0L);
        }
        if (propertyValue.getPropertyId() == 131) {
            return new NChangeListError(8, new NErrorType(2, 40), 0L);
        }
        int n = propertyValue.getPropertyId();
        int n2 = 0;
        while (n2 < REQUIRED_PROPS.length) {
            if (n == REQUIRED_PROPS[n2]) {
                return new NChangeListError(8, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        int[] nArray = this.getOptionalProps();
        int n3 = 0;
        while (n3 < nArray.length) {
            if (n == nArray[n3]) {
                return new NChangeListError(8, new NErrorType(5, 22), 0L);
            }
            ++n3;
        }
        return new NChangeListError(8, new NErrorType(2, 32), 0L);
    }

    public final ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        this.getLog();
        if (this.tlog == null) {
            return new NChangeListError(9, new NErrorType(1, 1000), 0L);
        }
        if (propertyValue.getPropertyId() == 131) {
            return new NChangeListError(9, new NErrorType(2, 40), 0L);
        }
        int n = propertyValue.getPropertyId();
        int n2 = 0;
        while (n2 < REQUIRED_PROPS.length) {
            if (n == REQUIRED_PROPS[n2]) {
                return new NChangeListError(9, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        int[] nArray = this.getOptionalProps();
        int n3 = 0;
        while (n3 < nArray.length) {
            if (n == nArray[n3]) {
                return new NChangeListError(9, new NErrorType(5, 22), 0L);
            }
            ++n3;
        }
        return new NChangeListError(9, new NErrorType(2, 32), 0L);
    }

    boolean isArray(int n) {
        return n == 130;
    }

    protected PropertyValue readProperty(int n, int n2) {
        if (this.tlog == null) {
            return new NReadPropertyResult(n, n2, new NErrorType(1, 1000));
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NReadPropertyResult(n, n2, new NErrorType(2, 50));
        }
        switch (n) {
            case 75: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnObjectId(this.getObjectId()));
            }
            case 77: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getObjectName()));
            }
            case 79: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(this.getObjectId().getObjectType()));
            }
            case 28: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getDescription()));
            }
            case 133: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnBoolean(this.tlog.getEnabled()));
            }
            case 144: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnBoolean(this.tlog.getHistoryConfig().getFullPolicy().equals((Object)BFullPolicy.stop)));
            }
            case 126: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(BacnetTrendLogUtil.getMaxRecords(this.tlog)));
            }
            case 131: {
                return new NReadPropertyResult(n, n2, new NErrorType(2, 27));
            }
            case 141: {
                long l = 0L;
                if (this.getHistory() != null) {
                    l = this.getHistory().getRecordCount();
                }
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(l));
            }
            case 145: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(this.tlog.getTotalRecordCount()));
            }
            case 36: {
                BControlPoint bControlPoint;
                BAbstractProxyExt bAbstractProxyExt;
                if (this.tlog instanceof BCovHistoryExt && (bAbstractProxyExt = (bControlPoint = this.getPoint()).getProxyExt()) instanceof BBacnetProxyExt) {
                    BBacnetProxyExt bBacnetProxyExt = (BBacnetProxyExt)bAbstractProxyExt;
                    if (bBacnetProxyExt.useCov() && !bBacnetProxyExt.isCOV()) {
                        return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(1));
                    }
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(0));
                }
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(0));
            }
            case 197: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(2));
            }
            case 111: {
                return new NReadPropertyResult(n, n2, AsnUtil.statusToAsnStatusFlags(BStatus.ok));
            }
        }
        return this.readOptionalProperty(n, n2);
    }

    protected PropertyValue readOptionalProperty(int n, int n2) {
        BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = this.getAlarmExt();
        if (bBacnetTrendLogAlarmSourceExt != null) {
            switch (n) {
                case 17: {
                    BBacnetNotificationClassDescriptor bBacnetNotificationClassDescriptor = this.getNotificationClass();
                    if (bBacnetNotificationClassDescriptor == null) {
                        return new NReadPropertyResult(n, n2, new NErrorType(2, 32));
                    }
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bBacnetNotificationClassDescriptor.getNotificationClass()));
                }
                case 35: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(bBacnetTrendLogAlarmSourceExt.getAlarmEnable())));
                }
                case 0: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(bBacnetTrendLogAlarmSourceExt.getAckedTransitions())));
                }
                case 72: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated((BEnum)bBacnetTrendLogAlarmSourceExt.getNotifyType()));
                }
                case 130: {
                    return this.readEventTimeStamps(bBacnetTrendLogAlarmSourceExt, n2);
                }
                case 137: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bBacnetTrendLogAlarmSourceExt.getNotificationThreshold()));
                }
                case 140: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bBacnetTrendLogAlarmSourceExt.getRecordsSinceNotification()));
                }
                case 173: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bBacnetTrendLogAlarmSourceExt.getLastNotifyRecord()));
                }
            }
        }
        BControlPoint bControlPoint = this.getPoint();
        switch (n) {
            case 205: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnBoolean(this.tlog.getTrigger()));
            }
            case 142: {
                BBacnetDateTime bBacnetDateTime;
                if (!(this.tlog.getActivePeriod() instanceof BBacnetActivePeriod) || (bBacnetDateTime = ((BBacnetActivePeriod)this.tlog.getActivePeriod()).getStartTime()) == null) break;
                return new NReadPropertyResult(n, n2, AsnUtil.toAsn((BValue)bBacnetDateTime));
            }
            case 143: {
                BBacnetDateTime bBacnetDateTime;
                if (!(this.tlog.getActivePeriod() instanceof BBacnetActivePeriod) || (bBacnetDateTime = ((BBacnetActivePeriod)this.tlog.getActivePeriod()).getStopTime()) == null) break;
                return new NReadPropertyResult(n, n2, AsnUtil.toAsn((BValue)bBacnetDateTime));
            }
            case 132: {
                BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference = this.getLogDOPRef();
                if (bBacnetDeviceObjectPropertyReference == NULL_DOPR) {
                    return new NReadPropertyResult(n, n2, new NErrorType(2, 32));
                }
                return new NReadPropertyResult(n, n2, AsnUtil.toAsn((BValue)bBacnetDeviceObjectPropertyReference));
            }
            case 134: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(0L));
            }
            case 127: {
                BBacnetProxyExt bBacnetProxyExt;
                if (!(this.tlog instanceof BCovHistoryExt)) break;
                SlotCursor slotCursor = bControlPoint.getProperties();
                Class clazz = class$javax$baja$bacnet$point$BBacnetProxyExt;
                if (clazz == null) {
                    clazz = class$javax$baja$bacnet$point$BBacnetProxyExt = BBacnetTrendLogDescriptor.class("[Ljavax.baja.bacnet.point.BBacnetProxyExt;", false);
                }
                if (slotCursor.next(clazz) && (bBacnetProxyExt = (BBacnetProxyExt)slotCursor.get()).isCOV()) {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnNull());
                }
                if (this.tlog instanceof BNumericCovHistoryExt) {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(((BNumericCovHistoryExt)this.tlog).getChangeTolerance()));
                }
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnNull());
            }
            case 128: {
                if (!(this.tlog instanceof BCovHistoryExt)) break;
                SlotCursor slotCursor = bControlPoint.getProperties();
                Class clazz = class$javax$baja$bacnet$point$BBacnetProxyExt;
                if (clazz == null) {
                    clazz = class$javax$baja$bacnet$point$BBacnetProxyExt = BBacnetTrendLogDescriptor.class("[Ljavax.baja.bacnet.point.BBacnetProxyExt;", false);
                }
                if (!slotCursor.next(clazz)) break;
                BBacnetProxyExt bBacnetProxyExt = (BBacnetProxyExt)slotCursor.get();
                BBacnetDevice bBacnetDevice = bBacnetProxyExt.device();
                if (bBacnetProxyExt == null || bBacnetDevice == null || !bBacnetProxyExt.isCOV()) break;
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bBacnetProxyExt.getCovSubscriptionLifetime() * 30));
            }
        }
        return new NReadPropertyResult(n, n2, new NErrorType(2, 32));
    }

    /*
     * Exception decompiling
     */
    protected ErrorType writeProperty(int var1_1, int var2_2, byte[] var3_3, int var4_4) throws BacnetException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CASE], 3[SWITCH]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected ErrorType writeOptionalProperty(int var1_1, int var2_2, byte[] var3_3, int var4_4) throws BacnetException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CASE]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final int[] getOptionalProps() {
        Object object;
        BBacnetObjectIdentifier bBacnetObjectIdentifier;
        Vector<BBacnetPropertyIdentifier> vector = new Vector<BBacnetPropertyIdentifier>();
        vector.add(BBacnetPropertyIdentifier.description);
        vector.add(BBacnetPropertyIdentifier.logInterval);
        vector.add(BBacnetPropertyIdentifier.trigger);
        BControlPoint bControlPoint = this.getPoint();
        BOrd bOrd = bControlPoint.getHandleOrd();
        BAbstractProxyExt bAbstractProxyExt = bControlPoint.getProxyExt();
        if (this.tlog instanceof BCovHistoryExt) {
            if (bAbstractProxyExt instanceof BBacnetProxyExt && ((BBacnetProxyExt)bAbstractProxyExt).isCOV()) {
                vector.add(BBacnetPropertyIdentifier.covResubscriptionInterval);
            }
            vector.add(BBacnetPropertyIdentifier.clientCovIncrement);
        }
        if ((bBacnetObjectIdentifier = BBacnetNetwork.localDevice().lookupBacnetObjectId(bOrd)) != null) {
            object = BBacnetNetwork.localDevice().lookupBacnetObject(bBacnetObjectIdentifier);
            if (object != null) {
                vector.add(BBacnetPropertyIdentifier.logDeviceObjectProperty);
            }
        } else if (bAbstractProxyExt instanceof BBacnetProxyExt) {
            vector.add(BBacnetPropertyIdentifier.logDeviceObjectProperty);
        }
        if (this.tlog != null && this.tlog.getActivePeriod() instanceof BBacnetActivePeriod) {
            vector.add(BBacnetPropertyIdentifier.startTime);
            vector.add(BBacnetPropertyIdentifier.stopTime);
        }
        if ((object = this.getAlarmExt()) != null) {
            vector.add(BBacnetPropertyIdentifier.notificationThreshold);
            vector.add(BBacnetPropertyIdentifier.recordsSinceNotification);
            vector.add(BBacnetPropertyIdentifier.lastNotifyRecord);
            vector.add(BBacnetPropertyIdentifier.notificationClass);
            vector.add(BBacnetPropertyIdentifier.eventEnable);
            vector.add(BBacnetPropertyIdentifier.ackedTransitions);
            vector.add(BBacnetPropertyIdentifier.notifyType);
            vector.add(BBacnetPropertyIdentifier.eventTimeStamps);
        }
        this.optionalProps = new int[vector.size()];
        int n = 0;
        while (n < this.optionalProps.length) {
            this.optionalProps[n] = ((BEnum)vector.elementAt(n)).getOrdinal();
            ++n;
        }
        return this.optionalProps;
    }

    public String toString(Context context) {
        return this.getObjectName() + " [" + (Object)((Object)this.getObjectId()) + ']';
    }

    final BIBacnetTrendLogExt getLog() {
        if (this.tlog == null) {
            return this.findLog();
        }
        return this.tlog;
    }

    private final BBacnetTrendLogAlarmSourceExt getAlarmExt() {
        return BacnetTrendLogUtil.getAlarmExt(this.tlog);
    }

    private final BControlPoint getPoint() {
        return this.tlog != null ? (BControlPoint)((BHistoryExt)this.tlog).getParent() : null;
    }

    private final BIBacnetTrendLogExt findLog() {
        try {
            if (!logOrd.isEquivalentToDefaultValue((BValue)this.getLogOrd())) {
                BObject bObject = this.getLogOrd().get((BObject)this);
                this.tlog = bObject instanceof BIBacnetTrendLogExt ? (BIBacnetTrendLogExt)bObject : null;
            }
        }
        catch (Exception exception) {
            log.warning("Unable to resolve log ord for " + this + ": " + this.getLogOrd());
            this.tlog = null;
        }
        if (this.tlog == null && this.isRunning()) {
            this.setFaultCause("Cannot find exported history");
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        }
        return this.tlog;
    }

    private final BIHistory getHistory() {
        BHistoryConfig bHistoryConfig;
        BHistoryId bHistoryId;
        BHistoryService bHistoryService;
        BHistoryDatabase bHistoryDatabase;
        BIBacnetTrendLogExt bIBacnetTrendLogExt = this.getLog();
        BIHistory bIHistory = bIBacnetTrendLogExt.getHistory();
        if (bIHistory == null && (bHistoryDatabase = (bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase()).exists(bHistoryId = (bHistoryConfig = bIBacnetTrendLogExt.getHistoryConfig()).getId())) {
            bIHistory = bHistoryDatabase.getHistory(bHistoryId);
        }
        return bIHistory;
    }

    private final BBacnetDeviceObjectPropertyReference getLogDOPRef() {
        BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference = NULL_DOPR;
        BOrd bOrd = this.getPoint().getHandleOrd();
        BBacnetObjectIdentifier bBacnetObjectIdentifier = BBacnetNetwork.localDevice().lookupBacnetObjectId(bOrd);
        if (bBacnetObjectIdentifier != null) {
            bBacnetDeviceObjectPropertyReference = new BBacnetDeviceObjectPropertyReference(bBacnetObjectIdentifier);
        } else {
            BAbstractProxyExt bAbstractProxyExt = this.getPoint().getProxyExt();
            if (bAbstractProxyExt instanceof BBacnetProxyExt) {
                BBacnetProxyExt bBacnetProxyExt = (BBacnetProxyExt)bAbstractProxyExt;
                bBacnetDeviceObjectPropertyReference = new BBacnetDeviceObjectPropertyReference(bBacnetProxyExt.getObjectId(), bBacnetProxyExt.getPropertyId().getOrdinal(), bBacnetProxyExt.getPropertyArrayIndex(), bBacnetProxyExt.device().getObjectId());
            }
        }
        return bBacnetDeviceObjectPropertyReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PropertyValue readEventTimeStamps(BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt, int n) {
        AsnOutputStream asnOutputStream = asnOut;
        synchronized (asnOutputStream) {
            asnOut.reset();
            BAbsTime bAbsTime = bBacnetTrendLogAlarmSourceExt.getToOffnormalTimes().getNormalTime();
            if (bAbsTime.isBefore(bBacnetTrendLogAlarmSourceExt.getToFaultTimes().getNormalTime())) {
                bAbsTime = bBacnetTrendLogAlarmSourceExt.getToFaultTimes().getNormalTime();
            }
            switch (n) {
                case 0: {
                    asnOut.writeUnsignedInteger(3);
                    break;
                }
                case 1: {
                    BBacnetTimeStamp.encodeTimeStamp(bBacnetTrendLogAlarmSourceExt.getToOffnormalTimes().getAlarmTime(), asnOut);
                    break;
                }
                case 2: {
                    BBacnetTimeStamp.encodeTimeStamp(bBacnetTrendLogAlarmSourceExt.getToFaultTimes().getAlarmTime(), asnOut);
                    break;
                }
                case 3: {
                    BBacnetTimeStamp.encodeTimeStamp(bAbsTime, asnOut);
                    break;
                }
                case -1: {
                    BBacnetTimeStamp.encodeTimeStamp(bBacnetTrendLogAlarmSourceExt.getToOffnormalTimes().getAlarmTime(), asnOut);
                    BBacnetTimeStamp.encodeTimeStamp(bBacnetTrendLogAlarmSourceExt.getToFaultTimes().getAlarmTime(), asnOut);
                    BBacnetTimeStamp.encodeTimeStamp(bAbsTime, asnOut);
                    break;
                }
                default: {
                    return new NReadPropertyResult(130, n, new NErrorType(2, 42));
                }
            }
            return new NReadPropertyResult(130, n, asnOut.toByteArray());
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetTrendLogDescriptor", 2);
        spyWriter.prop((Object)"tlog", (Object)this.tlog);
        spyWriter.prop((Object)"logSubscriber", (Object)this.logSubscriber);
        spyWriter.prop((Object)"oldId", (Object)this.oldId);
        spyWriter.prop((Object)"oldName", (Object)this.oldName);
        spyWriter.prop((Object)"duplicate", this.duplicate);
        spyWriter.endProps();
    }

    public BIcon getIcon() {
        return icon;
    }

    final void d(String string) {
        System.out.println("BacSTLog{" + (Object)((Object)this.getObjectId()) + "}:" + string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.oldId = null;
        this.oldName = null;
        this.duplicate = false;
    }

    public BBacnetTrendLogDescriptor() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$bacnet$export$BBacnetTrendLogDescriptor;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BBacnetTrendLogDescriptor = BBacnetTrendLogDescriptor.class("[Ljavax.baja.bacnet.export.BBacnetTrendLogDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"history.png"), (BIcon)BIcon.std((String)"badges/export.png"));
        asnOut = new AsnOutputStream();
        NULL_DOPR = new BBacnetDeviceObjectPropertyReference();
        REQUIRED_PROPS = new int[]{75, 77, 79, 133, 144, 126, 131, 141, 145, 36, 197, 111};
        log = Log.getLog((String)"bacnet.server");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BacnetTrendLogSubscriber
    extends Subscriber {
        private BBacnetTrendLogDescriptor obj;
        BHistoryConfig config;

        public void event(BComponentEvent bComponentEvent) {
            try {
                switch (bComponentEvent.getId()) {
                    case 0: {
                        if (BHistoryConfig.historyName.equals((Object)bComponentEvent.getSlot().asProperty())) {
                            this.obj.checkConfiguration();
                        }
                        break;
                    }
                    case 2: {
                        BObject bObject = this.obj.getObject();
                        if (bObject instanceof BComplex && ((BComplex)bObject).getPropertyInParent() == null) {
                            ((BComponent)this.obj.getParent()).remove(this.obj.getPropertyInParent());
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("obj=" + (Object)((Object)this.obj.getObjectId()));
            }
        }

        public BacnetTrendLogSubscriber(BBacnetTrendLogDescriptor bBacnetTrendLogDescriptor2, BIBacnetTrendLogExt bIBacnetTrendLogExt) {
            this.obj = bBacnetTrendLogDescriptor2;
            if (bIBacnetTrendLogExt != null) {
                this.config = bIBacnetTrendLogExt.getHistoryConfig();
            }
        }
    }
}

