/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.schedule.ScheduleSupport0;
import com.tridium.bacnet.schedule.ScheduleSupport4;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.services.error.NChangeListError;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.export.BBacnetCalendarDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BBacnetScheduleDescriptor
extends BComponent
implements BIBacnetExportObject {
    public static final Property status = BBacnetScheduleDescriptor.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property faultCause = BBacnetScheduleDescriptor.newProperty((int)3, (String)"", null);
    public static final Property scheduleOrd = BBacnetScheduleDescriptor.newProperty((int)64, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"targetType", (String)"baja:Component"));
    public static final Property objectId = BBacnetScheduleDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(17), null);
    public static final Property objectName = BBacnetScheduleDescriptor.newProperty((int)64, (String)"", null);
    public static final Property listOfObjectPropertyReferences = BBacnetScheduleDescriptor.newProperty((int)0, (BValue)new BBacnetListOf(BBacnetDeviceObjectPropertyReference.TYPE), null);
    public static final Property priorityForWriting = BBacnetScheduleDescriptor.newProperty((int)0, (int)16, (BFacets)BFacets.makeInt((int)1, (int)16));
    public static final Property description = BBacnetScheduleDescriptor.newProperty((int)0, (String)"", null);
    public static final Action writePresentValue = BBacnetScheduleDescriptor.newAction((int)20, null);
    public static final Type TYPE;
    private static final BIcon icon;
    static final AsnInputStream asnIn;
    static final AsnOutputStream asnOut;
    private static ScheduleSupport0 supp;
    static Log log;
    private static final int[] REQUIRED_PROPS;
    private static final int[] OPTIONAL_PROPS;
    private static Comparator specialEventBnIdxComparator;
    private static final BInteger NO_BN_IDX;
    private boolean fatalFault;
    private BWeeklySchedule schedule;
    private BBacnetObjectIdentifier oldId;
    private String oldName;
    private boolean duplicate;
    private boolean configOk;
    private boolean isValid;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetScheduleDescriptor;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetDeviceObjectPropertyReference;
    static /* synthetic */ Class class$javax$baja$schedule$BDailySchedule;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BOrd getScheduleOrd() {
        return (BOrd)this.get(scheduleOrd);
    }

    public void setScheduleOrd(BOrd bOrd) {
        this.set(scheduleOrd, (BValue)bOrd, null);
    }

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public String getObjectName() {
        return this.getString(objectName);
    }

    public void setObjectName(String string) {
        this.setString(objectName, string, null);
    }

    public BBacnetListOf getListOfObjectPropertyReferences() {
        return (BBacnetListOf)this.get(listOfObjectPropertyReferences);
    }

    public void setListOfObjectPropertyReferences(BBacnetListOf bBacnetListOf) {
        this.set(listOfObjectPropertyReferences, (BValue)bBacnetListOf, null);
    }

    public int getPriorityForWriting() {
        return this.getInt(priorityForWriting);
    }

    public void setPriorityForWriting(int n) {
        this.setInt(priorityForWriting, n, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String string) {
        this.setString(description, string, null);
    }

    public void writePresentValue() {
        this.invoke(writePresentValue, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.checkFatalFault();
        this.oldId = this.getObjectId();
        this.oldName = this.getObjectName();
        this.checkConfiguration();
        this.validateReferences();
        if (Sys.isStationStarted() && this.configOk()) {
            BBacnetNetwork.localDevice().incrementDatabaseRevision();
        }
    }

    public final void stopped() throws Exception {
        super.stopped();
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        bLocalBacnetDevice.unexport(this.oldId, this.oldName, this);
        this.schedule = null;
        this.oldId = null;
        this.oldName = null;
        if (this.getStatus().isOk() && bLocalBacnetDevice.isRunning()) {
            bLocalBacnetDevice.incrementDatabaseRevision();
        }
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)objectId)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldId = this.getObjectId();
            try {
                ((BComponent)this.getParent()).rename(this.getPropertyInParent(), this.getObjectId().toString(BacnetConst.nameContext));
            }
            catch (DuplicateSlotException duplicateSlotException) {}
            if (this.configOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)objectName)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldName = this.getObjectName();
            if (this.configOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)scheduleOrd)) {
            this.checkConfiguration();
            if (this.configOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)priorityForWriting)) {
            BBacnetNetwork.bacnet().postAsync(new Runnable(){

                public final void run() {
                    BBacnetScheduleDescriptor.this.writePresentValue();
                }
            });
        } else if (property.equals((Object)listOfObjectPropertyReferences)) {
            BBacnetNetwork.bacnet().postAsync(new Runnable(){

                public final void run() {
                    BBacnetScheduleDescriptor.this.resolveTargetReferences();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    BBacnetScheduleDescriptor.this.writePresentValue();
                }
            });
        } else if (property.getName() == "protocolRevision") {
            this.setSupport(((BInteger)this.get("protocolRevision")).getInt());
        } else {
            super.changed(property, context);
        }
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.resolveTargetReferences();
    }

    private final void setSupport(int n) {
        if (n >= 4) {
            if (!(supp instanceof ScheduleSupport4)) {
                supp = new ScheduleSupport4();
            }
        } else if (supp instanceof ScheduleSupport4) {
            supp = new ScheduleSupport0();
        }
        System.out.println("Server schedule support (new) is now " + supp.getClass());
    }

    public final BFacets getSlotFacets(Slot slot) {
        if (slot == objectId) {
            return BBacnetObjectType.getObjectIdFacets(17);
        }
        return super.getSlotFacets(slot);
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)writePresentValue)) {
            this.resolveTargetReferences();
            return BBacnetNetwork.bacnet().postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public abstract void doWritePresentValue();

    public final BObject getObject() {
        return this.getSchedule();
    }

    public final BOrd getObjectOrd() {
        return this.getScheduleOrd();
    }

    public final void setObjectOrd(BOrd bOrd, Context context) {
        this.set(scheduleOrd, (BValue)bOrd, context);
    }

    public synchronized void checkConfiguration() {
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        if (this.isFatalFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.configOk = false;
            return;
        }
        this.findSchedule();
        bLocalBacnetDevice.unsubscribe(this, this.schedule);
        boolean bl = true;
        if (this.schedule == null) {
            this.setFaultCause("Cannot find exported schedule");
            bl = false;
        } else {
            bLocalBacnetDevice.subscribe(this, this.schedule);
        }
        if (!this.getObjectId().isValid()) {
            this.setFaultCause("Invalid Object ID");
            bl = false;
        }
        if (bl &= this.checkScheduleConfiguration()) {
            String string = bLocalBacnetDevice.export(this);
            if (string != null) {
                this.duplicate = true;
                this.setFaultCause(string);
                bl = false;
            } else {
                this.duplicate = false;
            }
        }
        this.configOk = bl;
        if (bl) {
            this.setFaultCause("");
            this.validate();
        } else {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        }
    }

    public final PropertyValue readProperty(PropertyReference propertyReference) throws RejectException {
        this.getSchedule();
        return this.readProperty(propertyReference.getPropertyId(), propertyReference.getPropertyArrayIndex());
    }

    public final PropertyValue[] readPropertyMultiple(PropertyReference[] propertyReferenceArray) throws RejectException {
        this.getSchedule();
        PropertyValue[] propertyValueArray = new PropertyValue[]{};
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(propertyReferenceArray.length);
        int n = 0;
        while (n < propertyReferenceArray.length) {
            switch (propertyReferenceArray[n].getPropertyId()) {
                case 8: {
                    int[] nArray = REQUIRED_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    nArray = OPTIONAL_PROPS;
                    n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                case 80: {
                    int[] nArray = OPTIONAL_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                case 105: {
                    int[] nArray = REQUIRED_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                default: {
                    arrayList.add(this.readProperty(propertyReferenceArray[n].getPropertyId(), propertyReferenceArray[n].getPropertyArrayIndex()));
                }
            }
            ++n;
        }
        return arrayList.toArray(propertyValueArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RangeData readRange(RangeReference var1_1) throws RejectException {
        block34: {
            this.getSchedule();
            if (this.schedule == null) {
                return new ReadRangeAck(1, 1000);
            }
            switch (var1_1.getPropertyId()) {
                case 54: {
                    var2_2 = var1_1.getRangeType();
                    var3_3 = -1;
                    if (var1_1 instanceof BacnetConfirmedRequest) {
                        var3_3 = ((BacnetConfirmedRequest)var1_1).getMaxDataLength() - 23 + 3 + 5;
                    }
                    var4_4 = new boolean[3];
                    v0 = this.getListOfObjectPropertyReferences();
                    v1 = BBacnetScheduleDescriptor.class$javax$baja$bacnet$datatypes$BBacnetDeviceObjectPropertyReference;
                    if (v1 == null) {
                        v1 = BBacnetScheduleDescriptor.class$javax$baja$bacnet$datatypes$BBacnetDeviceObjectPropertyReference = BBacnetScheduleDescriptor.class("[Ljavax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;", false);
                    }
                    var5_5 = (BBacnetDeviceObjectPropertyReference[])v0.getChildren(v1);
                    var6_6 = var5_5.length;
                    if (var2_2 != 3) ** GOTO lbl36
                    var7_7 = (int)var1_1.getReferenceIndex();
                    var8_9 = var1_1.getCount();
                    if (var7_7 > var6_6 || var7_7 < 1) {
                        return new ReadRangeAck(this.getObjectId(), var1_1.getPropertyId(), -1, BBacnetBitString.emptyBitString(3), 0L, new byte[0]);
                    }
                    v2 = BBacnetScheduleDescriptor.class$javax$baja$bacnet$datatypes$BBacnetDeviceObjectPropertyReference;
                    if (v2 == null) {
                        v2 = BBacnetScheduleDescriptor.class$javax$baja$bacnet$datatypes$BBacnetDeviceObjectPropertyReference = BBacnetScheduleDescriptor.class("[Ljavax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;", false);
                    }
                    var9_11 = new Array(v2);
                    var10_12 = 0;
                    if (var8_9 <= 0) ** GOTO lbl31
                    var11_13 = var7_7 - 1;
                    if (true) ** GOTO lbl78
lbl31:
                    // 1 sources

                    if (var8_9 >= 0) {
                        return new ReadRangeAck(5, 7);
                    }
                    var8_9 = -var8_9;
                    var11_13 = var7_7 - 1;
                    if (true) ** GOTO lbl89
lbl36:
                    // 1 sources

                    if (var2_2 != -1) {
                        return new ReadRangeAck(5, 7);
                    }
                    var4_4[0] = true;
                    var7_8 = 0;
                    var8_10 = BBacnetScheduleDescriptor.asnOut;
                    synchronized (var8_10) {
                        BBacnetScheduleDescriptor.asnOut.reset();
                        if (var3_3 > 0) {
                            var11_15 = 0;
                        }
                        ** GOTO lbl59
                        while (var11_15 < var6_6) {
                            var5_5[var11_15].writeAsn(BBacnetScheduleDescriptor.asnOut);
                            ++var7_8;
                            if (var3_3 - BBacnetScheduleDescriptor.asnOut.size() < 16) break;
                            ++var11_15;
                        }
                        if (var7_8 == var6_6) {
                            var4_4[1] = true;
                        }
                        ** GOTO lbl68
lbl59:
                        // 1 sources

                        var7_8 = var6_6;
                        var11_16 = 0;
                        while (true) {
                            if (var11_16 >= var6_6) {
                                var4_4[1] = true;
                                break;
                            }
                            var5_5[var11_16].writeAsn(BBacnetScheduleDescriptor.asnOut);
                            ++var11_16;
                        }
lbl68:
                        // 2 sources

                        if (var7_8 < var6_6) {
                            var4_4[2] = true;
                        }
                        return new ReadRangeAck(this.getObjectId(), var1_1.getPropertyId(), -1, BBacnetBitString.make(var4_4), (long)var7_8, BBacnetScheduleDescriptor.asnOut.toByteArray());
                    }
                }
                default: {
                    return new ReadRangeAck(2, 22);
                }
            }
            do {
                var9_11.add((Object)var5_5[var11_13]);
                ++var10_12;
                ++var11_13;
lbl78:
                // 2 sources

            } while (var11_13 < var6_6 && var10_12 < var8_9);
            if (var7_7 == 1) {
                var4_4[0] = true;
            }
            if (var7_7 + var8_9 - 1 >= var6_6) {
                var4_4[1] = true;
            }
            break block34;
            do {
                var9_11.add((Object)var5_5[var11_13]);
                ++var10_12;
                --var11_13;
lbl89:
                // 2 sources

            } while (var11_13 >= 0 && var10_12 < var8_9);
            var9_11 = var9_11.reverse();
            if (var7_7 - var8_9 <= 0) {
                var4_4[0] = true;
            }
            if (var7_7 == var6_6) {
                var4_4[1] = true;
            }
        }
        var11_14 = var9_11.iterator();
        var12_17 = 0;
        var13_18 = BBacnetScheduleDescriptor.asnOut;
        synchronized (var13_18) {
            block33: {
                block32: {
                    BBacnetScheduleDescriptor.asnOut.reset();
                    if (var3_3 <= 0) break block32;
                    while (var11_14.hasNext()) {
                        if (var3_3 - BBacnetScheduleDescriptor.asnOut.size() < 16) {
                            var4_4[1] = false;
                            break block33;
                        }
                        ((BBacnetDeviceObjectPropertyReference)var11_14.next()).writeAsn(BBacnetScheduleDescriptor.asnOut);
                        ++var12_17;
                    }
                    break block33;
                }
                var12_17 = var10_12;
                while (var11_14.hasNext()) {
                    ((BBacnetDeviceObjectPropertyReference)var11_14.next()).writeAsn(BBacnetScheduleDescriptor.asnOut);
                }
            }
            if (var12_17 < var10_12) {
                var4_4[2] = true;
            }
            return new ReadRangeAck(this.getObjectId(), var1_1.getPropertyId(), -1, BBacnetBitString.make(var4_4), (long)var12_17, BBacnetScheduleDescriptor.asnOut.toByteArray());
        }
    }

    public final ErrorType writeProperty(PropertyValue propertyValue) throws BacnetException {
        this.getSchedule();
        return this.writeProperty(propertyValue.getPropertyId(), propertyValue.getPropertyArrayIndex(), propertyValue.getPropertyValue(), propertyValue.getPriority());
    }

    public final ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        if (this.getSchedule() == null) {
            return new NChangeListError(8, new NErrorType(1, 1000), 0L);
        }
        if (propertyValue.getPropertyId() == 54) {
            if (propertyValue.getPropertyArrayIndex() >= 0) {
                return new NChangeListError(8, new NErrorType(2, 50), 0L);
            }
            return this.addScheduleTargets(propertyValue.getPropertyValue());
        }
        return new NChangeListError(8, new NErrorType(5, 22), 0L);
    }

    public final ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        if (this.getSchedule() == null) {
            return new NChangeListError(9, new NErrorType(1, 1000), 0L);
        }
        if (propertyValue.getPropertyId() == 54) {
            if (propertyValue.getPropertyArrayIndex() >= 0) {
                return new NChangeListError(9, new NErrorType(2, 50), 0L);
            }
            return this.removeScheduleTargets(propertyValue.getPropertyValue());
        }
        return new NChangeListError(9, new NErrorType(5, 22), 0L);
    }

    boolean isArray(int n) {
        if (n == 123) {
            return true;
        }
        return n == 38;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PropertyValue readProperty(int n, int n2) {
        if (this.schedule == null) {
            return new NReadPropertyResult(n, n2, new NErrorType(1, 1000));
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NReadPropertyResult(n, n2, new NErrorType(2, 50));
        }
        switch (n) {
            case 75: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnObjectId(this.getObjectId()));
            }
            case 77: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getObjectName()));
            }
            case 79: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(this.getObjectId().getObjectType()));
            }
            case 32: {
                AsnOutputStream asnOutputStream = asnOut;
                synchronized (asnOutputStream) {
                    asnOut.reset();
                    supp.encodeDateRange(this.schedule.getEffective(), asnOut);
                    return new NReadPropertyResult(n, n2, asnOut.toByteArray());
                }
            }
            case 123: {
                return this.readWeeklySchedule(n2);
            }
            case 38: {
                return this.readExceptionSchedule(n2);
            }
            case 54: {
                return this.readListOfObjectPropertyReferences(n2);
            }
            case 88: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(this.getPriorityForWriting()));
            }
            case 111: {
                return new NReadPropertyResult(n, n2, AsnUtil.statusToAsnStatusFlags(((BStatusValue)this.schedule.get("out")).getStatus()));
            }
            case 103: {
                int n3 = 0;
                if (!this.isValid) {
                    n3 = 10;
                }
                if (((BStatusValue)this.schedule.get("out")).getStatus().isFault()) {
                    n3 = 10;
                }
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(n3));
            }
            case 81: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnBoolean(((BStatusValue)this.schedule.get("out")).getStatus().isDisabled()));
            }
            case 28: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getDescription()));
            }
        }
        return new NReadPropertyResult(n, n2, new NErrorType(2, 32));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ErrorType writeProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        if (this.schedule == null) {
            return new NErrorType(1, 1000);
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NErrorType(2, 50);
        }
        try {
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                asnIn.setBuffer(byArray);
                switch (n) {
                    case 75: {
                        return new NErrorType(2, 40);
                    }
                    case 77: {
                        return BacUtil.setObjectName(this, objectName, byArray);
                    }
                    case 79: {
                        return new NErrorType(2, 40);
                    }
                    case 32: {
                        this.schedule.set(BWeeklySchedule.effective, (BValue)supp.decodeDateRange(asnIn), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 123: {
                        return this.writeWeeklySchedule(n2);
                    }
                    case 38: {
                        return this.writeExceptionSchedule(n2);
                    }
                    case 54: {
                        return this.writeListOfObjectPropertyReferences();
                    }
                    case 88: {
                        int n4 = asnIn.readUnsignedInt();
                        if (n4 >= 1 && n4 <= 16) {
                            this.setInt(priorityForWriting, n4, BLocalBacnetDevice.getBacnetContext());
                            return null;
                        }
                        return new NErrorType(2, 37);
                    }
                    case 111: {
                        return new NErrorType(2, 40);
                    }
                    case 103: {
                        return new NErrorType(2, 40);
                    }
                    case 81: {
                        Property property = this.schedule.loadSlots().getProperty("in");
                        BLink[] bLinkArray = this.schedule.getLinks((Slot)property);
                        if (bLinkArray.length > 0) {
                            return new NErrorType(2, 40);
                        }
                        boolean bl = asnIn.readBoolean();
                        BStatusValue bStatusValue = (BStatusValue)this.schedule.get(property).newCopy();
                        Property property2 = this.schedule.loadSlots().getProperty("out");
                        BStatusValue bStatusValue2 = (BStatusValue)this.schedule.get(property2).newCopy();
                        bStatusValue.setStatusNull(bl ^ true);
                        bStatusValue.setStatusDisabled(bl);
                        bStatusValue.setValueValue(bStatusValue2.getValueValue());
                        this.schedule.set(property, (BValue)bStatusValue, BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 28: {
                        this.setString(description, AsnUtil.fromAsnCharacterString(byArray), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                }
                return new NErrorType(2, 32);
            }
        }
        catch (AsnException asnException) {
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
    }

    protected boolean checkScheduleConfiguration() {
        return true;
    }

    void checkValid() {
        if (this.configOk()) {
            this.validate();
        }
    }

    protected void validate() {
        BWeeklySchedule bWeeklySchedule = this.getSchedule();
        int n = 0;
        while (n < 7) {
            BDaySchedule bDaySchedule = bWeeklySchedule.get(BWeekday.make((int)n));
            BTimeSchedule[] bTimeScheduleArray = bDaySchedule.getTimesInOrder();
            int n2 = 0;
            while (n2 < bTimeScheduleArray.length) {
                if (bTimeScheduleArray[n2].getEffectiveValue().getStatus().isNull()) {
                    this.isValid = false;
                    this.setFaultCause("Exported schedule value cannot be null");
                    this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                    return;
                }
                ++n2;
            }
            ++n;
        }
        this.isValid = true;
        this.setFaultCause("");
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
    }

    synchronized boolean configOk() {
        return this.configOk;
    }

    public String toString(Context context) {
        return this.getObjectName() + " [" + (Object)((Object)this.getObjectId()) + ']';
    }

    protected final BWeeklySchedule getSchedule() {
        if (this.schedule == null) {
            return this.findSchedule();
        }
        return this.schedule;
    }

    private final BWeeklySchedule findSchedule() {
        try {
            if (!scheduleOrd.isEquivalentToDefaultValue((BValue)this.getScheduleOrd())) {
                BObject bObject = this.getScheduleOrd().get((BObject)this);
                this.schedule = bObject instanceof BWeeklySchedule ? (BWeeklySchedule)bObject : null;
            }
            if (!this.isScheduleTypeLegal(this.schedule)) {
                this.schedule = null;
            }
        }
        catch (Exception exception) {
            log.warning("Unable to resolve schedule ord for " + this + ": " + this.getScheduleOrd());
            this.schedule = null;
        }
        if (this.schedule == null && this.isRunning()) {
            this.setFaultCause("Cannot find exported schedule");
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        }
        return this.schedule;
    }

    boolean isScheduleTypeLegal(BWeeklySchedule bWeeklySchedule) {
        return true;
    }

    abstract int getAsnType();

    abstract Property getScheduleOutputProperty();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PropertyValue readWeeklySchedule(int n) {
        AsnOutputStream asnOutputStream = asnOut;
        synchronized (asnOutputStream) {
            asnOut.reset();
            switch (n) {
                case 0: {
                    return new NReadPropertyResult(123, n, AsnUtil.toAsnUnsigned(7L));
                }
                case -1: {
                    int n2 = 1;
                    while (true) {
                        if (n2 > 7) {
                            return new NReadPropertyResult(123, n, asnOut.toByteArray());
                        }
                        supp.encodeDailySchedule(this.schedule.get(BWeekday.make((int)(n2 % 7))), this.schedule.getDefaultOutput(), asnOut, this.getAsnType());
                        ++n2;
                    }
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    supp.encodeDailySchedule(this.schedule.get(BWeekday.make((int)(n % 7))), this.schedule.getDefaultOutput(), asnOut, this.getAsnType());
                    return new NReadPropertyResult(123, n, asnOut.toByteArray());
                }
            }
            return new NReadPropertyResult(123, n, new NErrorType(2, 42));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PropertyValue readExceptionSchedule(int n) {
        try {
            AsnOutputStream asnOutputStream = asnOut;
            synchronized (asnOutputStream) {
                asnOut.reset();
                switch (n) {
                    case 0: {
                        SlotCursor slotCursor = this.schedule.getSpecialEvents().getProperties();
                        int n2 = 0;
                        while (true) {
                            Class clazz;
                            if ((clazz = class$javax$baja$schedule$BDailySchedule) == null) {
                                clazz = BBacnetScheduleDescriptor.class("[Ljavax.baja.schedule.BDailySchedule;", false);
                            }
                            if (!slotCursor.next(clazz)) {
                                return new NReadPropertyResult(38, n, AsnUtil.toAsnUnsigned(n2));
                            }
                            ++n2;
                        }
                    }
                    case -1: {
                        supp.encodeExceptionScheduleWithIdx(this.schedule.getSpecialEvents(), this.schedule.getDefaultOutput(), asnOut, this.getAsnType(), BBacnetNetwork.localDevice().getObjectId());
                        return new NReadPropertyResult(38, n, asnOut.toByteArray());
                    }
                }
                if (n < 0) {
                    return new NReadPropertyResult(38, n, new NErrorType(2, 42));
                }
                supp.encodeSpecialEvent(n, this.schedule.getSpecialEvents(), this.schedule.getDefaultOutput(), asnOut, this.getAsnType(), BBacnetNetwork.localDevice().getObjectId());
                return new NReadPropertyResult(38, n, asnOut.toByteArray());
            }
        }
        catch (Exception exception) {
            return new NReadPropertyResult(38, n, new NErrorType(2, 42));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ErrorType writeWeeklySchedule(int n) throws BacnetException {
        try {
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                switch (n) {
                    case 0: {
                        return new NErrorType(2, 40);
                    }
                    case -1: {
                        int n2 = 1;
                        while (true) {
                            if (n2 > 7) {
                                return null;
                            }
                            ((BDailySchedule)this.schedule.getWeek().get(BWeekday.make((int)(n2 % 7)).getTag())).set(BDailySchedule.day, (BValue)supp.decodeDailySchedule(this.schedule.getDefaultOutput(), asnIn, this.getAsnType()), BLocalBacnetDevice.getBacnetContext());
                            ++n2;
                        }
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ((BDailySchedule)this.schedule.getWeek().get(BWeekday.make((int)(n % 7)).getTag())).set(BDailySchedule.day, (BValue)supp.decodeDailySchedule(this.schedule.getDefaultOutput(), asnIn, this.getAsnType()), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                }
                return new NErrorType(2, 42);
            }
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing weeklySchedule in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ErrorType writeExceptionSchedule(int n) throws BacnetException {
        BCompositeSchedule bCompositeSchedule = null;
        BCompositeSchedule bCompositeSchedule2 = null;
        Property property = this.schedule.getSchedule().loadSlots().getProperty("specialEvents");
        try {
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                BDailySchedule[] bDailyScheduleArray;
                bCompositeSchedule2 = this.schedule.getSpecialEvents();
                switch (n) {
                    case 0: {
                        this.writeExceptionSchSize(bCompositeSchedule2, asnIn.readInteger());
                        return null;
                    }
                    case -1: {
                        bCompositeSchedule = supp.decodeExceptionSchedule(this.schedule.getDefaultOutput(), asnIn, BBacnetNetwork.localDevice().getObjectId(), this.getAsnType());
                        Class clazz = class$javax$baja$schedule$BDailySchedule;
                        if (clazz == null) {
                            clazz = class$javax$baja$schedule$BDailySchedule = BBacnetScheduleDescriptor.class("[Ljavax.baja.schedule.BDailySchedule;", false);
                        }
                        this.switchOrds((BDailySchedule[])bCompositeSchedule.getChildren(clazz));
                        this.schedule.getSchedule().set(property, (BValue)bCompositeSchedule, BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                }
                BDailySchedule bDailySchedule = supp.decodeSpecialEvent(this.schedule.getDefaultOutput(), asnIn, BBacnetNetwork.localDevice().getObjectId(), this.getAsnType(), n);
                this.switchOrds(new BDailySchedule[]{bDailySchedule});
                if (n < 1) {
                    return new NErrorType(2, 42);
                }
                Class clazz = class$javax$baja$schedule$BDailySchedule;
                if (clazz == null) {
                    clazz = class$javax$baja$schedule$BDailySchedule = BBacnetScheduleDescriptor.class("[Ljavax.baja.schedule.BDailySchedule;", false);
                }
                if (n > (bDailyScheduleArray = (BDailySchedule[])bCompositeSchedule2.getChildren(clazz)).length) {
                    return new NErrorType(2, 42);
                }
                bDailyScheduleArray[n - 1].copyFrom((BAbstractSchedule)bDailySchedule, BLocalBacnetDevice.getBacnetContext());
                return null;
            }
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing exceptionSchedule in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
    }

    private final void writeExceptionSchSize(BCompositeSchedule bCompositeSchedule, int n) {
        block5: {
            Class clazz = class$javax$baja$schedule$BDailySchedule;
            if (clazz == null) {
                clazz = class$javax$baja$schedule$BDailySchedule = BBacnetScheduleDescriptor.class("[Ljavax.baja.schedule.BDailySchedule;", false);
            }
            BDailySchedule[] bDailyScheduleArray = (BDailySchedule[])bCompositeSchedule.getChildren(clazz);
            if (bCompositeSchedule == null || bDailyScheduleArray == null) break block5;
            Arrays.sort(bDailyScheduleArray, specialEventBnIdxComparator);
            int n2 = bDailyScheduleArray.length - n;
            if (n2 > 0) {
                int n3 = 0;
                while (n3 < n2) {
                    bCompositeSchedule.remove((BComplex)bDailyScheduleArray[bDailyScheduleArray.length - 1 - n3]);
                    ++n3;
                }
            } else {
                int n4 = 0;
                while (n4 < -n2) {
                    BDailySchedule bDailySchedule = new BDailySchedule();
                    bDailySchedule.add("bacnetIdx", (BValue)BInteger.make((int)(bDailyScheduleArray.length + n4)));
                    bCompositeSchedule.add(null, (BValue)bDailySchedule);
                    ++n4;
                }
            }
        }
    }

    private final void switchOrds(BDailySchedule[] bDailyScheduleArray) {
        if (bDailyScheduleArray == null) {
            return;
        }
        int n = 0;
        while (n < bDailyScheduleArray.length) {
            BOrd bOrd;
            BComponent bComponent;
            BDailySchedule bDailySchedule = bDailyScheduleArray[n];
            if (bDailySchedule.getDays() instanceof BScheduleReference && (bComponent = (bOrd = ((BScheduleReference)bDailySchedule.getDays()).getRef()).get((BObject)this).asComponent()) instanceof BBacnetCalendarDescriptor) {
                BCalendarSchedule bCalendarSchedule = (BCalendarSchedule)((BBacnetCalendarDescriptor)bComponent).getObject();
                ((BScheduleReference)bDailySchedule.getDays()).setRef(bCalendarSchedule.getSlotPathOrd());
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PropertyValue readListOfObjectPropertyReferences(int n) {
        AsnOutputStream asnOutputStream = asnOut;
        synchronized (asnOutputStream) {
            asnOut.reset();
            this.getListOfObjectPropertyReferences().writeAsn(asnOut);
            return new NReadPropertyResult(54, n, asnOut.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ErrorType writeListOfObjectPropertyReferences() throws BacnetException {
        BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference;
        BacnetConst bacnetConst;
        Vector<BBacnetDeviceObjectPropertyReference> vector = new Vector<BBacnetDeviceObjectPropertyReference>();
        try {
            bacnetConst = asnIn;
            synchronized (bacnetConst) {
                int n = asnIn.peekTag();
                while (n != -1) {
                    bBacnetDeviceObjectPropertyReference = new BBacnetDeviceObjectPropertyReference();
                    bBacnetDeviceObjectPropertyReference.readAsn(asnIn);
                    if (bBacnetDeviceObjectPropertyReference.isDeviceIdUsed() && bBacnetDeviceObjectPropertyReference.getDeviceId().getObjectType() != 8) {
                        return new NErrorType(2, 37);
                    }
                    if (!this.isValidReference(bBacnetDeviceObjectPropertyReference)) {
                        return new NErrorType(2, 47);
                    }
                    vector.add(bBacnetDeviceObjectPropertyReference);
                    n = asnIn.peekTag();
                }
            }
        }
        catch (AsnException asnException) {
            throw new RejectException(4);
        }
        this.getListOfObjectPropertyReferences().removeAll();
        try {
            bacnetConst = BBacnetNetwork.localDevice();
            Iterator iterator = vector.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return null;
                }
                BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference2 = (BBacnetDeviceObjectPropertyReference)iterator.next();
                if (!bBacnetDeviceObjectPropertyReference2.isDeviceIdUsed() || bBacnetDeviceObjectPropertyReference2.getDeviceId().equals((Object)((BLocalBacnetDevice)bacnetConst).getObjectId())) {
                    BIBacnetExportObject bIBacnetExportObject = ((BLocalBacnetDevice)bacnetConst).lookupBacnetObject(bBacnetDeviceObjectPropertyReference2.getObjectId());
                    if (bIBacnetExportObject == null) {
                        return new NErrorType(2, 37);
                    }
                    bBacnetDeviceObjectPropertyReference = bIBacnetExportObject.getObject();
                    if (bBacnetDeviceObjectPropertyReference == null) {
                        return new NErrorType(2, 1000);
                    }
                }
                this.getListOfObjectPropertyReferences().addListElement((BValue)bBacnetDeviceObjectPropertyReference2, BLocalBacnetDevice.getBacnetContext());
            }
        }
        catch (PermissionException permissionException) {
            return new NErrorType(2, 40);
        }
        catch (Exception exception) {
            return new NErrorType(2, 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void resolveTargetReferences() {
        var1_1 = this.getListOfObjectPropertyReferences().getProperties();
        if (true) ** GOTO lbl10
        do {
            if ((var2_2 = (BBacnetDeviceObjectPropertyReference)var1_1.get()).isDeviceIdUsed() && (var3_3 = var2_2.getDeviceId()).isValid() && var3_3.getObjectType() == 8 && BBacnetNetwork.bacnet().doLookupDeviceById(var3_3) == null) {
                try {
                    ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient().whoIs(BBacnetAddress.GLOBAL_BROADCAST_ADDRESS, var3_3.getInstanceNumber(), var3_3.getInstanceNumber());
                }
                catch (BacnetException var4_4) {
                    BBacnetScheduleDescriptor.log.warning("Unable to determine address for Schedule target reference: " + this + " target=" + (Object)var3_3 + " :" + (Object)var4_4);
                }
            }
lbl10:
            // 5 sources

            if ((v0 = BBacnetScheduleDescriptor.class$javax$baja$bacnet$datatypes$BBacnetDeviceObjectPropertyReference) != null) continue;
            v0 = BBacnetScheduleDescriptor.class("[Ljavax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;", false);
        } while (var1_1.next(v0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ChangeListError addScheduleTargets(byte[] byArray) throws RejectException {
        BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference;
        BacnetConst bacnetConst;
        Vector<BBacnetDeviceObjectPropertyReference> vector = new Vector<BBacnetDeviceObjectPropertyReference>();
        int n = 1;
        try {
            bacnetConst = asnIn;
            synchronized (bacnetConst) {
                asnIn.setBuffer(byArray);
                int n2 = asnIn.peekTag();
                while (n2 != -1) {
                    bBacnetDeviceObjectPropertyReference = new BBacnetDeviceObjectPropertyReference();
                    bBacnetDeviceObjectPropertyReference.readAsn(asnIn);
                    if (bBacnetDeviceObjectPropertyReference.isDeviceIdUsed() && bBacnetDeviceObjectPropertyReference.getDeviceId().getObjectType() != 8) {
                        return new NChangeListError(8, new NErrorType(2, 37), n);
                    }
                    if (!this.isValidReference(bBacnetDeviceObjectPropertyReference)) {
                        return new NChangeListError(8, new NErrorType(2, 47), n);
                    }
                    vector.add(bBacnetDeviceObjectPropertyReference);
                    ++n;
                    n2 = asnIn.peekTag();
                }
            }
        }
        catch (AsnException asnException) {
            return new NChangeListError(8, new NErrorType(2, 9), n);
        }
        n = 1;
        try {
            bacnetConst = BBacnetNetwork.localDevice();
            Iterator iterator = vector.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return null;
                }
                BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference2 = (BBacnetDeviceObjectPropertyReference)iterator.next();
                if (!bBacnetDeviceObjectPropertyReference2.isDeviceIdUsed() || bBacnetDeviceObjectPropertyReference2.getDeviceId().equals((Object)((BLocalBacnetDevice)bacnetConst).getObjectId())) {
                    BIBacnetExportObject bIBacnetExportObject = ((BLocalBacnetDevice)bacnetConst).lookupBacnetObject(bBacnetDeviceObjectPropertyReference2.getObjectId());
                    if (bIBacnetExportObject == null) {
                        return new NChangeListError(8, new NErrorType(2, 37), n);
                    }
                    bBacnetDeviceObjectPropertyReference = bIBacnetExportObject.getObject();
                    if (bBacnetDeviceObjectPropertyReference == null) {
                        return new NChangeListError(8, new NErrorType(2, 1000), n);
                    }
                }
                this.getListOfObjectPropertyReferences().addListElement((BValue)bBacnetDeviceObjectPropertyReference2, BLocalBacnetDevice.getBacnetContext());
                ++n;
            }
        }
        catch (PermissionException permissionException) {
            return new NChangeListError(8, new NErrorType(2, 40), n);
        }
        catch (Exception exception) {
            return new NChangeListError(8, new NErrorType(2, 0), n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ChangeListError removeScheduleTargets(byte[] byArray) throws RejectException {
        Object object;
        int n = 1;
        Vector<BBacnetDeviceObjectPropertyReference> vector = new Vector<BBacnetDeviceObjectPropertyReference>();
        try {
            object = asnIn;
            synchronized (object) {
                asnIn.setBuffer(byArray);
                int n2 = asnIn.peekTag();
                while (n2 != -1) {
                    BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference = new BBacnetDeviceObjectPropertyReference();
                    bBacnetDeviceObjectPropertyReference.readAsn(asnIn);
                    vector.add(bBacnetDeviceObjectPropertyReference);
                    n2 = asnIn.peekTag();
                    ++n;
                }
            }
        }
        catch (AsnException asnException) {
            if (log.isTraceOn()) {
                asnException.printStackTrace();
            }
            return new NChangeListError(9, new NErrorType(2, 9), n);
        }
        n = 1;
        while (n <= vector.size()) {
            object = (BBacnetDeviceObjectPropertyReference)vector.get(n - 1);
            if (!this.getListOfObjectPropertyReferences().contains((BValue)object)) {
                return new NChangeListError(9, new NErrorType(5, 81), n);
            }
            ++n;
        }
        try {
            object = vector.iterator();
            while (true) {
                if (!object.hasNext()) {
                    return null;
                }
                BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference = (BBacnetDeviceObjectPropertyReference)object.next();
                this.getListOfObjectPropertyReferences().removeListElement((BValue)bBacnetDeviceObjectPropertyReference, BLocalBacnetDevice.getBacnetContext());
                ++n;
            }
        }
        catch (PermissionException permissionException) {
            return new NChangeListError(9, new NErrorType(2, 40), n);
        }
        catch (Exception exception) {
            return new NChangeListError(9, new NErrorType(2, 0), n);
        }
    }

    private final boolean isValidReference(BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference) {
        BBacnetDevice bBacnetDevice;
        PropertyInfo propertyInfo = BBacnetNetwork.localDevice().getPropertyInfo(bBacnetDeviceObjectPropertyReference.getObjectId().getObjectType(), bBacnetDeviceObjectPropertyReference.getPropertyId());
        if (bBacnetDeviceObjectPropertyReference.isDeviceIdUsed() && !bBacnetDeviceObjectPropertyReference.getDeviceId().equals((Object)BBacnetNetwork.localDevice().getObjectId()) && (bBacnetDevice = BBacnetNetwork.bacnet().doLookupDeviceById(bBacnetDeviceObjectPropertyReference.getDeviceId())) != null) {
            propertyInfo = bBacnetDevice.getPropertyInfo(bBacnetDeviceObjectPropertyReference.getObjectId().getObjectType(), bBacnetDeviceObjectPropertyReference.getPropertyId());
        }
        if (propertyInfo != null) {
            boolean bl = false;
            if (propertyInfo.getAsnType() == this.getAsnType()) {
                bl = true;
            }
            return bl;
        }
        return true;
    }

    private final void validateReferences() {
        BBacnetListOf bBacnetListOf = this.getListOfObjectPropertyReferences();
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetDeviceObjectPropertyReference;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetDeviceObjectPropertyReference = BBacnetScheduleDescriptor.class("[Ljavax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;", false);
        }
        BBacnetDeviceObjectPropertyReference[] bBacnetDeviceObjectPropertyReferenceArray = (BBacnetDeviceObjectPropertyReference[])bBacnetListOf.getChildren(clazz);
        int n = 0;
        while (n < bBacnetDeviceObjectPropertyReferenceArray.length) {
            BBacnetDeviceObjectPropertyReference bBacnetDeviceObjectPropertyReference = bBacnetDeviceObjectPropertyReferenceArray[n];
            if (!this.isValidReference(bBacnetDeviceObjectPropertyReference)) {
                bBacnetListOf.remove((BComplex)bBacnetDeviceObjectPropertyReference);
            }
            ++n;
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    private final void checkFatalFault() {
        BBacnetExportTable bBacnetExportTable = null;
        BLocalBacnetDevice bLocalBacnetDevice = null;
        BBacnetNetwork bBacnetNetwork = null;
        if (this.fatalFault) {
            return;
        }
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BBacnetExportTable) {
                bBacnetExportTable = (BBacnetExportTable)bComplex;
            } else if (bComplex instanceof BLocalBacnetDevice) {
                bLocalBacnetDevice = (BLocalBacnetDevice)bComplex;
                break;
            }
            bComplex = bComplex.getParent();
        }
        if (bBacnetExportTable == null || bLocalBacnetDevice == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under LocalBacnetDevice Export Table");
            return;
        }
        if (bLocalBacnetDevice.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("LocalDevice fault: " + bLocalBacnetDevice.getFaultCause());
            return;
        }
        bBacnetNetwork = (BBacnetNetwork)bLocalBacnetDevice.getParent();
        if (bBacnetNetwork == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under BacnetNetwork");
            return;
        }
        if (bBacnetNetwork.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + bBacnetNetwork.getFaultCause());
            return;
        }
        Feature feature = bBacnetNetwork.getLicenseFeature();
        boolean bl = feature.getb("export", false);
        if (!bl) {
            this.fatalFault = true;
            this.setFaultCause("Server capability not licensed");
            return;
        }
        this.setFaultCause("");
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetScheduleDescriptor", 2);
        spyWriter.prop((Object)"fatalFault", this.fatalFault);
        spyWriter.prop((Object)"schedule", (Object)this.schedule);
        spyWriter.prop((Object)"supp", (Object)supp);
        spyWriter.prop((Object)"oldId", (Object)this.oldId);
        spyWriter.prop((Object)"oldName", (Object)this.oldName);
        spyWriter.prop((Object)"duplicate", this.duplicate);
        spyWriter.prop((Object)"configOk", this.configOk());
        spyWriter.prop((Object)"isValid", this.isValid);
        spyWriter.endProps();
    }

    final BBacnetClientLayer client() {
        return ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.fatalFault = false;
        this.oldId = null;
        this.oldName = null;
        this.duplicate = false;
    }

    public BBacnetScheduleDescriptor() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$bacnet$export$BBacnetScheduleDescriptor;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BBacnetScheduleDescriptor = BBacnetScheduleDescriptor.class("[Ljavax.baja.bacnet.export.BBacnetScheduleDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"schedule.png"), (BIcon)BIcon.std((String)"badges/export.png"));
        asnIn = new AsnInputStream();
        asnOut = new AsnOutputStream();
        supp = new ScheduleSupport4();
        log = Log.getLog((String)"bacnet.server");
        REQUIRED_PROPS = new int[]{75, 77, 79, 85, 32, 174, 54, 88, 111, 103, 81};
        OPTIONAL_PROPS = new int[]{28, 123, 38};
        specialEventBnIdxComparator = new Comparator(){

            public final int compare(Object object, Object object2) {
                if (object == null || object2 == null) {
                    throw new NullPointerException();
                }
                if (object instanceof BDailySchedule && object2 instanceof BDailySchedule) {
                    BInteger bInteger;
                    BDailySchedule bDailySchedule = (BDailySchedule)object;
                    BDailySchedule bDailySchedule2 = (BDailySchedule)object2;
                    BInteger bInteger2 = (BInteger)bDailySchedule.get("bacnetIdx");
                    if (bInteger2 == null) {
                        bInteger2 = NO_BN_IDX;
                    }
                    if ((bInteger = (BInteger)bDailySchedule2.get("bacnetIdx")) == null) {
                        bInteger = NO_BN_IDX;
                    }
                    return bInteger2.getInt() - bInteger.getInt();
                }
                throw new ClassCastException("Cannot compare " + object.getClass() + " and " + object2.getClass());
            }
        };
        NO_BN_IDX = BInteger.make((int)-1);
    }
}

