/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.services.error.NChangeListError;
import com.tridium.bacnet.stack.server.BBacnetExportFolder;
import java.util.ArrayList;
import java.util.Vector;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetCovSubscription;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetEventSource;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BIBacnetCovSource;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BOutOfServiceExt;
import javax.baja.bacnet.export.Cov;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BBacnetPointDescriptor
extends BBacnetEventSource
implements BIBacnetCovSource {
    public static final Property pointOrd = BBacnetPointDescriptor.newProperty((int)64, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"targetType", (String)"baja:Component"));
    public static final Property objectId = BBacnetPointDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    public static final Property objectName = BBacnetPointDescriptor.newProperty((int)64, (String)"", null);
    public static final Property reliability = BBacnetPointDescriptor.newProperty((int)3, (BValue)BBacnetReliability.noFaultDetected, null);
    public static final Property outOfService = BBacnetPointDescriptor.newProperty((int)5, (boolean)false, null);
    public static final Property description = BBacnetPointDescriptor.newProperty((int)0, (String)"", null);
    public static final Property notifyType = BBacnetPointDescriptor.newProperty((int)0, (BValue)BBacnetNotifyType.alarm, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"bacnet:BacnetNotifyTypeFE")));
    public static final Action addCovSubscription = BBacnetPointDescriptor.newAction((int)4, (BValue)new BBacnetCovSubscription(), null);
    public static final Action removeCovSubscription = BBacnetPointDescriptor.newAction((int)4, (BValue)new BBacnetCovSubscription(), null);
    public static final Action makeWritable = BBacnetPointDescriptor.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Action sendCovNotification = BBacnetPointDescriptor.newAction((int)4, (BValue)new BBacnetCovSubscription(), null);
    public static final Action checkCov = BBacnetPointDescriptor.newAction((int)20, null);
    public static final Type TYPE;
    static final AsnInputStream asnIn;
    static final AsnOutputStream asnOut;
    static Log log;
    static Lexicon lex;
    static String lexNotWritable;
    private BControlPoint point;
    private int[] requiredProps;
    private int[] optionalProps;
    private int oldNotifyType;
    private BBacnetObjectIdentifier oldId;
    private String oldName;
    private boolean duplicate;
    private boolean configOk;
    protected BOutOfServiceExt oosExt;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetPointDescriptor;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetCovSubscription;
    static /* synthetic */ Class class$javax$baja$alarm$ext$BAlarmSourceExt;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BOutOfServiceExt;

    public BOrd getPointOrd() {
        return (BOrd)this.get(pointOrd);
    }

    public void setPointOrd(BOrd bOrd) {
        this.set(pointOrd, (BValue)bOrd, null);
    }

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public String getObjectName() {
        return this.getString(objectName);
    }

    public void setObjectName(String string) {
        this.setString(objectName, string, null);
    }

    public BEnum getReliability() {
        return (BEnum)this.get(reliability);
    }

    public void setReliability(BEnum bEnum) {
        this.set(reliability, (BValue)bEnum, null);
    }

    public boolean getOutOfService() {
        return this.getBoolean(outOfService);
    }

    public void setOutOfService(boolean bl) {
        this.setBoolean(outOfService, bl, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String string) {
        this.setString(description, string, null);
    }

    public BBacnetNotifyType getNotifyType() {
        return (BBacnetNotifyType)this.get(notifyType);
    }

    public void setNotifyType(BBacnetNotifyType bBacnetNotifyType) {
        this.set(notifyType, (BValue)bBacnetNotifyType, null);
    }

    public void addCovSubscription(BBacnetCovSubscription bBacnetCovSubscription) {
        this.invoke(addCovSubscription, (BValue)bBacnetCovSubscription, null);
    }

    public void removeCovSubscription(BBacnetCovSubscription bBacnetCovSubscription) {
        this.invoke(removeCovSubscription, (BValue)bBacnetCovSubscription, null);
    }

    public void makeWritable(BValue bValue) {
        this.invoke(makeWritable, bValue, null);
    }

    public void sendCovNotification(BBacnetCovSubscription bBacnetCovSubscription) {
        this.invoke(sendCovNotification, (BValue)bBacnetCovSubscription, null);
    }

    public void checkCov() {
        this.invoke(checkCov, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.oldId = this.getObjectId();
        this.oldName = this.getObjectName();
        this.checkConfiguration();
        if (Sys.isStationStarted() && this.configOk()) {
            BBacnetNetwork.localDevice().incrementDatabaseRevision();
        }
    }

    public final void stopped() throws Exception {
        super.stopped();
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        bLocalBacnetDevice.unexport(this.oldId, this.oldName, this);
        bLocalBacnetDevice.unsubscribe(this, this.point);
        this.requiredProps = null;
        this.optionalProps = null;
        this.point = null;
        this.oldId = null;
        this.oldName = null;
        if (this.getStatus().isOk() && bLocalBacnetDevice.isRunning()) {
            bLocalBacnetDevice.incrementDatabaseRevision();
        }
    }

    public final void added(Property property, Context context) {
        super.added(property, context);
        if (!this.isRunning()) {
            return;
        }
    }

    public void changed(Property property, Context context) {
        BBacnetExportFolder bBacnetExportFolder;
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)objectId)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldId = this.getObjectId();
            try {
                ((BComponent)this.getParent()).rename(this.getPropertyInParent(), this.getObjectId().toString(BacnetConst.nameContext));
            }
            catch (DuplicateSlotException duplicateSlotException) {}
            if (this.configOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)objectName)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldName = this.getObjectName();
            if (this.configOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)pointOrd)) {
            this.checkConfiguration();
            if (this.configOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)notifyType)) {
            if (this.getNotifyType() == BBacnetNotifyType.ackNotification) {
                log.message("Invalid Notify Type for " + this);
                this.setNotifyType(BBacnetNotifyType.make(this.oldNotifyType));
            } else {
                this.oldNotifyType = this.getNotifyType().getOrdinal();
            }
        } else if (property.equals((Object)description) && (bBacnetExportFolder = this.getSvo()) != null) {
            bBacnetExportFolder.fireSubordinateAnnotationChanged(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void clockChanged(BRelTime var1_1) throws Exception {
        var2_2 = this.getProperties();
        if (true) ** GOTO lbl6
        do {
            var3_3 = (BBacnetCovSubscription)var2_2.get();
            var3_3.setSubscriptionEndTime(var3_3.getSubscriptionEndTime().add(var1_1));
lbl6:
            // 2 sources

            if ((v0 = BBacnetPointDescriptor.class$javax$baja$bacnet$datatypes$BBacnetCovSubscription) != null) continue;
            v0 = BBacnetPointDescriptor.class("[Ljavax.baja.bacnet.datatypes.BBacnetCovSubscription;", false);
        } while (var2_2.next(v0));
    }

    public final void doAddCovSubscription(BBacnetCovSubscription bBacnetCovSubscription) {
        if (log.isTraceOn()) {
            log.trace("Adding Cov subscription: " + bBacnetCovSubscription + " on " + this);
        }
        Property property = this.add("covSubscription?", (BValue)bBacnetCovSubscription, 3);
        BBacnetNetwork.localDevice().subscribeCov(this, (BComponent)this.getPoint(), property);
    }

    public final void doRemoveCovSubscription(BBacnetCovSubscription bBacnetCovSubscription) {
        Object[] objectArray;
        Class clazz;
        Clock.Ticket ticket;
        if (log.isTraceOn()) {
            log.trace("Removing Cov subscription: " + bBacnetCovSubscription + " on " + this);
        }
        if ((ticket = bBacnetCovSubscription.getTicket()) != null) {
            ticket.cancel();
        }
        bBacnetCovSubscription.setTicket(null);
        Property property = this.getProperty(bBacnetCovSubscription.getName());
        if (property != null) {
            this.remove(property);
        }
        if ((clazz = class$javax$baja$bacnet$datatypes$BBacnetCovSubscription) == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetCovSubscription = BBacnetPointDescriptor.class("[Ljavax.baja.bacnet.datatypes.BBacnetCovSubscription;", false);
        }
        if ((objectArray = this.getChildren(clazz)).length <= 0) {
            if (log.isTraceOn()) {
                log.trace("Removing unsub" + bBacnetCovSubscription + " on " + this);
            }
            BBacnetNetwork.localDevice().unsubscribeCov(this, (BComponent)this.getPoint(), property);
        }
    }

    public void doMakeWritable(BValue bValue) {
    }

    public void doSendCovNotification(BBacnetCovSubscription bBacnetCovSubscription) {
        BControlPoint bControlPoint = this.getPoint();
        if (bBacnetCovSubscription.getTimeRemaining() < 0) {
            this.removeCovSubscription(bBacnetCovSubscription);
            return;
        }
        if (log.isTraceOn()) {
            log.trace("Sending Cov Notification on " + this + ": pt=" + bControlPoint + "\n  covSub=" + bBacnetCovSubscription);
        }
        Cov cov = new Cov(bBacnetCovSubscription, this, bControlPoint);
        BBacnetNetwork.bacnet().getCovWorker().sendCov(cov);
        if (bBacnetCovSubscription.isCovProperty()) {
            bBacnetCovSubscription.setLastPropValue(this.getCurrentCovValue(bBacnetCovSubscription));
            bBacnetCovSubscription.setLastStatusBits(this.getStatusFlags().getBits() & 0x2B);
        } else {
            bBacnetCovSubscription.setLastValue(this.getCurrentStatusValue());
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void doCheckCov() {
        var1_1 = this.getProperties();
        if (true) ** GOTO lbl30
        do {
            if ((var2_2 = (BBacnetCovSubscription)var1_1.get()).isCovProperty()) {
                try {
                    var3_3 = this.readProperty(var2_2.getMonitoredPropertyReference().getPropertyId(), var2_2.getMonitoredPropertyReference().getPropertyArrayIndex());
                    var4_5 = BBacnetNetwork.localDevice().getPropertyInfo(this.getObjectId().getObjectType(), var2_2.getMonitoredPropertyReference().getPropertyId());
                    var5_6 = AsnUtil.asnToValue(var4_5, var3_3.getPropertyValue());
                    var6_7 = this.getStatusFlags().getBits() & 43;
                    if (var6_7 != var2_2.getLastStatusBits()) {
                        this.sendCovNotification(var2_2);
                        return;
                    }
                    if (var4_5.getAsnType() == 4) {
                        var7_8 = Math.abs(((BINumeric)var5_6).getNumeric() - ((BINumeric)var2_2.getLastPropValue()).getNumeric());
                        var9_9 = var2_2.getCovIncrement();
                        if (Double.isNaN(var9_9)) {
                            var9_9 = var2_2.getMonitoredPropertyReference().getPropertyId() == 85 ? ((var11_10 = (BNumber)this.get("covIncrement")) != null ? var11_10.getDouble() : 0.0) : 0.0;
                        }
                        if (var7_8 >= var9_9) {
                            this.sendCovNotification(var2_2);
                        }
                    } else if (!var5_6.equals((Object)var2_2.getLastPropValue())) {
                        this.sendCovNotification(var2_2);
                    }
                }
                catch (AsnException var3_4) {
                    var3_4.printStackTrace();
                }
            } else if (this.checkCov(this.getCurrentStatusValue(), var2_2.getLastValue())) {
                this.sendCovNotification(var2_2);
            }
            if ((v0 = BBacnetPointDescriptor.class$javax$baja$bacnet$datatypes$BBacnetCovSubscription) != null) continue;
            v0 = BBacnetPointDescriptor.class("[Ljavax.baja.bacnet.datatypes.BBacnetCovSubscription;", false);
        } while (var1_1.next(v0));
    }

    public final BObject getObject() {
        return this.getPoint();
    }

    public final BOrd getObjectOrd() {
        return this.getPointOrd();
    }

    public final void setObjectOrd(BOrd bOrd, Context context) {
        this.set(pointOrd, (BValue)bOrd, context);
    }

    /*
     * Exception decompiling
     */
    public synchronized void checkConfiguration() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [1 : 77->203)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final boolean isEventInitiationEnabled() {
        boolean bl = false;
        if (this.getNotificationClass() != null) {
            bl = true;
        }
        return bl;
    }

    public final BEnum getEventState() {
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt == null) {
            return null;
        }
        return BBacnetEventState.make(bAlarmSourceExt.getAlarmState());
    }

    public final BBacnetBitString getAckedTransitions() {
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt == null) {
            return null;
        }
        return BacnetBitStringUtil.getBacnetEventTransitionBits(bAlarmSourceExt.getAckedTransitions());
    }

    public final BBacnetTimeStamp[] getEventTimeStamps() {
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt == null) {
            return null;
        }
        BBacnetTimeStamp[] bBacnetTimeStampArray = new BBacnetTimeStamp[3];
        BAbsTime bAbsTime = bAlarmSourceExt.getLastOffnormalTime();
        bBacnetTimeStampArray[0] = BAbsTime.DEFAULT.equals((Object)bAbsTime) ? new BBacnetTimeStamp(new BBacnetDateTime()) : new BBacnetTimeStamp(bAbsTime);
        bAbsTime = bAlarmSourceExt.getLastFaultTime();
        bBacnetTimeStampArray[1] = BAbsTime.DEFAULT.equals((Object)bAbsTime) ? new BBacnetTimeStamp(new BBacnetDateTime()) : new BBacnetTimeStamp(bAbsTime);
        bAbsTime = bAlarmSourceExt.getLastToNormalTime();
        bBacnetTimeStampArray[2] = BAbsTime.DEFAULT.equals((Object)bAbsTime) ? new BBacnetTimeStamp(new BBacnetDateTime()) : new BBacnetTimeStamp(bAbsTime);
        return bBacnetTimeStampArray;
    }

    public final BBacnetBitString getEventEnable() {
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt == null) {
            return null;
        }
        return BacnetBitStringUtil.getBacnetEventTransitionBits(bAlarmSourceExt.getAlarmEnable());
    }

    public final int[] getEventPriorities() {
        BBacnetNotificationClassDescriptor bBacnetNotificationClassDescriptor = this.getNotificationClass();
        if (bBacnetNotificationClassDescriptor == null) {
            return null;
        }
        return bBacnetNotificationClassDescriptor.getEventPriorities();
    }

    public final BBacnetNotificationClassDescriptor getNotificationClass() {
        BBacnetNotificationClassDescriptor bBacnetNotificationClassDescriptor = null;
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt == null) {
            return null;
        }
        try {
            BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmClass bAlarmClass = bAlarmService.lookupAlarmClass(bAlarmSourceExt.getAlarmClass());
            BBacnetObjectIdentifier bBacnetObjectIdentifier = BBacnetNetwork.localDevice().lookupBacnetObjectId(bAlarmClass.getHandleOrd());
            if (bBacnetObjectIdentifier != null) {
                bBacnetNotificationClassDescriptor = (BBacnetNotificationClassDescriptor)BBacnetNetwork.localDevice().lookupBacnetObject(bBacnetObjectIdentifier);
                if (bBacnetNotificationClassDescriptor == null) {
                    log.warning("Can't find Notification Class Descriptor for ID " + (Object)((Object)bBacnetObjectIdentifier));
                }
            } else {
                log.message("Alarm Class '" + bAlarmClass + "' is used for BACnet-exposed object " + this + ", but is not exposed as a BACnet Notification Class!");
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.message("getNotificationClass on " + this + ": Unable to find alarm service!", (Throwable)serviceNotFoundException);
        }
        return bBacnetNotificationClassDescriptor;
    }

    public abstract BEnum getEventType();

    public BIBacnetExportObject getExport() {
        return this;
    }

    public final BBacnetCovSubscription findCovSubscription(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        return this.findSubscription(false, bBacnetAddress, l, bBacnetObjectIdentifier, 85, -1);
    }

    public final BBacnetCovSubscription findCovPropertySubscription(BBacnetAddress bBacnetAddress, long l, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2) {
        return this.findSubscription(true, bBacnetAddress, l, bBacnetObjectIdentifier, n, -1);
    }

    public final void startCovTimer(BBacnetCovSubscription bBacnetCovSubscription, long l) {
        Clock.Ticket ticket = bBacnetCovSubscription.getTicket();
        if (ticket != null) {
            ticket.cancel();
        }
        if (l > 0L) {
            BRelTime bRelTime = BRelTime.make((long)((long)((int)l) * 1000L));
            bBacnetCovSubscription.setSubscriptionEndTime(BAbsTime.make().add(bRelTime));
            bBacnetCovSubscription.setTicket(Clock.schedule((BComponent)this, (BRelTime)bRelTime, (Action)removeCovSubscription, (BValue)bBacnetCovSubscription));
        }
        this.sendCovNotification(bBacnetCovSubscription);
    }

    public Property getOutProperty() {
        BControlPoint bControlPoint = this.getPoint();
        return bControlPoint != null ? bControlPoint.getOutProperty() : null;
    }

    public boolean supportsSubscribeCov() {
        return true;
    }

    public BValue getCurrentCovValue(BBacnetCovSubscription bBacnetCovSubscription) {
        PropertyValue propertyValue = this.readProperty(bBacnetCovSubscription.getMonitoredPropertyReference().getPropertyId(), bBacnetCovSubscription.getMonitoredPropertyReference().getPropertyArrayIndex());
        try {
            return AsnUtil.asnToValue(BBacnetNetwork.localDevice().getPropertyInfo(this.getObjectId().getObjectType(), bBacnetCovSubscription.getMonitoredPropertyReference().getPropertyId()), propertyValue.getPropertyValue());
        }
        catch (AsnException asnException) {
            asnException.printStackTrace();
            return null;
        }
    }

    abstract BStatusValue getCurrentStatusValue();

    boolean checkCov(BStatusValue bStatusValue, BStatusValue bStatusValue2) {
        return bStatusValue.equals((Object)bStatusValue2) ^ true;
    }

    public final PropertyValue readProperty(PropertyReference propertyReference) throws RejectException {
        this.getPoint();
        return this.readProperty(propertyReference.getPropertyId(), propertyReference.getPropertyArrayIndex());
    }

    public final PropertyValue[] readPropertyMultiple(PropertyReference[] propertyReferenceArray) throws RejectException {
        this.getPoint();
        PropertyValue[] propertyValueArray = new PropertyValue[]{};
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(propertyReferenceArray.length);
        int n = 0;
        while (n < propertyReferenceArray.length) {
            switch (propertyReferenceArray[n].getPropertyId()) {
                case 8: {
                    int[] nArray = this.getRequiredProps();
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    nArray = this.getOptionalProps();
                    n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                case 80: {
                    int[] nArray = this.getOptionalProps();
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                case 105: {
                    int[] nArray = this.getRequiredProps();
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                default: {
                    arrayList.add(this.readProperty(propertyReferenceArray[n].getPropertyId(), propertyReferenceArray[n].getPropertyArrayIndex()));
                }
            }
            ++n;
        }
        return arrayList.toArray(propertyValueArray);
    }

    public RangeData readRange(RangeReference rangeReference) throws RejectException {
        this.getPoint();
        int n = rangeReference.getPropertyId();
        int[] nArray = this.getRequiredProps();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) {
                return new ReadRangeAck(5, 22);
            }
            ++n2;
        }
        nArray = this.getOptionalProps();
        n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) {
                return new ReadRangeAck(5, 22);
            }
            ++n2;
        }
        return new ReadRangeAck(2, 32);
    }

    public final ErrorType writeProperty(PropertyValue propertyValue) throws BacnetException {
        this.getPoint();
        return this.writeProperty(propertyValue.getPropertyId(), propertyValue.getPropertyArrayIndex(), propertyValue.getPropertyValue(), propertyValue.getPriority());
    }

    public ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        this.getPoint();
        int[] nArray = this.getRequiredProps();
        int n = propertyValue.getPropertyId();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return new NChangeListError(8, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        nArray = this.getOptionalProps();
        n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return new NChangeListError(8, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        return new NChangeListError(8, new NErrorType(2, 32), 0L);
    }

    public ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        this.getPoint();
        int[] nArray = this.getRequiredProps();
        int n = propertyValue.getPropertyId();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return new NChangeListError(9, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        nArray = this.getOptionalProps();
        n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return new NChangeListError(9, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        return new NChangeListError(9, new NErrorType(2, 32), 0L);
    }

    boolean isArray(int n) {
        if (n == 130) {
            return true;
        }
        if (n == 87) {
            return true;
        }
        return n == 110;
    }

    protected PropertyValue readProperty(int n, int n2) {
        if (this.point == null) {
            return new NReadPropertyResult(n, n2, new NErrorType(1, 1000));
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NReadPropertyResult(n, n2, new NErrorType(2, 50));
        }
        switch (n) {
            case 75: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnObjectId(this.getObjectId()));
            }
            case 77: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getObjectName()));
            }
            case 79: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(this.getObjectId().getObjectType()));
            }
            case 28: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getDescription()));
            }
            case 111: {
                return new NReadPropertyResult(n, n2, AsnUtil.statusToAsnStatusFlags(this.getStatusFlags()));
            }
            case 36: {
                BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
                if (bAlarmSourceExt == null) {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(0));
                }
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(BBacnetEventState.fromBAlarmState(bAlarmSourceExt.getAlarmState())));
            }
            case 103: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(this.getReliability()));
            }
            case 81: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnBoolean(this.getOosExt().getOutOfService()));
            }
        }
        return this.readOptionalProperty(n, n2);
    }

    protected PropertyValue readOptionalProperty(int n, int n2) {
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt != null) {
            switch (n) {
                case 17: {
                    BBacnetNotificationClassDescriptor bBacnetNotificationClassDescriptor = this.getNotificationClass();
                    if (bBacnetNotificationClassDescriptor == null) {
                        return new NReadPropertyResult(n, n2, new NErrorType(2, 32));
                    }
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bBacnetNotificationClassDescriptor.getNotificationClass()));
                }
                case 35: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(bAlarmSourceExt.getAlarmEnable())));
                }
                case 0: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(bAlarmSourceExt.getAckedTransitions())));
                }
                case 72: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated((BEnum)this.getNotifyType()));
                }
                case 130: {
                    return this.readEventTimeStamps(bAlarmSourceExt, n2);
                }
                case 113: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bAlarmSourceExt.getTimeDelay().getMillis() / 1000L));
                }
            }
        }
        return new NReadPropertyResult(n, n2, new NErrorType(2, 32));
    }

    protected ErrorType writeProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        if (this.point == null) {
            return new NErrorType(1, 1000);
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (n) {
                case 75: {
                    return new NErrorType(2, 40);
                }
                case 77: {
                    return BacUtil.setObjectName(this, objectName, byArray);
                }
                case 79: {
                    return new NErrorType(2, 40);
                }
                case 103: {
                    if (this.getOosExt().getOutOfService()) {
                        this.set(reliability, (BValue)AsnUtil.fromAsnEnumerated(this.getReliability(), byArray), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    return new NErrorType(2, 40);
                }
                case 28: {
                    this.setString(description, AsnUtil.fromAsnCharacterString(byArray), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 111: {
                    return new NErrorType(2, 40);
                }
                case 36: {
                    return new NErrorType(2, 40);
                }
                case 81: {
                    this.getOosExt().setBoolean(BOutOfServiceExt.outOfService, AsnUtil.fromAsnBoolean(byArray), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
            return this.writeOptionalProperty(n, n2, byArray, n3);
        }
        catch (AsnException asnException) {
            asnException.printStackTrace();
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)asnException));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
    }

    protected ErrorType writeOptionalProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        try {
            BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
            if (bAlarmSourceExt != null) {
                switch (n) {
                    case 17: {
                        int n4 = AsnUtil.fromAsnUnsignedInt(byArray);
                        if (n4 > 0x3FFFFE) {
                            return new NErrorType(2, 37);
                        }
                        BBacnetObjectIdentifier bBacnetObjectIdentifier = BBacnetObjectIdentifier.make(15, n4);
                        BBacnetNotificationClassDescriptor bBacnetNotificationClassDescriptor = (BBacnetNotificationClassDescriptor)BBacnetNetwork.localDevice().lookupBacnetObject(bBacnetObjectIdentifier);
                        if (bBacnetNotificationClassDescriptor == null) {
                            return new NErrorType(2, 37);
                        }
                        BAlarmClass bAlarmClass = bBacnetNotificationClassDescriptor.getAlarmClass();
                        bAlarmSourceExt.setString(BAlarmSourceExt.alarmClass, bAlarmClass.getName(), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 35: {
                        return new NErrorType(2, 40);
                    }
                    case 0: {
                        return new NErrorType(2, 40);
                    }
                    case 72: {
                        this.set(notifyType, (BValue)BBacnetNotifyType.make(AsnUtil.fromAsnEnumerated(byArray)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 130: {
                        return new NErrorType(2, 40);
                    }
                    case 113: {
                        bAlarmSourceExt.set(BAlarmSourceExt.timeDelay, (BValue)BRelTime.make((long)(AsnUtil.fromAsnUnsignedInteger(byArray) * 1000L)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                }
            }
        }
        catch (AsnException asnException) {
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)asnException));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new NErrorType(2, 37);
        }
        return new NErrorType(2, 32);
    }

    int[] getRequiredProps() {
        if (this.requiredProps == null) {
            Vector<BBacnetPropertyIdentifier> vector = new Vector<BBacnetPropertyIdentifier>();
            vector.add(BBacnetPropertyIdentifier.objectIdentifier);
            vector.add(BBacnetPropertyIdentifier.objectName);
            vector.add(BBacnetPropertyIdentifier.objectType);
            this.addRequiredProps(vector);
            this.requiredProps = new int[vector.size()];
            int n = 0;
            while (n < this.requiredProps.length) {
                this.requiredProps[n] = ((BEnum)vector.elementAt(n)).getOrdinal();
                ++n;
            }
        }
        return this.requiredProps;
    }

    int[] getOptionalProps() {
        Vector<BBacnetPropertyIdentifier> vector = new Vector<BBacnetPropertyIdentifier>();
        vector.add(BBacnetPropertyIdentifier.reliability);
        vector.add(BBacnetPropertyIdentifier.description);
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt != null) {
            vector.add(BBacnetPropertyIdentifier.timeDelay);
            vector.add(BBacnetPropertyIdentifier.notificationClass);
            vector.add(BBacnetPropertyIdentifier.eventEnable);
            vector.add(BBacnetPropertyIdentifier.ackedTransitions);
            vector.add(BBacnetPropertyIdentifier.notifyType);
            vector.add(BBacnetPropertyIdentifier.eventTimeStamps);
        }
        this.addOptionalProps(vector);
        this.optionalProps = new int[vector.size()];
        int n = 0;
        while (n < this.optionalProps.length) {
            this.optionalProps[n] = ((BEnum)vector.elementAt(n)).getOrdinal();
            ++n;
        }
        return this.optionalProps;
    }

    protected void addRequiredProps(Vector vector) {
    }

    protected void addOptionalProps(Vector vector) {
    }

    protected boolean isPointTypeLegal(BControlPoint bControlPoint) {
        return bControlPoint instanceof BControlPoint;
    }

    BStatus getStatusFlags() {
        int n;
        this.getPoint();
        BStatus bStatus = this.point.getStatus();
        int n2 = n = this.point == null ? 2 : bStatus.getBits();
        if (bStatus.isDown()) {
            n |= 2;
        }
        n = this.getOosExt().getOutOfService() ? (n |= 1) : (n &= 0xFFFFFFFE);
        if (this.getReliability() != BBacnetReliability.noFaultDetected) {
            n |= 2;
        }
        return BStatus.make((int)n);
    }

    protected boolean checkPointConfiguration() {
        return true;
    }

    void checkValid() {
        if (this.configOk()) {
            this.validate();
        }
    }

    protected void validate() {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
    }

    synchronized boolean configOk() {
        return this.configOk;
    }

    public String toString(Context context) {
        return this.getObjectName() + " [" + (Object)((Object)this.getObjectId()) + ']';
    }

    public final BControlPoint getPoint() {
        if (this.point == null) {
            return this.findPoint();
        }
        return this.point;
    }

    /*
     * Unable to fully structure code
     */
    BAlarmSourceExt getAlarmExt() {
        var1_1 = this.getPoint();
        if (var1_1 == null) {
            return null;
        }
        var2_2 = var1_1.getProperties();
        if (true) ** GOTO lbl9
        do {
            if (this.isValidAlarmExt((BIAlarmSource)(var3_3 = (BAlarmSourceExt)var2_2.get()))) {
                return var3_3;
            }
lbl9:
            // 3 sources

            if ((v0 = BBacnetPointDescriptor.class$javax$baja$alarm$ext$BAlarmSourceExt) != null) continue;
            v0 = BBacnetPointDescriptor.class("[Ljavax.baja.alarm.ext.BAlarmSourceExt;", false);
        } while (var2_2.next(v0));
        return null;
    }

    public BOutOfServiceExt getOosExt() {
        BOutOfServiceExt[] bOutOfServiceExtArray;
        BControlPoint bControlPoint = this.getPoint();
        Class clazz = class$javax$baja$bacnet$export$BOutOfServiceExt;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BOutOfServiceExt = BBacnetPointDescriptor.class("[Ljavax.baja.bacnet.export.BOutOfServiceExt;", false);
        }
        if ((bOutOfServiceExtArray = (BOutOfServiceExt[])bControlPoint.getChildren(clazz)) == null || bOutOfServiceExtArray.length == 0) {
            this.oosExt = new BOutOfServiceExt();
            this.getPoint().add("outOfServiceExt?", (BValue)this.oosExt);
        } else {
            this.oosExt = bOutOfServiceExtArray[0];
        }
        this.oosExt.setExport(this);
        this.oosExt.setCommandable(this.isCommandable());
        return this.oosExt;
    }

    protected boolean isCommandable() {
        return false;
    }

    public String getBacnetWritable() {
        return lexNotWritable;
    }

    private final BControlPoint findPoint() {
        try {
            if (!pointOrd.isEquivalentToDefaultValue((BValue)this.getPointOrd())) {
                BObject bObject = this.getPointOrd().get((BObject)this);
                this.point = bObject instanceof BControlPoint ? (BControlPoint)bObject : null;
            }
            if (!this.isPointTypeLegal(this.point)) {
                this.point = null;
            }
        }
        catch (Exception exception) {
            log.warning("Unable to resolve point ord for " + this + ": " + this.getPointOrd());
            this.point = null;
        }
        if (this.point == null && this.isRunning()) {
            this.setReliability((BEnum)BBacnetReliability.unreliableOther);
            this.setFaultCause("Cannot find exported point");
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        }
        return this.point;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PropertyValue readEventTimeStamps(BAlarmSourceExt bAlarmSourceExt, int n) {
        AsnOutputStream asnOutputStream = asnOut;
        synchronized (asnOutputStream) {
            asnOut.reset();
            switch (n) {
                case 0: {
                    asnOut.writeUnsignedInteger(3);
                    break;
                }
                case 1: {
                    BBacnetTimeStamp.encodeTimeStamp(bAlarmSourceExt.getLastOffnormalTime(), asnOut);
                    break;
                }
                case 2: {
                    BBacnetTimeStamp.encodeTimeStamp(bAlarmSourceExt.getLastFaultTime(), asnOut);
                    break;
                }
                case 3: {
                    BBacnetTimeStamp.encodeTimeStamp(bAlarmSourceExt.getLastToNormalTime(), asnOut);
                    break;
                }
                case -1: {
                    BBacnetTimeStamp.encodeTimeStamp(bAlarmSourceExt.getLastOffnormalTime(), asnOut);
                    BBacnetTimeStamp.encodeTimeStamp(bAlarmSourceExt.getLastFaultTime(), asnOut);
                    BBacnetTimeStamp.encodeTimeStamp(bAlarmSourceExt.getLastToNormalTime(), asnOut);
                    break;
                }
                default: {
                    return new NReadPropertyResult(130, n, new NErrorType(2, 42));
                }
            }
            return new NReadPropertyResult(130, n, asnOut.toByteArray());
        }
    }

    /*
     * Unable to fully structure code
     */
    private final BBacnetCovSubscription findSubscription(boolean var1_1, BBacnetAddress var2_2, long var3_3, BBacnetObjectIdentifier var5_4, int var6_5, int var7_6) {
        var8_7 = this.getProperties();
        if (true) ** GOTO lbl6
        do {
            if ((var9_8 = (BBacnetCovSubscription)var8_7.get()).isCovProperty() == var1_1 && var9_8.getRecipient().getRecipient().getAddress().equals(var2_2.getNetworkNumber(), var2_2.getMacAddress().getBytes()) && var9_8.getRecipient().getProcessIdentifier().getUnsigned() == var3_3 && this.getObjectId().equals((Object)var5_4) && var9_8.getMonitoredPropertyReference().getPropertyId() == var6_5 && var9_8.getMonitoredPropertyReference().getPropertyArrayIndex() == var7_6) {
                return var9_8;
            }
lbl6:
            // 3 sources

            if ((v0 = BBacnetPointDescriptor.class$javax$baja$bacnet$datatypes$BBacnetCovSubscription) != null) continue;
            v0 = BBacnetPointDescriptor.class("[Ljavax.baja.bacnet.datatypes.BBacnetCovSubscription;", false);
        } while (var8_7.next(v0));
        return null;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetPointDescriptor", 2);
        spyWriter.prop((Object)"point", (Object)this.point);
        spyWriter.prop((Object)"oldId", (Object)this.oldId);
        spyWriter.prop((Object)"oldName", (Object)this.oldName);
        spyWriter.prop((Object)"duplicate", this.duplicate);
        spyWriter.prop((Object)"oldNotifyType", this.oldNotifyType);
        spyWriter.prop((Object)"almExt", (Object)this.getAlarmExt());
        spyWriter.prop((Object)"notificationClass", (Object)this.getNotificationClass());
        spyWriter.prop((Object)"configOk", this.configOk());
        spyWriter.prop((Object)"oosExt", (Object)this.oosExt);
        spyWriter.endProps();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.oldId = null;
        this.oldName = null;
        this.duplicate = false;
        this.oosExt = null;
    }

    public BBacnetPointDescriptor() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$bacnet$export$BBacnetPointDescriptor;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BBacnetPointDescriptor = BBacnetPointDescriptor.class("[Ljavax.baja.bacnet.export.BBacnetPointDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        asnIn = new AsnInputStream();
        asnOut = new AsnOutputStream();
        log = Log.getLog((String)"bacnet.server");
        lex = Lexicon.make((String)"bacnet");
        lexNotWritable = lex.getText("server.notWritable");
    }
}

