/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.datatypes.BEventSaver;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.services.error.NChangeListError;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import java.util.ArrayList;
import java.util.Vector;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmPriorities;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetAlarmConst;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDestination;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetNotificationClassDescriptor
extends BComponent
implements BIBacnetExportObject,
BacnetAlarmConst {
    public static final Property status = BBacnetNotificationClassDescriptor.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property faultCause = BBacnetNotificationClassDescriptor.newProperty((int)3, (String)"", null);
    public static final Property alarmClassOrd = BBacnetNotificationClassDescriptor.newProperty((int)64, (BValue)BOrd.NULL, null);
    public static final Property objectId = BBacnetNotificationClassDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(15), null);
    public static final Property objectName = BBacnetNotificationClassDescriptor.newProperty((int)64, (String)"", null);
    public static final Property description = BBacnetNotificationClassDescriptor.newProperty((int)0, (String)"", null);
    public static final Property eventSaver = BBacnetNotificationClassDescriptor.newProperty((int)0, (BValue)new BEventSaver(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static AsnInputStream asnIn;
    private static AsnOutputStream asnOut;
    static Log log;
    private static final int[] REQUIRED_PROPS;
    private static final int[] OPTIONAL_PROPS;
    private boolean fatalFault;
    private BAlarmClass ac;
    private boolean recipientListChanged;
    private BBacnetDestination[] recipientList;
    private BBacnetObjectIdentifier oldId;
    private String oldName;
    private boolean duplicate;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetNotificationClassDescriptor;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetDestination;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BOrd getAlarmClassOrd() {
        return (BOrd)this.get(alarmClassOrd);
    }

    public void setAlarmClassOrd(BOrd bOrd) {
        this.set(alarmClassOrd, (BValue)bOrd, null);
    }

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public String getObjectName() {
        return this.getString(objectName);
    }

    public void setObjectName(String string) {
        this.setString(objectName, string, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String string) {
        this.setString(description, string, null);
    }

    public BAlarmRecipient getEventSaver() {
        return (BAlarmRecipient)this.get(eventSaver);
    }

    public void setEventSaver(BAlarmRecipient bAlarmRecipient) {
        this.set(eventSaver, (BValue)bAlarmRecipient, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        super.started();
        this.checkFatalFault();
        this.oldId = this.getObjectId();
        this.oldName = this.getObjectName();
        this.checkConfiguration();
        if (Sys.isStationStarted() && this.getStatus().isOk()) {
            BBacnetNetwork.localDevice().incrementDatabaseRevision();
        }
    }

    public final void stopped() throws Exception {
        super.stopped();
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        bLocalBacnetDevice.unexport(this.oldId, this.oldName, this);
        this.oldId = null;
        this.oldName = null;
        if (this.getStatus().isOk() && bLocalBacnetDevice.isRunning()) {
            bLocalBacnetDevice.incrementDatabaseRevision();
        }
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)objectId)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldId = this.getObjectId();
            try {
                ((BComponent)this.getParent()).rename(this.getPropertyInParent(), this.getObjectId().toString(BacnetConst.nameContext));
            }
            catch (DuplicateSlotException duplicateSlotException) {}
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)objectName)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldName = this.getObjectName();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)alarmClassOrd)) {
            this.checkConfiguration();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
            super.changed(property, context);
        }
    }

    public final BFacets getSlotFacets(Slot slot) {
        if (slot == objectId) {
            return BBacnetObjectType.getObjectIdFacets(15);
        }
        return super.getSlotFacets(slot);
    }

    public final BObject getObject() {
        return this.getAlarmClass();
    }

    public final BOrd getObjectOrd() {
        return this.getAlarmClassOrd();
    }

    public final void setObjectOrd(BOrd bOrd, Context context) {
        this.set(alarmClassOrd, (BValue)bOrd, context);
    }

    public void checkConfiguration() {
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        if (this.isFatalFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        this.findAlarmClass();
        bLocalBacnetDevice.unsubscribe(this, this.ac);
        boolean bl = true;
        if (this.ac == null) {
            this.setFaultCause("Cannot find exported alarm class");
            bl = false;
        } else {
            bLocalBacnetDevice.subscribe(this, this.ac);
        }
        if (!this.getObjectId().isValid()) {
            this.setFaultCause("Invalid Object ID");
            bl = false;
        }
        BEventSaver bEventSaver = (BEventSaver)this.getEventSaver();
        BLink[] bLinkArray = this.getEventSaver().getLinks((Slot)BAlarmRecipient.routeAlarm);
        int n = 0;
        while (n < bLinkArray.length) {
            bEventSaver.remove((BComplex)bLinkArray[n]);
            ++n;
        }
        BLink bLink = new BLink(this.ac.getHandleOrd(), "alarm", "routeAlarm", true);
        bEventSaver.add("link", (BValue)bLink, 4);
        if (bl) {
            String string = bLocalBacnetDevice.export(this);
            if (string != null) {
                this.duplicate = true;
                this.setFaultCause(string);
                bl = false;
            } else {
                this.duplicate = false;
            }
        }
        if (bl) {
            this.setFaultCause("");
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)(bl ^ true)));
    }

    public final PropertyValue readProperty(PropertyReference propertyReference) throws RejectException {
        this.getAlarmClass();
        return this.readProperty(propertyReference.getPropertyId(), propertyReference.getPropertyArrayIndex());
    }

    public final PropertyValue[] readPropertyMultiple(PropertyReference[] propertyReferenceArray) throws RejectException {
        this.getAlarmClass();
        PropertyValue[] propertyValueArray = new PropertyValue[]{};
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(propertyReferenceArray.length);
        int n = 0;
        while (n < propertyReferenceArray.length) {
            switch (propertyReferenceArray[n].getPropertyId()) {
                case 8: {
                    int[] nArray = REQUIRED_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    nArray = OPTIONAL_PROPS;
                    n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                case 80: {
                    int[] nArray = OPTIONAL_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                case 105: {
                    int[] nArray = REQUIRED_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                default: {
                    arrayList.add(this.readProperty(propertyReferenceArray[n].getPropertyId(), propertyReferenceArray[n].getPropertyArrayIndex()));
                }
            }
            ++n;
        }
        return arrayList.toArray(propertyValueArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RangeData readRange(RangeReference var1_1) throws RejectException {
        block33: {
            this.getAlarmClass();
            if (this.ac == null) {
                return new ReadRangeAck(1, 1000);
            }
            switch (var1_1.getPropertyId()) {
                case 102: {
                    var2_2 = var1_1.getRangeType();
                    var3_3 = -1;
                    if (var1_1 instanceof BacnetConfirmedRequest) {
                        var3_3 = ((BacnetConfirmedRequest)var1_1).getMaxDataLength() - 23 + 3 + 5;
                    }
                    var4_4 = new boolean[3];
                    var5_5 = this.getRecipientList();
                    var6_6 = var5_5.length;
                    if (var2_2 != 3) ** GOTO lbl32
                    var7_7 = (int)var1_1.getReferenceIndex();
                    var8_9 = var1_1.getCount();
                    if (var7_7 > var6_6 || var7_7 < 1) {
                        return new ReadRangeAck(this.getObjectId(), var1_1.getPropertyId(), -1, BBacnetBitString.emptyBitString(3), 0L, new byte[0]);
                    }
                    v0 = BBacnetNotificationClassDescriptor.class$javax$baja$bacnet$datatypes$BBacnetDestination;
                    if (v0 == null) {
                        v0 = BBacnetNotificationClassDescriptor.class$javax$baja$bacnet$datatypes$BBacnetDestination = BBacnetNotificationClassDescriptor.class("[Ljavax.baja.bacnet.datatypes.BBacnetDestination;", false);
                    }
                    var9_11 = new Array(v0);
                    var10_12 = 0;
                    if (var8_9 <= 0) ** GOTO lbl27
                    var11_13 = var7_7 - 1;
                    if (true) ** GOTO lbl74
lbl27:
                    // 1 sources

                    if (var8_9 >= 0) {
                        return new ReadRangeAck(5, 7);
                    }
                    var8_9 = -var8_9;
                    var11_13 = var7_7 - 1;
                    if (true) ** GOTO lbl85
lbl32:
                    // 1 sources

                    if (var2_2 != -1) {
                        return new ReadRangeAck(5, 7);
                    }
                    var4_4[0] = true;
                    var7_8 = 0;
                    var8_10 = BBacnetNotificationClassDescriptor.asnOut;
                    synchronized (var8_10) {
                        BBacnetNotificationClassDescriptor.asnOut.reset();
                        if (var3_3 > 0) {
                            var11_15 = 0;
                        }
                        ** GOTO lbl55
                        while (var11_15 < var6_6) {
                            var5_5[var11_15].writeAsn(BBacnetNotificationClassDescriptor.asnOut);
                            ++var7_8;
                            if (var3_3 - BBacnetNotificationClassDescriptor.asnOut.size() < 35) break;
                            ++var11_15;
                        }
                        if (var7_8 == var6_6) {
                            var4_4[1] = true;
                        }
                        ** GOTO lbl64
lbl55:
                        // 1 sources

                        var7_8 = var6_6;
                        var11_16 = 0;
                        while (true) {
                            if (var11_16 >= var6_6) {
                                var4_4[1] = true;
                                break;
                            }
                            var5_5[var11_16].writeAsn(BBacnetNotificationClassDescriptor.asnOut);
                            ++var11_16;
                        }
lbl64:
                        // 2 sources

                        if (var7_8 < var6_6) {
                            var4_4[2] = true;
                        }
                        return new ReadRangeAck(this.getObjectId(), var1_1.getPropertyId(), -1, BBacnetBitString.make(var4_4), (long)var7_8, BBacnetNotificationClassDescriptor.asnOut.toByteArray());
                    }
                }
                default: {
                    return new ReadRangeAck(2, 22);
                }
            }
            do {
                var9_11.add((Object)var5_5[var11_13]);
                ++var10_12;
                ++var11_13;
lbl74:
                // 2 sources

            } while (var11_13 < var6_6 && var10_12 < var8_9);
            if (var7_7 == 1) {
                var4_4[0] = true;
            }
            if (var7_7 + var8_9 - 1 >= var6_6) {
                var4_4[1] = true;
            }
            break block33;
            do {
                var9_11.add((Object)var5_5[var11_13]);
                ++var10_12;
                --var11_13;
lbl85:
                // 2 sources

            } while (var11_13 >= 0 && var10_12 < var8_9);
            var9_11 = var9_11.reverse();
            if (var7_7 - var8_9 <= 0) {
                var4_4[0] = true;
            }
            if (var7_7 == var6_6) {
                var4_4[1] = true;
            }
        }
        var11_14 = var9_11.iterator();
        var12_17 = 0;
        var13_18 = BBacnetNotificationClassDescriptor.asnOut;
        synchronized (var13_18) {
            block32: {
                block31: {
                    BBacnetNotificationClassDescriptor.asnOut.reset();
                    if (var3_3 <= 0) break block31;
                    while (var11_14.hasNext()) {
                        if (var3_3 - BBacnetNotificationClassDescriptor.asnOut.size() < 35) {
                            var4_4[1] = false;
                            break block32;
                        }
                        ((BBacnetDestination)var11_14.next()).writeAsn(BBacnetNotificationClassDescriptor.asnOut);
                        ++var12_17;
                    }
                    break block32;
                }
                var12_17 = var10_12;
                while (var11_14.hasNext()) {
                    ((BBacnetDestination)var11_14.next()).writeAsn(BBacnetNotificationClassDescriptor.asnOut);
                }
            }
            if (var12_17 < var10_12) {
                var4_4[2] = true;
            }
            return new ReadRangeAck(this.getObjectId(), var1_1.getPropertyId(), -1, BBacnetBitString.make(var4_4), (long)var12_17, BBacnetNotificationClassDescriptor.asnOut.toByteArray());
        }
    }

    public final ErrorType writeProperty(PropertyValue propertyValue) throws BacnetException {
        this.getAlarmClass();
        return this.writeProperty(propertyValue.getPropertyId(), propertyValue.getPropertyArrayIndex(), propertyValue.getPropertyValue(), propertyValue.getPriority());
    }

    public final ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        BAlarmClass bAlarmClass = this.getAlarmClass();
        if (bAlarmClass == null) {
            return new NChangeListError(8, new NErrorType(1, 1000), 0L);
        }
        if (propertyValue.getPropertyId() == 102) {
            if (propertyValue.getPropertyArrayIndex() >= 0) {
                return new NChangeListError(8, new NErrorType(2, 50), 0L);
            }
            return this.addRecipients(propertyValue);
        }
        int n = propertyValue.getPropertyId();
        int n2 = 0;
        while (n2 < REQUIRED_PROPS.length) {
            if (n == REQUIRED_PROPS[n2]) {
                return new NChangeListError(8, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < OPTIONAL_PROPS.length) {
            if (n == OPTIONAL_PROPS[n2]) {
                return new NChangeListError(8, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        return new NChangeListError(8, new NErrorType(2, 32), 0L);
    }

    public final ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        BAlarmClass bAlarmClass = this.getAlarmClass();
        if (bAlarmClass == null) {
            return new NChangeListError(9, new NErrorType(1, 1000), 0L);
        }
        if (propertyValue.getPropertyId() == 102) {
            if (propertyValue.getPropertyArrayIndex() >= 0) {
                return new NChangeListError(9, new NErrorType(2, 50), 0L);
            }
            return this.removeRecipients(propertyValue);
        }
        int n = propertyValue.getPropertyId();
        int n2 = 0;
        while (n2 < REQUIRED_PROPS.length) {
            if (n == REQUIRED_PROPS[n2]) {
                return new NChangeListError(9, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < OPTIONAL_PROPS.length) {
            if (n == OPTIONAL_PROPS[n2]) {
                return new NChangeListError(9, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        return new NChangeListError(9, new NErrorType(2, 32), 0L);
    }

    boolean isArray(int n) {
        return n == 86;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PropertyValue readProperty(int n, int n2) {
        BAlarmClass bAlarmClass = this.getAlarmClass();
        if (bAlarmClass == null) {
            return new NReadPropertyResult(n, n2, new NErrorType(1, 1000));
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NReadPropertyResult(n, n2, new NErrorType(2, 50));
        }
        switch (n) {
            case 75: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnObjectId(this.getObjectId()));
            }
            case 79: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(this.getObjectId().getObjectType()));
            }
            case 77: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getObjectName()));
            }
            case 17: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(this.getObjectId().getInstanceNumber()));
            }
            case 86: {
                BAlarmPriorities bAlarmPriorities = bAlarmClass.getPriority();
                switch (n2) {
                    case 0: {
                        return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(3));
                    }
                    case 1: {
                        return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bAlarmPriorities.getToOffnormal()));
                    }
                    case 2: {
                        return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bAlarmPriorities.getToFault()));
                    }
                    case 3: {
                        return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bAlarmPriorities.getToNormal()));
                    }
                    case -1: {
                        AsnOutputStream asnOutputStream = asnOut;
                        synchronized (asnOutputStream) {
                            asnOut.reset();
                            asnOut.writeUnsignedInteger(bAlarmPriorities.getToOffnormal());
                            asnOut.writeUnsignedInteger(bAlarmPriorities.getToFault());
                            asnOut.writeUnsignedInteger(bAlarmPriorities.getToNormal());
                            return new NReadPropertyResult(n, n2, asnOut.toByteArray());
                        }
                    }
                }
                return new NReadPropertyResult(n, n2, new NErrorType(2, 42));
            }
            case 1: {
                BAlarmTransitionBits bAlarmTransitionBits = bAlarmClass.getAckRequired();
                AsnOutputStream asnOutputStream = asnOut;
                synchronized (asnOutputStream) {
                    asnOut.reset();
                    asnOut.writeBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(bAlarmTransitionBits));
                    return new NReadPropertyResult(n, n2, asnOut.toByteArray());
                }
            }
            case 102: {
                BBacnetDestination[] bBacnetDestinationArray = this.getRecipientList();
                AsnOutputStream asnOutputStream = asnOut;
                synchronized (asnOutputStream) {
                    asnOut.reset();
                    int n3 = 0;
                    while (true) {
                        if (n3 >= bBacnetDestinationArray.length) {
                            return new NReadPropertyResult(n, n2, asnOut.toByteArray());
                        }
                        bBacnetDestinationArray[n3].writeAsn(asnOut);
                        ++n3;
                    }
                }
            }
            case 28: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getDescription()));
            }
        }
        return new NReadPropertyResult(n, n2, new NErrorType(2, 32));
    }

    /*
     * Exception decompiling
     */
    protected ErrorType writeProperty(int var1_1, int var2_2, byte[] var3_3, int var4_4) throws BacnetException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [1 : 319->361)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString(Context context) {
        return this.getObjectName() + " [" + (Object)((Object)this.getObjectId()) + ']';
    }

    public int getNotificationClass() {
        return this.getObjectId().getInstanceNumber();
    }

    public int[] getEventPriorities() {
        BAlarmPriorities bAlarmPriorities = this.getAlarmClass().getPriority();
        return new int[]{bAlarmPriorities.getToOffnormal(), bAlarmPriorities.getToFault(), bAlarmPriorities.getToNormal()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BBacnetDestination[] getRecipientList() {
        BBacnetDestination[] bBacnetDestinationArray = this.recipientList;
        synchronized (this.recipientList) {
            if (this.recipientListChanged) {
                this.buildRecipientList();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.recipientList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recipientListChanged() {
        BBacnetDestination[] bBacnetDestinationArray = this.recipientList;
        synchronized (this.recipientList) {
            this.recipientListChanged = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public final BAlarmClass getAlarmClass() {
        if (this.ac == null) {
            return this.findAlarmClass();
        }
        return this.ac;
    }

    private final BAlarmClass findAlarmClass() {
        try {
            if (!alarmClassOrd.isEquivalentToDefaultValue((BValue)this.getAlarmClassOrd())) {
                BObject bObject = this.getAlarmClassOrd().get((BObject)this);
                this.ac = bObject instanceof BAlarmClass ? (BAlarmClass)bObject : null;
            }
            return this.ac;
        }
        catch (Exception exception) {
            log.warning("Unable to resolve alarm class ord for " + this + ": " + this.getAlarmClassOrd());
            this.ac = null;
            if (this.ac == null && this.isRunning()) {
                this.setFaultCause("Cannot find exported alarm class");
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            }
            return this.ac;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void buildRecipientList() {
        BBacnetDestination[] bBacnetDestinationArray = this.recipientList;
        synchronized (this.recipientList) {
            Class clazz = class$javax$baja$bacnet$datatypes$BBacnetDestination;
            if (clazz == null) {
                clazz = class$javax$baja$bacnet$datatypes$BBacnetDestination = BBacnetNotificationClassDescriptor.class("[Ljavax.baja.bacnet.datatypes.BBacnetDestination;", false);
            }
            Array array = new Array(clazz);
            Knob[] knobArray = this.getAlarmClass().getKnobs((Slot)BAlarmClass.alarm);
            int n = 0;
            while (true) {
                if (n >= knobArray.length) {
                    this.recipientList = (BBacnetDestination[])array.trim();
                    this.recipientListChanged = false;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                if (knobArray[n].getTargetComponent() instanceof BBacnetDestination) {
                    array.add((Object)((BBacnetDestination)knobArray[n].getTargetComponent()));
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ErrorType writeRecipientList(byte[] var1_1) {
        var2_2 = new Vector<BBacnetDestination>();
        try {
            var3_3 = BBacnetNotificationClassDescriptor.asnIn;
            synchronized (var3_3) {
                BBacnetNotificationClassDescriptor.asnIn.setBuffer(var1_1);
                var6_6 = BBacnetNotificationClassDescriptor.asnIn.peekTag();
                while (true) {
                    if (var6_6 == -1) {
                        break;
                    }
                    var7_8 = new BBacnetDestination();
                    var7_8.readAsn(BBacnetNotificationClassDescriptor.asnIn);
                    var2_2.add(var7_8);
                    var6_6 = BBacnetNotificationClassDescriptor.asnIn.peekTag();
                }
            }
        }
        catch (AsnException var3_4) {
            var3_4.printStackTrace();
            return new NErrorType(2, 9);
        }
        try {
            var3_3 = this.getAlarmClass();
            var4_10 = var3_3.getKnobs((Slot)BAlarmClass.alarm);
            var5_11 = var4_10.length;
            var6_7 = new boolean[var5_11];
            var7_9 = 0;
            while (true) {
                block22: {
                    if (var7_9 < var2_2.size()) break block22;
                    var7_9 = 0;
                    if (true) ** GOTO lbl82
                }
                var8_12 = false;
                var9_15 = (BLink[])var2_2.elementAt(var7_9);
                var10_16 = 0;
                while (var10_16 < var5_11) {
                    if (var4_10[var10_16].getTargetComponent() instanceof BBacnetDestination && var9_15.destinationEquals((BBacnetDestination)var4_10[var10_16].getTargetComponent())) {
                        var8_12 = true;
                        var6_7[var10_16] = true;
                        break;
                    }
                    ++var10_16;
                }
                if (!var8_12) {
                    var10_17 /* !! */  = null;
                    var11_19 = this.getAlarmClass().getParent().asComponent();
                    v1 = BBacnetNotificationClassDescriptor.class$javax$baja$bacnet$datatypes$BBacnetDestination;
                    if (v1 == null) {
                        v1 = BBacnetNotificationClassDescriptor.class("[Ljavax.baja.bacnet.datatypes.BBacnetDestination;", false);
                    }
                    var12_20 = (BBacnetDestination[])var11_19.getChildren(v1);
                    var13_22 = 0;
                    while (var13_22 < var12_20.length) {
                        if (var9_15.destinationEquals(var12_20[var13_22])) {
                            var10_17 /* !! */  = var12_20[var13_22];
                            break;
                        }
                        ++var13_22;
                    }
                    if (var10_17 /* !! */  == null) {
                        var11_19.add(null, (BValue)var9_15, BLocalBacnetDevice.getBacnetContext());
                        var10_17 /* !! */  = var9_15;
                    }
                    var13_21 = new BLink(this.getAlarmClass().getHandleOrd(), "alarm", "routeAlarm", true);
                    var10_17 /* !! */ .add(null, (BValue)var13_21, BLocalBacnetDevice.getBacnetContext());
                }
                ++var7_9;
            }
        }
        catch (PermissionException var3_5) {
            BBacnetNotificationClassDescriptor.log.message("PermissionException writing elements to recipientList in object " + (Object)this.getObjectId() + ':' + (Object)var3_5);
            return new NErrorType(2, 40);
        }
        do {
            if (!var6_7[var7_9] && (var8_14 = var4_10[var7_9].getTargetComponent()) instanceof BBacnetDestination) {
                var9_15 = var8_14.getLinks((Slot)BBacnetDestination.routeAlarm);
                var10_18 = 0;
                while (var10_18 < var9_15.length) {
                    if (var9_15[var10_18].getSourceComponent() == this.getAlarmClass()) {
                        var8_14.remove((BComplex)var9_15[var10_18]);
                        break;
                    }
                    ++var10_18;
                }
            }
            ++var7_9;
lbl82:
            // 2 sources

        } while (var7_9 < var5_11);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final NChangeListError addRecipients(PropertyValue propertyValue) {
        BBacnetDestination bBacnetDestination;
        int n;
        Knob[] knobArray;
        BAlarmClass bAlarmClass = this.getAlarmClass();
        Vector<BBacnetDestination> vector = new Vector<BBacnetDestination>();
        int n2 = 1;
        try {
            knobArray = asnIn;
            synchronized (asnIn) {
                asnIn.setBuffer(propertyValue.getPropertyValue());
                n = asnIn.peekTag();
                while (true) {
                    if (n == -1) {
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        break;
                    }
                    bBacnetDestination = new BBacnetDestination();
                    bBacnetDestination.readAsn(asnIn);
                    vector.add(bBacnetDestination);
                    ++n2;
                    n = asnIn.peekTag();
                }
            }
        }
        catch (AsnException asnException) {
            if (log.isTraceOn()) {
                asnException.printStackTrace();
            }
            return new NChangeListError(8, new NErrorType(2, 9), n2);
        }
        {
            try {
                knobArray = bAlarmClass.getKnobs((Slot)BAlarmClass.alarm);
                int n3 = knobArray.length;
                int n4 = 0;
                while (true) {
                    if (n4 >= vector.size()) {
                        return null;
                    }
                    n = 0;
                    bBacnetDestination = (BBacnetDestination)vector.elementAt(n4);
                    int n5 = 0;
                    while (n5 < n3) {
                        if (knobArray[n5].getTargetComponent() instanceof BBacnetDestination && bBacnetDestination.destinationEquals((BBacnetDestination)knobArray[n5].getTargetComponent())) {
                            n = 1;
                            break;
                        }
                        ++n5;
                    }
                    if (n == 0) {
                        BBacnetDestination bBacnetDestination2 = null;
                        BComponent bComponent = this.getAlarmClass().getParent().asComponent();
                        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetDestination;
                        if (clazz == null) {
                            clazz = BBacnetNotificationClassDescriptor.class("[Ljavax.baja.bacnet.datatypes.BBacnetDestination;", false);
                        }
                        BBacnetDestination[] bBacnetDestinationArray = (BBacnetDestination[])bComponent.getChildren(clazz);
                        int n6 = 0;
                        while (n6 < bBacnetDestinationArray.length) {
                            if (bBacnetDestination.destinationEquals(bBacnetDestinationArray[n6])) {
                                bBacnetDestination2 = bBacnetDestinationArray[n6];
                                break;
                            }
                            ++n6;
                        }
                        if (bBacnetDestination2 == null) {
                            bComponent.add(null, (BValue)bBacnetDestination, BLocalBacnetDevice.getBacnetContext());
                            bBacnetDestination2 = bBacnetDestination;
                        }
                        BLink bLink = new BLink(this.getAlarmClass().getHandleOrd(), "alarm", "routeAlarm", true);
                        bBacnetDestination2.add(null, (BValue)bLink, BLocalBacnetDevice.getBacnetContext());
                    }
                    ++n4;
                }
            }
            catch (PermissionException permissionException) {
                log.message("PermissionException adding elements to recipientList in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
                return new NChangeListError(8, new NErrorType(2, 40), 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final NChangeListError removeRecipients(PropertyValue var1_1) {
        var2_2 = this.getAlarmClass();
        var3_3 = new Vector<BBacnetDestination>();
        var4_4 = 1;
        try {
            var5_5 = BBacnetNotificationClassDescriptor.asnIn;
            synchronized (BBacnetNotificationClassDescriptor.asnIn) {
                BBacnetNotificationClassDescriptor.asnIn.setBuffer(var1_1.getPropertyValue());
                var8_7 = BBacnetNotificationClassDescriptor.asnIn.peekTag();
                while (true) {
                    if (var8_7 == -1) {
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        break;
                    }
                    var9_9 = new BBacnetDestination();
                    var9_9.readAsn(BBacnetNotificationClassDescriptor.asnIn);
                    var3_3.add(var9_9);
                    ++var4_4;
                    var8_7 = BBacnetNotificationClassDescriptor.asnIn.peekTag();
                }
            }
        }
        catch (AsnException var5_6) {
            if (BBacnetNotificationClassDescriptor.log.isTraceOn()) {
                var5_6.printStackTrace();
            }
            return new NChangeListError(9, new NErrorType(2, 9), var4_4);
        }
        {
            block20: {
                var5_5 = var2_2.getKnobs((Slot)BAlarmClass.alarm);
                var6_12 = var5_5.length;
                var4_4 = 1;
                while (var4_4 <= var3_3.size()) {
                    var7_13 = (BBacnetDestination)var3_3.get(var4_4 - 1);
                    var8_7 = 0;
                    var9_10 = 0;
                    while (var9_10 < var6_12) {
                        if (var5_5[var9_10].getTargetComponent() instanceof BBacnetDestination && var7_13.destinationEquals((BBacnetDestination)var5_5[var9_10].getTargetComponent())) {
                            var8_7 = 1;
                            break;
                        }
                        ++var9_10;
                    }
                    if (var8_7 == 0) {
                        return new NChangeListError(9, new NErrorType(5, 81), var4_4);
                    }
                    ++var4_4;
                }
                try {
                    var7_14 = 0;
lbl49:
                    // 2 sources

                    while (true) {
                        if (var7_14 >= var3_3.size()) {
                            return null;
                        }
                        var8_8 = (BBacnetDestination)var3_3.elementAt(var7_14);
                        var9_11 = 0;
                        while (var9_11 < var6_12) {
                            block21: {
                                if (!(var5_5[var9_11].getTargetComponent() instanceof BBacnetDestination) || !var8_8.destinationEquals((BBacnetDestination)var5_5[var9_11].getTargetComponent())) break block21;
                                var10_16 = var5_5[var9_11].getTargetComponent();
                                var11_17 = var10_16.getLinks((Slot)BBacnetDestination.routeAlarm);
                                var12_18 = 0;
                                if (true) ** GOTO lbl72
                            }
                            ++var9_11;
                        }
                        break block20;
                        break;
                    }
                }
                catch (PermissionException var7_15) {
                    BBacnetNotificationClassDescriptor.log.message("PermissionException removing elements to recipientList in object " + (Object)this.getObjectId() + ':' + (Object)var7_15);
                    return new NChangeListError(9, new NErrorType(2, 40), 0L);
                }
                do {
                    if (var11_17[var12_18].getSourceComponent() == this.getAlarmClass()) {
                        var10_16.remove((BComplex)var11_17[var12_18]);
                        break;
                    }
                    ++var12_18;
lbl72:
                    // 2 sources

                } while (var12_18 < var11_17.length);
            }
            ++var7_14;
            ** continue;
        }
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    private final void checkFatalFault() {
        BBacnetExportTable bBacnetExportTable = null;
        BLocalBacnetDevice bLocalBacnetDevice = null;
        BBacnetNetwork bBacnetNetwork = null;
        if (this.fatalFault) {
            return;
        }
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BBacnetExportTable) {
                bBacnetExportTable = (BBacnetExportTable)bComplex;
            } else if (bComplex instanceof BLocalBacnetDevice) {
                bLocalBacnetDevice = (BLocalBacnetDevice)bComplex;
                break;
            }
            bComplex = bComplex.getParent();
        }
        if (bBacnetExportTable == null || bLocalBacnetDevice == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under LocalBacnetDevice Export Table");
            return;
        }
        if (bLocalBacnetDevice.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("LocalDevice fault: " + bLocalBacnetDevice.getFaultCause());
            return;
        }
        bBacnetNetwork = (BBacnetNetwork)bLocalBacnetDevice.getParent();
        if (bBacnetNetwork == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under BacnetNetwork");
            return;
        }
        if (bBacnetNetwork.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + bBacnetNetwork.getFaultCause());
            return;
        }
        Feature feature = bBacnetNetwork.getLicenseFeature();
        boolean bl = feature.getb("export", false);
        if (!bl) {
            this.fatalFault = true;
            this.setFaultCause("Server capability not licensed");
            return;
        }
        this.setFaultCause("");
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetNotificationClassDescriptor", 2);
        spyWriter.prop((Object)"fatalFault", this.fatalFault);
        spyWriter.prop((Object)"ac", (Object)this.ac);
        spyWriter.prop((Object)"recipientListChanged", this.recipientListChanged);
        spyWriter.trTitle((Object)"Recipient List", 2);
        int n = 0;
        while (n < this.recipientList.length) {
            spyWriter.prop((Object)("  " + n), (Object)this.recipientList[n]);
            ++n;
        }
        spyWriter.prop((Object)"oldId", (Object)this.oldId);
        spyWriter.prop((Object)"oldName", (Object)this.oldName);
        spyWriter.prop((Object)"duplicate", this.duplicate);
        spyWriter.endProps();
    }

    public BIcon getIcon() {
        return icon;
    }

    final void d(String string) {
        System.out.println("BacSPt{" + (Object)((Object)this.getObjectId()) + "}:" + string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.fatalFault = false;
        this.recipientListChanged = true;
        this.recipientList = new BBacnetDestination[0];
        this.oldId = null;
        this.oldName = null;
        this.duplicate = false;
    }

    public BBacnetNotificationClassDescriptor() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$bacnet$export$BBacnetNotificationClassDescriptor;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BBacnetNotificationClassDescriptor = BBacnetNotificationClassDescriptor.class("[Ljavax.baja.bacnet.export.BBacnetNotificationClassDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"alarm.png"), (BIcon)BIcon.std((String)"badges/export.png"));
        asnIn = new AsnInputStream();
        asnOut = new AsnOutputStream();
        log = Log.getLog((String)"bacnet.server");
        REQUIRED_PROPS = new int[]{75, 77, 79, 17, 86, 1, 102};
        OPTIONAL_PROPS = new int[]{28};
    }
}

