/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.datatypes.BTrendEvent;
import com.tridium.bacnet.history.BBacnetTrendLogAlarmSourceExt;
import com.tridium.bacnet.history.BBacnetTrendRecord;
import com.tridium.bacnet.history.BacnetTrendLogUtil;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.services.error.NChangeListError;
import java.util.ArrayList;
import java.util.Vector;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetLogRecord;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetEventSource;
import javax.baja.bacnet.export.BBacnetNotificationClassDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendRecord;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetNiagaraHistoryDescriptor
extends BBacnetEventSource {
    public static final Property id = BBacnetNiagaraHistoryDescriptor.newProperty((int)8, (BValue)BHistoryId.NULL, null);
    public static final Property historyOrd = BBacnetNiagaraHistoryDescriptor.newProperty((int)5, (BValue)BOrd.DEFAULT, null);
    public static final Property objectId = BBacnetNiagaraHistoryDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(20), null);
    public static final Property objectName = BBacnetNiagaraHistoryDescriptor.newProperty((int)64, (String)"", null);
    public static final Property description = BBacnetNiagaraHistoryDescriptor.newProperty((int)0, (String)"", null);
    public static final Property firstTimestamp = BBacnetNiagaraHistoryDescriptor.newProperty((int)5, (BValue)BAbsTime.NULL, null);
    public static final Property firstSeqNum = BBacnetNiagaraHistoryDescriptor.newProperty((int)5, (int)0, null);
    public static final Property lastTimestamp = BBacnetNiagaraHistoryDescriptor.newProperty((int)5, (BValue)BAbsTime.NULL, null);
    public static final Property lastSeqNum = BBacnetNiagaraHistoryDescriptor.newProperty((int)5, (int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static AsnOutputStream asnOut;
    private static final int[] REQUIRED_PROPS;
    static Log log;
    private int[] optionalProps;
    private BBacnetObjectIdentifier oldId;
    private String oldName;
    private boolean duplicate;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetNiagaraHistoryDescriptor;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetNotificationClassDescriptor;
    static /* synthetic */ Class class$com$tridium$bacnet$history$BBacnetTrendLogAlarmSourceExt;

    public BHistoryId getId() {
        return (BHistoryId)this.get(id);
    }

    public void setId(BHistoryId bHistoryId) {
        this.set(id, (BValue)bHistoryId, null);
    }

    public BOrd getHistoryOrd() {
        return (BOrd)this.get(historyOrd);
    }

    public void setHistoryOrd(BOrd bOrd) {
        this.set(historyOrd, (BValue)bOrd, null);
    }

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public String getObjectName() {
        return this.getString(objectName);
    }

    public void setObjectName(String string) {
        this.setString(objectName, string, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String string) {
        this.setString(description, string, null);
    }

    public BAbsTime getFirstTimestamp() {
        return (BAbsTime)this.get(firstTimestamp);
    }

    public void setFirstTimestamp(BAbsTime bAbsTime) {
        this.set(firstTimestamp, (BValue)bAbsTime, null);
    }

    public long getFirstSeqNum() {
        return this.getLong(firstSeqNum);
    }

    public void setFirstSeqNum(long l) {
        this.setLong(firstSeqNum, l, null);
    }

    public BAbsTime getLastTimestamp() {
        return (BAbsTime)this.get(lastTimestamp);
    }

    public void setLastTimestamp(BAbsTime bAbsTime) {
        this.set(lastTimestamp, (BValue)bAbsTime, null);
    }

    public long getLastSeqNum() {
        return this.getLong(lastSeqNum);
    }

    public void setLastSeqNum(long l) {
        this.setLong(lastSeqNum, l, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        super.started();
        this.initialize();
        this.oldId = this.getObjectId();
        this.oldName = this.getObjectName();
        this.checkConfiguration();
        if (Sys.isStationStarted() && this.getStatus().isOk()) {
            BBacnetNetwork.localDevice().incrementDatabaseRevision();
        }
    }

    public final void stopped() throws Exception {
        super.stopped();
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        bLocalBacnetDevice.unexport(this.oldId, this.oldName, this);
        this.optionalProps = null;
        this.oldId = null;
        this.oldName = null;
        if (this.getStatus().isOk() && bLocalBacnetDevice.isRunning()) {
            bLocalBacnetDevice.incrementDatabaseRevision();
        }
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.equals((Object)historyOrd)) {
            this.setId(BHistoryId.make((String)this.getHistoryOrd().parse()[0].getBody()));
            if (this.isRunning()) {
                this.checkConfiguration();
            }
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)objectId)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldId = this.getObjectId();
            try {
                ((BComponent)this.getParent()).rename(this.getPropertyInParent(), this.getObjectId().toString(BacnetConst.nameContext));
            }
            catch (DuplicateSlotException duplicateSlotException) {}
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)objectName)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldName = this.getObjectName();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)id)) {
            this.setHistoryOrd(BOrd.make((String)("history:" + this.getId())));
            this.checkConfiguration();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        }
    }

    public final BFacets getSlotFacets(Slot slot) {
        if (slot == objectId) {
            return BBacnetObjectType.getObjectIdFacets(20);
        }
        return super.getSlotFacets(slot);
    }

    public final BObject getObject() {
        return (BObject)this.getHistory();
    }

    public final BOrd getObjectOrd() {
        return this.getHistoryOrd();
    }

    public final void setObjectOrd(BOrd bOrd, Context context) {
        this.set(historyOrd, (BValue)bOrd, context);
    }

    public void checkConfiguration() {
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        if (this.isFatalFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        bLocalBacnetDevice.unsubscribe(this, this.getHistory());
        boolean bl = true;
        if (this.getHistory() == null) {
            this.setFaultCause("Cannot find exported history");
            bl = false;
        } else {
            bLocalBacnetDevice.subscribe(this, this.getHistory());
        }
        if (!this.getObjectId().isValid()) {
            this.setFaultCause("Invalid Object ID");
            bl = false;
        }
        if (bl) {
            String string = BBacnetNetwork.localDevice().export(this);
            if (string != null) {
                this.duplicate = true;
                this.setFaultCause(string);
                bl = false;
            } else {
                this.duplicate = false;
            }
        }
        if (bl) {
            this.setFaultCause("");
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)(bl ^ true)));
    }

    public boolean isValidAlarmExt(BIAlarmSource bIAlarmSource) {
        return bIAlarmSource instanceof BBacnetTrendLogAlarmSourceExt;
    }

    public final boolean isEventInitiationEnabled() {
        boolean bl = false;
        if (this.getNotificationClass() != null) {
            bl = true;
        }
        return bl;
    }

    public final BEnum getEventState() {
        BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = this.getAlarmExt();
        if (bBacnetTrendLogAlarmSourceExt == null) {
            return null;
        }
        return BBacnetEventState.make(bBacnetTrendLogAlarmSourceExt.getAlarmState());
    }

    public final BBacnetBitString getAckedTransitions() {
        BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = this.getAlarmExt();
        if (bBacnetTrendLogAlarmSourceExt == null) {
            return null;
        }
        return BacnetBitStringUtil.getBacnetEventTransitionBits(bBacnetTrendLogAlarmSourceExt.getAckedTransitions());
    }

    public final BBacnetTimeStamp[] getEventTimeStamps() {
        BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = this.getAlarmExt();
        if (bBacnetTrendLogAlarmSourceExt == null) {
            return null;
        }
        BAbsTime bAbsTime = bBacnetTrendLogAlarmSourceExt.getToOffnormalTimes().getNormalTime();
        if (bAbsTime.isBefore(bBacnetTrendLogAlarmSourceExt.getToFaultTimes().getNormalTime())) {
            bAbsTime = bBacnetTrendLogAlarmSourceExt.getToFaultTimes().getNormalTime();
        }
        return new BBacnetTimeStamp[]{new BBacnetTimeStamp(bBacnetTrendLogAlarmSourceExt.getToOffnormalTimes().getAlarmTime()), new BBacnetTimeStamp(bBacnetTrendLogAlarmSourceExt.getToFaultTimes().getAlarmTime()), new BBacnetTimeStamp(bAbsTime)};
    }

    public final BBacnetNotifyType getNotifyType() {
        BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = this.getAlarmExt();
        if (bBacnetTrendLogAlarmSourceExt == null) {
            return null;
        }
        return bBacnetTrendLogAlarmSourceExt.getNotifyType();
    }

    public final BBacnetBitString getEventEnable() {
        BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = this.getAlarmExt();
        if (bBacnetTrendLogAlarmSourceExt == null) {
            return null;
        }
        return BacnetBitStringUtil.getBacnetEventTransitionBits(bBacnetTrendLogAlarmSourceExt.getAlarmEnable());
    }

    public final int[] getEventPriorities() {
        BBacnetNotificationClassDescriptor bBacnetNotificationClassDescriptor = this.getNotificationClass();
        if (bBacnetNotificationClassDescriptor == null) {
            return null;
        }
        return bBacnetNotificationClassDescriptor.getEventPriorities();
    }

    public final BBacnetNotificationClassDescriptor getNotificationClass() {
        BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = this.getAlarmExt();
        if (bBacnetTrendLogAlarmSourceExt == null) {
            return null;
        }
        try {
            BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmClass bAlarmClass = bAlarmService.lookupAlarmClass(bBacnetTrendLogAlarmSourceExt.getAlarmClass());
            SlotCursor slotCursor = bAlarmClass.getProperties();
            Class clazz = class$javax$baja$bacnet$export$BBacnetNotificationClassDescriptor;
            if (clazz == null) {
                clazz = class$javax$baja$bacnet$export$BBacnetNotificationClassDescriptor = BBacnetNiagaraHistoryDescriptor.class("[Ljavax.baja.bacnet.export.BBacnetNotificationClassDescriptor;", false);
            }
            if (slotCursor.next(clazz)) {
                return (BBacnetNotificationClassDescriptor)slotCursor.get();
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.message("getNotificationClass on " + this + ":Unable to find alarm service!", (Throwable)serviceNotFoundException);
        }
        return null;
    }

    public BEnum getEventType() {
        return BBacnetEventType.bufferReady;
    }

    public String toString(Context context) {
        return this.getObjectName() + " [" + (Object)((Object)this.getObjectId()) + ']';
    }

    final BBacnetTrendLogAlarmSourceExt getAlarmExt() {
        SlotCursor slotCursor = this.getProperties();
        Class clazz = class$com$tridium$bacnet$history$BBacnetTrendLogAlarmSourceExt;
        if (clazz == null) {
            clazz = class$com$tridium$bacnet$history$BBacnetTrendLogAlarmSourceExt = BBacnetNiagaraHistoryDescriptor.class("[Lcom.tridium.bacnet.history.BBacnetTrendLogAlarmSourceExt;", false);
        }
        if (slotCursor.next(clazz)) {
            return (BBacnetTrendLogAlarmSourceExt)slotCursor.get();
        }
        return null;
    }

    private final void initialize() {
        if (!this.getFirstTimestamp().equals((Object)BAbsTime.NULL)) {
            return;
        }
        BIHistory bIHistory = this.getHistory();
        if (bIHistory == null) {
            return;
        }
        int n = bIHistory.getRecordCount();
        if (n > 0) {
            this.setFirstTimestamp(bIHistory.getFirstTimestamp());
            this.setFirstSeqNum(1L);
            this.setLastTimestamp(bIHistory.getLastTimestamp());
            this.setLastSeqNum(n);
        }
    }

    public final BIHistory getHistory() {
        if (!this.isRunning()) {
            return null;
        }
        try {
            BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
            return bHistoryDatabase.getHistory(this.getId());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private final void reinitTimestamps(BIHistory bIHistory) {
        BAbsTime bAbsTime;
        BAbsTime bAbsTime2 = bIHistory.getFirstTimestamp();
        if (!bAbsTime2.equals((Object)this.getFirstTimestamp())) {
            if (bAbsTime2.isAfter(this.getLastTimestamp())) {
                this.setFirstTimestamp(bAbsTime2);
                this.setFirstSeqNum(BBacnetNiagaraHistoryDescriptor.getSequenceNumber(this.getLastSeqNum() + 1L));
            } else {
                bAbsTime = bIHistory.timeQuery(bAbsTime2, this.getLastTimestamp()).cursor();
                long l = 0L;
                while (bAbsTime.next()) {
                    if (((BTrendRecord)bAbsTime.get()).getTimestamp().equals((Object)this.getLastTimestamp())) continue;
                    ++l;
                }
                this.setFirstTimestamp(bAbsTime2);
                this.setFirstSeqNum(BBacnetNiagaraHistoryDescriptor.getSequenceNumber(this.getLastSeqNum() - l));
            }
        }
        if (!(bAbsTime = bIHistory.getLastTimestamp()).equals((Object)this.getLastTimestamp()) && bAbsTime.isAfter(this.getLastTimestamp())) {
            Cursor cursor = bIHistory.timeQuery(this.getLastTimestamp(), bAbsTime).cursor();
            long l = 0L;
            while (cursor.next()) {
                if (((BTrendRecord)cursor.get()).getTimestamp().equals((Object)this.getLastTimestamp())) continue;
                ++l;
            }
            this.setLastTimestamp(bAbsTime);
            this.setLastSeqNum(BBacnetNiagaraHistoryDescriptor.getSequenceNumber(this.getLastSeqNum() + l));
        }
    }

    private static final long getSequenceNumber(long l) {
        if (l > BacnetTrendLogUtil.MAX_SEQ_NUM) {
            l -= BacnetTrendLogUtil.MAX_SEQ_NUM;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ReadLogResult readRangeAll(int n) {
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        boolean bl2 = false;
        AsnOutputStream asnOutputStream = asnOut;
        synchronized (asnOutputStream) {
            asnOut.reset();
            BIHistory bIHistory = this.getHistory();
            this.reinitTimestamps(bIHistory);
            Cursor cursor = bIHistory.scan();
            BTrendRecord bTrendRecord = null;
            long l3 = this.getFirstSeqNum();
            boolean bl3 = cursor.next();
            while (bl3) {
                bTrendRecord = (BTrendRecord)cursor.get();
                if (BBacnetNiagaraHistoryDescriptor.getLogDatumType(bTrendRecord) >= 0) {
                    AsnOutputStream asnOutputStream2 = new AsnOutputStream();
                    try {
                        asnOut.writeTo(asnOutputStream2);
                    }
                    catch (Exception exception) {
                        log.warning("Error exporting all trend records, Bacnet Object ID " + (Object)((Object)this.getObjectId()), (Throwable)exception);
                        asnOutputStream2 = asnOut;
                    }
                    BBacnetLogRecord.writeLogRecord(bTrendRecord.getTimestamp(), (BSimple)bTrendRecord.get(bTrendRecord.getValueProperty()), BBacnetNiagaraHistoryDescriptor.getLogDatumType(bTrendRecord), bTrendRecord.getStatus(), BBacnetNiagaraHistoryDescriptor.getLogEvent(bTrendRecord).getLong(), (AsnOutput)asnOut);
                    if (n > 0 && asnOut.size() > n) {
                        asnOut = asnOutputStream2;
                        bl2 = true;
                        break;
                    }
                    if (l3 == this.getFirstSeqNum()) {
                        bl = true;
                    }
                    if (l == 0L) {
                        l2 = l3;
                    }
                    ++l;
                }
                ++l3;
                bl3 = cursor.next();
            }
            return new ReadLogResult(l, l2, asnOut.toByteArray(), bl, bl3 ^ true, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ReadLogResult readRangeByPosition(long l, int n, int n2) {
        BIHistory bIHistory = this.getHistory();
        this.reinitTimestamps(bIHistory);
        BAbsTime bAbsTime = bIHistory.getFirstTimestamp();
        BAbsTime bAbsTime2 = bIHistory.getLastTimestamp();
        BAbsTime bAbsTime3 = null;
        long l2 = 0L;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Cursor cursor = bIHistory.scan();
        BTrendRecord bTrendRecord = null;
        AsnOutputStream asnOutputStream = asnOut;
        synchronized (asnOutputStream) {
            block20: {
                block19: {
                    if (n < 0) break block19;
                    asnOut.reset();
                    long l3 = 1L;
                    while (cursor.next() && l2 < (long)n) {
                        if (l3 >= l) {
                            bTrendRecord = (BTrendRecord)cursor.get();
                            bAbsTime3 = bTrendRecord.getTimestamp();
                            int n3 = BBacnetNiagaraHistoryDescriptor.getLogDatumType(bTrendRecord);
                            if (n3 >= 0) {
                                AsnOutputStream asnOutputStream2 = new AsnOutputStream();
                                try {
                                    asnOut.writeTo(asnOutputStream2);
                                }
                                catch (Exception exception) {
                                    log.warning("Error caching trend records during read by position, objectID " + (Object)((Object)this.getObjectId()), (Throwable)exception);
                                    asnOutputStream2 = asnOut;
                                }
                                BBacnetLogRecord.writeLogRecord(bAbsTime3, (BSimple)bTrendRecord.get(bTrendRecord.getValueProperty()), n3, bTrendRecord.getStatus(), BBacnetNiagaraHistoryDescriptor.getLogEvent(bTrendRecord).getLong(), (AsnOutput)asnOut);
                                if (n2 > 0 && asnOut.size() > n2) {
                                    asnOut = asnOutputStream2;
                                    bl3 = true;
                                    break block20;
                                }
                                if (bAbsTime3.equals((Object)bAbsTime)) {
                                    bl = true;
                                }
                                if (bAbsTime3.equals((Object)bAbsTime2)) {
                                    bl2 = true;
                                }
                                ++l2;
                            }
                        }
                        ++l3;
                    }
                    break block20;
                }
                n = -n;
                Vector<BTrendRecord> vector = new Vector<BTrendRecord>();
                while (cursor.next()) {
                    bTrendRecord = (BTrendRecord)cursor.get();
                    if (BBacnetNiagaraHistoryDescriptor.getLogDatumType(bTrendRecord) < 0) continue;
                    vector.addElement(bTrendRecord);
                }
                int n4 = vector.size();
                int n5 = 0;
                if (n4 > n) {
                    n5 = n4 - n;
                    n4 = n;
                }
                asnOut.reset();
                int n6 = n5;
                while (n6 < n4) {
                    bTrendRecord = (BTrendRecord)vector.get(n6);
                    bAbsTime3 = bTrendRecord.getTimestamp();
                    AsnOutputStream asnOutputStream3 = new AsnOutputStream();
                    try {
                        asnOut.writeTo(asnOutputStream3);
                    }
                    catch (Exception exception) {
                        log.warning("Error caching trend records during read by position, objectID " + (Object)((Object)this.getObjectId()), (Throwable)exception);
                        asnOutputStream3 = asnOut;
                    }
                    BBacnetLogRecord.writeLogRecord(bAbsTime3, (BSimple)bTrendRecord.get(bTrendRecord.getValueProperty()), BBacnetNiagaraHistoryDescriptor.getLogDatumType(bTrendRecord), bTrendRecord.getStatus(), BBacnetNiagaraHistoryDescriptor.getLogEvent(bTrendRecord).getLong(), (AsnOutput)asnOut);
                    if (n2 > 0 && asnOut.size() > n2) {
                        asnOut = asnOutputStream3;
                        bl3 = true;
                        break;
                    }
                    if (bAbsTime3.equals((Object)bAbsTime)) {
                        bl = true;
                    }
                    if (bAbsTime3.equals((Object)bAbsTime2)) {
                        bl2 = true;
                    }
                    ++l2;
                    ++n6;
                }
            }
            return new ReadLogResult(l2, -1, asnOut.toByteArray(), bl, bl2, bl3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ReadLogResult readRangeByTime(BBacnetDateTime bBacnetDateTime, int n, int n2) {
        BAbsTime bAbsTime = bBacnetDateTime.toBAbsTime();
        BIHistory bIHistory = this.getHistory();
        this.reinitTimestamps(bIHistory);
        BAbsTime bAbsTime2 = bIHistory.getFirstTimestamp();
        BAbsTime bAbsTime3 = bIHistory.getLastTimestamp();
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        AsnOutputStream asnOutputStream = asnOut;
        synchronized (asnOutputStream) {
            block23: {
                block22: {
                    if (n < 0) break block22;
                    asnOut.reset();
                    Cursor cursor = bIHistory.timeQuery(bAbsTime, null).cursor();
                    BTrendRecord bTrendRecord = null;
                    long l3 = 0L;
                    while (cursor.next()) {
                        if ((long)n > l) {
                            bTrendRecord = (BTrendRecord)cursor.get();
                            BBacnetDateTime bBacnetDateTime2 = new BBacnetDateTime(bTrendRecord.getTimestamp());
                            if (BBacnetNiagaraHistoryDescriptor.getLogDatumType(bTrendRecord) >= 0 && !bBacnetDateTime2.toBAbsTime().equals((Object)bAbsTime)) {
                                AsnOutputStream asnOutputStream2 = new AsnOutputStream();
                                try {
                                    asnOut.writeTo(asnOutputStream2);
                                }
                                catch (Exception exception) {
                                    log.warning("Error caching trend records during read by time, objectID " + (Object)((Object)this.getObjectId()), (Throwable)exception);
                                    asnOutputStream2 = asnOut;
                                }
                                BBacnetLogRecord.writeLogRecord(bTrendRecord.getTimestamp(), (BSimple)bTrendRecord.get(bTrendRecord.getValueProperty()), BBacnetNiagaraHistoryDescriptor.getLogDatumType(bTrendRecord), bTrendRecord.getStatus(), BBacnetNiagaraHistoryDescriptor.getLogEvent(bTrendRecord).getLong(), (AsnOutput)asnOut);
                                if (n2 > 0 && asnOut.size() > n2) {
                                    asnOut = asnOutputStream2;
                                    bl3 = true;
                                    break;
                                }
                                if (bTrendRecord.getTimestamp().equals((Object)bAbsTime2)) {
                                    bl = true;
                                }
                                if (bTrendRecord.getTimestamp().equals((Object)bAbsTime3)) {
                                    bl2 = true;
                                }
                                if (l == 0L) {
                                    l2 = l3 + 1L;
                                }
                                ++l;
                            }
                        }
                        ++l3;
                    }
                    l2 = this.getLastSeqNum() - l3 + l2;
                    break block23;
                }
                int n3 = n * -1;
                Cursor cursor = bIHistory.timeQuery(null, bAbsTime).cursor();
                Vector<Object> vector = new Vector<Object>();
                long l4 = this.getFirstSeqNum();
                while (cursor.next()) {
                    BBacnetDateTime bBacnetDateTime3 = new BBacnetDateTime(((BTrendRecord)cursor.get()).getTimestamp());
                    if (BBacnetNiagaraHistoryDescriptor.getLogDatumType((BTrendRecord)cursor.get()) >= 0 && !bBacnetDateTime3.toBAbsTime().equals((Object)bAbsTime)) {
                        vector.addElement((BTrendRecord)cursor.get());
                        vector.addElement(BLong.make((long)l4));
                    }
                    ++l4;
                }
                int n4 = vector.size() / 2;
                int n5 = 0;
                if (n4 > n3) {
                    n5 = n4 - n3;
                    n4 = n3;
                }
                asnOut.reset();
                BTrendRecord bTrendRecord = null;
                int n6 = n5;
                while (n6 < n4) {
                    bTrendRecord = (BTrendRecord)vector.elementAt(n6 * 2);
                    AsnOutputStream asnOutputStream3 = new AsnOutputStream();
                    try {
                        asnOut.writeTo(asnOutputStream3);
                    }
                    catch (Exception exception) {
                        log.warning("Error exporting trend records by time, Bacnet Object ID " + (Object)((Object)this.getObjectId()), (Throwable)exception);
                        asnOutputStream3 = asnOut;
                    }
                    BBacnetLogRecord.writeLogRecord(bTrendRecord.getTimestamp(), (BSimple)bTrendRecord.get(bTrendRecord.getValueProperty()), BBacnetNiagaraHistoryDescriptor.getLogDatumType(bTrendRecord), bTrendRecord.getStatus(), BBacnetNiagaraHistoryDescriptor.getLogEvent(bTrendRecord).getLong(), (AsnOutput)asnOut);
                    if (n2 > 0 && asnOut.size() > n2) {
                        asnOut = asnOutputStream3;
                        bl3 = true;
                        break;
                    }
                    if (bTrendRecord.getTimestamp().equals((Object)bAbsTime2)) {
                        bl = true;
                    }
                    if (bTrendRecord.getTimestamp().equals((Object)bAbsTime3)) {
                        bl2 = true;
                    }
                    if (l == 0L) {
                        l2 = ((BLong)vector.elementAt(n6 * 2 + 1)).getLong();
                    }
                    ++l;
                    ++n6;
                }
                vector.removeAllElements();
            }
            return new ReadLogResult(l, l2, asnOut.toByteArray(), bl, bl2, bl3);
        }
    }

    private static final int getLogDatumType(BTrendRecord bTrendRecord) {
        if (bTrendRecord instanceof BBacnetTrendRecord) {
            return ((BBacnetTrendRecord)bTrendRecord).getLogDatumType();
        }
        BValue bValue = bTrendRecord.get(bTrendRecord.getValueProperty());
        if (bValue instanceof BBoolean) {
            return 1;
        }
        if (bValue instanceof BDouble) {
            return 2;
        }
        if (bValue instanceof BEnum) {
            return 3;
        }
        if (bValue instanceof BBacnetUnsigned) {
            return 4;
        }
        if (bValue instanceof BFloat) {
            return 2;
        }
        if (bValue instanceof BInteger) {
            return 5;
        }
        if (bValue instanceof BBacnetBitString) {
            return 6;
        }
        if (bValue instanceof BBacnetNull) {
            return 7;
        }
        if (bValue instanceof BTrendEvent) {
            BTrendEvent bTrendEvent = (BTrendEvent)bValue;
            if (bTrendEvent.isLogStatus()) {
                return 0;
            }
            if (bTrendEvent.isFailure()) {
                return 8;
            }
            if (bTrendEvent.isTimeChange()) {
                return 9;
            }
        }
        return -1;
    }

    private static final BTrendEvent getLogEvent(BTrendRecord bTrendRecord) {
        if (bTrendRecord instanceof BBacnetTrendRecord) {
            return ((BBacnetTrendRecord)bTrendRecord).getLogEvent();
        }
        return BTrendEvent.DEFAULT;
    }

    public final PropertyValue readProperty(PropertyReference propertyReference) throws RejectException {
        return this.readProperty(propertyReference.getPropertyId(), propertyReference.getPropertyArrayIndex());
    }

    public final PropertyValue[] readPropertyMultiple(PropertyReference[] propertyReferenceArray) throws RejectException {
        PropertyValue[] propertyValueArray = new PropertyValue[]{};
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(propertyReferenceArray.length);
        int n = 0;
        while (n < propertyReferenceArray.length) {
            switch (propertyReferenceArray[n].getPropertyId()) {
                case 8: {
                    int[] nArray = REQUIRED_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    nArray = this.getOptionalProps();
                    n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                case 80: {
                    int[] nArray = this.getOptionalProps();
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                case 105: {
                    int[] nArray = REQUIRED_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                default: {
                    arrayList.add(this.readProperty(propertyReferenceArray[n].getPropertyId(), propertyReferenceArray[n].getPropertyArrayIndex()));
                }
            }
            ++n;
        }
        return arrayList.toArray(propertyValueArray);
    }

    public final RangeData readRange(RangeReference rangeReference) throws RejectException {
        int n = rangeReference.getPropertyId();
        if (n == 131) {
            int n2 = -1;
            if (rangeReference instanceof BacnetConfirmedRequest) {
                n2 = ((BacnetConfirmedRequest)((Object)rangeReference)).getMaxDataLength();
            }
            int n3 = rangeReference.getCount();
            switch (rangeReference.getRangeType()) {
                case 6: {
                    throw new RejectException(6);
                }
                case 3: {
                    long l = rangeReference.getReferenceIndex();
                    try {
                        ReadLogResult readLogResult = this.readRangeByPosition(l, n3, n2);
                        return new ReadRangeAck(this.getObjectId(), n, -1, readLogResult.getResultFlags(), readLogResult.itemCount, readLogResult.itemCount > 0L ? readLogResult.firstSequenceNumber : (long)-1, readLogResult.itemData);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return new ReadRangeAck(2, 0);
                    }
                }
                case 7: {
                    BBacnetDateTime bBacnetDateTime = rangeReference.getReferenceTime();
                    try {
                        ReadLogResult readLogResult = this.readRangeByTime(bBacnetDateTime, n3, n2);
                        return new ReadRangeAck(this.getObjectId(), n, -1, readLogResult.getResultFlags(), readLogResult.itemCount, readLogResult.itemCount > 0L ? readLogResult.firstSequenceNumber : (long)-1, readLogResult.itemData);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return new ReadRangeAck(2, 0);
                    }
                }
                case -1: {
                    try {
                        ReadLogResult readLogResult = this.readRangeAll(n2);
                        return new ReadRangeAck(this.getObjectId(), n, -1, readLogResult.getResultFlags(), readLogResult.itemCount, readLogResult.itemCount > 0L ? readLogResult.firstSequenceNumber : (long)-1, readLogResult.itemData);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return new ReadRangeAck(2, 0);
                    }
                }
            }
            log.message("Unsupported ReadRange Range Type: " + rangeReference.getRangeType());
            return new ReadRangeAck(2, 0);
        }
        int n4 = 0;
        while (n4 < REQUIRED_PROPS.length) {
            if (n == REQUIRED_PROPS[n4]) {
                return new ReadRangeAck(5, 22);
            }
            ++n4;
        }
        int[] nArray = this.getOptionalProps();
        int n5 = 0;
        while (n5 < nArray.length) {
            if (n == nArray[n5]) {
                return new ReadRangeAck(5, 22);
            }
            ++n5;
        }
        return new ReadRangeAck(2, 32);
    }

    public final ErrorType writeProperty(PropertyValue propertyValue) throws BacnetException {
        return this.writeProperty(propertyValue.getPropertyId(), propertyValue.getPropertyArrayIndex(), propertyValue.getPropertyValue(), propertyValue.getPriority());
    }

    public final ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        if (propertyValue.getPropertyId() == 131) {
            return new NChangeListError(8, new NErrorType(2, 40), 0L);
        }
        int n = propertyValue.getPropertyId();
        int n2 = 0;
        while (n2 < REQUIRED_PROPS.length) {
            if (n == REQUIRED_PROPS[n2]) {
                return new NChangeListError(8, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        int[] nArray = this.getOptionalProps();
        int n3 = 0;
        while (n3 < nArray.length) {
            if (n == nArray[n3]) {
                return new NChangeListError(8, new NErrorType(5, 22), 0L);
            }
            ++n3;
        }
        return new NChangeListError(8, new NErrorType(2, 32), 0L);
    }

    public final ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        if (propertyValue.getPropertyId() == 131) {
            return new NChangeListError(9, new NErrorType(2, 40), 0L);
        }
        int n = propertyValue.getPropertyId();
        int n2 = 0;
        while (n2 < REQUIRED_PROPS.length) {
            if (n == REQUIRED_PROPS[n2]) {
                return new NChangeListError(9, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        int[] nArray = this.getOptionalProps();
        int n3 = 0;
        while (n3 < nArray.length) {
            if (n == nArray[n3]) {
                return new NChangeListError(9, new NErrorType(5, 22), 0L);
            }
            ++n3;
        }
        return new NChangeListError(9, new NErrorType(2, 32), 0L);
    }

    boolean isArray(int n) {
        return n == 130;
    }

    protected PropertyValue readProperty(int n, int n2) {
        if (n2 >= 0 && !this.isArray(n)) {
            return new NReadPropertyResult(n, n2, new NErrorType(2, 50));
        }
        switch (n) {
            case 75: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnObjectId(this.getObjectId()));
            }
            case 77: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getObjectName()));
            }
            case 79: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(this.getObjectId().getObjectType()));
            }
            case 28: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getDescription()));
            }
            case 133: {
                return new NReadPropertyResult(n, n2, new NErrorType(2, 27));
            }
            case 144: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnBoolean(this.getHistory().getConfig().getFullPolicy().equals((Object)BFullPolicy.stop)));
            }
            case 126: {
                long l = 0xFFFFFFFFL;
                if (this.getHistory().getConfig().getCapacity().isByRecordCount()) {
                    l = this.getHistory().getConfig().getCapacity().getMaxRecords();
                } else if (this.getHistory().getConfig().getCapacity().isByStorageSize()) {
                    l = this.getHistory().getConfig().getCapacity().getMaxStorage();
                }
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(l));
            }
            case 131: {
                return new NReadPropertyResult(n, n2, new NErrorType(2, 27));
            }
            case 141: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(this.getHistory().getRecordCount()));
            }
            case 145: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(this.getLastSeqNum()));
            }
            case 36: {
                BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = this.getAlarmExt();
                if (bBacnetTrendLogAlarmSourceExt == null) {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(0));
                }
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(BBacnetEventState.fromBAlarmState(bBacnetTrendLogAlarmSourceExt.getAlarmState())));
            }
        }
        return this.readOptionalProperty(n, n2);
    }

    protected ErrorType writeProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        if (n2 >= 0 && !this.isArray(n)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (n) {
                case 77: {
                    return BacUtil.setObjectName(this, objectName, byArray);
                }
                case 36: 
                case 75: 
                case 79: 
                case 126: 
                case 131: 
                case 133: 
                case 141: 
                case 144: 
                case 145: {
                    return new NErrorType(2, 40);
                }
                case 28: {
                    this.setString(description, AsnUtil.fromAsnCharacterString(byArray), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
            return this.writeOptionalProperty(n, n2, byArray, n3);
        }
        catch (AsnException asnException) {
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
    }

    protected PropertyValue readOptionalProperty(int n, int n2) {
        BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = this.getAlarmExt();
        if (bBacnetTrendLogAlarmSourceExt != null) {
            switch (n) {
                case 17: {
                    BBacnetNotificationClassDescriptor bBacnetNotificationClassDescriptor = this.getNotificationClass();
                    if (bBacnetNotificationClassDescriptor == null) {
                        return new NReadPropertyResult(n, n2, new NErrorType(2, 32));
                    }
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bBacnetNotificationClassDescriptor.getNotificationClass()));
                }
                case 35: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(bBacnetTrendLogAlarmSourceExt.getAlarmEnable())));
                }
                case 0: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(bBacnetTrendLogAlarmSourceExt.getAckedTransitions())));
                }
                case 72: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated((BEnum)bBacnetTrendLogAlarmSourceExt.getNotifyType()));
                }
                case 130: {
                    return this.readEventTimeStamps(bBacnetTrendLogAlarmSourceExt, n2);
                }
                case 137: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bBacnetTrendLogAlarmSourceExt.getNotificationThreshold()));
                }
                case 140: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bBacnetTrendLogAlarmSourceExt.getRecordsSinceNotification()));
                }
                case 173: {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bBacnetTrendLogAlarmSourceExt.getLastNotifyRecord()));
                }
            }
        }
        if (n == 134) {
            BCollectionInterval bCollectionInterval = this.getHistory().getConfig().getInterval();
            long l = bCollectionInterval.isIrregular() ? 0L : bCollectionInterval.getInterval().getMillis() / 10L;
            return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(l));
        }
        return new NReadPropertyResult(n, n2, new NErrorType(2, 32));
    }

    protected ErrorType writeOptionalProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        try {
            BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = this.getAlarmExt();
            if (bBacnetTrendLogAlarmSourceExt != null) {
                switch (n) {
                    case 35: {
                        return new NErrorType(2, 40);
                    }
                    case 72: {
                        this.set(BBacnetTrendLogAlarmSourceExt.notifyType, (BValue)BBacnetNotifyType.make(AsnUtil.fromAsnEnumerated(byArray)), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 17: {
                        int n4 = AsnUtil.fromAsnUnsignedInt(byArray);
                        if (n4 > 0x3FFFFE) {
                            return new NErrorType(2, 37);
                        }
                        BBacnetObjectIdentifier bBacnetObjectIdentifier = BBacnetObjectIdentifier.make(15, n4);
                        BBacnetNotificationClassDescriptor bBacnetNotificationClassDescriptor = (BBacnetNotificationClassDescriptor)BBacnetNetwork.localDevice().lookupBacnetObject(bBacnetObjectIdentifier);
                        if (bBacnetNotificationClassDescriptor == null) {
                            return new NErrorType(2, 37);
                        }
                        BAlarmClass bAlarmClass = bBacnetNotificationClassDescriptor.getAlarmClass();
                        bBacnetTrendLogAlarmSourceExt.setString(BBacnetTrendLogAlarmSourceExt.alarmClass, bAlarmClass.getName(), BLocalBacnetDevice.getBacnetContext());
                        return null;
                    }
                    case 0: 
                    case 130: 
                    case 137: 
                    case 140: 
                    case 173: {
                        return new NErrorType(2, 40);
                    }
                }
            }
            if (n == 134) {
                return new NErrorType(2, 40);
            }
        }
        catch (AsnException asnException) {
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new NErrorType(2, 37);
        }
        return new NErrorType(2, 32);
    }

    private final int[] getOptionalProps() {
        Vector<BBacnetPropertyIdentifier> vector = new Vector<BBacnetPropertyIdentifier>();
        vector.add(BBacnetPropertyIdentifier.description);
        vector.add(BBacnetPropertyIdentifier.logInterval);
        BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt = this.getAlarmExt();
        if (bBacnetTrendLogAlarmSourceExt != null) {
            vector.add(BBacnetPropertyIdentifier.notificationThreshold);
            vector.add(BBacnetPropertyIdentifier.recordsSinceNotification);
            vector.add(BBacnetPropertyIdentifier.lastNotifyRecord);
            vector.add(BBacnetPropertyIdentifier.notificationClass);
            vector.add(BBacnetPropertyIdentifier.eventEnable);
            vector.add(BBacnetPropertyIdentifier.ackedTransitions);
            vector.add(BBacnetPropertyIdentifier.notifyType);
            vector.add(BBacnetPropertyIdentifier.eventTimeStamps);
        }
        this.optionalProps = new int[vector.size()];
        int n = 0;
        while (n < this.optionalProps.length) {
            this.optionalProps[n] = ((BEnum)vector.elementAt(n)).getOrdinal();
            ++n;
        }
        return this.optionalProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PropertyValue readEventTimeStamps(BBacnetTrendLogAlarmSourceExt bBacnetTrendLogAlarmSourceExt, int n) {
        AsnOutputStream asnOutputStream = asnOut;
        synchronized (asnOutputStream) {
            asnOut.reset();
            BAbsTime bAbsTime = bBacnetTrendLogAlarmSourceExt.getToOffnormalTimes().getNormalTime();
            if (bAbsTime.isBefore(bBacnetTrendLogAlarmSourceExt.getToFaultTimes().getNormalTime())) {
                bAbsTime = bBacnetTrendLogAlarmSourceExt.getToFaultTimes().getNormalTime();
            }
            switch (n) {
                case 0: {
                    asnOut.writeUnsignedInteger(3);
                    break;
                }
                case 1: {
                    BBacnetTimeStamp.encodeTimeStamp(bBacnetTrendLogAlarmSourceExt.getToOffnormalTimes().getAlarmTime(), asnOut);
                    break;
                }
                case 2: {
                    BBacnetTimeStamp.encodeTimeStamp(bBacnetTrendLogAlarmSourceExt.getToFaultTimes().getAlarmTime(), asnOut);
                    break;
                }
                case 3: {
                    BBacnetTimeStamp.encodeTimeStamp(bAbsTime, asnOut);
                    break;
                }
                case -1: {
                    BBacnetTimeStamp.encodeTimeStamp(bBacnetTrendLogAlarmSourceExt.getToOffnormalTimes().getAlarmTime(), asnOut);
                    BBacnetTimeStamp.encodeTimeStamp(bBacnetTrendLogAlarmSourceExt.getToFaultTimes().getAlarmTime(), asnOut);
                    BBacnetTimeStamp.encodeTimeStamp(bAbsTime, asnOut);
                    break;
                }
                default: {
                    return new NReadPropertyResult(130, n, new NErrorType(2, 42));
                }
            }
            return new NReadPropertyResult(130, n, asnOut.toByteArray());
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetNiagaraHistoryDescriptor", 2);
        spyWriter.prop((Object)"history", (Object)this.getHistory());
        spyWriter.prop((Object)"oldId", (Object)this.oldId);
        spyWriter.prop((Object)"oldName", (Object)this.oldName);
        spyWriter.prop((Object)"duplicate", this.duplicate);
        spyWriter.endProps();
    }

    public BIcon getIcon() {
        return icon;
    }

    void d(String string) {
        System.out.println(string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.oldId = null;
        this.oldName = null;
        this.duplicate = false;
    }

    public BBacnetNiagaraHistoryDescriptor() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$bacnet$export$BBacnetNiagaraHistoryDescriptor;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BBacnetNiagaraHistoryDescriptor = BBacnetNiagaraHistoryDescriptor.class("[Ljavax.baja.bacnet.export.BBacnetNiagaraHistoryDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"history.png"), (BIcon)BIcon.std((String)"badges/export.png"));
        asnOut = new AsnOutputStream();
        REQUIRED_PROPS = new int[]{75, 77, 79, 133, 144, 126, 131, 141, 145, 36};
        log = Log.getLog((String)"bacnet.server");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ReadLogResult
    implements RangeData {
        long itemCount;
        long firstSequenceNumber;
        byte[] itemData;
        boolean includeFirst;
        boolean includeLast;
        boolean moreItems;

        public BBacnetBitString getResultFlags() {
            return BBacnetBitString.make(new boolean[]{this.includeFirst, this.includeLast, this.moreItems});
        }

        public boolean includesFirstItem() {
            return this.includeFirst;
        }

        public boolean includesLastItem() {
            return this.includeLast;
        }

        public boolean isMoreItems() {
            return this.moreItems;
        }

        public long getItemCount() {
            return this.itemCount;
        }

        public long getFirstSequenceNumber() {
            return this.firstSequenceNumber;
        }

        public byte[] getItemData() {
            return this.itemData;
        }

        public ErrorType getError() {
            return null;
        }

        public int getErrorClass() {
            return -1;
        }

        public int getErrorCode() {
            return -1;
        }

        public boolean isError() {
            return false;
        }

        public int getPropertyId() {
            return 131;
        }

        public int getPropertyArrayIndex() {
            return -1;
        }

        public void writeAsn(AsnOutput asnOutput) {
        }

        public void readAsn(AsnInput asnInput) {
        }

        ReadLogResult(long l, long l2, byte[] byArray, boolean bl, boolean bl2, boolean bl3) {
            this.itemCount = l;
            this.firstSequenceNumber = l2;
            this.itemData = byArray;
            this.includeFirst = bl;
            this.includeLast = bl2;
            this.moreItems = bl3;
        }
    }
}

