/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import java.util.Vector;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.fault.BEnumFaultAlgorithm;
import javax.baja.alarm.ext.offnormal.BEnumChangeOfStateAlgorithm;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetCovSubscription;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.export.BBacnetPointDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BBacnetMultiStatePointDescriptor
extends BBacnetPointDescriptor {
    public static final Type TYPE;
    private static final BIcon icon;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetMultiStatePointDescriptor;
    static /* synthetic */ Class class$java$lang$Integer;

    public Type getType() {
        return TYPE;
    }

    protected boolean isPointTypeLegal(BControlPoint bControlPoint) {
        return bControlPoint instanceof BEnumPoint;
    }

    protected PropertyValue readProperty(int n, int n2) {
        BEnumPoint bEnumPoint = (BEnumPoint)this.getPoint();
        if (bEnumPoint == null) {
            return new NReadPropertyResult(n, n2, new NErrorType(1, 1000));
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NReadPropertyResult(n, n2, new NErrorType(2, 50));
        }
        switch (n) {
            case 85: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bEnumPoint.getOut().getValue().getOrdinal()));
            }
            case 74: {
                BEnumRange bEnumRange = (BEnumRange)bEnumPoint.getFacets().getFacet("range");
                if (bEnumRange != null) {
                    return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bEnumRange.getOrdinals().length));
                }
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(Integer.MAX_VALUE));
            }
            case 110: {
                return this.readStateText(n2);
            }
        }
        return super.readProperty(n, n2);
    }

    public RangeData readRange(RangeReference rangeReference) throws RejectException {
        int n = rangeReference.getPropertyId();
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        switch (n) {
            case 7: {
                if (bAlarmSourceExt == null) break;
                BEnumChangeOfStateAlgorithm bEnumChangeOfStateAlgorithm = (BEnumChangeOfStateAlgorithm)bAlarmSourceExt.getOffnormalAlgorithm();
                int[] nArray = bEnumChangeOfStateAlgorithm.getAlarmValues().getOrdinals();
                Integer[] integerArray = new Integer[nArray.length];
                int n2 = 0;
                while (n2 < integerArray.length) {
                    integerArray[n2] = new Integer(nArray[n2]);
                    ++n2;
                }
                return this.readRange(rangeReference, integerArray, 5);
            }
            case 39: {
                if (bAlarmSourceExt == null) break;
                BEnumFaultAlgorithm bEnumFaultAlgorithm = (BEnumFaultAlgorithm)bAlarmSourceExt.getFaultAlgorithm();
                int[] nArray = bEnumFaultAlgorithm.getValidValues().getOrdinals();
                BEnumRange bEnumRange = (BEnumRange)this.getPoint().getFacets().getFacet("range");
                int[] nArray2 = bEnumRange.getOrdinals();
                Class clazz = class$java$lang$Integer;
                if (clazz == null) {
                    clazz = class$java$lang$Integer = BBacnetMultiStatePointDescriptor.class("[Ljava.lang.Integer;", false);
                }
                Array array = new Array(clazz);
                int n3 = 0;
                while (n3 < nArray2.length) {
                    boolean bl = false;
                    int n4 = 0;
                    while (n4 < nArray.length) {
                        if (nArray2[n3] == nArray[n4]) {
                            bl = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!bl) {
                        array.add((Object)new Integer(nArray2[n3]));
                    }
                    ++n3;
                }
                Integer[] integerArray = (Integer[])array.trim();
                return this.readRange(rangeReference, integerArray, 5);
            }
            default: {
                int[] nArray = this.getRequiredProps();
                int n5 = 0;
                while (n5 < nArray.length) {
                    if (n == nArray[n5]) {
                        return new ReadRangeAck(5, 22);
                    }
                    ++n5;
                }
                nArray = this.getOptionalProps();
                n5 = 0;
                while (n5 < nArray.length) {
                    if (n == nArray[n5]) {
                        return new ReadRangeAck(5, 22);
                    }
                    ++n5;
                }
                break block0;
            }
        }
        return new ReadRangeAck(2, 32);
    }

    protected ErrorType writeProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        BEnumPoint bEnumPoint = (BEnumPoint)this.getPoint();
        if (bEnumPoint == null) {
            return new NErrorType(1, 1000);
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (n) {
                case 74: {
                    return new NErrorType(2, 40);
                }
                case 110: {
                    return this.writeStateText(n2, byArray, bEnumPoint);
                }
            }
            return super.writeProperty(n, n2, byArray, n3);
        }
        catch (AsnException asnException) {
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()));
            return new NErrorType(2, 9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RangeData readRange(RangeReference var1_1, Integer[] var2_2, int var3_3) {
        block30: {
            block27: {
                block28: {
                    var4_4 = var1_1.getRangeType();
                    var5_5 = var2_2.length;
                    var6_6 = new boolean[3];
                    var7_7 = -1;
                    if (var1_1 instanceof BacnetConfirmedRequest) {
                        var7_7 = ((BacnetConfirmedRequest)var1_1).getMaxDataLength() - 23 + 3 + 5;
                    }
                    if (var4_4 != 3) break block27;
                    var8_8 = (int)var1_1.getReferenceIndex();
                    var9_10 = var1_1.getCount();
                    if (var8_8 > var5_5 || var8_8 < 1) {
                        return new ReadRangeAck(this.getObjectId(), var1_1.getPropertyId(), -1, BBacnetBitString.emptyBitString(3), 0L, new byte[0]);
                    }
                    var10_12 = new Array();
                    var11_13 = 0;
                    if (var9_10 <= 0) break block28;
                    var12_14 = var8_8 - 1;
                    if (true) ** GOTO lbl55
                }
                if (var9_10 >= 0) {
                    return new ReadRangeAck(5, 7);
                }
                var9_10 = -var9_10;
                var12_14 = var8_8 - 1;
                if (true) ** GOTO lbl66
            }
            if (var4_4 != -1) {
                return new ReadRangeAck(5, 7);
            }
            var6_6[0] = true;
            var8_9 = 0;
            var9_11 = BBacnetMultiStatePointDescriptor.asnOut;
            synchronized (var9_11) {
                block24: {
                    BBacnetMultiStatePointDescriptor.asnOut.reset();
                    if (var7_7 <= 0) break block24;
                    var12_16 = 0;
                    while (var12_16 < var5_5) {
                        BBacnetMultiStatePointDescriptor.asnOut.writeUnsignedInteger(var2_2[var12_16].intValue());
                        ++var8_9;
                        if (var7_7 - BBacnetMultiStatePointDescriptor.asnOut.size() < var3_3) break;
                        ++var12_16;
                    }
                    if (var8_9 == var5_5) {
                        var6_6[1] = true;
                    }
                    break block29;
                }
                var8_9 = var5_5;
                var12_17 = 0;
                if (true) ** GOTO lbl103
            }
            do {
                var10_12.add((Object)var2_2[var12_14]);
                ++var11_13;
                ++var12_14;
lbl55:
                // 2 sources

            } while (var12_14 < var5_5 && var11_13 < var9_10);
            if (var8_8 == 1) {
                var6_6[0] = true;
            }
            if (var8_8 + var9_10 - 1 >= var5_5) {
                var6_6[1] = true;
            }
            break block30;
            do {
                var10_12.add((Object)var2_2[var12_14]);
                ++var11_13;
                --var12_14;
lbl66:
                // 2 sources

            } while (var12_14 >= 0 && var11_13 < var9_10);
            var10_12 = var10_12.reverse();
            if (var8_8 - var9_10 <= 0) {
                var6_6[0] = true;
            }
            if (var8_8 == var5_5) {
                var6_6[1] = true;
            }
        }
        var12_15 = var10_12.iterator();
        var13_18 = 0;
        var14_19 = BBacnetMultiStatePointDescriptor.asnOut;
        synchronized (var14_19) {
            block26: {
                block25: {
                    BBacnetMultiStatePointDescriptor.asnOut.reset();
                    if (var7_7 <= 0) break block25;
                    while (var12_15.hasNext()) {
                        if (var7_7 - BBacnetMultiStatePointDescriptor.asnOut.size() < var3_3) {
                            var6_6[1] = false;
                            break block26;
                        }
                        BBacnetMultiStatePointDescriptor.asnOut.writeUnsignedInteger(((Integer)var12_15.next()).intValue());
                        ++var13_18;
                    }
                    break block26;
                }
                var13_18 = var11_13;
                while (var12_15.hasNext()) {
                    BBacnetMultiStatePointDescriptor.asnOut.writeUnsignedInteger(((Integer)var12_15.next()).intValue());
                }
            }
            if (var13_18 < var11_13) {
                var6_6[2] = true;
            }
            return new ReadRangeAck(this.getObjectId(), var1_1.getPropertyId(), -1, BBacnetBitString.make(var6_6), (long)var13_18, BBacnetMultiStatePointDescriptor.asnOut.toByteArray());
        }
        {
            block29: {
                do {
                    BBacnetMultiStatePointDescriptor.asnOut.writeUnsignedInteger(var2_2[var12_17].intValue());
                    ++var12_17;
lbl103:
                    // 2 sources

                } while (var12_17 < var5_5);
                var6_6[1] = true;
            }
            if (var8_9 < var5_5) {
                var6_6[2] = true;
            }
            return new ReadRangeAck(this.getObjectId(), var1_1.getPropertyId(), -1, BBacnetBitString.make(var6_6), (long)var8_9, BBacnetMultiStatePointDescriptor.asnOut.toByteArray());
        }
    }

    protected void addRequiredProps(Vector vector) {
        super.addRequiredProps(vector);
        vector.add(BBacnetPropertyIdentifier.presentValue);
        vector.add(BBacnetPropertyIdentifier.statusFlags);
        vector.add(BBacnetPropertyIdentifier.eventState);
        vector.add(BBacnetPropertyIdentifier.outOfService);
        vector.add(BBacnetPropertyIdentifier.numberOfStates);
    }

    protected void addOptionalProps(Vector vector) {
        super.addOptionalProps(vector);
        BEnumRange bEnumRange = (BEnumRange)this.getPoint().getFacets().getFacet("range");
        if (bEnumRange != null) {
            vector.add(BBacnetPropertyIdentifier.stateText);
        }
    }

    protected final boolean checkPointConfiguration() {
        int[] nArray;
        BEnumRange bEnumRange = (BEnumRange)this.getPoint().getFacets().getFacet("range");
        if (bEnumRange != null && (nArray = bEnumRange.getOrdinals()).length > 0) {
            if (nArray[0] != 1) {
                this.setFaultCause("Range must be 1-N for export to BACnet.");
                return false;
            }
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] != n + 1) {
                    this.setFaultCause("Range must be 1-N for export to BACnet.");
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    protected void validate() {
        BStatusEnum bStatusEnum = ((BEnumPoint)this.getPoint()).getOut();
        BStatus bStatus = bStatusEnum.getStatus();
        if (bStatus.isNull()) {
            this.setReliability((BEnum)BBacnetReliability.unreliableOther);
            this.setFaultCause("Invalid value for BACnet Object:" + bStatusEnum);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        } else if (bStatus.isFault()) {
            this.setReliability((BEnum)BBacnetReliability.unreliableOther);
        } else if (bStatus.isDown()) {
            this.setReliability((BEnum)BBacnetReliability.communicationFailure);
        } else {
            int n = bStatusEnum.getValue().getOrdinal();
            BEnumRange bEnumRange = (BEnumRange)this.getPoint().getFacets().getFacet("range");
            if (bEnumRange == null) {
                this.setReliability((BEnum)BBacnetReliability.unreliableOther);
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                this.setFaultCause(lex.getText("export.configurationFault"));
                return;
            }
            if (n == 0 || !bEnumRange.isOrdinal(n)) {
                this.setReliability((BEnum)BBacnetReliability.unreliableOther);
                this.setFaultCause("Value out of range:" + n);
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                return;
            }
            this.setReliability((BEnum)BBacnetReliability.noFaultDetected);
            if (this.configOk()) {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
                this.setFaultCause("");
            } else {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
                this.setFaultCause(lex.getText("export.configurationFault"));
            }
        }
    }

    BStatusValue getCurrentStatusValue() {
        BStatusEnum bStatusEnum = new BStatusEnum((BEnum)((BEnumPoint)this.getPoint()).getOut().getValue());
        bStatusEnum.setStatus(this.getStatusFlags());
        return bStatusEnum;
    }

    boolean checkCov(BStatusValue bStatusValue, BStatusValue bStatusValue2) {
        if (bStatusValue.getStatus().getBits() != bStatusValue2.getStatus().getBits()) {
            return true;
        }
        boolean bl = false;
        if (((BStatusEnum)bStatusValue).getEnum().getOrdinal() != ((BStatusEnum)bStatusValue2).getEnum().getOrdinal()) {
            bl = true;
        }
        return bl;
    }

    boolean checkCov(BControlPoint bControlPoint, BBacnetCovSubscription bBacnetCovSubscription) {
        if (bControlPoint.getStatus().getBits() != bBacnetCovSubscription.getLastValue().getStatus().getBits()) {
            return true;
        }
        int n = ((BEnumPoint)bControlPoint).getEnum().getOrdinal();
        int n2 = ((BIEnum)bBacnetCovSubscription.getLastValue()).getEnum().getOrdinal();
        boolean bl = false;
        if (n != n2) {
            bl = true;
        }
        return bl;
    }

    BStatus getStatusFlags() {
        int n = super.getStatusFlags().getBits();
        BEnumPoint bEnumPoint = (BEnumPoint)this.getPoint();
        if (bEnumPoint.getOut().getValue().getOrdinal() <= 0) {
            n |= 2;
        }
        return BStatus.make((int)n);
    }

    private final String[] getTags(BEnumRange bEnumRange) {
        int[] nArray = bEnumRange.getOrdinals();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = bEnumRange.getTag(nArray[n]);
            ++n;
        }
        return stringArray;
    }

    private final int findIndex(int n, int[] nArray) {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PropertyValue readStateText(int n) {
        BEnumRange bEnumRange = (BEnumRange)this.getPoint().getFacets().getFacet("range");
        if (bEnumRange == null) {
            return new NReadPropertyResult(110, n, new NErrorType(2, 32));
        }
        if (n == -1) {
            AsnOutputStream asnOutputStream = asnOut;
            synchronized (asnOutputStream) {
                asnOut.reset();
                int[] nArray = bEnumRange.getOrdinals();
                int n2 = 0;
                while (true) {
                    if (n2 >= nArray.length) {
                        return new NReadPropertyResult(110, n, asnOut.toByteArray());
                    }
                    asnOut.writeCharacterString(SlotPath.unescape((String)bEnumRange.getTag(nArray[n2])));
                    ++n2;
                }
            }
        }
        if (n == 0) {
            return new NReadPropertyResult(110, n, AsnUtil.toAsnUnsigned(bEnumRange.getOrdinals().length));
        }
        try {
            return new NReadPropertyResult(110, n, AsnUtil.toAsnCharacterString(SlotPath.unescape((String)bEnumRange.getTag(n))));
        }
        catch (Exception exception) {
            return new NReadPropertyResult(110, n, new NErrorType(2, 42));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final NErrorType writeStateText(int var1_1, byte[] var2_2, BEnumPoint var3_3) throws BacnetException {
        var4_4 = var3_3.getFacets();
        var5_5 = (BEnumRange)var4_4.getFacet("range");
        if (var5_5 == null) {
            return new NErrorType(2, 32);
        }
        try {
            switch (var1_1) {
                case 0: {
                    return new NErrorType(2, 40);
                }
                case -1: {
                    var6_6 = new Vector<String>();
                    var7_8 = BBacnetMultiStatePointDescriptor.asnIn;
                    synchronized (var7_8) {
                        BBacnetMultiStatePointDescriptor.asnIn.setBuffer(var2_2);
                        var10_9 = BBacnetMultiStatePointDescriptor.asnIn.peekTag();
                        while (true) {
                            if (var10_9 == -1) {
                                break;
                            }
                            var6_6.addElement(BBacnetMultiStatePointDescriptor.asnIn.readCharacterString());
                            var10_9 = BBacnetMultiStatePointDescriptor.asnIn.peekTag();
                        }
                    }
                    if (var6_6.size() != var5_5.getOrdinals().length) {
                        return new NErrorType(2, 45);
                    }
                    var10_10 = new int[var6_6.size()];
                    var11_11 = new String[var6_6.size()];
                    var12_12 = 0;
                    while (true) {
                        if (var12_12 >= var10_10.length) {
                            ** try [egrp 2[TRYBLOCK] [2 : 238->250)] { 
lbl33:
                            // 1 sources

                            break;
                        }
                        var10_10[var12_12] = var12_12 + 1;
                        var11_11[var12_12] = SlotPath.escape((String)((String)var6_6.elementAt(var12_12)));
                        if (var11_11[var12_12].length() == 0) {
                            return new NErrorType(2, 37);
                        }
                        ++var12_12;
                    }
                    {
                        var12_13 = BEnumRange.make((int[])var10_10, (String[])var11_11);
                    }
lbl42:
                    // 1 sources

                    catch (IllegalArgumentException var13_14) {
                        return new NErrorType(2, 37);
                    }
                    var3_3.set(BControlPoint.facets, (BValue)BFacets.make((BFacets)var4_4, (String)"range", (BIDataValue)var12_13), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
            var13_15 = var5_5.getOrdinals();
            var14_16 = this.getTags(var5_5);
            if (var1_1 < 1 || var1_1 > var13_15.length) {
                return new NErrorType(2, 42);
            }
            var15_17 = this.findIndex(var1_1, var13_15);
            if (var15_17 < 0) {
                BBacnetMultiStatePointDescriptor.log.error("MultiStatePointDescriptor.writeStateText: Index not found in ordinal list: " + var1_1);
                return new NErrorType(2, 42);
            }
            var14_16[var15_17] = SlotPath.escape((String)AsnUtil.fromAsnCharacterString(var2_2));
            var3_3.set(BControlPoint.facets, (BValue)BFacets.make((BFacets)var4_4, (String)"range", (BIDataValue)BEnumRange.make((int[])var13_15, (String[])var14_16)), BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        catch (PermissionException var6_7) {
            BBacnetMultiStatePointDescriptor.log.message("PermissionException writing stateText in object " + (Object)this.getObjectId() + ':' + (Object)var6_7);
            return new NErrorType(2, 40);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$export$BBacnetMultiStatePointDescriptor;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BBacnetMultiStatePointDescriptor = BBacnetMultiStatePointDescriptor.class("[Ljavax.baja.bacnet.export.BBacnetMultiStatePointDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"control/enumPoint.png"), (BIcon)BIcon.std((String)"badges/export.png"));
    }
}

