/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import java.util.Vector;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.offnormal.BEnumCommandFailureAlgorithm;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetMultiStateWritableDescriptor;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetMultiStateOutputDescriptor
extends BBacnetMultiStateWritableDescriptor {
    public static final Property objectId = BBacnetMultiStateOutputDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(14));
    public static final Property deviceType = BBacnetMultiStateOutputDescriptor.newProperty((int)0, (String)"", null);
    public static final Type TYPE;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetMultiStateOutputDescriptor;

    public String getDeviceType() {
        return this.getString(deviceType);
    }

    public void setDeviceType(String string) {
        this.setString(deviceType, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BFacets getSlotFacets(Slot slot) {
        if (slot == objectId) {
            return BBacnetObjectType.getObjectIdFacets(14);
        }
        return super.getSlotFacets(slot);
    }

    public BEnum getEventType() {
        return BBacnetEventType.commandFailure;
    }

    public boolean isValidAlarmExt(BIAlarmSource bIAlarmSource) {
        if (bIAlarmSource instanceof BAlarmSourceExt) {
            return ((BAlarmSourceExt)bIAlarmSource).getOffnormalAlgorithm() instanceof BEnumCommandFailureAlgorithm;
        }
        return false;
    }

    protected void addRequiredProps(Vector vector) {
        super.addRequiredProps(vector);
        vector.add(BBacnetPropertyIdentifier.priorityArray);
        vector.add(BBacnetPropertyIdentifier.relinquishDefault);
    }

    protected void addOptionalProps(Vector vector) {
        super.addOptionalProps(vector);
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt != null) {
            vector.add(BBacnetPropertyIdentifier.feedbackValue);
        }
        vector.add(BBacnetPropertyIdentifier.deviceType);
    }

    public RangeData readRange(RangeReference rangeReference) throws RejectException {
        int n = rangeReference.getPropertyId();
        int[] nArray = this.getRequiredProps();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) {
                return new ReadRangeAck(5, 22);
            }
            ++n2;
        }
        nArray = this.getOptionalProps();
        n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) {
                return new ReadRangeAck(5, 22);
            }
            ++n2;
        }
        return new ReadRangeAck(2, 32);
    }

    protected PropertyValue readOptionalProperty(int n, int n2) {
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt != null) {
            BEnumCommandFailureAlgorithm bEnumCommandFailureAlgorithm = (BEnumCommandFailureAlgorithm)bAlarmSourceExt.getOffnormalAlgorithm();
            if (n == 40) {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnUnsigned(bEnumCommandFailureAlgorithm.getFeedbackValue().getValue().getOrdinal()));
            }
        }
        if (n == 31) {
            return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getDeviceType()));
        }
        return super.readOptionalProperty(n, n2);
    }

    protected ErrorType writeOptionalProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        if (n == 31) {
            return new NErrorType(2, 40);
        }
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt != null && n == 40) {
            return new NErrorType(2, 40);
        }
        return super.writeOptionalProperty(n, n2, byArray, n3);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$export$BBacnetMultiStateOutputDescriptor;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BBacnetMultiStateOutputDescriptor = BBacnetMultiStateOutputDescriptor.class("[Ljavax.baja.bacnet.export.BBacnetMultiStateOutputDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

