/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NBacnetPropertyValue;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.stack.DeviceRegistry;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.export.BBacnetScheduleDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.schedule.BControlSchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetEnumScheduleDescriptor
extends BBacnetScheduleDescriptor {
    private static final int LOCAL_UNSIGNED = 0;
    private static final int LOCAL_ENUMERATED = 1;
    private static final int LOCAL_INTEGER = 2;
    private static final BEnumRange ENUM_DATA_TYPE_RANGE = BEnumRange.make((String[])new String[]{AsnUtil.getAsnTypeName(2), AsnUtil.getAsnTypeName(9), AsnUtil.getAsnTypeName(3)});
    public static final Property scheduleDataType = BBacnetEnumScheduleDescriptor.newProperty((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)ENUM_DATA_TYPE_RANGE), null);
    public static final Type TYPE;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetEnumScheduleDescriptor;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetDeviceObjectPropertyReference;

    public BEnum getScheduleDataType() {
        return (BEnum)this.get(scheduleDataType);
    }

    public void setScheduleDataType(BEnum bEnum) {
        this.set(scheduleDataType, (BValue)bEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setScheduleDataType((BEnum)BDynamicEnum.make((int)this.getScheduleDataType().getOrdinal(), (BEnumRange)ENUM_DATA_TYPE_RANGE));
    }

    private final boolean isUnsigned() {
        boolean bl = false;
        if (this.getScheduleDataType().getOrdinal() == 0) {
            bl = true;
        }
        return bl;
    }

    private final boolean isEnumerated() {
        boolean bl = false;
        if (this.getScheduleDataType().getOrdinal() == 1) {
            bl = true;
        }
        return bl;
    }

    private final boolean isInteger() {
        boolean bl = false;
        if (this.getScheduleDataType().getOrdinal() == 2) {
            bl = true;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public void doWritePresentValue() {
        block16: {
            var1_1 = (BEnumSchedule)this.getSchedule();
            var2_2 = null;
            if (var1_1 == null || !var1_1.getEffective().isEffective(BAbsTime.now())) break block16;
            var3_3 = var1_1.getOut();
            var2_2 = AsnUtil.toAsnNull();
            if (!var3_3.getStatus().isNull()) {
                switch (this.getScheduleDataType().getOrdinal()) {
                    case 0: {
                        var2_2 = AsnUtil.toAsnUnsigned(var3_3.getValue().getOrdinal());
                        break;
                    }
                    case 1: {
                        var2_2 = AsnUtil.toAsnEnumerated(var3_3.getValue().getOrdinal());
                        break;
                    }
                    case 2: {
                        var2_2 = AsnUtil.toAsnInteger(var3_3.getValue().getOrdinal());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid Schedule Data Type for " + this + ':' + this.getScheduleDataType().getOrdinal());
                    }
                }
            }
            var5_4 = this.getListOfObjectPropertyReferences().getProperties();
            if (true) ** GOTO lbl41
            do {
                if ((var6_6 = (BBacnetDeviceObjectPropertyReference)var5_4.get()).isDeviceIdUsed()) {
                    var4_5 = DeviceRegistry.getDeviceAddress(var6_6.getDeviceId());
                    if (var4_5 != null) {
                        try {
                            this.client().writeProperty(var4_5, var6_6.getObjectId(), var6_6.getPropertyId(), var6_6.getPropertyArrayIndex(), var2_2, this.getPriorityForWriting());
                        }
                        catch (BacnetException var7_8) {
                            BBacnetEnumScheduleDescriptor.log.warning("BacnetException writing schedule output to " + var6_6 + "::" + (Object)var7_8);
                        }
                    } else {
                        BBacnetEnumScheduleDescriptor.log.warning("Unable to write Schedule output " + var3_3 + " to " + var6_6 + ": unable to resolve device address!");
                    }
                } else {
                    var7_7 = BBacnetNetwork.localDevice().lookupBacnetObject(var6_6.getObjectId());
                    try {
                        var8_9 = var7_7.writeProperty(new NBacnetPropertyValue(var6_6.getPropertyId(), var6_6.getPropertyArrayIndex(), var2_2, this.getPriorityForWriting()));
                        if (var8_9 != null) {
                            throw new ErrorException(var8_9);
                        }
                    }
                    catch (Exception var8_10) {
                        BBacnetEnumScheduleDescriptor.log.warning("Unable to write schedule output " + var3_3 + " from " + this + " to local object " + var6_6 + ": " + var8_10);
                    }
                }
lbl41:
                // 6 sources

                if ((v0 = BBacnetEnumScheduleDescriptor.class$javax$baja$bacnet$datatypes$BBacnetDeviceObjectPropertyReference) != null) continue;
                v0 = BBacnetEnumScheduleDescriptor.class("[Ljavax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;", false);
            } while (var5_4.next(v0));
        }
    }

    final boolean isScheduleTypeLegal(BWeeklySchedule bWeeklySchedule) {
        return bWeeklySchedule instanceof BEnumSchedule;
    }

    int getAsnType() {
        switch (this.getScheduleDataType().getOrdinal()) {
            case 0: {
                return 2;
            }
            case 1: {
                return 9;
            }
            case 2: {
                return 3;
            }
        }
        throw new IllegalStateException("Invalid Schedule Data Type for " + this + ':' + this.getScheduleDataType().getOrdinal());
    }

    final Property getScheduleOutputProperty() {
        return BEnumSchedule.out;
    }

    protected PropertyValue readProperty(int n, int n2) {
        BEnumSchedule bEnumSchedule = (BEnumSchedule)this.getSchedule();
        if (bEnumSchedule == null) {
            return new NReadPropertyResult(n, n2, new NErrorType(1, 1000));
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NReadPropertyResult(n, n2, new NErrorType(2, 50));
        }
        switch (n) {
            case 85: {
                BStatusEnum bStatusEnum = bEnumSchedule.getOut();
                return new NReadPropertyResult(n, n2, this.encodeAsn(bStatusEnum));
            }
            case 174: {
                BStatusEnum bStatusEnum = (BStatusEnum)bEnumSchedule.getDefaultOutput();
                return new NReadPropertyResult(n, n2, this.encodeAsn(bStatusEnum));
            }
        }
        return super.readProperty(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ErrorType writeProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        BEnumSchedule bEnumSchedule = (BEnumSchedule)this.getSchedule();
        if (bEnumSchedule == null) {
            return new NErrorType(1, 1000);
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NErrorType(2, 50);
        }
        try {
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                asnIn.setBuffer(byArray);
                switch (n) {
                    case 85: {
                        if (!((BStatusValue)bEnumSchedule.get("out")).getStatus().isDisabled()) {
                            return new NErrorType(2, 40);
                        }
                        BStatusEnum bStatusEnum = (BStatusEnum)bEnumSchedule.getIn().newCopy();
                        BDynamicEnum bDynamicEnum = bStatusEnum.getValue();
                        switch (asnIn.peekApplicationTag()) {
                            case 0: {
                                bEnumSchedule.getOut().set(BStatusValue.status, (BValue)BStatus.make((BStatus)bEnumSchedule.getOut().getStatus(), (int)64, (boolean)true), BLocalBacnetDevice.getBacnetContext());
                                return null;
                            }
                            case 2: {
                                if (this.isUnsigned()) {
                                    bStatusEnum.setValue(BDynamicEnum.make((int)asnIn.readUnsignedInt(), (BEnumRange)bDynamicEnum.getRange()));
                                    bEnumSchedule.set(BEnumSchedule.in, (BValue)bStatusEnum, BLocalBacnetDevice.getBacnetContext());
                                    return null;
                                }
                            }
                            case 3: {
                                if (this.isInteger()) {
                                    bStatusEnum.setValue(BDynamicEnum.make((int)asnIn.readInteger(), (BEnumRange)bDynamicEnum.getRange()));
                                    bEnumSchedule.set(BEnumSchedule.in, (BValue)bStatusEnum, BLocalBacnetDevice.getBacnetContext());
                                    return null;
                                }
                            }
                            case 9: {
                                if (!this.isEnumerated()) break;
                                bStatusEnum.setValue(BDynamicEnum.make((int)asnIn.readEnumerated(), (BEnumRange)bDynamicEnum.getRange()));
                                bEnumSchedule.set(BEnumSchedule.in, (BValue)bStatusEnum, BLocalBacnetDevice.getBacnetContext());
                                return null;
                            }
                        }
                        return new NErrorType(2, 47);
                    }
                    case 174: {
                        BStatusEnum bStatusEnum = (BStatusEnum)bEnumSchedule.getDefaultOutput().newCopy();
                        BDynamicEnum bDynamicEnum = bStatusEnum.getValue();
                        switch (asnIn.peekApplicationTag()) {
                            case 0: {
                                bEnumSchedule.getDefaultOutput().set(BStatusValue.status, (BValue)BStatus.make((BStatus)bEnumSchedule.getDefaultOutput().getStatus(), (int)64, (boolean)true), BLocalBacnetDevice.getBacnetContext());
                                return null;
                            }
                            case 2: {
                                if (this.isUnsigned()) {
                                    bStatusEnum.setValue(BDynamicEnum.make((int)asnIn.readUnsignedInt(), (BEnumRange)bDynamicEnum.getRange()));
                                    bStatusEnum.setStatusNull(false);
                                    bEnumSchedule.set(BControlSchedule.defaultOutput, (BValue)bStatusEnum, BLocalBacnetDevice.getBacnetContext());
                                    return null;
                                }
                            }
                            case 3: {
                                if (this.isInteger()) {
                                    bStatusEnum.setValue(BDynamicEnum.make((int)asnIn.readInteger(), (BEnumRange)bDynamicEnum.getRange()));
                                    bStatusEnum.setStatusNull(false);
                                    bEnumSchedule.set(BControlSchedule.defaultOutput, (BValue)bStatusEnum, BLocalBacnetDevice.getBacnetContext());
                                    return null;
                                }
                            }
                            case 9: {
                                if (!this.isEnumerated()) break;
                                bStatusEnum.setValue(BDynamicEnum.make((int)asnIn.readEnumerated(), (BEnumRange)bDynamicEnum.getRange()));
                                bStatusEnum.setStatusNull(false);
                                bEnumSchedule.set(BControlSchedule.defaultOutput, (BValue)bStatusEnum, BLocalBacnetDevice.getBacnetContext());
                                return null;
                            }
                        }
                        return new NErrorType(2, 47);
                    }
                }
                return super.writeProperty(n, n2, byArray, n3);
            }
        }
        catch (AsnException asnException) {
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)asnException));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
        catch (Exception exception) {
            log.message("Exception writing property " + n + " in object " + (Object)((Object)this.getObjectId()), (Throwable)exception);
            return new NErrorType(2, 0);
        }
    }

    private final byte[] encodeAsn(BStatusEnum bStatusEnum) {
        if (bStatusEnum.getStatus().isNull()) {
            return AsnUtil.toAsnNull();
        }
        int n = bStatusEnum.getValue().getOrdinal();
        switch (this.getScheduleDataType().getOrdinal()) {
            case 0: {
                return AsnUtil.toAsnUnsigned(n);
            }
            case 1: {
                return AsnUtil.toAsnEnumerated(n);
            }
            case 2: {
                return AsnUtil.toAsnInteger(n);
            }
        }
        throw new IllegalStateException("Invalid Schedule Data Type for " + this + ':' + this.getScheduleDataType().getOrdinal());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$export$BBacnetEnumScheduleDescriptor;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BBacnetEnumScheduleDescriptor = BBacnetEnumScheduleDescriptor.class("[Ljavax.baja.bacnet.export.BBacnetEnumScheduleDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

