/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.schedule.ScheduleSupport0;
import com.tridium.bacnet.schedule.ScheduleSupport4;
import com.tridium.bacnet.services.BacnetConfirmedRequest;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.services.error.NChangeListError;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetCalendarDescriptor
extends BComponent
implements BIBacnetExportObject {
    public static final Property status = BBacnetCalendarDescriptor.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property faultCause = BBacnetCalendarDescriptor.newProperty((int)3, (String)"", null);
    public static final Property calendarOrd = BBacnetCalendarDescriptor.newProperty((int)64, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"targetType", (String)"baja:Component"));
    public static final Property objectId = BBacnetCalendarDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(6), null);
    public static final Property objectName = BBacnetCalendarDescriptor.newProperty((int)64, (String)"", null);
    public static final Property description = BBacnetCalendarDescriptor.newProperty((int)0, (String)"", null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static AsnInputStream asnIn;
    private static AsnOutputStream asnOut;
    private static ScheduleSupport0 supp;
    private static Log log;
    private static final int[] REQUIRED_PROPS;
    private static final int[] OPTIONAL_PROPS;
    private boolean fatalFault;
    private BCalendarSchedule calendar;
    private BBacnetObjectIdentifier oldId;
    private String oldName;
    private boolean duplicate;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetCalendarDescriptor;
    static /* synthetic */ Class class$javax$baja$schedule$BAbstractSchedule;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BOrd getCalendarOrd() {
        return (BOrd)this.get(calendarOrd);
    }

    public void setCalendarOrd(BOrd bOrd) {
        this.set(calendarOrd, (BValue)bOrd, null);
    }

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public String getObjectName() {
        return this.getString(objectName);
    }

    public void setObjectName(String string) {
        this.setString(objectName, string, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String string) {
        this.setString(description, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        super.started();
        this.checkFatalFault();
        this.oldId = this.getObjectId();
        this.oldName = this.getObjectName();
        this.checkConfiguration();
        if (Sys.isStationStarted() && this.getStatus().isOk()) {
            BBacnetNetwork.localDevice().incrementDatabaseRevision();
        }
    }

    public final void stopped() throws Exception {
        super.stopped();
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        bLocalBacnetDevice.unexport(this.oldId, this.oldName, this);
        this.oldId = null;
        this.oldName = null;
        if (this.getStatus().isOk() && bLocalBacnetDevice.isRunning()) {
            bLocalBacnetDevice.incrementDatabaseRevision();
        }
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)objectId)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldId = this.getObjectId();
            try {
                ((BComponent)this.getParent()).rename(this.getPropertyInParent(), this.getObjectId().toString(BacnetConst.nameContext));
            }
            catch (DuplicateSlotException duplicateSlotException) {}
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)objectName)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldName = this.getObjectName();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.equals((Object)calendarOrd)) {
            this.checkConfiguration();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (property.getName() == "protocolRevision") {
            this.setSupport(((BInteger)this.get("protocolRevision")).getInt());
        }
    }

    private final void setSupport(int n) {
        if (n >= 4) {
            if (!(supp instanceof ScheduleSupport4)) {
                supp = new ScheduleSupport4();
            }
        } else if (supp instanceof ScheduleSupport4) {
            supp = new ScheduleSupport0();
        }
        System.out.println("Server calendar support (new) is now " + supp.getClass());
    }

    public final BFacets getSlotFacets(Slot slot) {
        if (slot == objectId) {
            return BBacnetObjectType.getObjectIdFacets(6);
        }
        return super.getSlotFacets(slot);
    }

    public final BObject getObject() {
        return this.getCalendar();
    }

    public final BOrd getObjectOrd() {
        return this.getCalendarOrd();
    }

    public final void setObjectOrd(BOrd bOrd, Context context) {
        this.set(calendarOrd, (BValue)bOrd, context);
    }

    public void checkConfiguration() {
        BLocalBacnetDevice bLocalBacnetDevice = BBacnetNetwork.localDevice();
        if (this.isFatalFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        this.findCalendar();
        bLocalBacnetDevice.unsubscribe(this, this.calendar);
        boolean bl = true;
        if (this.calendar == null) {
            this.setFaultCause("Cannot find exported calendar");
            bl = false;
        } else {
            bLocalBacnetDevice.subscribe(this, this.calendar);
        }
        if (!this.getObjectId().isValid()) {
            this.setFaultCause("Invalid Object ID");
            bl = false;
        }
        if (bl) {
            String string = bLocalBacnetDevice.export(this);
            if (string != null) {
                this.duplicate = true;
                this.setFaultCause(string);
                bl = false;
            } else {
                this.duplicate = false;
            }
        }
        if (bl) {
            this.setFaultCause("");
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)(bl ^ true)));
    }

    public final PropertyValue readProperty(PropertyReference propertyReference) throws RejectException {
        this.getCalendar();
        return this.readProperty(propertyReference.getPropertyId(), propertyReference.getPropertyArrayIndex());
    }

    public final PropertyValue[] readPropertyMultiple(PropertyReference[] propertyReferenceArray) throws RejectException {
        this.getCalendar();
        PropertyValue[] propertyValueArray = new PropertyValue[]{};
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(propertyReferenceArray.length);
        int n = 0;
        while (n < propertyReferenceArray.length) {
            switch (propertyReferenceArray[n].getPropertyId()) {
                case 8: {
                    int[] nArray = REQUIRED_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    nArray = OPTIONAL_PROPS;
                    n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                case 80: {
                    int[] nArray = OPTIONAL_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                case 105: {
                    int[] nArray = REQUIRED_PROPS;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        arrayList.add(this.readProperty(nArray[n2], -1));
                        ++n2;
                    }
                    break;
                }
                default: {
                    arrayList.add(this.readProperty(propertyReferenceArray[n].getPropertyId(), propertyReferenceArray[n].getPropertyArrayIndex()));
                }
            }
            ++n;
        }
        return arrayList.toArray(propertyValueArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RangeData readRange(RangeReference var1_1) throws RejectException {
        block34: {
            this.getCalendar();
            if (this.calendar == null) {
                return new ReadRangeAck(1, 1000);
            }
            switch (var1_1.getPropertyId()) {
                case 23: {
                    var2_2 = var1_1.getRangeType();
                    var3_3 = -1;
                    if (var1_1 instanceof BacnetConfirmedRequest) {
                        var3_3 = ((BacnetConfirmedRequest)var1_1).getMaxDataLength() - 23 + 3 + 5;
                    }
                    var4_4 = new boolean[3];
                    v0 = BBacnetCalendarDescriptor.class$javax$baja$schedule$BAbstractSchedule;
                    if (v0 == null) {
                        v0 = BBacnetCalendarDescriptor.class$javax$baja$schedule$BAbstractSchedule = BBacnetCalendarDescriptor.class("[Ljavax.baja.schedule.BAbstractSchedule;", false);
                    }
                    var5_5 = (BAbstractSchedule[])this.calendar.getChildren(v0);
                    var6_6 = var5_5.length;
                    if (var2_2 != 3) ** GOTO lbl35
                    var7_7 = (int)var1_1.getReferenceIndex();
                    var8_9 = var1_1.getCount();
                    if (var7_7 > var6_6 || var7_7 < 1) {
                        return new ReadRangeAck(this.getObjectId(), var1_1.getPropertyId(), -1, BBacnetBitString.emptyBitString(3), 0L, new byte[0]);
                    }
                    v1 = BBacnetCalendarDescriptor.class$javax$baja$schedule$BAbstractSchedule;
                    if (v1 == null) {
                        v1 = BBacnetCalendarDescriptor.class$javax$baja$schedule$BAbstractSchedule = BBacnetCalendarDescriptor.class("[Ljavax.baja.schedule.BAbstractSchedule;", false);
                    }
                    var9_11 = new Array(v1);
                    var10_12 = 0;
                    if (var8_9 <= 0) ** GOTO lbl30
                    var11_13 = var7_7 - 1;
                    if (true) ** GOTO lbl77
lbl30:
                    // 1 sources

                    if (var8_9 >= 0) {
                        return new ReadRangeAck(5, 7);
                    }
                    var8_9 = -var8_9;
                    var11_13 = var7_7 - 1;
                    if (true) ** GOTO lbl88
lbl35:
                    // 1 sources

                    if (var2_2 != -1) {
                        return new ReadRangeAck(5, 7);
                    }
                    var4_4[0] = true;
                    var7_8 = 0;
                    var8_10 = BBacnetCalendarDescriptor.asnOut;
                    synchronized (var8_10) {
                        BBacnetCalendarDescriptor.asnOut.reset();
                        if (var3_3 > 0) {
                            var11_15 = 0;
                        }
                        ** GOTO lbl58
                        while (var11_15 < var6_6) {
                            BBacnetCalendarDescriptor.supp.encodeCalendarEntry(var5_5[var11_15], BBacnetCalendarDescriptor.asnOut);
                            ++var7_8;
                            if (var3_3 - BBacnetCalendarDescriptor.asnOut.size() < 12) break;
                            ++var11_15;
                        }
                        if (var7_8 == var6_6) {
                            var4_4[1] = true;
                        }
                        ** GOTO lbl67
lbl58:
                        // 1 sources

                        var7_8 = var6_6;
                        var11_16 = 0;
                        while (true) {
                            if (var11_16 >= var6_6) {
                                var4_4[1] = true;
                                break;
                            }
                            BBacnetCalendarDescriptor.supp.encodeCalendarEntry(var5_5[var11_16], BBacnetCalendarDescriptor.asnOut);
                            ++var11_16;
                        }
lbl67:
                        // 2 sources

                        if (var7_8 < var6_6) {
                            var4_4[2] = true;
                        }
                        return new ReadRangeAck(this.getObjectId(), var1_1.getPropertyId(), -1, BBacnetBitString.make(var4_4), (long)var7_8, BBacnetCalendarDescriptor.asnOut.toByteArray());
                    }
                }
                default: {
                    return new ReadRangeAck(2, 22);
                }
            }
            do {
                var9_11.add((Object)var5_5[var11_13]);
                ++var10_12;
                ++var11_13;
lbl77:
                // 2 sources

            } while (var11_13 < var6_6 && var10_12 < var8_9);
            if (var7_7 == 1) {
                var4_4[0] = true;
            }
            if (var7_7 + var8_9 - 1 >= var6_6) {
                var4_4[1] = true;
            }
            break block34;
            do {
                var9_11.add((Object)var5_5[var11_13]);
                ++var10_12;
                --var11_13;
lbl88:
                // 2 sources

            } while (var11_13 >= 0 && var10_12 < var8_9);
            var9_11 = var9_11.reverse();
            if (var7_7 - var8_9 <= 0) {
                var4_4[0] = true;
            }
            if (var7_7 == var6_6) {
                var4_4[1] = true;
            }
        }
        var11_14 = var9_11.iterator();
        var12_17 = 0;
        var13_18 = BBacnetCalendarDescriptor.asnOut;
        synchronized (var13_18) {
            block33: {
                block32: {
                    BBacnetCalendarDescriptor.asnOut.reset();
                    if (var3_3 <= 0) break block32;
                    while (var11_14.hasNext()) {
                        if (var3_3 - BBacnetCalendarDescriptor.asnOut.size() < 12) {
                            var4_4[1] = false;
                            break block33;
                        }
                        BBacnetCalendarDescriptor.supp.encodeCalendarEntry((BAbstractSchedule)var11_14.next(), BBacnetCalendarDescriptor.asnOut);
                        ++var12_17;
                    }
                    break block33;
                }
                var12_17 = var10_12;
                while (var11_14.hasNext()) {
                    BBacnetCalendarDescriptor.supp.encodeCalendarEntry((BAbstractSchedule)var11_14.next(), BBacnetCalendarDescriptor.asnOut);
                }
            }
            if (var12_17 < var10_12) {
                var4_4[2] = true;
            }
            return new ReadRangeAck(this.getObjectId(), var1_1.getPropertyId(), -1, BBacnetBitString.make(var4_4), (long)var12_17, BBacnetCalendarDescriptor.asnOut.toByteArray());
        }
    }

    public final ErrorType writeProperty(PropertyValue propertyValue) throws BacnetException {
        this.getCalendar();
        return this.writeProperty(propertyValue.getPropertyId(), propertyValue.getPropertyArrayIndex(), propertyValue.getPropertyValue(), propertyValue.getPriority());
    }

    public final ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        BCalendarSchedule bCalendarSchedule = this.getCalendar();
        if (bCalendarSchedule == null) {
            return new NChangeListError(8, new NErrorType(1, 1000), 0L);
        }
        int n = propertyValue.getPropertyId();
        if (n == 23) {
            if (propertyValue.getPropertyArrayIndex() >= 0) {
                return new NChangeListError(8, new NErrorType(2, 50), 0L);
            }
            return this.addDates(propertyValue);
        }
        int n2 = 0;
        while (n2 < REQUIRED_PROPS.length) {
            if (n == REQUIRED_PROPS[n2]) {
                return new NChangeListError(8, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < OPTIONAL_PROPS.length) {
            if (n == OPTIONAL_PROPS[n2]) {
                return new NChangeListError(8, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        return new NChangeListError(8, new NErrorType(2, 32), 0L);
    }

    public final ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        BCalendarSchedule bCalendarSchedule = this.getCalendar();
        if (bCalendarSchedule == null) {
            return new NChangeListError(9, new NErrorType(1, 1000), 0L);
        }
        int n = propertyValue.getPropertyId();
        if (n == 23) {
            if (propertyValue.getPropertyArrayIndex() >= 0) {
                return new NChangeListError(9, new NErrorType(2, 50), 0L);
            }
            return this.removeDates(propertyValue);
        }
        int n2 = 0;
        while (n2 < REQUIRED_PROPS.length) {
            if (n == REQUIRED_PROPS[n2]) {
                return new NChangeListError(9, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < OPTIONAL_PROPS.length) {
            if (n == OPTIONAL_PROPS[n2]) {
                return new NChangeListError(9, new NErrorType(5, 22), 0L);
            }
            ++n2;
        }
        return new NChangeListError(9, new NErrorType(2, 32), 0L);
    }

    protected PropertyValue readProperty(int n, int n2) {
        if (this.calendar == null) {
            return new NReadPropertyResult(n, n2, new NErrorType(1, 1000));
        }
        if (n2 >= 0) {
            return new NReadPropertyResult(n, n2, new NErrorType(2, 50));
        }
        switch (n) {
            case 75: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnObjectId(this.getObjectId()));
            }
            case 77: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getObjectName()));
            }
            case 79: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(this.getObjectId().getObjectType()));
            }
            case 85: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnBoolean(this.calendar.getOut().getValue()));
            }
            case 23: {
                return this.readDateList(n2);
            }
            case 28: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getDescription()));
            }
        }
        return new NReadPropertyResult(n, n2, new NErrorType(2, 32));
    }

    protected ErrorType writeProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        if (this.calendar == null) {
            return new NErrorType(1, 1000);
        }
        if (n2 >= 0) {
            return new NErrorType(5, 7);
        }
        try {
            switch (n) {
                case 75: {
                    return new NErrorType(2, 40);
                }
                case 77: {
                    return BacUtil.setObjectName(this, objectName, byArray);
                }
                case 79: {
                    return new NErrorType(2, 40);
                }
                case 85: {
                    return new NErrorType(2, 40);
                }
                case 23: {
                    return this.writeDateList(byArray);
                }
                case 28: {
                    this.setString(description, AsnUtil.fromAsnCharacterString(byArray), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
            return new NErrorType(2, 32);
        }
        catch (AsnException asnException) {
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
    }

    public String toString(Context context) {
        return this.getObjectName() + " [" + (Object)((Object)this.getObjectId()) + ']';
    }

    protected final BCalendarSchedule getCalendar() {
        if (this.calendar == null) {
            return this.findCalendar();
        }
        return this.calendar;
    }

    private final BCalendarSchedule findCalendar() {
        try {
            if (!calendarOrd.isEquivalentToDefaultValue((BValue)this.getCalendarOrd())) {
                BObject bObject = this.getCalendarOrd().get((BObject)this);
                this.calendar = bObject instanceof BCalendarSchedule ? (BCalendarSchedule)bObject : null;
            }
        }
        catch (Exception exception) {
            log.warning("Unable to resolve calendar ord for " + this + ": " + this.getCalendarOrd());
            this.calendar = null;
        }
        if (this.calendar == null && this.isRunning()) {
            this.setFaultCause("Cannot find exported calendar");
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        }
        return this.calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final NReadPropertyResult readDateList(int n) {
        AsnOutputStream asnOutputStream = asnOut;
        synchronized (asnOutputStream) {
            asnOut.reset();
            supp.encodeDateList(this.calendar, asnOut);
            return new NReadPropertyResult(23, n, asnOut.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ErrorType writeDateList(byte[] byArray) {
        try {
            AsnInputStream asnInputStream = asnIn;
            synchronized (asnInputStream) {
                asnIn.setBuffer(byArray);
                BCalendarSchedule bCalendarSchedule = supp.decodeDateList(asnIn);
                boolean bl = this.calendar.getCleanupExpiredEvents();
                bCalendarSchedule.setCleanupExpiredEvents(bl);
                this.calendar.copyFrom((BAbstractSchedule)bCalendarSchedule, BLocalBacnetDevice.getBacnetContext());
                return null;
            }
        }
        catch (AsnException asnException) {
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing datelist in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
        catch (Exception exception) {
            log.message("Exception writing datelist in object " + (Object)((Object)this.getObjectId()), (Throwable)exception);
            return new NErrorType(2, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ChangeListError addDates(PropertyValue propertyValue) {
        AsnInputStream asnInputStream;
        int n = 1;
        Vector<BAbstractSchedule> vector = new Vector<BAbstractSchedule>();
        try {
            asnInputStream = asnIn;
            synchronized (asnInputStream) {
                asnIn.setBuffer(propertyValue.getPropertyValue());
                while (asnIn.peekTag() != -1) {
                    BAbstractSchedule bAbstractSchedule = supp.decodeCalendarEntry(asnIn);
                    if (bAbstractSchedule != null) {
                        vector.addElement(bAbstractSchedule);
                    }
                    ++n;
                }
            }
        }
        catch (AsnException asnException) {
            if (log.isTraceOn()) {
                asnException.printStackTrace();
            }
            return new NChangeListError(8, new NErrorType(2, 9), n);
        }
        try {
            Iterator iterator = vector.iterator();
            while (true) {
                boolean bl;
                BAbstractSchedule bAbstractSchedule;
                block17: {
                    if (!iterator.hasNext()) {
                        return null;
                    }
                    bAbstractSchedule = (BAbstractSchedule)iterator.next();
                    asnInputStream = this.calendar.getProperties();
                    bl = false;
                    do {
                        Class clazz;
                        if ((clazz = class$javax$baja$schedule$BAbstractSchedule) == null) {
                            clazz = BBacnetCalendarDescriptor.class("[Ljavax.baja.schedule.BAbstractSchedule;", false);
                        }
                        if (!asnInputStream.next(clazz)) break block17;
                    } while (!bAbstractSchedule.equivalent((Object)asnInputStream.get()));
                    bl = true;
                }
                if (bl) continue;
                this.calendar.add(null, (BValue)bAbstractSchedule, BLocalBacnetDevice.getBacnetContext());
            }
        }
        catch (PermissionException permissionException) {
            log.trace("PermissionException adding elements to datelist in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NChangeListError(8, new NErrorType(2, 40), 0L);
        }
        catch (Exception exception) {
            log.message("Exception adding elements to datelist in object " + (Object)((Object)this.getObjectId()) + ':' + exception);
            return new NChangeListError(8, new NErrorType(2, 0), n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ChangeListError removeDates(PropertyValue var1_1) {
        var2_2 = 1;
        var3_3 = new Vector<BAbstractSchedule>();
        try {
            var4_4 = BBacnetCalendarDescriptor.asnIn;
            synchronized (BBacnetCalendarDescriptor.asnIn) {
                BBacnetCalendarDescriptor.asnIn.setBuffer(var1_1.getPropertyValue());
                while (true) {
                    if (BBacnetCalendarDescriptor.asnIn.peekTag() == -1) {
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        break;
                    }
                    var7_8 = BBacnetCalendarDescriptor.supp.decodeCalendarEntry(BBacnetCalendarDescriptor.asnIn);
                    if (var7_8 != null) {
                        var3_3.addElement(var7_8);
                    }
                    ++var2_2;
                }
            }
        }
        catch (AsnException var4_5) {
            if (BBacnetCalendarDescriptor.log.isTraceOn()) {
                var4_5.printStackTrace();
            }
            return new NChangeListError(9, new NErrorType(2, 9), var2_2);
        }
        {
            try {
                var4_4 = this.calendar.getSchedules();
                var2_2 = 1;
                while (true) {
                    block20: {
                        if (var2_2 <= var3_3.size()) break block20;
                        var2_2 = 0;
                        if (true) ** GOTO lbl63
                    }
                    var5_10 = (BAbstractSchedule)var3_3.get(var2_2 - 1);
                    var6_11 = 0;
                    var7_9 = 0;
                    while (var7_9 < var4_4.length) {
                        if (var5_10.equivalent((Object)var4_4[var7_9])) {
                            var6_11 = 1;
                            break;
                        }
                        ++var7_9;
                    }
                    if (var6_11 == 0) {
                        return new NChangeListError(9, new NErrorType(5, 81), var2_2);
                    }
                    ++var2_2;
                }
            }
            catch (PermissionException var4_6) {
                BBacnetCalendarDescriptor.log.trace("PermissionException removing elements from datelist in object " + (Object)this.getObjectId() + ':' + (Object)var4_6);
                return new NChangeListError(9, new NErrorType(2, 40), 0L);
            }
            catch (Exception var4_7) {
                BBacnetCalendarDescriptor.log.message("Exception removing elements from datelist in object " + (Object)this.getObjectId(), (Throwable)var4_7);
                return new NChangeListError(9, new NErrorType(2, 0), 0L);
            }
            do {
                var5_10 = (BAbstractSchedule)var3_3.get(var2_2);
                var6_11 = 0;
                while (var6_11 < var4_4.length) {
                    if (var5_10.equivalent((Object)var4_4[var6_11])) {
                        this.calendar.remove((BComplex)var4_4[var6_11]);
                        break;
                    }
                    ++var6_11;
                }
                ++var2_2;
lbl63:
                // 2 sources

            } while (var2_2 < var3_3.size());
            return null;
        }
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    private final void checkFatalFault() {
        BBacnetExportTable bBacnetExportTable = null;
        BLocalBacnetDevice bLocalBacnetDevice = null;
        BBacnetNetwork bBacnetNetwork = null;
        if (this.fatalFault) {
            return;
        }
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BBacnetExportTable) {
                bBacnetExportTable = (BBacnetExportTable)bComplex;
            } else if (bComplex instanceof BLocalBacnetDevice) {
                bLocalBacnetDevice = (BLocalBacnetDevice)bComplex;
                break;
            }
            bComplex = bComplex.getParent();
        }
        if (bBacnetExportTable == null || bLocalBacnetDevice == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under LocalBacnetDevice Export Table");
            return;
        }
        if (bLocalBacnetDevice.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("LocalDevice fault: " + bLocalBacnetDevice.getFaultCause());
            return;
        }
        bBacnetNetwork = (BBacnetNetwork)bLocalBacnetDevice.getParent();
        if (bBacnetNetwork == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under BacnetNetwork");
            return;
        }
        if (bBacnetNetwork.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + bBacnetNetwork.getFaultCause());
            return;
        }
        Feature feature = bBacnetNetwork.getLicenseFeature();
        boolean bl = feature.getb("export", false);
        if (!bl) {
            this.fatalFault = true;
            this.setFaultCause("Server capability not licensed");
            return;
        }
        this.setFaultCause("");
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetCalendarDescriptor", 2);
        spyWriter.prop((Object)"fatalFault", this.fatalFault);
        spyWriter.prop((Object)"calendar", (Object)this.calendar);
        spyWriter.prop((Object)"oldId", (Object)this.oldId);
        spyWriter.prop((Object)"oldName", (Object)this.oldName);
        spyWriter.prop((Object)"duplicate", this.duplicate);
        spyWriter.prop((Object)"supp", (Object)supp);
        spyWriter.endProps();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.fatalFault = false;
        this.oldId = null;
        this.oldName = null;
        this.duplicate = false;
    }

    public BBacnetCalendarDescriptor() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$bacnet$export$BBacnetCalendarDescriptor;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BBacnetCalendarDescriptor = BBacnetCalendarDescriptor.class("[Ljavax.baja.bacnet.export.BBacnetCalendarDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"calendar.png"), (BIcon)BIcon.std((String)"badges/export.png"));
        asnIn = new AsnInputStream();
        asnOut = new AsnOutputStream();
        supp = new ScheduleSupport4();
        log = Log.getLog((String)"bacnet.server");
        REQUIRED_PROPS = new int[]{75, 77, 79, 85, 23};
        OPTIONAL_PROPS = new int[]{28};
    }
}

