/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.Vector;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.offnormal.BBooleanCommandFailureAlgorithm;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetBinaryWritableDescriptor;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.control.BBooleanWritable;
import javax.baja.security.PermissionException;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetBinaryOutputDescriptor
extends BBacnetBinaryWritableDescriptor {
    public static final Property objectId = BBacnetBinaryOutputDescriptor.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(4));
    public static final Property deviceType = BBacnetBinaryOutputDescriptor.newProperty((int)0, (String)"", null);
    public static final Type TYPE;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetBinaryOutputDescriptor;

    public String getDeviceType() {
        return this.getString(deviceType);
    }

    public void setDeviceType(String string) {
        this.setString(deviceType, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BFacets getSlotFacets(Slot slot) {
        if (slot == objectId) {
            return BBacnetObjectType.getObjectIdFacets(4);
        }
        return super.getSlotFacets(slot);
    }

    public BEnum getEventType() {
        return BBacnetEventType.commandFailure;
    }

    public boolean isValidAlarmExt(BIAlarmSource bIAlarmSource) {
        if (bIAlarmSource instanceof BAlarmSourceExt) {
            return ((BAlarmSourceExt)bIAlarmSource).getOffnormalAlgorithm() instanceof BBooleanCommandFailureAlgorithm;
        }
        return false;
    }

    protected PropertyValue readProperty(int n, int n2) {
        BBooleanWritable bBooleanWritable = (BBooleanWritable)this.getPoint();
        if (bBooleanWritable == null) {
            return new NReadPropertyResult(n, n2, new NErrorType(1, 1000));
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NReadPropertyResult(n, n2, new NErrorType(2, 50));
        }
        switch (n) {
            case 85: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(bBooleanWritable.getOut().getValue()));
            }
            case 84: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(0));
            }
        }
        return super.readProperty(n, n2);
    }

    protected ErrorType writeProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        BBooleanWritable bBooleanWritable = (BBooleanWritable)this.getPoint();
        if (bBooleanWritable == null) {
            return new NErrorType(1, 1000);
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (n) {
                case 84: {
                    return new NErrorType(2, 40);
                }
            }
            return super.writeProperty(n, n2, byArray, n3);
        }
        catch (AsnException asnException) {
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
    }

    protected void addRequiredProps(Vector vector) {
        super.addRequiredProps(vector);
        vector.add(BBacnetPropertyIdentifier.polarity);
    }

    protected void addOptionalProps(Vector vector) {
        super.addOptionalProps(vector);
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt != null) {
            vector.add(BBacnetPropertyIdentifier.feedbackValue);
        }
        vector.add(BBacnetPropertyIdentifier.deviceType);
    }

    protected PropertyValue readOptionalProperty(int n, int n2) {
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt != null) {
            BBooleanCommandFailureAlgorithm bBooleanCommandFailureAlgorithm = (BBooleanCommandFailureAlgorithm)bAlarmSourceExt.getOffnormalAlgorithm();
            if (n == 40) {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnEnumerated(bBooleanCommandFailureAlgorithm.getFeedbackValue().getValue()));
            }
        }
        if (n == 31) {
            return new NReadPropertyResult(n, n2, AsnUtil.toAsnCharacterString(this.getDeviceType()));
        }
        return super.readOptionalProperty(n, n2);
    }

    protected ErrorType writeOptionalProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        if (n == 31) {
            return new NErrorType(2, 40);
        }
        BAlarmSourceExt bAlarmSourceExt = this.getAlarmExt();
        if (bAlarmSourceExt != null && n == 40) {
            return new NErrorType(2, 40);
        }
        return super.writeOptionalProperty(n, n2, byArray, n3);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$export$BBacnetBinaryOutputDescriptor;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BBacnetBinaryOutputDescriptor = BBacnetBinaryOutputDescriptor.class("[Ljavax.baja.bacnet.export.BBacnetBinaryOutputDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

