/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.export;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.export.BBacnetAnalogPointDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.enums.BPriorityLevel;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BComplex;
import javax.baja.sys.BLink;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BBacnetAnalogWritableDescriptor
extends BBacnetAnalogPointDescriptor {
    public static final Property bacnetWritable = BBacnetAnalogWritableDescriptor.newProperty((int)5, (String)lexNotWritable, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$javax$baja$bacnet$export$BBacnetAnalogWritableDescriptor;
    static /* synthetic */ Class class$javax$baja$status$BStatusNumeric;

    public String getBacnetWritable() {
        return this.getString(bacnetWritable);
    }

    public void setBacnetWritable(String string) {
        this.setString(bacnetWritable, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected final boolean isPointTypeLegal(BControlPoint bControlPoint) {
        return bControlPoint instanceof BNumericWritable;
    }

    protected boolean isCommandable() {
        return true;
    }

    protected PropertyValue readProperty(int n, int n2) {
        BNumericWritable bNumericWritable = (BNumericWritable)this.getPoint();
        if (bNumericWritable == null) {
            return new NReadPropertyResult(n, n2, new NErrorType(1, 1000));
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NReadPropertyResult(n, n2, new NErrorType(2, 50));
        }
        switch (n) {
            case 87: {
                return this.readPriorityArray(n2);
            }
            case 104: {
                return new NReadPropertyResult(n, n2, AsnUtil.toAsnReal(bNumericWritable.getFallback().getValue()));
            }
        }
        return super.readProperty(n, n2);
    }

    protected ErrorType writeProperty(int n, int n2, byte[] byArray, int n3) throws BacnetException {
        BNumericWritable bNumericWritable = (BNumericWritable)this.getPoint();
        if (bNumericWritable == null) {
            return new NErrorType(1, 1000);
        }
        if (n2 >= 0 && !this.isArray(n)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (n) {
                case 85: {
                    return this.writePriorityArray(n3, byArray);
                }
                case 87: {
                    return new NErrorType(2, 40);
                }
                case 104: {
                    BNumber bNumber = (BNumber)this.getPoint().getFacets().getFacet("min");
                    BNumber bNumber2 = (BNumber)this.getPoint().getFacets().getFacet("max");
                    double d = bNumber != null ? bNumber.getDouble() : Double.NEGATIVE_INFINITY;
                    double d2 = bNumber2 != null ? bNumber2.getDouble() : Double.POSITIVE_INFINITY;
                    double d3 = Double.NaN;
                    d3 = AsnUtil.fromAsnReal(byArray);
                    if (d3 < d || d3 > d2) {
                        return new NErrorType(2, 37);
                    }
                    bNumericWritable.getFallback().setDouble(BStatusNumeric.value, (double)AsnUtil.fromAsnReal(byArray), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
            }
        }
        catch (AsnException asnException) {
            log.message("AsnException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)asnException));
            return new NErrorType(2, 9);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing property " + n + " in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
        return super.writeProperty(n, n2, byArray, n3);
    }

    protected void addRequiredProps(Vector vector) {
        super.addRequiredProps(vector);
        vector.add(BBacnetPropertyIdentifier.priorityArray);
        vector.add(BBacnetPropertyIdentifier.relinquishDefault);
    }

    protected void addOptionalProps(Vector vector) {
        super.addOptionalProps(vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final PropertyValue readPriorityArray(int n) {
        BNumericWritable bNumericWritable = (BNumericWritable)this.getPoint();
        if (bNumericWritable == null) {
            return new NReadPropertyResult(87, n, new NErrorType(1, 1000));
        }
        if (n == -1) {
            AsnOutputStream asnOutputStream = asnOut;
            synchronized (asnOutputStream) {
                asnOut.reset();
                int n2 = 1;
                while (true) {
                    if (n2 > 16) {
                        return new NReadPropertyResult(87, n, asnOut.toByteArray());
                    }
                    BStatusNumeric bStatusNumeric = bNumericWritable.getLevel(BPriorityLevel.make((int)n2));
                    if (bStatusNumeric.getStatus().isNull()) {
                        asnOut.writeNull();
                    } else {
                        asnOut.writeReal(bStatusNumeric.getValue());
                    }
                    ++n2;
                }
            }
        }
        if (n == 0) {
            return new NReadPropertyResult(87, n, AsnUtil.toAsnUnsigned(16L));
        }
        try {
            BStatusNumeric bStatusNumeric = bNumericWritable.getLevel(BPriorityLevel.make((int)n));
            if (bStatusNumeric.getStatus().isNull()) {
                return new NReadPropertyResult(87, n, AsnUtil.toAsnNull());
            }
            return new NReadPropertyResult(87, n, AsnUtil.toAsnReal(bStatusNumeric.getValue()));
        }
        catch (Exception exception) {
            return new NReadPropertyResult(87, n, new NErrorType(2, 42));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ErrorType writePriorityArray(int n, byte[] byArray) throws BacnetException {
        BNumericWritable bNumericWritable = (BNumericWritable)this.getPoint();
        if (bNumericWritable == null) {
            return new NErrorType(1, 1000);
        }
        try {
            BStatusNumeric bStatusNumeric;
            Property property;
            block13: {
                if (n == -1) {
                    n = 16;
                }
                if (n < 1 || n > 16) {
                    return new NErrorType(2, 42);
                }
                String string = "bacnetValueIn" + n;
                property = this.loadSlots().getProperty(string);
                if (property == null) {
                    return new NErrorType(2, 40);
                }
                bStatusNumeric = (BStatusNumeric)this.get(property).newCopy();
                BNumber bNumber = (BNumber)bNumericWritable.getFacets().getFacet("min");
                BNumber bNumber2 = (BNumber)bNumericWritable.getFacets().getFacet("max");
                double d = bNumber != null ? bNumber.getDouble() : Double.NEGATIVE_INFINITY;
                double d2 = bNumber2 != null ? bNumber2.getDouble() : Double.POSITIVE_INFINITY;
                AsnInputStream asnInputStream = asnIn;
                synchronized (asnInputStream) {
                    int n2;
                    block12: {
                        asnIn.setBuffer(byArray);
                        n2 = asnIn.peekTag();
                        if (n2 != 0) break block12;
                        bStatusNumeric.setStatusNull(true);
                        break block13;
                    }
                    if (n2 != 4) {
                        throw new AsnException("Invalid tag: " + n2);
                    }
                    double d3 = asnIn.readReal();
                    if (d3 < d || d3 > d2) {
                        return new NErrorType(2, 37);
                    }
                    bStatusNumeric.setStatusNull(false);
                    bStatusNumeric.setValue(d3);
                }
            }
            this.set(property, (BValue)bStatusNumeric, BLocalBacnetDevice.getBacnetContext());
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.message("IllegalArgumentException writing priorityArray in object " + (Object)((Object)this.getObjectId()) + ':' + illegalArgumentException);
            return new NErrorType(2, 37);
        }
        catch (PermissionException permissionException) {
            log.message("PermissionException writing priorityArray in object " + (Object)((Object)this.getObjectId()) + ':' + (Object)((Object)permissionException));
            return new NErrorType(2, 40);
        }
    }

    private final void resetBacnetWritable() {
        StringBuffer stringBuffer = new StringBuffer();
        Knob[] knobArray = this.getKnobs();
        int n = 0;
        while (n < knobArray.length) {
            BObject bObject = knobArray[n].getTargetOrd().get((BObject)this);
            BControlPoint bControlPoint = this.getPoint();
            if (knobArray[n].getTargetSlotName().startsWith("in") && bObject == bControlPoint) {
                stringBuffer.append(knobArray[n].getTargetSlotName()).append(',');
            }
            ++n;
        }
        this.setBacnetWritable(stringBuffer.length() > 0 ? stringBuffer.toString().substring(0, stringBuffer.length() - 1) : lexNotWritable);
    }

    public void knobAdded(Knob knob, Context context) {
        this.resetBacnetWritable();
    }

    public void knobRemoved(Knob knob, Context context) {
        this.resetBacnetWritable();
    }

    public final void doMakeWritable(BValue bValue) {
        if (!this.isRunning()) {
            return;
        }
        BNumericWritable bNumericWritable = (BNumericWritable)this.getPoint();
        if (bNumericWritable == null) {
            return;
        }
        BLink[] bLinkArray = bNumericWritable.getLinks();
        int n = 0;
        while (n < bLinkArray.length) {
            if (bLinkArray[n].isActive()) {
                if (bLinkArray[n].getSourceComponent() == this && bLinkArray[n].getTargetSlot().getName().startsWith("in")) {
                    bNumericWritable.remove((BComplex)bLinkArray[n]);
                }
            } else {
                bNumericWritable.remove((BComplex)bLinkArray[n]);
            }
            ++n;
        }
        Class clazz = class$javax$baja$status$BStatusNumeric;
        if (clazz == null) {
            clazz = class$javax$baja$status$BStatusNumeric = BBacnetAnalogWritableDescriptor.class("[Ljavax.baja.status.BStatusNumeric;", false);
        }
        BStatusNumeric[] bStatusNumericArray = (BStatusNumeric[])this.getChildren(clazz);
        int n2 = 0;
        while (n2 < bStatusNumericArray.length) {
            if (bStatusNumericArray[n2].getName().startsWith("bacnetValueIn")) {
                this.remove((BComplex)bStatusNumericArray[n2]);
            }
            ++n2;
        }
        String string = ((BString)bValue).getString();
        if (string.equals(lexNotWritable)) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Slot slot = bNumericWritable.getSlot(string2);
            String string3 = "bacnetValue" + TextUtil.capitalize((String)string2);
            BStatusNumeric bStatusNumeric = new BStatusNumeric();
            bStatusNumeric.setStatusNull(true);
            this.add(string3, (BValue)bStatusNumeric, 257);
            bNumericWritable.setFlags(slot, bNumericWritable.getFlags(slot) | 0x400);
            BLink bLink = new BLink(this.getHandleOrd(), string3, string2, true);
            bNumericWritable.add("bacnet" + string2, (BValue)bLink, 1);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$export$BBacnetAnalogWritableDescriptor;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$export$BBacnetAnalogWritableDescriptor = BBacnetAnalogWritableDescriptor.class("[Ljavax.baja.bacnet.export.BBacnetAnalogWritableDescriptor;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

