/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.enums;

import javax.baja.bacnet.BacnetConst;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetReliability
extends BFrozenEnum
implements BacnetConst {
    public static final int NO_FAULT_DETECTED = 0;
    public static final int NO_SENSOR = 1;
    public static final int OVER_RANGE = 2;
    public static final int UNDER_RANGE = 3;
    public static final int OPEN_LOOP = 4;
    public static final int SHORTED_LOOP = 5;
    public static final int NO_OUTPUT = 6;
    public static final int UNRELIABLE_OTHER = 7;
    public static final int PROCESS_ERROR = 8;
    public static final int MULTI_STATE_FAULT = 9;
    public static final int CONFIGURATION_ERROR = 10;
    public static final int COMMUNICATION_FAILURE = 12;
    public static final BBacnetReliability noFaultDetected = new BBacnetReliability(0);
    public static final BBacnetReliability noSensor = new BBacnetReliability(1);
    public static final BBacnetReliability overRange = new BBacnetReliability(2);
    public static final BBacnetReliability underRange = new BBacnetReliability(3);
    public static final BBacnetReliability openLoop = new BBacnetReliability(4);
    public static final BBacnetReliability shortedLoop = new BBacnetReliability(5);
    public static final BBacnetReliability noOutput = new BBacnetReliability(6);
    public static final BBacnetReliability unreliableOther = new BBacnetReliability(7);
    public static final BBacnetReliability processError = new BBacnetReliability(8);
    public static final BBacnetReliability multiStateFault = new BBacnetReliability(9);
    public static final BBacnetReliability configurationError = new BBacnetReliability(10);
    public static final BBacnetReliability communicationFailure = new BBacnetReliability(12);
    public static final Type TYPE;
    public static final int MAX_ASHRAE_ID = 12;
    public static final int MAX_RESERVED_ID = 63;
    public static final int MAX_ID = 65535;
    public static final BBacnetReliability DEFAULT;
    static /* synthetic */ Class class$javax$baja$bacnet$enums$BBacnetReliability;

    public final Type getType() {
        return TYPE;
    }

    public static final BBacnetReliability make(int n) {
        return (BBacnetReliability)noFaultDetected.getRange().get(n, false);
    }

    public static final BBacnetReliability make(String string) {
        return (BBacnetReliability)noFaultDetected.getRange().get(string);
    }

    public static final String tag(int n) {
        if (DEFAULT.getRange().isOrdinal(n)) {
            return DEFAULT.getRange().getTag(n);
        }
        if (BBacnetReliability.isAshrae(n)) {
            return BacnetConst.ASHRAE_PREFIX + n;
        }
        if (BBacnetReliability.isProprietary(n)) {
            return BacnetConst.PROPRIETARY_PREFIX + n;
        }
        throw new InvalidEnumException(n);
    }

    public static final int ordinal(String string) {
        try {
            return DEFAULT.getRange().tagToOrdinal(string);
        }
        catch (InvalidEnumException invalidEnumException) {
            if (string.startsWith(BacnetConst.ASHRAE_PREFIX)) {
                return Integer.parseInt(string.substring(BacnetConst.ASHRAE_PREFIX_LENGTH));
            }
            if (string.startsWith(BacnetConst.PROPRIETARY_PREFIX)) {
                return Integer.parseInt(string.substring(BacnetConst.PROPRIETARY_PREFIX_LENGTH));
            }
            throw invalidEnumException;
        }
    }

    public static final boolean isProprietary(int n) {
        boolean bl = false;
        if (n > 63 && n <= (char)-1) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isAshrae(int n) {
        boolean bl = false;
        if (n > 12 && n <= 63) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isValid(int n) {
        boolean bl = false;
        if (n <= (char)-1) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isFixed(int n) {
        boolean bl = false;
        if (n <= 12) {
            bl = true;
        }
        return bl;
    }

    public final String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.getTag();
        }
        return this.getDisplayTag(context);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BBacnetReliability(int n) {
        super(n);
    }

    static {
        Class clazz = class$javax$baja$bacnet$enums$BBacnetReliability;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$enums$BBacnetReliability = BBacnetReliability.class("[Ljavax.baja.bacnet.enums.BBacnetReliability;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        DEFAULT = noFaultDetected;
    }
}

