/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.enums;

import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BacnetConst;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetObjectType
extends BFrozenEnum
implements BacnetConst {
    public static final int ANALOG_INPUT = 0;
    public static final int ANALOG_OUTPUT = 1;
    public static final int ANALOG_VALUE = 2;
    public static final int BINARY_INPUT = 3;
    public static final int BINARY_OUTPUT = 4;
    public static final int BINARY_VALUE = 5;
    public static final int CALENDAR = 6;
    public static final int COMMAND = 7;
    public static final int DEVICE = 8;
    public static final int EVENT_ENROLLMENT = 9;
    public static final int FILE = 10;
    public static final int GROUP = 11;
    public static final int LOOP = 12;
    public static final int MULTI_STATE_INPUT = 13;
    public static final int MULTI_STATE_OUTPUT = 14;
    public static final int NOTIFICATION_CLASS = 15;
    public static final int PROGRAM = 16;
    public static final int SCHEDULE = 17;
    public static final int AVERAGING = 18;
    public static final int MULTI_STATE_VALUE = 19;
    public static final int TREND_LOG = 20;
    public static final int LIFE_SAFETY_POINT = 21;
    public static final int LIFE_SAFETY_ZONE = 22;
    public static final int ACCUMULATOR = 23;
    public static final int PULSE_CONVERTER = 24;
    public static final int EVENT_LOG = 25;
    public static final int TREND_LOG_MULTIPLE = 27;
    public static final int LOAD_CONTROL = 28;
    public static final int STRUCTURED_VIEW = 29;
    public static final int ACCESS_DOOR = 30;
    public static final BBacnetObjectType analogInput = new BBacnetObjectType(0);
    public static final BBacnetObjectType analogOutput = new BBacnetObjectType(1);
    public static final BBacnetObjectType analogValue = new BBacnetObjectType(2);
    public static final BBacnetObjectType binaryInput = new BBacnetObjectType(3);
    public static final BBacnetObjectType binaryOutput = new BBacnetObjectType(4);
    public static final BBacnetObjectType binaryValue = new BBacnetObjectType(5);
    public static final BBacnetObjectType calendar = new BBacnetObjectType(6);
    public static final BBacnetObjectType command = new BBacnetObjectType(7);
    public static final BBacnetObjectType device = new BBacnetObjectType(8);
    public static final BBacnetObjectType eventEnrollment = new BBacnetObjectType(9);
    public static final BBacnetObjectType file = new BBacnetObjectType(10);
    public static final BBacnetObjectType group = new BBacnetObjectType(11);
    public static final BBacnetObjectType loop = new BBacnetObjectType(12);
    public static final BBacnetObjectType multiStateInput = new BBacnetObjectType(13);
    public static final BBacnetObjectType multiStateOutput = new BBacnetObjectType(14);
    public static final BBacnetObjectType notificationClass = new BBacnetObjectType(15);
    public static final BBacnetObjectType program = new BBacnetObjectType(16);
    public static final BBacnetObjectType schedule = new BBacnetObjectType(17);
    public static final BBacnetObjectType averaging = new BBacnetObjectType(18);
    public static final BBacnetObjectType multiStateValue = new BBacnetObjectType(19);
    public static final BBacnetObjectType trendLog = new BBacnetObjectType(20);
    public static final BBacnetObjectType lifeSafetyPoint = new BBacnetObjectType(21);
    public static final BBacnetObjectType lifeSafetyZone = new BBacnetObjectType(22);
    public static final BBacnetObjectType accumulator = new BBacnetObjectType(23);
    public static final BBacnetObjectType pulseConverter = new BBacnetObjectType(24);
    public static final BBacnetObjectType eventLog = new BBacnetObjectType(25);
    public static final BBacnetObjectType trendLogMultiple = new BBacnetObjectType(27);
    public static final BBacnetObjectType loadControl = new BBacnetObjectType(28);
    public static final BBacnetObjectType structuredView = new BBacnetObjectType(29);
    public static final BBacnetObjectType accessDoor = new BBacnetObjectType(30);
    public static final Type TYPE;
    public static final int MAX_ASHRAE_ID = 30;
    public static final int MAX_RESERVED_ID = 127;
    public static final int MAX_ID = 1023;
    private static long statusFlagsObjectTypes;
    private static long statusFlagsObjectTypesPR4;
    private static long statusFlagsObjectTypesPR6;
    private static long statusFlagsObjectTypesPR7;
    private static long covObjectTypes;
    private static long covObjectTypesPR4;
    private static long covObjectTypesPR6;
    private static final String INVALID_OBJECT_TYPE = "INVALID";
    public static final BBacnetObjectType DEFAULT;
    private static IntHashMap stagByOType;
    private static IntHashMap objectIdFacets;
    static /* synthetic */ Class class$javax$baja$bacnet$enums$BBacnetObjectType;

    public final Type getType() {
        return TYPE;
    }

    public static final BBacnetObjectType make(int n) {
        return (BBacnetObjectType)analogInput.getRange().get(n, false);
    }

    public static final BBacnetObjectType make(String string) {
        return (BBacnetObjectType)analogInput.getRange().get(string);
    }

    public static final String tag(int n) {
        if (DEFAULT.getRange().isOrdinal(n)) {
            return DEFAULT.getRange().getTag(n);
        }
        if (BBacnetObjectType.isAshrae(n)) {
            return BacnetConst.ASHRAE_PREFIX + n;
        }
        if (BBacnetObjectType.isProprietary(n)) {
            return BacnetConst.PROPRIETARY_PREFIX + n;
        }
        return "INVALID:" + n;
    }

    public static final int ordinal(String string) {
        try {
            return DEFAULT.getRange().tagToOrdinal(string);
        }
        catch (InvalidEnumException invalidEnumException) {
            if (string.startsWith(BacnetConst.ASHRAE_PREFIX)) {
                return Integer.parseInt(string.substring(BacnetConst.ASHRAE_PREFIX_LENGTH));
            }
            if (string.startsWith(BacnetConst.PROPRIETARY_PREFIX)) {
                return Integer.parseInt(string.substring(BacnetConst.PROPRIETARY_PREFIX_LENGTH));
            }
            if (string.startsWith(INVALID_OBJECT_TYPE)) {
                return -1;
            }
            throw invalidEnumException;
        }
    }

    public static final boolean isProprietary(int n) {
        boolean bl = false;
        if (n > 127 && n <= 1023) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isAshrae(int n) {
        boolean bl = false;
        if (n > 30 && n <= 127) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isValid(int n) {
        boolean bl = false;
        if (n <= 1023) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isFixed(int n) {
        boolean bl = false;
        if (n <= 30) {
            bl = true;
        }
        return bl;
    }

    public static final boolean hasStatusFlags(int n) {
        return BBacnetObjectType.hasStatusFlags(n, null);
    }

    public static final boolean hasStatusFlags(int n, BBacnetDevice bBacnetDevice) {
        int n2 = 0;
        if (bBacnetDevice != null) {
            n2 = bBacnetDevice.getProtocolRevision();
        }
        if (n > 30) {
            return false;
        }
        long l = 1L << n;
        if (n2 > 6) {
            boolean bl = false;
            if ((l & statusFlagsObjectTypesPR7) != 0L) {
                bl = true;
            }
            return bl;
        }
        if (n2 > 5) {
            boolean bl = false;
            if ((l & statusFlagsObjectTypesPR6) != 0L) {
                bl = true;
            }
            return bl;
        }
        if (n2 > 3) {
            boolean bl = false;
            if ((l & statusFlagsObjectTypesPR4) != 0L) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if ((l & statusFlagsObjectTypes) != 0L) {
            bl = true;
        }
        return bl;
    }

    public static final boolean canSupportCov(int n) {
        return BBacnetObjectType.canSupportCov(n, null);
    }

    public static final boolean canSupportCov(int n, BBacnetDevice bBacnetDevice) {
        int n2 = 0;
        if (bBacnetDevice != null) {
            n2 = bBacnetDevice.getProtocolRevision();
        }
        if (n > 30) {
            return false;
        }
        long l = 1L << n;
        if (n2 > 5) {
            boolean bl = false;
            if ((l & covObjectTypesPR6) != 0L) {
                bl = true;
            }
            return bl;
        }
        if (n2 > 3) {
            boolean bl = false;
            if ((l & covObjectTypesPR4) != 0L) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if ((l & covObjectTypes) != 0L) {
            bl = true;
        }
        return bl;
    }

    public static final String getShortTag(int n) {
        String string = (String)stagByOType.get(n);
        if (string != null) {
            return string;
        }
        return "" + n + ':';
    }

    public static final BFacets getObjectIdFacets(int n) {
        return (BFacets)objectIdFacets.get(n);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BBacnetObjectType(int n) {
        super(n);
    }

    static {
        Class clazz = class$javax$baja$bacnet$enums$BBacnetObjectType;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$enums$BBacnetObjectType = BBacnetObjectType.class("[Ljavax.baja.bacnet.enums.BBacnetObjectType;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        statusFlagsObjectTypes = 6910015L;
        statusFlagsObjectTypesPR4 = 32206911L;
        statusFlagsObjectTypesPR6 = 1374384191L;
        statusFlagsObjectTypesPR7 = 1543204927L;
        covObjectTypes = 6844479L;
        covObjectTypesPR4 = 23621695L;
        covObjectTypesPR6 = 1365798975L;
        DEFAULT = analogInput;
        stagByOType = new IntHashMap();
        stagByOType.put(0, (Object)"AI");
        stagByOType.put(1, (Object)"AO");
        stagByOType.put(2, (Object)"AV");
        stagByOType.put(3, (Object)"BI");
        stagByOType.put(4, (Object)"BO");
        stagByOType.put(5, (Object)"BV");
        stagByOType.put(6, (Object)"CAL");
        stagByOType.put(7, (Object)"CMD");
        stagByOType.put(8, (Object)"DEV");
        stagByOType.put(9, (Object)"EE");
        stagByOType.put(10, (Object)"FILE");
        stagByOType.put(11, (Object)"GRP");
        stagByOType.put(12, (Object)"LP");
        stagByOType.put(13, (Object)"MSI");
        stagByOType.put(14, (Object)"MSO");
        stagByOType.put(15, (Object)"NC");
        stagByOType.put(16, (Object)"PGM");
        stagByOType.put(17, (Object)"SCH");
        stagByOType.put(18, (Object)"AVG");
        stagByOType.put(19, (Object)"MSV");
        stagByOType.put(20, (Object)"LOG");
        stagByOType.put(21, (Object)"LSP");
        stagByOType.put(22, (Object)"LSZ");
        stagByOType.put(23, (Object)"ACC");
        stagByOType.put(24, (Object)"PC");
        stagByOType.put(25, (Object)"ELOG");
        stagByOType.put(27, (Object)"TLM");
        stagByOType.put(28, (Object)"LCO");
        stagByOType.put(29, (Object)"SVO");
        stagByOType.put(30, (Object)"DOOR");
        objectIdFacets = new IntHashMap();
        objectIdFacets.put(0, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[1], (String[])new String[]{analogInput.getTag()})));
        objectIdFacets.put(1, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{1}, (String[])new String[]{analogOutput.getTag()})));
        objectIdFacets.put(2, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{2}, (String[])new String[]{analogValue.getTag()})));
        objectIdFacets.put(3, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{3}, (String[])new String[]{binaryInput.getTag()})));
        objectIdFacets.put(4, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{4}, (String[])new String[]{binaryOutput.getTag()})));
        objectIdFacets.put(5, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{5}, (String[])new String[]{binaryValue.getTag()})));
        objectIdFacets.put(6, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{6}, (String[])new String[]{calendar.getTag()})));
        objectIdFacets.put(7, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{7}, (String[])new String[]{command.getTag()})));
        objectIdFacets.put(8, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{8}, (String[])new String[]{device.getTag()})));
        objectIdFacets.put(9, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{9}, (String[])new String[]{eventEnrollment.getTag()})));
        objectIdFacets.put(10, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{10}, (String[])new String[]{file.getTag()})));
        objectIdFacets.put(11, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{11}, (String[])new String[]{group.getTag()})));
        objectIdFacets.put(12, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{12}, (String[])new String[]{loop.getTag()})));
        objectIdFacets.put(13, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{13}, (String[])new String[]{multiStateInput.getTag()})));
        objectIdFacets.put(14, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{14}, (String[])new String[]{multiStateOutput.getTag()})));
        objectIdFacets.put(15, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{15}, (String[])new String[]{notificationClass.getTag()})));
        objectIdFacets.put(16, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{16}, (String[])new String[]{program.getTag()})));
        objectIdFacets.put(17, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{17}, (String[])new String[]{schedule.getTag()})));
        objectIdFacets.put(18, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{18}, (String[])new String[]{averaging.getTag()})));
        objectIdFacets.put(19, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{19}, (String[])new String[]{multiStateValue.getTag()})));
        objectIdFacets.put(20, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{20}, (String[])new String[]{trendLog.getTag()})));
        objectIdFacets.put(21, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{21}, (String[])new String[]{lifeSafetyPoint.getTag()})));
        objectIdFacets.put(22, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{22}, (String[])new String[]{lifeSafetyZone.getTag()})));
        objectIdFacets.put(23, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{23}, (String[])new String[]{accumulator.getTag()})));
        objectIdFacets.put(24, (Object)BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])new int[]{24}, (String[])new String[]{pulseConverter.getTag()})));
    }
}

