/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.enums;

import javax.baja.alarm.BSourceState;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.bacnet.BacnetConst;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetEventState
extends BFrozenEnum
implements BacnetConst {
    public static final int NORMAL = 0;
    public static final int FAULT = 1;
    public static final int OFFNORMAL = 2;
    public static final int HIGH_LIMIT = 3;
    public static final int LOW_LIMIT = 4;
    public static final int LIFE_SAFETY_ALARM = 5;
    public static final BBacnetEventState normal = new BBacnetEventState(0);
    public static final BBacnetEventState fault = new BBacnetEventState(1);
    public static final BBacnetEventState offnormal = new BBacnetEventState(2);
    public static final BBacnetEventState highLimit = new BBacnetEventState(3);
    public static final BBacnetEventState lowLimit = new BBacnetEventState(4);
    public static final BBacnetEventState lifeSafetyAlarm = new BBacnetEventState(5);
    public static final Type TYPE;
    public static final int MAX_ASHRAE_ID = 5;
    public static final int MAX_RESERVED_ID = 63;
    public static final int MAX_ID = 65535;
    public static final BBacnetEventState DEFAULT;
    static /* synthetic */ Class class$javax$baja$bacnet$enums$BBacnetEventState;

    public final Type getType() {
        return TYPE;
    }

    public static final BBacnetEventState make(int n) {
        return (BBacnetEventState)normal.getRange().get(n);
    }

    public static final BBacnetEventState make(String string) {
        return (BBacnetEventState)normal.getRange().get(string);
    }

    public static final String tag(int n) {
        if (DEFAULT.getRange().isOrdinal(n)) {
            return DEFAULT.getRange().getTag(n);
        }
        if (BBacnetEventState.isAshrae(n)) {
            return BacnetConst.ASHRAE_PREFIX + n;
        }
        if (BBacnetEventState.isProprietary(n)) {
            return BacnetConst.PROPRIETARY_PREFIX + n;
        }
        throw new InvalidEnumException(n);
    }

    public static final int ordinal(String string) {
        try {
            return DEFAULT.getRange().tagToOrdinal(string);
        }
        catch (InvalidEnumException invalidEnumException) {
            if (string.startsWith(BacnetConst.ASHRAE_PREFIX)) {
                return Integer.parseInt(string.substring(BacnetConst.ASHRAE_PREFIX_LENGTH));
            }
            if (string.startsWith(BacnetConst.PROPRIETARY_PREFIX)) {
                return Integer.parseInt(string.substring(BacnetConst.PROPRIETARY_PREFIX_LENGTH));
            }
            throw invalidEnumException;
        }
    }

    public static final boolean isProprietary(int n) {
        boolean bl = false;
        if (n > 63 && n <= (char)-1) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isAshrae(int n) {
        boolean bl = false;
        if (n > 5 && n <= 63) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isValid(int n) {
        boolean bl = false;
        if (n <= (char)-1) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isFixed(int n) {
        boolean bl = false;
        if (n <= 5) {
            bl = true;
        }
        return bl;
    }

    public static final BBacnetEventState make(BAlarmState bAlarmState) {
        return BBacnetEventState.make(bAlarmState.getOrdinal());
    }

    public static final BBacnetEventState make(BSourceState bSourceState) {
        switch (bSourceState.getOrdinal()) {
            case 0: {
                return normal;
            }
            case 1: {
                return offnormal;
            }
            case 2: {
                return fault;
            }
        }
        throw new IllegalArgumentException("Invalid sourceState:" + bSourceState);
    }

    public static final int fromBAlarmState(BAlarmState bAlarmState) {
        return bAlarmState.getOrdinal();
    }

    public final BSourceState toSourceState() {
        switch (this.getOrdinal()) {
            case 0: {
                return BSourceState.normal;
            }
            case 1: {
                return BSourceState.fault;
            }
        }
        return BSourceState.offnormal;
    }

    public static final boolean isNormal(BEnum bEnum) {
        boolean bl = false;
        if (bEnum.getOrdinal() == 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isFault(BEnum bEnum) {
        boolean bl = false;
        if (bEnum.getOrdinal() == 1) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isOffnormal(BEnum bEnum) {
        boolean bl = false;
        if (bEnum.getOrdinal() != 0 && bEnum.getOrdinal() != 1) {
            bl = true;
        }
        return bl;
    }

    public static final int getEventTransitionBits(BEnum bEnum) {
        switch (bEnum.getOrdinal()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 4;
    }

    public static final int getEventTransition(BEnum bEnum) {
        switch (bEnum.getOrdinal()) {
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public final String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.getTag();
        }
        return this.getDisplayTag(context);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BBacnetEventState(int n) {
        super(n);
    }

    static {
        Class clazz = class$javax$baja$bacnet$enums$BBacnetEventState;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$enums$BBacnetEventState = BBacnetEventState.class("[Ljavax.baja.bacnet.enums.BBacnetEventState;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        DEFAULT = normal;
    }
}

