/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.enums;

import javax.baja.bacnet.BacnetConst;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetDeviceStatus
extends BFrozenEnum
implements BacnetConst {
    public static final int OPERATIONAL = 0;
    public static final int OPERATIONAL_READ_ONLY = 1;
    public static final int DOWNLOAD_REQUIRED = 2;
    public static final int DOWNLOAD_IN_PROGRESS = 3;
    public static final int NON_OPERATIONAL = 4;
    public static final int BACKUP_IN_PROGRESS = 5;
    public static final BBacnetDeviceStatus operational = new BBacnetDeviceStatus(0);
    public static final BBacnetDeviceStatus operationalReadOnly = new BBacnetDeviceStatus(1);
    public static final BBacnetDeviceStatus downloadRequired = new BBacnetDeviceStatus(2);
    public static final BBacnetDeviceStatus downloadInProgress = new BBacnetDeviceStatus(3);
    public static final BBacnetDeviceStatus nonOperational = new BBacnetDeviceStatus(4);
    public static final BBacnetDeviceStatus backupInProgress = new BBacnetDeviceStatus(5);
    public static final Type TYPE;
    public static final int MAX_ASHRAE_ID = 5;
    public static final int MAX_RESERVED_ID = 63;
    public static final int MAX_ID = 65535;
    public static final BBacnetDeviceStatus DEFAULT;
    static /* synthetic */ Class class$javax$baja$bacnet$enums$BBacnetDeviceStatus;

    public final Type getType() {
        return TYPE;
    }

    public static final BBacnetDeviceStatus make(int n) {
        return (BBacnetDeviceStatus)operational.getRange().get(n);
    }

    public static final BBacnetDeviceStatus make(String string) {
        return (BBacnetDeviceStatus)operational.getRange().get(string);
    }

    public static final String tag(int n) {
        if (DEFAULT.getRange().isOrdinal(n)) {
            return DEFAULT.getRange().getTag(n);
        }
        if (BBacnetDeviceStatus.isAshrae(n)) {
            return BacnetConst.ASHRAE_PREFIX + n;
        }
        if (BBacnetDeviceStatus.isProprietary(n)) {
            return BacnetConst.PROPRIETARY_PREFIX + n;
        }
        throw new InvalidEnumException(n);
    }

    public static final int ordinal(String string) {
        try {
            return DEFAULT.getRange().tagToOrdinal(string);
        }
        catch (InvalidEnumException invalidEnumException) {
            if (string.startsWith(BacnetConst.ASHRAE_PREFIX)) {
                return Integer.parseInt(string.substring(BacnetConst.ASHRAE_PREFIX_LENGTH));
            }
            if (string.startsWith(BacnetConst.PROPRIETARY_PREFIX)) {
                return Integer.parseInt(string.substring(BacnetConst.PROPRIETARY_PREFIX_LENGTH));
            }
            throw invalidEnumException;
        }
    }

    public static final boolean isProprietary(int n) {
        boolean bl = false;
        if (n > 63 && n <= (char)-1) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isAshrae(int n) {
        boolean bl = false;
        if (n > 5 && n <= 63) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isValid(int n) {
        boolean bl = false;
        if (n <= (char)-1) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isFixed(int n) {
        boolean bl = false;
        if (n <= 5) {
            bl = true;
        }
        return bl;
    }

    public final String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.getTag();
        }
        return this.getDisplayTag(context);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BBacnetDeviceStatus(int n) {
        super(n);
    }

    static {
        Class clazz = class$javax$baja$bacnet$enums$BBacnetDeviceStatus;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$enums$BBacnetDeviceStatus = BBacnetDeviceStatus.class("[Ljavax.baja.bacnet.enums.BBacnetDeviceStatus;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        DEFAULT = operational;
    }
}

