/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.asn.AsnUtil;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BErrorType;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BReadPropertyResult
extends BComponent
implements PropertyValue,
BIBacnetDataType {
    public static final Property propertyId = BReadPropertyResult.newProperty((int)1, (int)85, null);
    public static final Property propertyArrayIndex = BReadPropertyResult.newProperty((int)1, (int)-1, null);
    public static final Property value = BReadPropertyResult.newProperty((int)1, (BValue)BBacnetNull.DEFAULT, null);
    public static final Property error = BReadPropertyResult.newProperty((int)1, (BValue)new BErrorType(), null);
    public static final Type TYPE;
    public static final int PROPERTY_ID_TAG = 2;
    public static final int PROPERTY_ARRAY_INDEX_TAG = 3;
    public static final int PROPERTY_VALUE_TAG = 4;
    public static final int PROPERTY_ACCESS_ERROR_TAG = 5;
    private boolean isError;
    private byte[] propertyValue;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BReadPropertyResult;

    public final int getPropertyId() {
        return this.getInt(propertyId);
    }

    public final void setPropertyId(int n) {
        this.setInt(propertyId, n, null);
    }

    public final int getPropertyArrayIndex() {
        return this.getInt(propertyArrayIndex);
    }

    public final void setPropertyArrayIndex(int n) {
        this.setInt(propertyArrayIndex, n, null);
    }

    public final BValue getValue() {
        return this.get(value);
    }

    public final void setValue(BValue bValue) {
        this.set(value, bValue, null);
    }

    public final BErrorType getError() {
        return (BErrorType)this.get(error);
    }

    public final void setError(BErrorType bErrorType) {
        this.set(error, (BValue)bErrorType, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void changed(Property property, Context context) {
        if (property.equals((Object)value)) {
            this.propertyValue = null;
        } else if (property.equals((Object)error)) {
            this.isError = !this.getError().isDefault();
            this.propertyValue = null;
        }
    }

    public final byte[] getPropertyValue() {
        if (this.propertyValue == null && !this.isError) {
            this.propertyValue = AsnUtil.toAsn(this.getValue());
        }
        return this.propertyValue;
    }

    public final int getPriority() {
        return -1;
    }

    public final ErrorType getPropertyAccessError() {
        return this.getError();
    }

    public final int getErrorClass() {
        return this.getPropertyAccessError().getErrorClass();
    }

    public final int getErrorCode() {
        return this.getPropertyAccessError().getErrorCode();
    }

    public final boolean isError() {
        return this.isError;
    }

    public final boolean isPropertyArrayIndexUsed() {
        boolean bl = false;
        if (this.getPropertyArrayIndex() != -1) {
            bl = true;
        }
        return bl;
    }

    public final void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeEnumerated(2, this.getPropertyId());
        if (this.isPropertyArrayIndexUsed()) {
            asnOutput.writeUnsignedInteger(3, this.getPropertyArrayIndex());
        }
        if (this.isError) {
            asnOutput.writeOpeningTag(5);
            this.getError().writeAsn(asnOutput);
            asnOutput.writeClosingTag(5);
        } else {
            BValue bValue = this.getValue();
            if (bValue instanceof BIBacnetDataType) {
                asnOutput.writeOpeningTag(4);
                ((BIBacnetDataType)bValue).writeAsn(asnOutput);
                asnOutput.writeClosingTag(4);
            } else {
                throw new IllegalStateException("propertyValue type " + bValue.getType() + " is not a BIBacnetDataType!");
            }
        }
    }

    public final void readAsn(AsnInput asnInput) throws AsnException {
        this.setInt(propertyId, asnInput.readEnumerated(2), BacnetConst.noWrite);
        int n = asnInput.peekTag();
        if (asnInput.isValueTag(3)) {
            this.setInt(propertyArrayIndex, asnInput.readUnsignedInt(3), BacnetConst.noWrite);
            n = asnInput.peekTag();
        } else {
            this.setInt(propertyArrayIndex, -1, BacnetConst.noWrite);
        }
        if (asnInput.isOpeningTag(4)) {
            this.isError = false;
            this.propertyValue = asnInput.readEncodedValue(4);
            BValue bValue = AsnUtil.asnToValue(this.propertyValue);
            this.set(value, bValue, BacnetConst.noWrite);
            this.getError().setToDefault(BacnetConst.noWrite);
        } else if (asnInput.isOpeningTag(5)) {
            this.isError = true;
            this.propertyValue = null;
            asnInput.skipTag();
            this.getError().readAsn(asnInput);
            asnInput.skipTag();
        } else {
            throw new AsnException("Invalid tag: " + n);
        }
    }

    public final String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BBacnetPropertyIdentifier.tag(this.getPropertyId()));
        if (this.isPropertyArrayIndexUsed()) {
            stringBuffer.append(" [").append(this.getPropertyArrayIndex()).append("] ");
        }
        stringBuffer.append(":");
        if (this.isError) {
            stringBuffer.append(this.getError().toString(context));
        } else {
            stringBuffer.append(this.getValue().toString(context));
        }
        return stringBuffer.toString();
    }

    public final String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("\n  " + BBacnetPropertyIdentifier.tag(this.getPropertyId()));
        if (this.isPropertyArrayIndexUsed()) {
            stringBuffer.append("[" + this.getPropertyArrayIndex() + ']');
        }
        if (this.isError) {
            stringBuffer.append("\n  err:" + this.getError().toString());
        } else {
            stringBuffer.append("\n  val:" + this.getValue().toString());
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.isError = false;
        this.propertyValue = null;
    }

    public BReadPropertyResult() {
        this.this();
    }

    public BReadPropertyResult(int n) {
        this.this();
        this.setPropertyId(n);
    }

    public BReadPropertyResult(int n, int n2) {
        this.this();
        this.setPropertyId(n);
        this.setPropertyArrayIndex(n2);
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BReadPropertyResult;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BReadPropertyResult = BReadPropertyResult.class("[Ljavax.baja.bacnet.datatypes.BReadPropertyResult;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

