/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetTime
extends BSimple
implements BIComparable {
    public static final byte UNSPECIFIED = -1;
    public static final int TEXT_LENGTH = 11;
    public static final BBacnetTime DEFAULT = new BBacnetTime(-1, -1, -1, -1);
    public static final Type TYPE;
    private byte hour;
    private byte minute;
    private byte second;
    private byte hundredth;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetTime;

    public static final BBacnetTime make() {
        return new BBacnetTime(-1, -1, -1, -1);
    }

    public static final BBacnetTime make(int n, int n2, int n3, int n4) {
        if ((n < -1 || n > 23) && n != 255) {
            throw new IllegalArgumentException("BBacnetTime: invalid hour:" + n);
        }
        if ((n2 < -1 || n2 > 59) && n2 != 255) {
            throw new IllegalArgumentException("BBacnetTime: invalid minute:" + n2);
        }
        if ((n3 < -1 || n3 > 59) && n3 != 255) {
            throw new IllegalArgumentException("BBacnetTime: invalid second:" + n3);
        }
        if ((n4 < -1 || n4 > 99) && n4 != 255) {
            throw new IllegalArgumentException("BBacnetTime: invalid hundredth:" + n4);
        }
        return new BBacnetTime(n, n2, n3, n4);
    }

    public static final BBacnetTime make(BAbsTime bAbsTime) {
        int n = bAbsTime.getHour();
        int n2 = bAbsTime.getMinute();
        int n3 = bAbsTime.getSecond();
        int n4 = bAbsTime.getMillisecond() / 10;
        return new BBacnetTime(n, n2, n3, n4);
    }

    public static final BBacnetTime make(BTime bTime) {
        int n = bTime.getHour();
        int n2 = bTime.getMinute();
        int n3 = bTime.getSecond();
        int n4 = bTime.getMillisecond() / 10;
        return new BBacnetTime(n, n2, n3, n4);
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof BBacnetTime) {
            BBacnetTime bBacnetTime = (BBacnetTime)((Object)object);
            boolean bl = false;
            if (this.hour == bBacnetTime.hour && this.minute == bBacnetTime.minute && this.second == bBacnetTime.second && this.hundredth == bBacnetTime.hundredth) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final int hashCode() {
        return this.hour << 24 | this.minute << 16 | this.second << 8 | this.hundredth;
    }

    public final String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hour == -1) {
            stringBuffer.append("**:");
        } else {
            stringBuffer.append(this.hour < 10 ? "0" + this.hour : String.valueOf(this.hour)).append(':');
        }
        if (this.minute == -1) {
            stringBuffer.append("**:");
        } else {
            stringBuffer.append(this.minute < 10 ? "0" + this.minute : String.valueOf(this.minute)).append(':');
        }
        if (this.second == -1) {
            stringBuffer.append("**.");
        } else {
            stringBuffer.append(this.second < 10 ? "0" + this.second : String.valueOf(this.second)).append('.');
        }
        if (this.hundredth == -1) {
            stringBuffer.append("**");
        } else {
            stringBuffer.append(this.hundredth < 10 ? "0" + this.hundredth : String.valueOf(this.hundredth));
        }
        return stringBuffer.toString();
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.hour);
        dataOutput.writeByte(this.minute);
        dataOutput.writeByte(this.second);
        dataOutput.writeByte(this.hundredth);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        byte by2 = dataInput.readByte();
        byte by3 = dataInput.readByte();
        byte by4 = dataInput.readByte();
        return new BBacnetTime(by, by2, by3, by4);
    }

    public final String encodeToString() throws IOException {
        return this.toString(null);
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":.");
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            String string2 = stringTokenizer.nextToken();
            int n5 = n = string2.indexOf("*") < 0 ? Integer.parseInt(string2) : -1;
            if (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                int n6 = n2 = string3.indexOf("*") < 0 ? Integer.parseInt(string3) : -1;
                if (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    int n7 = n3 = string4.indexOf("*") < 0 ? Integer.parseInt(string4) : -1;
                    if (stringTokenizer.hasMoreTokens()) {
                        String string5 = stringTokenizer.nextToken();
                        n4 = string5.indexOf("*") < 0 ? Integer.parseInt(string5) : -1;
                    }
                }
            }
            return new BBacnetTime(n, n2, n3, n4);
        }
        catch (Exception exception) {
            throw new IOException("Error decoding BBacnetTime:" + string);
        }
    }

    public final int getHour() {
        return this.hour;
    }

    public final int getMinute() {
        return this.minute;
    }

    public final int getSecond() {
        return this.second;
    }

    public final int getHundredth() {
        return this.hundredth;
    }

    public final boolean isHourUnspecified() {
        boolean bl = false;
        if (this.hour == -1) {
            bl = true;
        }
        return bl;
    }

    public final boolean isMinuteUnspecified() {
        boolean bl = false;
        if (this.minute == -1) {
            bl = true;
        }
        return bl;
    }

    public final boolean isSecondUnspecified() {
        boolean bl = false;
        if (this.second == -1) {
            bl = true;
        }
        return bl;
    }

    public final boolean isHundredthUnspecified() {
        boolean bl = false;
        if (this.hundredth == -1) {
            bl = true;
        }
        return bl;
    }

    public final boolean isAnyUnspecified() {
        boolean bl = false;
        if (this.hour == -1 || this.minute == -1 || this.second == -1 || this.hundredth == -1) {
            bl = true;
        }
        return bl;
    }

    public final boolean timeEquals(Object object) {
        boolean bl = false;
        if (this.compareTo(object) == 0) {
            bl = true;
        }
        return bl;
    }

    public final int compareTo(Object object) {
        if (object == null) {
            throw new ClassCastException();
        }
        if (((BObject)object).getType() == TYPE) {
            BBacnetTime bBacnetTime = (BBacnetTime)((Object)object);
            if (!bBacnetTime.isHourUnspecified() && !this.isHourUnspecified()) {
                if (this.hour < bBacnetTime.hour) {
                    return -1;
                }
                if (this.hour > bBacnetTime.hour) {
                    return 1;
                }
            }
            if (!bBacnetTime.isMinuteUnspecified() && !this.isMinuteUnspecified()) {
                if (this.minute < bBacnetTime.minute) {
                    return -1;
                }
                if (this.minute > bBacnetTime.minute) {
                    return 1;
                }
            }
            if (!bBacnetTime.isSecondUnspecified() && !this.isSecondUnspecified()) {
                if (this.second < bBacnetTime.second) {
                    return -1;
                }
                if (this.second > bBacnetTime.second) {
                    return 1;
                }
            }
            if (!bBacnetTime.isHundredthUnspecified() && !this.isHundredthUnspecified()) {
                if (this.hundredth < bBacnetTime.hundredth) {
                    return -1;
                }
                if (this.hundredth > bBacnetTime.hundredth) {
                    return 1;
                }
            }
            return 0;
        }
        if (((BObject)object).getType() == BTime.TYPE) {
            BTime bTime = (BTime)object;
            if (!this.isHourUnspecified()) {
                if (this.hour < bTime.getHour()) {
                    return -1;
                }
                if (this.hour > bTime.getHour()) {
                    return 1;
                }
            }
            if (!this.isMinuteUnspecified()) {
                if (this.minute < bTime.getMinute()) {
                    return -1;
                }
                if (this.minute > bTime.getMinute()) {
                    return 1;
                }
            }
            if (!this.isSecondUnspecified()) {
                if (this.second < bTime.getSecond()) {
                    return -1;
                }
                if (this.second > bTime.getSecond()) {
                    return 1;
                }
            }
            if (!this.isHundredthUnspecified()) {
                if (this.hundredth < bTime.getMillisecond() / 10) {
                    return -1;
                }
                if (this.hundredth > bTime.getMillisecond() / 10) {
                    return 1;
                }
            }
            return 0;
        }
        throw new IllegalArgumentException(object.toString());
    }

    public final boolean isBefore(Object object) {
        boolean bl = false;
        if (this.compareTo(object) < 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isAfter(Object object) {
        boolean bl = false;
        if (this.compareTo(object) > 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isNotBefore(Object object) {
        boolean bl = false;
        if (this.compareTo(object) >= 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isNotAfter(Object object) {
        boolean bl = false;
        if (this.compareTo(object) <= 0) {
            bl = true;
        }
        return bl;
    }

    public final BTime toBTime() {
        return BBacnetTime.getBTime(this, true);
    }

    public static final BBacnetTime fromString(String string) {
        try {
            return (BBacnetTime)DEFAULT.decodeFromString(string);
        }
        catch (Exception exception) {
            System.out.println("BBacnetTime.fromFacetString('" + string + "'): error parsing string!!");
            return DEFAULT;
        }
    }

    public static final BTime getBTime(BBacnetTime bBacnetTime) {
        return BBacnetTime.getBTime(bBacnetTime, true);
    }

    public static final BTime getBTime(BBacnetTime bBacnetTime, boolean bl) {
        return BTime.make((int)(bBacnetTime.isHourUnspecified() ? (bl ? 0 : 23) : bBacnetTime.getHour()), (int)(bBacnetTime.isMinuteUnspecified() ? (bl ? 0 : 59) : bBacnetTime.getMinute()), (int)(bBacnetTime.isSecondUnspecified() ? (bl ? 0 : 59) : bBacnetTime.getSecond()), (int)(bBacnetTime.isHundredthUnspecified() ? (bl ? 0 : 999) : bBacnetTime.getHundredth() * 10));
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BBacnetTime(int n, int n2, int n3, int n4) {
        this.hour = (byte)n;
        this.minute = (byte)n2;
        this.second = (byte)n3;
        this.hundredth = (byte)n4;
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetTime;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetTime = BBacnetTime.class("[Ljavax.baja.bacnet.datatypes.BBacnetTime;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

