/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetCalendarEntry;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetTimeValue;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.log.Log;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetSpecialEvent
extends BComponent
implements BIBacnetDataType {
    public static final Property eventName = BBacnetSpecialEvent.newProperty((int)0, (String)"event", null);
    public static final Property periodChoice = BBacnetSpecialEvent.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)1));
    public static final Property period = BBacnetSpecialEvent.newProperty((int)0, (BValue)new BBacnetCalendarEntry(), null);
    public static final Property eventPriority = BBacnetSpecialEvent.newProperty((int)0, (int)16, (BFacets)BFacets.makeInt((int)1, (int)16));
    public static final Action addTimeValue = BBacnetSpecialEvent.newAction((int)0, (BValue)new BBacnetTimeValue(), null);
    public static final Topic specialEventChanged = BBacnetSpecialEvent.newTopic((int)0, null);
    public static final Type TYPE;
    public static final int CALENDAR_ENTRY_TAG = 0;
    public static final int CALENDAR_REFERENCE_TAG = 1;
    public static final int LIST_OF_TIME_VALUES_TAG = 2;
    public static final int EVENT_PRIORITY_TAG = 3;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetSpecialEvent;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetTimeValue;

    public String getEventName() {
        return this.getString(eventName);
    }

    public void setEventName(String string) {
        this.setString(eventName, string, null);
    }

    public int getPeriodChoice() {
        return this.getInt(periodChoice);
    }

    public void setPeriodChoice(int n) {
        this.setInt(periodChoice, n, null);
    }

    public BValue getPeriod() {
        return this.get(period);
    }

    public void setPeriod(BValue bValue) {
        this.set(period, bValue, null);
    }

    public int getEventPriority() {
        return this.getInt(eventPriority);
    }

    public void setEventPriority(int n) {
        this.setInt(eventPriority, n, null);
    }

    public void addTimeValue(BBacnetTimeValue bBacnetTimeValue) {
        this.invoke(addTimeValue, (BValue)bBacnetTimeValue, null);
    }

    public void fireSpecialEventChanged(BValue bValue) {
        this.fire(specialEventChanged, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * Unable to fully structure code
     */
    public String toString(Context var1_1) {
        var2_2 = new StringBuffer();
        var2_2.append(this.getEventName()).append("[" + this.getPeriodChoice() + "]: ").append(this.getPeriod()).append(" pri" + this.getEventPriority() + ':');
        var3_3 = this.getProperties();
        if (true) ** GOTO lbl9
        do {
            var2_2.append(" ").append(((BBacnetTimeValue)var3_3.get()).toString(var1_1));
lbl9:
            // 2 sources

            if ((v0 = BBacnetSpecialEvent.class$javax$baja$bacnet$datatypes$BBacnetTimeValue) != null) continue;
            v0 = BBacnetSpecialEvent.class("[Ljavax.baja.bacnet.datatypes.BBacnetTimeValue;", false);
        } while (var3_3.next(v0));
        return var2_2.toString();
    }

    public void started() {
        if (!BacnetVirtualUtil.isVirtual(this) && this.getParent() instanceof BBacnetArray) {
            ((BBacnetArray)this.getParent()).linkTo(this, (Slot)specialEventChanged, (Slot)BBacnetArray.arrayPropertyChanged);
        }
        this.syncPeriod(true);
    }

    public void added(Property property, Context context) {
        if (!this.isMounted()) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (context != BacnetConst.noWrite) {
            this.sort();
            this.getParent().asComponent().changed(this.getPropertyInParent(), context);
            this.fireSpecialEventChanged(null);
        }
    }

    public void removed(Property property, BValue bValue, Context context) {
        if (!this.isMounted()) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (context != BacnetConst.noWrite) {
            this.sort();
            this.getParent().asComponent().changed(this.getPropertyInParent(), context);
            this.fireSpecialEventChanged(null);
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isMounted()) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)periodChoice)) {
            if (context != BacnetConst.noWrite) {
                this.syncPeriod(false);
            }
        } else if (property.equals((Object)period) && context != BacnetConst.noWrite) {
            this.syncPeriod(true);
        }
        if (context != BacnetConst.noWrite) {
            this.sort();
            this.getParent().asComponent().changed(this.getPropertyInParent(), context);
            this.fireSpecialEventChanged(null);
        }
    }

    private final void syncPeriod(boolean bl) {
        if (bl) {
            BValue bValue = this.getPeriod();
            if (bValue instanceof BBacnetCalendarEntry) {
                this.setInt(periodChoice, 0, BacnetConst.noWrite);
            } else if (bValue instanceof BBacnetObjectIdentifier) {
                this.setInt(periodChoice, 1, BacnetConst.noWrite);
            }
        } else {
            int n = this.getPeriodChoice();
            if (n == 0) {
                this.set(period, (BValue)new BBacnetCalendarEntry(), BacnetConst.noWrite);
            } else if (n == 1) {
                this.set(period, (BValue)BBacnetObjectIdentifier.make(6), BacnetConst.noWrite);
            }
        }
    }

    public final void subscribed() {
        BBacnetVirtualProperty bBacnetVirtualProperty = BacnetVirtualUtil.getVirtualProperty(this);
        if (bBacnetVirtualProperty != null) {
            bBacnetVirtualProperty.childSubscribed(this);
        }
    }

    public final void unsubscribed() {
        BBacnetVirtualProperty bBacnetVirtualProperty = BacnetVirtualUtil.getVirtualProperty(this);
        if (bBacnetVirtualProperty != null) {
            bBacnetVirtualProperty.childUnsubscribed(this);
        }
    }

    public BCategoryMask getAppliedCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getAppliedCategoryMask();
        }
        return super.getAppliedCategoryMask();
    }

    public BCategoryMask getCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getCategoryMask();
        }
        return super.getCategoryMask();
    }

    public BPermissions getPermissions(Context context) {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getPermissions(context);
        }
        return super.getPermissions(context);
    }

    public final void doAddTimeValue(BBacnetTimeValue bBacnetTimeValue) {
        this.add(null, (BValue)bBacnetTimeValue);
    }

    /*
     * Unable to fully structure code
     */
    public final void writeAsn(AsnOutput var1_1) {
        switch (this.getPeriodChoice()) {
            case 0: {
                var1_1.writeOpeningTag(0);
                ((BBacnetCalendarEntry)this.getPeriod()).writeAsn(var1_1);
                var1_1.writeClosingTag(0);
                break;
            }
            case 1: {
                var1_1.writeObjectIdentifier(1, (BBacnetObjectIdentifier)this.getPeriod());
            }
        }
        var1_1.writeOpeningTag(2);
        var2_2 = this.getProperties();
        if (true) ** GOTO lbl14
        do {
            ((BBacnetTimeValue)var2_2.get()).writeAsn(var1_1);
lbl14:
            // 2 sources

            if ((v0 = BBacnetSpecialEvent.class$javax$baja$bacnet$datatypes$BBacnetTimeValue) != null) continue;
            v0 = BBacnetSpecialEvent.class("[Ljavax.baja.bacnet.datatypes.BBacnetTimeValue;", false);
        } while (var2_2.next(v0));
        var1_1.writeClosingTag(2);
        var1_1.writeUnsignedInteger(3, this.getEventPriority());
    }

    public final void readAsn(AsnInput asnInput) throws AsnException {
        Object object;
        int n = asnInput.peekTag();
        if (asnInput.isOpeningTag(0)) {
            asnInput.skipTag();
            object = new BBacnetCalendarEntry();
            object.readAsn(asnInput);
            this.setInt(periodChoice, 0, BacnetConst.noWrite);
            this.set(period, (BValue)object, BacnetConst.noWrite);
            asnInput.skipTag();
        } else if (asnInput.isValueTag(1)) {
            this.setInt(periodChoice, 1, BacnetConst.noWrite);
            this.set(period, (BValue)asnInput.readObjectIdentifier(1), BacnetConst.noWrite);
        } else {
            throw new AsnException("Invalid tag: " + n);
        }
        n = asnInput.peekTag();
        if (!asnInput.isOpeningTag(2)) {
            throw new AsnException("Invalid tag: " + n);
        }
        asnInput.skipTag();
        n = asnInput.peekTag();
        while (!asnInput.isClosingTag(2)) {
            if (n == -1) {
                throw new AsnException("Invalid tag: " + n);
            }
            object = asnInput.readTime();
            BSimple bSimple = null;
            int n2 = asnInput.peekApplicationTag();
            switch (n2) {
                case 0: {
                    bSimple = asnInput.readNull();
                    break;
                }
                case 1: {
                    bSimple = BBoolean.make((boolean)asnInput.readBoolean());
                    break;
                }
                case 2: {
                    bSimple = asnInput.readUnsigned();
                    break;
                }
                case 3: {
                    bSimple = BInteger.make((int)asnInput.readSignedInteger());
                    break;
                }
                case 4: {
                    bSimple = BFloat.make((float)asnInput.readReal());
                    break;
                }
                case 5: {
                    bSimple = BDouble.make((double)asnInput.readDouble());
                    break;
                }
                case 6: {
                    bSimple = asnInput.readBacnetOctetString();
                    break;
                }
                case 7: {
                    bSimple = BString.make((String)asnInput.readCharacterString());
                    break;
                }
                case 8: {
                    bSimple = asnInput.readBitString();
                    break;
                }
                case 9: {
                    bSimple = BDynamicEnum.make((int)asnInput.readEnumerated());
                    break;
                }
                case 10: {
                    bSimple = asnInput.readDate();
                    break;
                }
                case 11: {
                    bSimple = asnInput.readTime();
                    break;
                }
                case 12: {
                    bSimple = asnInput.readObjectIdentifier();
                    break;
                }
                default: {
                    throw new AsnException("Invalid tag: " + n2);
                }
            }
            BBacnetTimeValue bBacnetTimeValue = this.getTV((BBacnetTime)((Object)object));
            if (bBacnetTimeValue == null) {
                this.add(null, (BValue)new BBacnetTimeValue((BBacnetTime)((Object)object), bSimple), BacnetConst.noWrite);
            } else {
                bBacnetTimeValue.set(BBacnetTimeValue.value, (BValue)bSimple, BacnetConst.noWrite);
            }
            n = asnInput.peekTag();
        }
        asnInput.skipTag();
        this.setInt(eventPriority, asnInput.readUnsignedInt(3), BacnetConst.noWrite);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final BAbsTime nextEvent(BAbsTime bAbsTime) {
        switch (this.getPeriodChoice()) {
            case 0: {
                BBacnetCalendarEntry bBacnetCalendarEntry = (BBacnetCalendarEntry)this.getPeriod();
                BAbsTime bAbsTime2 = bBacnetCalendarEntry.nextDate(bAbsTime);
                if (bAbsTime2 == null) {
                    return null;
                }
                BTime bTime = BTime.make((BAbsTime)bAbsTime);
                BBacnetTimeValue bBacnetTimeValue = null;
                BBacnetTimeValue bBacnetTimeValue2 = null;
                SlotCursor slotCursor = this.getProperties();
                while (true) {
                    Class clazz;
                    if ((clazz = class$javax$baja$bacnet$datatypes$BBacnetTimeValue) == null) {
                        clazz = BBacnetSpecialEvent.class("[Ljavax.baja.bacnet.datatypes.BBacnetTimeValue;", false);
                    }
                    if (!slotCursor.next(clazz)) {
                        if (bBacnetTimeValue2 != null) return BBacnetDateTime.makeBAbsTime(bAbsTime2, bBacnetTimeValue2.getTime());
                        return null;
                    }
                    bBacnetTimeValue = (BBacnetTimeValue)slotCursor.get();
                    if (!bBacnetTimeValue.getTime().isAfter(bTime) || bBacnetTimeValue2 != null && !bBacnetTimeValue.isBefore(bBacnetTimeValue2)) continue;
                    bBacnetTimeValue2 = bBacnetTimeValue;
                }
            }
            case 1: {
                Log.getLog((String)"bacnet.debug").error("Calendar reference choice not supported!");
                return null;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public final BSimple getValue(BAbsTime var1_1) {
        if (!this.isActive(var1_1)) {
            return null;
        }
        var2_2 = BTime.make((BAbsTime)var1_1);
        var3_3 = null;
        var4_4 = null;
        var5_5 = this.getProperties();
        if (true) ** GOTO lbl11
        do {
            if ((var3_3 = (BBacnetTimeValue)var5_5.get()).getTime().isNotAfter(var2_2) && (var4_4 == null || var3_3.isNotBefore(var4_4))) {
                var4_4 = var3_3;
            }
lbl11:
            // 4 sources

            if ((v0 = BBacnetSpecialEvent.class$javax$baja$bacnet$datatypes$BBacnetTimeValue) != null) continue;
            v0 = BBacnetSpecialEvent.class("[Ljavax.baja.bacnet.datatypes.BBacnetTimeValue;", false);
        } while (var5_5.next(v0));
        if (var4_4 == null) {
            var4_4 = var3_3;
        }
        if (var4_4 == null) {
            return BBacnetNull.DEFAULT;
        }
        return var4_4.getValue().getAny();
    }

    private final boolean isActive(BAbsTime bAbsTime) {
        switch (this.getPeriodChoice()) {
            case 0: {
                return ((BBacnetCalendarEntry)this.getPeriod()).isActive(bAbsTime);
            }
            case 1: {
                Log.getLog((String)"bacnet.debug").error("Calendar reference choice not supported!");
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private final BBacnetTimeValue getTV(BBacnetTime var1_1) {
        var2_2 = this.getProperties();
        if (true) ** GOTO lbl6
        do {
            if (((BBacnetTimeValue)var2_2.get()).getTime().equals((Object)var1_1)) {
                return (BBacnetTimeValue)var2_2.get();
            }
lbl6:
            // 3 sources

            if ((v0 = BBacnetSpecialEvent.class$javax$baja$bacnet$datatypes$BBacnetTimeValue) != null) continue;
            v0 = BBacnetSpecialEvent.class("[Ljavax.baja.bacnet.datatypes.BBacnetTimeValue;", false);
        } while (var2_2.next(v0));
        return null;
    }

    private final void sort() {
        Property[] propertyArray = this.getPropertiesArray();
        if (propertyArray.length > 4) {
            Property[] propertyArray2 = new Property[propertyArray.length - 4];
            System.arraycopy(propertyArray, 4, propertyArray2, 0, propertyArray2.length);
            int n = 0;
            while (n < propertyArray2.length - 1) {
                int n2 = n;
                int n3 = n + 1;
                while (n3 < propertyArray2.length) {
                    BBacnetTimeValue bBacnetTimeValue;
                    BBacnetTimeValue bBacnetTimeValue2 = (BBacnetTimeValue)this.get(propertyArray2[n3]);
                    if (bBacnetTimeValue2.isBefore(bBacnetTimeValue = (BBacnetTimeValue)this.get(propertyArray2[n2]))) {
                        n2 = n3;
                    }
                    ++n3;
                }
                Property property = propertyArray2[n];
                propertyArray2[n] = propertyArray2[n2];
                propertyArray2[n2] = property;
                ++n;
            }
            this.reorder(propertyArray2, null);
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetSpecialEvent", 2);
        spyWriter.prop((Object)"virtual", BacnetVirtualUtil.isVirtual(this));
        spyWriter.endProps();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetSpecialEvent;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetSpecialEvent = BBacnetSpecialEvent.class("[Ljavax.baja.bacnet.datatypes.BBacnetSpecialEvent;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

