/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.asn.AsnUtil;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetPropertyValue
extends BComponent
implements PropertyValue,
BIBacnetDataType {
    public static final Property propertyId = BBacnetPropertyValue.newProperty((int)0, (int)85, null);
    public static final Property propertyArrayIndex = BBacnetPropertyValue.newProperty((int)0, (int)-1, null);
    public static final Property value = BBacnetPropertyValue.newProperty((int)0, (BValue)BBacnetNull.DEFAULT, null);
    public static final Property priority = BBacnetPropertyValue.newProperty((int)0, (int)0, null);
    public static final Type TYPE;
    public static final int PROPERTY_ID_TAG = 0;
    public static final int PROPERTY_ARRAY_INDEX_TAG = 1;
    public static final int VALUE_TAG = 2;
    public static final int PRIORITY_TAG = 3;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetPropertyValue;

    public final int getPropertyId() {
        return this.getInt(propertyId);
    }

    public final void setPropertyId(int n) {
        this.setInt(propertyId, n, null);
    }

    public final int getPropertyArrayIndex() {
        return this.getInt(propertyArrayIndex);
    }

    public final void setPropertyArrayIndex(int n) {
        this.setInt(propertyArrayIndex, n, null);
    }

    public final BValue getValue() {
        return this.get(value);
    }

    public final void setValue(BValue bValue) {
        this.set(value, bValue, null);
    }

    public final int getPriority() {
        return this.getInt(priority);
    }

    public final void setPriority(int n) {
        this.setInt(priority, n, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final byte[] getPropertyValue() {
        return AsnUtil.toAsn(this.getValue());
    }

    public final ErrorType getPropertyAccessError() {
        return null;
    }

    public final int getErrorClass() {
        throw new IllegalStateException();
    }

    public final int getErrorCode() {
        throw new IllegalStateException();
    }

    public final boolean isError() {
        return false;
    }

    public final boolean isPropertyArrayIndexUsed() {
        boolean bl = false;
        if (this.getPropertyArrayIndex() != -1) {
            bl = true;
        }
        return bl;
    }

    public final boolean isPriorityUsed() {
        boolean bl = false;
        if (this.getPriority() > 0) {
            bl = true;
        }
        return bl;
    }

    public final void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeEnumerated(0, this.getPropertyId());
        if (this.isPropertyArrayIndexUsed()) {
            asnOutput.writeUnsignedInteger(1, this.getPropertyArrayIndex());
        }
        asnOutput.writeEncodedValue(2, AsnUtil.toAsn(this.getValue()));
        if (this.isPriorityUsed()) {
            asnOutput.writeUnsignedInteger(3, this.getPriority());
        }
    }

    public final void readAsn(AsnInput asnInput) throws AsnException {
        this.setInt(propertyId, asnInput.readEnumerated(0), BacnetConst.noWrite);
        asnInput.peekTag();
        if (asnInput.isValueTag(1)) {
            this.setInt(propertyArrayIndex, asnInput.readUnsignedInt(1), BacnetConst.noWrite);
        } else {
            this.setInt(propertyArrayIndex, -1, BacnetConst.noWrite);
        }
        BValue bValue = AsnUtil.asnToValue(asnInput.readEncodedValue(2));
        this.setValue(bValue);
        asnInput.peekTag();
        if (asnInput.isValueTag(3)) {
            this.setInt(priority, asnInput.readUnsignedInt(3), BacnetConst.noWrite);
        }
    }

    public final String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BBacnetPropertyIdentifier.tag(this.getPropertyId()));
        if (this.isPropertyArrayIndexUsed()) {
            stringBuffer.append('[').append(this.getPropertyArrayIndex()).append("]:");
        } else {
            stringBuffer.append(':');
        }
        stringBuffer.append(this.getValue().toString(context));
        if (this.isPriorityUsed()) {
            stringBuffer.append(" @").append(this.getPriority());
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BBacnetPropertyValue() {
    }

    public BBacnetPropertyValue(int n, BSimple bSimple) {
        this(n, -1, bSimple, 0);
    }

    public BBacnetPropertyValue(int n, int n2, BSimple bSimple) {
        this(n, n2, bSimple, 0);
    }

    public BBacnetPropertyValue(int n, BSimple bSimple, int n2) {
        this(n, -1, bSimple, n2);
    }

    public BBacnetPropertyValue(int n, int n2, BSimple bSimple, int n3) {
        this.setPropertyId(n);
        this.setPropertyArrayIndex(n2);
        this.setValue((BValue)bSimple);
        if (n3 < 0 || n3 > 16) {
            throw new IllegalArgumentException("BacnetPropertyValue.priority must be 1-16");
        }
        this.setPriority(n3);
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetPropertyValue;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetPropertyValue = BBacnetPropertyValue.class("[Ljavax.baja.bacnet.datatypes.BBacnetPropertyValue;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

