/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetBinaryPv;
import javax.baja.bacnet.enums.BBacnetDeviceStatus;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetLifeSafetyMode;
import javax.baja.bacnet.enums.BBacnetLifeSafetyState;
import javax.baja.bacnet.enums.BBacnetPolarity;
import javax.baja.bacnet.enums.BBacnetProgramError;
import javax.baja.bacnet.enums.BBacnetProgramRequest;
import javax.baja.bacnet.enums.BBacnetProgramState;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.enums.BBacnetRestartReason;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetPropertyStates
extends BComponent
implements BIBacnetDataType {
    public static final Property choice = BBacnetPropertyStates.newProperty((int)4, (int)0, null);
    public static final Type TYPE;
    private static final int MAX_TAG = 254;
    public static final int BOOLEAN_VALUE_TAG = 0;
    public static final int BINARY_VALUE_TAG = 1;
    public static final int EVENT_TYPE_TAG = 2;
    public static final int POLARITY_TAG = 3;
    public static final int PROGRAM_CHANGE_TAG = 4;
    public static final int PROGRAM_STATE_TAG = 5;
    public static final int REASON_FOR_HALT_TAG = 6;
    public static final int RELIABILITY_TAG = 7;
    public static final int STATE_TAG = 8;
    public static final int SYSTEM_STATUS_TAG = 9;
    public static final int UNITS_TAG = 10;
    public static final int UNSIGNED_VALUE_TAG = 11;
    public static final int LIFE_SAFETY_MODE_TAG = 12;
    public static final int LIFE_SAFETY_STATE_TAG = 13;
    public static final int RESTART_REASON_TAG = 14;
    public static final int BACKUP_STATE = 36;
    private static final int MAX_DEFINED_CHOICE = 14;
    private static final int MAX_ASHRAE_CHOICE = 63;
    private static final Lexicon lex;
    private static String[] tags;
    private static final int ASHRAE_CHOICE_INDEX = 15;
    private static final int PROPRIETARY_CHOICE_INDEX = 16;
    private static final int INVALID_CHOICE_INDEX = 17;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetPropertyStates;

    public final int getChoice() {
        return this.getInt(choice);
    }

    public final void setChoice(int n) {
        this.setInt(choice, n, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        BComplex bComplex = this.getParent();
        if (bComplex != null) {
            bComplex.asComponent().changed(this.getPropertyInParent(), context);
        }
    }

    public final void subscribed() {
        BBacnetVirtualProperty bBacnetVirtualProperty = BacnetVirtualUtil.getVirtualProperty(this);
        if (bBacnetVirtualProperty != null) {
            bBacnetVirtualProperty.childSubscribed(this);
        }
    }

    public final void unsubscribed() {
        BBacnetVirtualProperty bBacnetVirtualProperty = BacnetVirtualUtil.getVirtualProperty(this);
        if (bBacnetVirtualProperty != null) {
            bBacnetVirtualProperty.childUnsubscribed(this);
        }
    }

    public final BCategoryMask getAppliedCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getAppliedCategoryMask();
        }
        return super.getAppliedCategoryMask();
    }

    public final BCategoryMask getCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getCategoryMask();
        }
        return super.getCategoryMask();
    }

    public final BPermissions getPermissions(Context context) {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getPermissions(context);
        }
        return super.getPermissions(context);
    }

    public final String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTag());
        switch (this.getChoice()) {
            case 0: {
                stringBuffer.append((BBoolean)this.get("booleanValue"));
                break;
            }
            case 1: {
                stringBuffer.append((BEnum)this.get("binaryValue"));
                break;
            }
            case 2: {
                stringBuffer.append((BEnum)this.get("eventType"));
                break;
            }
            case 3: {
                stringBuffer.append((BEnum)this.get("polarity"));
                break;
            }
            case 4: {
                stringBuffer.append((BEnum)this.get("programChange"));
                break;
            }
            case 5: {
                stringBuffer.append((BEnum)this.get("programState"));
                break;
            }
            case 6: {
                stringBuffer.append((BEnum)this.get("reasonForHalt"));
                break;
            }
            case 7: {
                stringBuffer.append((BEnum)this.get("reliability"));
                break;
            }
            case 8: {
                stringBuffer.append((BEnum)this.get("state"));
                break;
            }
            case 9: {
                stringBuffer.append((BEnum)this.get("systemStatus"));
                break;
            }
            case 10: {
                stringBuffer.append((BEnum)this.get("units"));
                break;
            }
            case 11: {
                stringBuffer.append((Object)((BBacnetUnsigned)this.get("unsignedValue")));
                break;
            }
            case 12: {
                stringBuffer.append((BEnum)this.get("lifeSafetyMode"));
                break;
            }
            case 13: {
                stringBuffer.append((BEnum)this.get("lifeSafetyState"));
                break;
            }
            case 14: {
                stringBuffer.append((BEnum)this.get("restartReason"));
                break;
            }
        }
        return stringBuffer.toString();
    }

    public final void writeAsn(AsnOutput asnOutput) {
        switch (this.getChoice()) {
            case 0: {
                asnOutput.writeBoolean(0, (BBoolean)this.get("booleanValue"));
                break;
            }
            case 1: {
                asnOutput.writeEnumerated(1, (BEnum)this.get("binaryValue"));
                break;
            }
            case 2: {
                asnOutput.writeEnumerated(2, (BEnum)this.get("eventType"));
                break;
            }
            case 3: {
                asnOutput.writeEnumerated(3, (BEnum)this.get("polarity"));
                break;
            }
            case 4: {
                asnOutput.writeEnumerated(4, (BEnum)this.get("programChange"));
                break;
            }
            case 5: {
                asnOutput.writeEnumerated(5, (BEnum)this.get("programState"));
                break;
            }
            case 6: {
                asnOutput.writeEnumerated(6, (BEnum)this.get("reasonForHalt"));
                break;
            }
            case 7: {
                asnOutput.writeEnumerated(7, (BEnum)this.get("reliability"));
                break;
            }
            case 8: {
                asnOutput.writeEnumerated(8, (BEnum)this.get("state"));
                break;
            }
            case 9: {
                asnOutput.writeEnumerated(9, (BEnum)this.get("systemStatus"));
                break;
            }
            case 10: {
                asnOutput.writeEnumerated(10, (BEnum)this.get("units"));
                break;
            }
            case 11: {
                asnOutput.writeUnsigned(11, (BBacnetUnsigned)this.get("unsignedValue"));
                break;
            }
            case 12: {
                asnOutput.writeEnumerated(12, (BEnum)this.get("lifeSafetyMode"));
                break;
            }
            case 13: {
                asnOutput.writeEnumerated(13, (BEnum)this.get("lifeSafetyState"));
                break;
            }
            case 14: {
                asnOutput.writeEnumerated(14, (BEnum)this.get("restartReason"));
                break;
            }
        }
    }

    public final void readAsn(AsnInput asnInput) throws AsnException {
        int n = asnInput.peekTag();
        if (n < 0 || n > 254) {
            throw new AsnException("Invalid tag: " + n);
        }
        this.setInt(choice, n, BacnetConst.noWrite);
        this.removeAll(BacnetConst.noWrite);
        switch (n) {
            case 0: {
                this.add("booleanValue", (BValue)BBoolean.make((boolean)asnInput.readBoolean(n)), BacnetConst.noWrite);
                break;
            }
            case 1: {
                this.add("binaryValue", (BValue)BBacnetBinaryPv.make(asnInput.readEnumerated(n)), BacnetConst.noWrite);
                break;
            }
            case 2: {
                this.add("eventType", (BValue)BDynamicEnum.make((int)asnInput.readEnumerated(n), (BEnumRange)BBacnetEventType.DEFAULT.getRange()), BacnetConst.noWrite);
                break;
            }
            case 3: {
                this.add("polarity", (BValue)BBacnetPolarity.make(asnInput.readEnumerated(n)), BacnetConst.noWrite);
                break;
            }
            case 4: {
                this.add("programChange", (BValue)BBacnetProgramRequest.make(asnInput.readEnumerated(n)), BacnetConst.noWrite);
                break;
            }
            case 5: {
                this.add("programState", (BValue)BBacnetProgramState.make(asnInput.readEnumerated(n)), BacnetConst.noWrite);
                break;
            }
            case 6: {
                this.add("reasonForHalt", (BValue)BDynamicEnum.make((int)asnInput.readEnumerated(n), (BEnumRange)BBacnetProgramError.DEFAULT.getRange()), BacnetConst.noWrite);
                break;
            }
            case 7: {
                this.add("reliability", (BValue)BDynamicEnum.make((int)asnInput.readEnumerated(n), (BEnumRange)BBacnetReliability.DEFAULT.getRange()), BacnetConst.noWrite);
                break;
            }
            case 8: {
                this.add("state", (BValue)BDynamicEnum.make((int)asnInput.readEnumerated(n), (BEnumRange)BBacnetEventState.DEFAULT.getRange()), BacnetConst.noWrite);
                break;
            }
            case 9: {
                this.add("systemStatus", (BValue)BDynamicEnum.make((int)asnInput.readEnumerated(n), (BEnumRange)BBacnetDeviceStatus.DEFAULT.getRange()), BacnetConst.noWrite);
                break;
            }
            case 10: {
                this.add("units", (BValue)BDynamicEnum.make((int)asnInput.readEnumerated(n), (BEnumRange)BBacnetEngineeringUnits.DEFAULT.getRange()), BacnetConst.noWrite);
                break;
            }
            case 11: {
                this.add("unsignedValue", (BValue)BBacnetUnsigned.make(asnInput.readUnsignedInteger(n)), BacnetConst.noWrite);
                break;
            }
            case 12: {
                this.add("lifeSafetyMode", (BValue)BDynamicEnum.make((int)asnInput.readEnumerated(n), (BEnumRange)BBacnetLifeSafetyMode.DEFAULT.getRange()), BacnetConst.noWrite);
                break;
            }
            case 13: {
                this.add("lifeSafetyState", (BValue)BDynamicEnum.make((int)asnInput.readEnumerated(n), (BEnumRange)BBacnetLifeSafetyState.DEFAULT.getRange()), BacnetConst.noWrite);
                break;
            }
            case 14: {
                this.add("restartReason", (BValue)BDynamicEnum.make((int)asnInput.readEnumerated(n), (BEnumRange)BBacnetRestartReason.DEFAULT.getRange()), BacnetConst.noWrite);
                break;
            }
            default: {
                asnInput.skipTag();
            }
        }
    }

    public final void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetPropertyStates", 2);
        spyWriter.prop((Object)"virtual", BacnetVirtualUtil.isVirtual(this));
        spyWriter.endProps();
    }

    private final String getTag() {
        int n = this.getChoice();
        if (n < 0 || n > 254) {
            n = 17;
        }
        if (n <= 14) {
            return tags[n];
        }
        int n2 = 0;
        if (n <= 63) {
            n2 = 1;
        }
        n = 16 - n2;
        return tags[n];
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetPropertyStates;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetPropertyStates = BBacnetPropertyStates.class("[Ljavax.baja.bacnet.datatypes.BBacnetPropertyStates;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"bacnet");
        tags = new String[]{lex.getText("BacnetPropertyStates.booleanValue"), lex.getText("BacnetPropertyStates.binaryValue"), lex.getText("BacnetPropertyStates.eventType"), lex.getText("BacnetPropertyStates.polarity"), lex.getText("BacnetPropertyStates.programChange"), lex.getText("BacnetPropertyStates.programState"), lex.getText("BacnetPropertyStates.reasonForHalt"), lex.getText("BacnetPropertyStates.reliability"), lex.getText("BacnetPropertyStates.state"), lex.getText("BacnetPropertyStates.systemStatus"), lex.getText("BacnetPropertyStates.units"), lex.getText("BacnetPropertyStates.unsignedValue"), lex.getText("BacnetPropertyStates.lifeSafetyMode"), lex.getText("BacnetPropertyStates.lifeSafetyState"), lex.getText("BacnetPropertyStates.restartReason"), lex.getText("BacnetPropertyStates.ashrae"), lex.getText("BacnetPropertyStates.proprietary"), lex.getText("BacnetPropertyStates.invalid")};
    }
}

