/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetObjectPropertyReference
extends BStruct
implements BIBacnetDataType,
PropertyReference {
    public static final Property objectId = BBacnetObjectPropertyReference.newProperty((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    public static final Property propertyId = BBacnetObjectPropertyReference.newProperty((int)0, (int)85, null);
    public static final Property propertyArrayIndex = BBacnetObjectPropertyReference.newProperty((int)0, (int)-1, null);
    public static final Type TYPE;
    public static final int OBJECT_ID_TAG = 0;
    public static final int PROPERTY_ID_TAG = 1;
    public static final int PROPERTY_ARRAY_INDEX_TAG = 2;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetObjectPropertyReference;

    public final BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public final void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public final int getPropertyId() {
        return this.getInt(propertyId);
    }

    public final void setPropertyId(int n) {
        this.setInt(propertyId, n, null);
    }

    public final int getPropertyArrayIndex() {
        return this.getInt(propertyArrayIndex);
    }

    public final void setPropertyArrayIndex(int n) {
        this.setInt(propertyArrayIndex, n, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final boolean isPropertyArrayIndexUsed() {
        boolean bl = false;
        if (this.getPropertyArrayIndex() != -1) {
            bl = true;
        }
        return bl;
    }

    public final void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeObjectIdentifier(0, this.getObjectId());
        asnOutput.writeEnumerated(1, this.getPropertyId());
        if (this.isPropertyArrayIndexUsed()) {
            asnOutput.writeUnsignedInteger(2, this.getPropertyArrayIndex());
        }
    }

    public final void readAsn(AsnInput asnInput) throws AsnException {
        this.set(objectId, (BValue)asnInput.readObjectIdentifier(0), BacnetConst.noWrite);
        this.setInt(propertyId, asnInput.readEnumerated(1), BacnetConst.noWrite);
        asnInput.peekTag();
        if (asnInput.isValueTag(2)) {
            this.setInt(propertyArrayIndex, asnInput.readUnsignedInt(2), BacnetConst.noWrite);
        } else {
            this.setInt(propertyArrayIndex, -1, BacnetConst.noWrite);
        }
    }

    public final String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getObjectId().toString(context)).append('_').append(BBacnetPropertyIdentifier.tag(this.getPropertyId()));
        if (context != null && context.equals(BacnetConst.nameContext)) {
            if (this.isPropertyArrayIndexUsed()) {
                stringBuffer.append('_').append(this.getPropertyArrayIndex());
            }
        } else {
            stringBuffer.append('[').append(this.getPropertyArrayIndex()).append(']');
        }
        return stringBuffer.toString();
    }

    public final String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("\n  " + this.getObjectId().toString());
        stringBuffer.append("\n  " + BBacnetPropertyIdentifier.tag(this.getPropertyId()));
        if (this.isPropertyArrayIndexUsed()) {
            stringBuffer.append("[" + this.getPropertyArrayIndex() + ']');
        }
        return stringBuffer.toString();
    }

    public final String encodeToString() throws IOException {
        return this.getObjectId().encodeToString() + '|' + String.valueOf(this.getPropertyId()) + '|' + String.valueOf(this.getPropertyArrayIndex());
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            BBacnetObjectIdentifier bBacnetObjectIdentifier = BBacnetObjectIdentifier.DEFAULT;
            BBacnetObjectIdentifier bBacnetObjectIdentifier2 = (BBacnetObjectIdentifier)bBacnetObjectIdentifier.decodeFromString(stringTokenizer.nextToken());
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            return new BBacnetObjectPropertyReference(bBacnetObjectIdentifier2, n, n2);
        }
        catch (Exception exception) {
            throw new IOException("Error decoding BBacnetObjectPropertyReference " + string);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BBacnetObjectPropertyReference() {
    }

    public BBacnetObjectPropertyReference(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.setObjectId(bBacnetObjectIdentifier);
    }

    public BBacnetObjectPropertyReference(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n) {
        this.setObjectId(bBacnetObjectIdentifier);
        this.setPropertyId(n);
    }

    public BBacnetObjectPropertyReference(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2) {
        this.setObjectId(bBacnetObjectIdentifier);
        this.setPropertyId(n);
        this.setPropertyArrayIndex(n2);
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetObjectPropertyReference;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetObjectPropertyReference = BBacnetObjectPropertyReference.class("[Ljavax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

