/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetObjectIdentifier
extends BSimple
implements BIComparable {
    public static final int OBJECT_TYPE_MASK = -4194304;
    public static final int OBJECT_TYPE_MASK_SHIFTED = 1023;
    public static final int INSTANCE_NUMBER_MASK = 0x3FFFFF;
    public static final int OBJECT_TYPE_SHIFT = 22;
    public static final int MIN_INSTANCE_NUMBER = 0;
    public static final int MAX_INSTANCE_NUMBER = 0x3FFFFE;
    public static final int UNCONFIGURED_INSTANCE_NUMBER = 0x3FFFFF;
    private static final char SEP = ':';
    private static final char NAME_SEP = '_';
    public static final BBacnetObjectIdentifier DEFAULT = new BBacnetObjectIdentifier(0, -1);
    public static final BBacnetObjectIdentifier DEFAULT_DEVICE = new BBacnetObjectIdentifier(8, -1);
    public static final Type TYPE;
    private int objectType;
    private int instanceNumber;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetObjectIdentifier;

    public static final BBacnetObjectIdentifier make(int n) {
        return new BBacnetObjectIdentifier(n, -1);
    }

    public static final BBacnetObjectIdentifier make(int n, int n2) {
        return new BBacnetObjectIdentifier(n, n2);
    }

    public static final BBacnetObjectIdentifier makeId(int n) {
        int n2 = n >> 22 & 0x3FF;
        int n3 = n & 0x3FFFFF;
        return new BBacnetObjectIdentifier(n2, n3);
    }

    public final boolean equals(Object object) {
        if (object instanceof BBacnetObjectIdentifier) {
            boolean bl = false;
            if (((BBacnetObjectIdentifier)((Object)object)).objectType == this.objectType && ((BBacnetObjectIdentifier)((Object)object)).instanceNumber == this.instanceNumber) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final String toString(Context context) {
        char c = ':';
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (context != null) {
                BEnumRange bEnumRange;
                if (context.equals(BacnetConst.nameContext) || context.equals(BacnetConst.facetsContext)) {
                    c = '_';
                }
                if ((bEnumRange = (BEnumRange)context.getFacet("range")) != null) {
                    stringBuffer.append(bEnumRange.getTag(this.objectType)).append(c).append(this.instanceNumber);
                } else {
                    stringBuffer.append(BBacnetObjectType.tag(this.objectType)).append(c).append(this.instanceNumber);
                }
                if (context.equals(BacnetConst.nameContext) || context.equals(BacnetConst.facetsContext)) {
                    return SlotPath.escape((String)stringBuffer.toString());
                }
                return stringBuffer.toString();
            }
            return this.encodeToString();
        }
        catch (IOException iOException) {
            return iOException.toString();
        }
    }

    public final String toShortString() {
        if (this.instanceNumber == 0x3FFFFF) {
            return "";
        }
        return BBacnetObjectType.getShortTag(this.objectType) + this.instanceNumber;
    }

    public final int hashCode() {
        return this.objectType << 22 & 0xFFC00000 | this.instanceNumber & 0x3FFFFF;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.objectType);
        dataOutput.writeInt(this.instanceNumber);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return new BBacnetObjectIdentifier(dataInput.readInt(), dataInput.readInt());
    }

    public final String encodeToString() throws IOException {
        return BBacnetObjectType.tag(this.objectType) + ':' + String.valueOf(this.instanceNumber);
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":_ ");
            int n = BBacnetObjectType.ordinal(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            return new BBacnetObjectIdentifier(n, n2);
        }
        catch (Exception exception) {
            throw new IOException("Error decoding BBacnetObjectIdentifier " + string);
        }
    }

    public final boolean isValid() {
        boolean bl = false;
        if (this.objectType >= 0 && this.instanceNumber >= 0 && this.instanceNumber < 0x3FFFFF) {
            bl = true;
        }
        return bl;
    }

    public final int getObjectType() {
        return this.objectType;
    }

    public final int getInstanceNumber() {
        return this.instanceNumber;
    }

    public final int getId() {
        return this.hashCode();
    }

    public final BBacnetObjectIdentifier newId(int n) {
        return new BBacnetObjectIdentifier(this.objectType, n);
    }

    public final int compareTo(Object object) {
        if (!(object instanceof BBacnetObjectIdentifier)) {
            throw new ClassCastException();
        }
        BBacnetObjectIdentifier bBacnetObjectIdentifier = (BBacnetObjectIdentifier)((Object)object);
        long l = this.hashCode();
        long l2 = bBacnetObjectIdentifier.hashCode();
        return (int)(l - l2);
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BBacnetObjectIdentifier(int n, int n2) {
        this.objectType = n;
        this.instanceNumber = n2;
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetObjectIdentifier;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetObjectIdentifier = BBacnetObjectIdentifier.class("[Ljavax.baja.bacnet.datatypes.BBacnetObjectIdentifier;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

