/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetDeviceObjectPropertyReference
extends BStruct
implements BIBacnetDataType,
PropertyReference {
    public static final Property objectId = BBacnetDeviceObjectPropertyReference.newProperty((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    public static final Property propertyId = BBacnetDeviceObjectPropertyReference.newProperty((int)0, (int)85, null);
    public static final Property propertyArrayIndex = BBacnetDeviceObjectPropertyReference.newProperty((int)0, (int)-1, null);
    public static final Property deviceId = BBacnetDeviceObjectPropertyReference.newProperty((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT_DEVICE, (BFacets)BBacnetObjectType.getObjectIdFacets(8));
    public static final Type TYPE;
    public static final int MAX_ENCODED_SIZE = 16;
    private static final String SEP = "_";
    private static final BBacnetDeviceObjectPropertyReference REF;
    public static final int OBJECT_ID_TAG = 0;
    public static final int PROPERTY_ID_TAG = 1;
    public static final int PROPERTY_ARRAY_INDEX_TAG = 2;
    public static final int DEVICE_ID_TAG = 3;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetDeviceObjectPropertyReference;

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public int getPropertyId() {
        return this.getInt(propertyId);
    }

    public void setPropertyId(int n) {
        this.setInt(propertyId, n, null);
    }

    public int getPropertyArrayIndex() {
        return this.getInt(propertyArrayIndex);
    }

    public void setPropertyArrayIndex(int n) {
        this.setInt(propertyArrayIndex, n, null);
    }

    public BBacnetObjectIdentifier getDeviceId() {
        return (BBacnetObjectIdentifier)this.get(deviceId);
    }

    public void setDeviceId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(deviceId, (BValue)bBacnetObjectIdentifier, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final boolean isPropertyArrayIndexUsed() {
        boolean bl = false;
        if (this.getPropertyArrayIndex() != -1) {
            bl = true;
        }
        return bl;
    }

    public final boolean isDeviceIdUsed() {
        return deviceId.isEquivalentToDefaultValue(this.get(deviceId)) ^ true;
    }

    public final void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeObjectIdentifier(0, this.getObjectId());
        asnOutput.writeEnumerated(1, this.getPropertyId());
        if (this.isPropertyArrayIndexUsed()) {
            asnOutput.writeUnsignedInteger(2, this.getPropertyArrayIndex());
        }
        if (this.isDeviceIdUsed()) {
            asnOutput.writeObjectIdentifier(3, this.getDeviceId());
        }
    }

    public final void readAsn(AsnInput asnInput) throws AsnException {
        this.set(objectId, (BValue)asnInput.readObjectIdentifier(0), BacnetConst.noWrite);
        this.setInt(propertyId, asnInput.readEnumerated(1), BacnetConst.noWrite);
        asnInput.peekTag();
        if (asnInput.isValueTag(2)) {
            this.setInt(propertyArrayIndex, asnInput.readUnsignedInt(2), BacnetConst.noWrite);
        } else {
            this.setInt(propertyArrayIndex, -1, BacnetConst.noWrite);
        }
        asnInput.peekTag();
        if (asnInput.isValueTag(3)) {
            this.set(deviceId, (BValue)asnInput.readObjectIdentifier(3), BacnetConst.noWrite);
        } else {
            this.set(deviceId, (BValue)BBacnetObjectIdentifier.DEFAULT_DEVICE, BacnetConst.noWrite);
        }
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getObjectId().toString(context)).append('_').append(BBacnetPropertyIdentifier.tag(this.getPropertyId()));
        if (context != null && context.equals(BacnetConst.nameContext)) {
            if (this.isPropertyArrayIndexUsed()) {
                stringBuffer.append('_').append(this.getPropertyArrayIndex());
            }
            if (this.isDeviceIdUsed()) {
                stringBuffer.append('_').append(this.getDeviceId().toString(context));
            }
        } else {
            stringBuffer.append('[').append(this.getPropertyArrayIndex()).append(']');
            if (this.isDeviceIdUsed()) {
                stringBuffer.append(" in ").append(this.getDeviceId().toString(context));
            }
        }
        return stringBuffer.toString();
    }

    public final String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("\n  " + this.getObjectId().toString());
        stringBuffer.append("\n  " + BBacnetPropertyIdentifier.tag(this.getPropertyId()));
        if (this.isPropertyArrayIndexUsed()) {
            stringBuffer.append("[" + this.getPropertyArrayIndex() + ']');
        }
        if (this.isDeviceIdUsed()) {
            stringBuffer.append("\n  " + this.getDeviceId().toString());
        }
        return stringBuffer.toString();
    }

    public final String encodeToString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getObjectId().getObjectType()).append(SEP).append(this.getObjectId().getInstanceNumber()).append(SEP).append(this.getPropertyId());
        if (this.isPropertyArrayIndexUsed()) {
            stringBuffer.append(SEP).append(this.getPropertyArrayIndex());
        }
        if (this.isDeviceIdUsed()) {
            stringBuffer.append(SEP).append(this.getDeviceId().getObjectType()).append(SEP).append(this.getDeviceId().getInstanceNumber());
        }
        return stringBuffer.toString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, SEP);
            int n = stringTokenizer.countTokens();
            if (n < 3) {
                throw new IOException("Incomplete BacnetDeviceObjectPropretyReference:" + string);
            }
            BBacnetObjectIdentifier bBacnetObjectIdentifier = BBacnetObjectIdentifier.make(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = -1;
            BBacnetObjectIdentifier bBacnetObjectIdentifier2 = BBacnetObjectIdentifier.DEFAULT_DEVICE;
            if (n == 4 || n == 6) {
                n3 = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (n > 4) {
                bBacnetObjectIdentifier2 = BBacnetObjectIdentifier.make(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            }
            return new BBacnetDeviceObjectPropertyReference(bBacnetObjectIdentifier, n2, n3, bBacnetObjectIdentifier2);
        }
        catch (Exception exception) {
            throw new IOException("Error decoding BBacnetObjectPropertyReference " + string);
        }
    }

    public static final BBacnetDeviceObjectPropertyReference fromString(String string) {
        try {
            return (BBacnetDeviceObjectPropertyReference)REF.decodeFromString(string);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return null;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BBacnetDeviceObjectPropertyReference() {
    }

    public BBacnetDeviceObjectPropertyReference(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.setObjectId(bBacnetObjectIdentifier);
    }

    public BBacnetDeviceObjectPropertyReference(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n) {
        this.setObjectId(bBacnetObjectIdentifier);
        this.setPropertyId(n);
    }

    public BBacnetDeviceObjectPropertyReference(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2) {
        this.setObjectId(bBacnetObjectIdentifier);
        this.setPropertyId(n);
        this.setPropertyArrayIndex(n2);
    }

    public BBacnetDeviceObjectPropertyReference(BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, BBacnetObjectIdentifier bBacnetObjectIdentifier2) {
        this.setObjectId(bBacnetObjectIdentifier);
        this.setPropertyId(n);
        this.setPropertyArrayIndex(n2);
        this.setDeviceId(bBacnetObjectIdentifier2);
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetDeviceObjectPropertyReference;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetDeviceObjectPropertyReference = BBacnetDeviceObjectPropertyReference.class("[Ljavax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        REF = new BBacnetDeviceObjectPropertyReference();
    }
}

