/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.client.AsyncEventNotificationRequest;
import java.util.StringTokenizer;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetAlarmConst;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetRecipient;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTimeRange;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetDestination
extends BAlarmRecipient
implements BIBacnetDataType,
BacnetAlarmConst {
    public static final Property timeRange = BBacnetDestination.newProperty((int)0, (BValue)new BTimeRange(BTime.make((int)0, (int)0, (int)0, (int)0), BTime.make((int)23, (int)59, (int)59, (int)999)), null);
    public static final Property routeAcks = BBacnetDestination.newProperty((int)1, (boolean)true, null);
    public static final Property transitions = BBacnetDestination.newProperty((int)0, (BValue)BAlarmTransitionBits.make((int)7), null);
    public static final Property recipient = BBacnetDestination.newProperty((int)8, (BValue)new BBacnetRecipient(), null);
    public static final Property processIdentifier = BBacnetDestination.newProperty((int)0, (BValue)BBacnetUnsigned.make(0L), null);
    public static final Property issueConfirmedNotifications = BBacnetDestination.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE;
    public static final long LOCAL_PROCESS_ID = 0L;
    public static final int MAX_ENCODED_SIZE = 35;
    private boolean client;
    private BEnumRange eventStateRange;
    private final Log log;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetDestination;

    public BBacnetRecipient getRecipient() {
        return (BBacnetRecipient)this.get(recipient);
    }

    public void setRecipient(BBacnetRecipient bBacnetRecipient) {
        this.set(recipient, (BValue)bBacnetRecipient, null);
    }

    public BBacnetUnsigned getProcessIdentifier() {
        return (BBacnetUnsigned)this.get(processIdentifier);
    }

    public void setProcessIdentifier(BBacnetUnsigned bBacnetUnsigned) {
        this.set(processIdentifier, (BValue)bBacnetUnsigned, null);
    }

    public boolean getIssueConfirmedNotifications() {
        return this.getBoolean(issueConfirmedNotifications);
    }

    public void setIssueConfirmedNotifications(boolean bl) {
        this.setBoolean(issueConfirmedNotifications, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void handleAlarm(BAlarmRecord bAlarmRecord) {
        try {
            BBacnetObjectIdentifier bBacnetObjectIdentifier;
            boolean bl = this.log.isTraceOn();
            if (bl) {
                this.log.trace("handleAlarm on " + SlotPath.unescape((String)this.getName()) + ':' + bAlarmRecord + "\n alarmData=" + bAlarmRecord.getAlarmData() + "\n uuid=" + bAlarmRecord.getUuid());
            }
            BObject bObject = bAlarmRecord.getSource().get(0).get((BObject)this);
            BComponent bComponent = bObject.asComplex().getParent().asComponent();
            BOrd bOrd = bComponent.getOrdInSession();
            BBacnetObjectIdentifier bBacnetObjectIdentifier2 = BBacnetNetwork.localDevice().lookupBacnetObjectId(bOrd);
            if (bBacnetObjectIdentifier2 == null) {
                this.log.warning("Alarm " + bAlarmRecord.getUuid() + " not sent to " + this.getRecipient() + ": object " + bComponent.getName() + " not exposed to BACnet!");
                return;
            }
            BString bString = (BString)bAlarmRecord.getAlarmFacet("toState");
            BBacnetEventState bBacnetEventState = bString != null ? BBacnetEventState.make(bString.getString()) : BBacnetEventState.make(bAlarmRecord.getSourceState());
            boolean bl2 = false;
            BInteger bInteger = (BInteger)bAlarmRecord.getAlarmFacet("stateAcked");
            if (bAlarmRecord.isAcknowledged()) {
                BBoolean bBoolean;
                bBacnetObjectIdentifier = BBacnetNetwork.localDevice().getObjectId();
                if (BBacnetEventState.isNormal((BEnum)bBacnetEventState)) {
                    bBoolean = (BBoolean)bAlarmRecord.getAlarmFacet("offnormalAcked");
                    if (bBoolean != null) {
                        bl2 = bBoolean.getBoolean() ^ true;
                    } else {
                        BString bString2 = (BString)bAlarmRecord.getAlarmFacet("fromState");
                        bl2 = bString.equals((Object)bString2) ^ true;
                    }
                } else if (BBacnetEventState.isOffnormal((BEnum)bBacnetEventState)) {
                    bBoolean = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                    bAlarmRecord.addAlarmFacet("offnormalAcked", (BIDataValue)BBoolean.TRUE);
                    bBoolean.getAlarmDb().update(bAlarmRecord);
                }
                if (bl) {
                    this.log.trace("acknowledged - stateAcked=" + bInteger + " ar:" + this.ackDump(bAlarmRecord) + ", toState(alarm)=" + bBacnetEventState);
                }
                if (bInteger != null) {
                    bBacnetEventState = BBacnetEventState.make(bInteger.getInt());
                }
                bBoolean = ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getServer().getEventHandler().getRecordFromEventBuffer(bBacnetEventState.getOrdinal(), bBacnetObjectIdentifier, bBacnetObjectIdentifier2, 0L, bAlarmRecord.getUuid(), false);
                if (bl) {
                    this.log.trace("dest " + this.getName() + ": rec=" + (bBoolean != null ? bBoolean.getUuid().toString() : "null"));
                }
                if (bBoolean == null) {
                    if (bl) {
                        this.log.trace("Skipping event notification: No matching record in event buffer for " + (Object)((Object)bBacnetObjectIdentifier) + ' ' + (Object)((Object)bBacnetObjectIdentifier2) + " 0 with UUID " + bAlarmRecord.getUuid());
                    }
                    return;
                }
                this.removeFromNotifyList(bAlarmRecord);
            } else {
                bBacnetObjectIdentifier = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                if (bl) {
                    System.out.println("stateAcked=" + bInteger + " ar:" + this.ackDump(bAlarmRecord));
                }
                if (bInteger == null) {
                    if (bl) {
                        System.out.println(" new alarm - add acksReq to BAC_ACK_REQUIRED");
                    }
                    int n = 0;
                    BInteger bInteger2 = (BInteger)bAlarmRecord.getAlarmFacet("bacnetAcksRequired");
                    if (bInteger2 != null) {
                        n = bInteger2.getInt();
                    }
                    BAlarmClass bAlarmClass = bBacnetObjectIdentifier.lookupAlarmClass(bAlarmRecord.getAlarmClass());
                    BAlarmTransitionBits bAlarmTransitionBits = bAlarmClass.getAckRequired();
                    if (BBacnetEventState.isOffnormal((BEnum)bBacnetEventState)) {
                        if (bAlarmTransitionBits.isToOffnormal()) {
                            bAlarmRecord.removeAlarmFacet("offnormalAcked");
                            n |= 4;
                        }
                    } else if (BBacnetEventState.isFault((BEnum)bBacnetEventState)) {
                        if (bAlarmTransitionBits.isToFault()) {
                            n |= 2;
                        }
                    } else if (BBacnetEventState.isNormal((BEnum)bBacnetEventState) && bAlarmTransitionBits.isToNormal()) {
                        n |= 1;
                    }
                    bAlarmRecord.addAlarmFacet("bacnetAcksRequired", (BIDataValue)BInteger.make((int)n));
                }
                this.addToNotifyList(bAlarmRecord);
                bBacnetObjectIdentifier.getAlarmDb().update(bAlarmRecord);
            }
            bBacnetObjectIdentifier = (BBoolean)bAlarmRecord.getAlarmFacet("staleAck");
            if (bBacnetObjectIdentifier != null && bBacnetObjectIdentifier.getBoolean()) {
                this.log.trace("Skipping event notification for stale ack (BAC_STALE_ACK)");
                return;
            }
            AsyncEventNotificationRequest asyncEventNotificationRequest = new AsyncEventNotificationRequest(bAlarmRecord, bComponent, this.getProcessIdentifier().getUnsigned(), this.getRecipient(), this.getIssueConfirmedNotifications(), bl2);
            BBacnetNetwork.bacnet().postAsync(asyncEventNotificationRequest);
        }
        catch (Exception exception) {
            this.log.error("Exception handling alarm in " + this.getName() + ':', (Throwable)exception);
        }
    }

    public final boolean recipientEquals(BBacnetRecipient bBacnetRecipient) {
        return this.getRecipient().equivalent(bBacnetRecipient);
    }

    public final boolean destinationEquals(BBacnetDestination bBacnetDestination) {
        return this.destinationEquals(bBacnetDestination, false);
    }

    public final boolean destinationEquals(BBacnetDestination bBacnetDestination, boolean bl) {
        if (bBacnetDestination == null) {
            return false;
        }
        int n = BAlarmTransitionBits.ALL.getBits() & 0xFFFFFFF7;
        int n2 = this.getTransitions().getBits() & n;
        int n3 = bBacnetDestination.getTransitions().getBits() & n;
        return this.timeRangesEquivalent(this.getTimeRange(), bBacnetDestination.getTimeRange(), bl) && this.getDaysOfWeek().equals((Object)bBacnetDestination.getDaysOfWeek()) && n2 == n3 && this.getTransitions().getBits() == bBacnetDestination.getTransitions().getBits() && this.getRecipient().equivalent(bBacnetDestination.getRecipient()) && this.getProcessIdentifier().equals((Object)bBacnetDestination.getProcessIdentifier()) && this.getIssueConfirmedNotifications() == bBacnetDestination.getIssueConfirmedNotifications();
    }

    public final boolean timeRangesEquivalent(BTimeRange bTimeRange, BTimeRange bTimeRange2, boolean bl) {
        if (bl) {
            return bTimeRange.equivalent((Object)bTimeRange2);
        }
        boolean bl2 = false;
        if (bTimeRange.getStartTime().getHour() == bTimeRange2.getStartTime().getHour() && bTimeRange.getStartTime().getMinute() == bTimeRange2.getStartTime().getMinute() && bTimeRange.getStartTime().getSecond() == bTimeRange2.getStartTime().getSecond() && bTimeRange.getEndTime().getHour() == bTimeRange2.getEndTime().getHour() && bTimeRange.getEndTime().getMinute() == bTimeRange2.getEndTime().getMinute() && bTimeRange.getEndTime().getSecond() == bTimeRange2.getEndTime().getSecond()) {
            bl2 = true;
        }
        return bl2;
    }

    public final void started() {
        if (this.getParent() instanceof BBacnetListOf) {
            this.client = true;
        }
        if (Sys.atSteadyState() && this.isRunning()) {
            this.resolveRecipient();
        }
    }

    public final void changed(Property property, Context context) {
        BComplex bComplex;
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)recipient)) {
            this.resolveRecipient();
        }
        if ((bComplex = this.getParent()) != null) {
            bComplex.asComponent().changed(this.getPropertyInParent(), context);
        }
    }

    public final void atSteadyState() throws Exception {
        super.atSteadyState();
        this.resolveRecipient();
    }

    public final void subscribed() {
        BBacnetVirtualProperty bBacnetVirtualProperty = BacnetVirtualUtil.getVirtualProperty((BComponent)this);
        if (bBacnetVirtualProperty != null) {
            bBacnetVirtualProperty.childSubscribed((BComponent)this);
        }
    }

    public final void unsubscribed() {
        BBacnetVirtualProperty bBacnetVirtualProperty = BacnetVirtualUtil.getVirtualProperty((BComponent)this);
        if (bBacnetVirtualProperty != null) {
            bBacnetVirtualProperty.childSubscribed((BComponent)this);
        }
    }

    public final boolean isParentLegal(BComponent bComponent) {
        boolean bl = false;
        if (bComponent instanceof BAlarmService || bComponent instanceof BBacnetListOf) {
            bl = true;
        }
        return bl;
    }

    public final BCategoryMask getAppliedCategoryMask() {
        if (BacnetVirtualUtil.isVirtual((BComponent)this)) {
            return this.getParent().asComponent().getAppliedCategoryMask();
        }
        return super.getAppliedCategoryMask();
    }

    public final BCategoryMask getCategoryMask() {
        if (BacnetVirtualUtil.isVirtual((BComponent)this)) {
            return this.getParent().asComponent().getCategoryMask();
        }
        return super.getCategoryMask();
    }

    public final BPermissions getPermissions(Context context) {
        if (BacnetVirtualUtil.isVirtual((BComponent)this)) {
            return this.getParent().asComponent().getPermissions(context);
        }
        return super.getPermissions(context);
    }

    public boolean accept(BAlarmRecord bAlarmRecord) {
        BAbsTime bAbsTime = BAbsTime.now();
        if (!this.getDaysOfWeek().includes(bAbsTime.getWeekday())) {
            return false;
        }
        if (!this.getTimeRange().includes(bAbsTime)) {
            return false;
        }
        return this.getTransitions().includes(bAlarmRecord.getSourceState());
    }

    private final void resolveRecipient() {
        if (!this.client) {
            if (this.getRecipient().isDevice()) {
                BBacnetObjectIdentifier bBacnetObjectIdentifier = this.getRecipient().getDevice();
                if (bBacnetObjectIdentifier.isValid() && bBacnetObjectIdentifier.getObjectType() == 8 && BBacnetNetwork.bacnet().doLookupDeviceById(bBacnetObjectIdentifier) == null) {
                    try {
                        ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient().whoIs(BBacnetAddress.GLOBAL_BROADCAST_ADDRESS, bBacnetObjectIdentifier.getInstanceNumber(), bBacnetObjectIdentifier.getInstanceNumber());
                    }
                    catch (BacnetException bacnetException) {
                        this.log.warning("Unable to determine address for Bacnet Destination " + this.getName() + ": " + this.getRecipient(), (Throwable)((Object)bacnetException));
                    }
                }
            } else {
                BBacnetAddress bBacnetAddress = this.getRecipient().getAddress();
                if (BBacnetNetwork.bacnet().doLookupDeviceByAddress(bBacnetAddress) == null) {
                    try {
                        ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient().whoIs(bBacnetAddress);
                    }
                    catch (BacnetException bacnetException) {
                        this.log.error("Unable to resolve address for Bacnet Destination " + this.getName() + ": " + this.getRecipient(), (Throwable)((Object)bacnetException));
                    }
                }
            }
        }
    }

    private final void addToNotifyList(BAlarmRecord bAlarmRecord) {
        BString bString = (BString)bAlarmRecord.getAlarmFacet("bacNotify");
        bString = bString == null ? BString.make((String)this.getHandle().toString()) : BString.make((String)(bString.getString() + ';' + this.getHandle().toString()));
        bAlarmRecord.addAlarmFacet("bacNotify", (BIDataValue)bString);
    }

    private final boolean removeFromNotifyList(BAlarmRecord bAlarmRecord) {
        BString bString = (BString)bAlarmRecord.getAlarmFacet("bacNotify");
        String string = this.getHandle().toString();
        if (bString != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(bString.getString(), ";");
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string.equals(string2)) continue;
                stringBuffer.append(string2).append(";");
            }
            if (stringBuffer.length() == 0) {
                bAlarmRecord.removeAlarmFacet("bacNotify");
                return false;
            }
            bAlarmRecord.addAlarmFacet("bacNotify", (BIDataValue)BString.make((String)stringBuffer.toString()));
            return true;
        }
        return false;
    }

    public final void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeBitString(BacnetBitStringUtil.getBacnetDaysOfWeek(this.getDaysOfWeek()).getBits());
        asnOutput.writeTime(this.getTimeRange().getStartTime());
        asnOutput.writeTime(this.getTimeRange().getEndTime());
        this.getRecipient().writeAsn(asnOutput);
        asnOutput.writeUnsigned(this.getProcessIdentifier());
        asnOutput.writeBoolean(this.getIssueConfirmedNotifications());
        asnOutput.writeBitString(BacnetBitStringUtil.getBacnetEventTransitionBits(this.getTransitions()).getBits());
    }

    public final void readAsn(AsnInput asnInput) throws AsnException {
        this.set(daysOfWeek, (BValue)BacnetBitStringUtil.getBDaysOfWeekBits(asnInput.readBitString()), BacnetConst.noWrite);
        this.getTimeRange().set(BTimeRange.startTime, (BValue)BBacnetTime.getBTime(asnInput.readTime(), true), BacnetConst.noWrite);
        this.getTimeRange().set(BTimeRange.endTime, (BValue)BBacnetTime.getBTime(asnInput.readTime(), false), BacnetConst.noWrite);
        this.getRecipient().readAsn(asnInput);
        this.set(processIdentifier, (BValue)asnInput.readUnsigned(), BacnetConst.noWrite);
        this.setBoolean(issueConfirmedNotifications, asnInput.readBoolean(), BacnetConst.noWrite);
        this.set(transitions, (BValue)BacnetBitStringUtil.getBAlarmTransitionBits(asnInput.readBitString()), BacnetConst.noWrite);
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getRecipient().toString(context)).append(" pId=").append((Object)this.getProcessIdentifier()).append(" conf=").append(this.getIssueConfirmedNotifications()).append(" times=").append(this.getTimeRange().toString(context)).append(" days=").append(this.getDaysOfWeek().toString(context)).append(" trans=").append(this.getTransitions().toString(context));
        return stringBuffer.toString();
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetDestination", 2);
        spyWriter.prop((Object)"client", this.client);
        spyWriter.prop((Object)"eventStateRange", (Object)this.eventStateRange);
        spyWriter.prop((Object)"virtual", BacnetVirtualUtil.isVirtual((BComponent)this));
        spyWriter.endProps();
    }

    private final String ackDump(BAlarmRecord bAlarmRecord) {
        return "" + bAlarmRecord.getSourceState() + '/' + bAlarmRecord.getAckState() + '/' + bAlarmRecord.getAckRequired();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.client = false;
        this.eventStateRange = BBacnetEventState.DEFAULT.getRange();
        this.log = Log.getLog((String)"bacnet.server");
    }

    public BBacnetDestination() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetDestination;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetDestination = BBacnetDestination.class("[Ljavax.baja.bacnet.datatypes.BBacnetDestination;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

