/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetDateTime
extends BStruct
implements BIBacnetDataType,
Comparable {
    public static final Property date = BBacnetDateTime.newProperty((int)0, (BValue)BBacnetDate.DEFAULT, null);
    public static final Property time = BBacnetDateTime.newProperty((int)0, (BValue)BBacnetTime.DEFAULT, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetDateTime;

    public BBacnetDate getDate() {
        return (BBacnetDate)this.get(date);
    }

    public void setDate(BBacnetDate bBacnetDate) {
        this.set(date, (BValue)bBacnetDate, null);
    }

    public BBacnetTime getTime() {
        return (BBacnetTime)this.get(time);
    }

    public void setTime(BBacnetTime bBacnetTime) {
        this.set(time, (BValue)bBacnetTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void writeAsn(AsnOutput asnOutput) {
        asnOutput.writeDate(this.getDate());
        asnOutput.writeTime(this.getTime());
    }

    public final void readAsn(AsnInput asnInput) throws AsnException {
        this.set(date, (BValue)asnInput.readDate(), BacnetConst.noWrite);
        this.set(time, (BValue)asnInput.readTime(), BacnetConst.noWrite);
    }

    public String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.getDate().toString(context) + ' ' + this.getTime().toString(context);
        }
        return this.getDate().toString(context) + '_' + this.getTime().toString(context);
    }

    public final boolean isAnyUnspecified() {
        boolean bl = false;
        if (this.getDate().isAnyUnspecified() || this.getTime().isAnyUnspecified()) {
            bl = true;
        }
        return bl;
    }

    public final BAbsTime toBAbsTime() {
        return BBacnetDateTime.makeBAbsTime(this.getDate(), this.getTime());
    }

    public final void fromBAbsTime(BAbsTime bAbsTime) {
        this.setDate(BBacnetDate.make(bAbsTime));
        this.setTime(BBacnetTime.make(bAbsTime));
    }

    public final boolean dateTimeEquals(Object object) {
        boolean bl = false;
        if (this.compareTo(object) == 0) {
            bl = true;
        }
        return bl;
    }

    public final int compareTo(Object object) {
        if (object == null) {
            throw new ClassCastException();
        }
        BBacnetDateTime bBacnetDateTime = (BBacnetDateTime)object;
        int n = this.getDate().compareTo((Object)bBacnetDateTime.getDate());
        if (n != 0) {
            return n;
        }
        return this.getTime().compareTo((Object)bBacnetDateTime.getTime());
    }

    public final boolean isBefore(Object object) {
        boolean bl = false;
        if (this.compareTo(object) < 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isAfter(Object object) {
        boolean bl = false;
        if (this.compareTo(object) > 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isNotBefore(Object object) {
        boolean bl = false;
        if (this.compareTo(object) >= 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isNotAfter(Object object) {
        boolean bl = false;
        if (this.compareTo(object) <= 0) {
            bl = true;
        }
        return bl;
    }

    public static final BBacnetDateTime fromString(String string) {
        BBacnetDate bBacnetDate = BBacnetDate.fromString(string.substring(0, 14));
        BBacnetTime bBacnetTime = BBacnetTime.fromString(string.substring(15, 26));
        return new BBacnetDateTime(bBacnetDate, bBacnetTime);
    }

    public static final BAbsTime makeBAbsTime(BBacnetDate bBacnetDate, BBacnetTime bBacnetTime) {
        int n;
        int n2 = bBacnetDate.isYearUnspecified() ? 1900 : bBacnetDate.getYear();
        BMonth bMonth = bBacnetDate.isMonthUnspecified() ? BMonth.january : bBacnetDate.getBMonth();
        int n3 = 1;
        if (!bBacnetDate.isDayOfMonthUnspecified()) {
            n3 = bBacnetDate.getDayOfMonth();
        }
        int n4 = n3;
        int n5 = 0;
        if (!bBacnetTime.isHourUnspecified()) {
            n5 = bBacnetTime.getHour();
        }
        int n6 = n5;
        int n7 = 0;
        if (!bBacnetTime.isMinuteUnspecified()) {
            n7 = n = bBacnetTime.getMinute();
        }
        if (bBacnetTime.isSecondUnspecified() || bBacnetTime.isHundredthUnspecified()) {
            return BAbsTime.make((int)n2, (BMonth)bMonth, (int)n4, (int)n6, (int)n);
        }
        return BAbsTime.make((int)n2, (BMonth)bMonth, (int)n4, (int)n6, (int)n, (int)bBacnetTime.getSecond(), (int)(bBacnetTime.getHundredth() * 10));
    }

    public static final BAbsTime makeBAbsTime(BAbsTime bAbsTime, BBacnetTime bBacnetTime) {
        int n;
        int n2 = 0;
        if (!bBacnetTime.isHourUnspecified()) {
            n2 = bBacnetTime.getHour();
        }
        int n3 = n2;
        int n4 = 0;
        if (!bBacnetTime.isMinuteUnspecified()) {
            n4 = n = bBacnetTime.getMinute();
        }
        if (bBacnetTime.isSecondUnspecified() || bBacnetTime.isHundredthUnspecified()) {
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)n3, (int)n);
        }
        return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bBacnetTime.getHour(), (int)bBacnetTime.getMinute(), (int)bBacnetTime.getSecond(), (int)(bBacnetTime.getHundredth() * 10));
    }

    public static final void main(String[] stringArray) {
        BAbsTime bAbsTime = BAbsTime.make();
        System.out.println("BAbsTime:" + bAbsTime);
        BBacnetDateTime bBacnetDateTime = new BBacnetDateTime(bAbsTime);
        System.out.println("BacnetDateTime:" + bBacnetDateTime);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BBacnetDateTime() {
    }

    public BBacnetDateTime(BBacnetDate bBacnetDate, BBacnetTime bBacnetTime) {
        this.setDate(bBacnetDate);
        this.setTime(bBacnetTime);
    }

    public BBacnetDateTime(BAbsTime bAbsTime) {
        this.setDate(BBacnetDate.make(bAbsTime));
        this.setTime(BBacnetTime.make(bAbsTime));
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetDateTime;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetDateTime = BBacnetDateTime.class("[Ljavax.baja.bacnet.datatypes.BBacnetDateTime;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

