/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetDate
extends BSimple
implements BIComparable {
    public static final byte UNSPECIFIED = -1;
    public static final byte LAST_DAY_OF_MONTH = 32;
    public static final byte ODD_MONTHS = 13;
    public static final byte EVEN_MONTHS = 14;
    private static Lexicon lex = Lexicon.make((String)"baja");
    private static final String[] WEEKDAYS_LEXICONIZED = new String[]{lex.getText("monday.short"), lex.getText("tuesday.short"), lex.getText("wednesday.short"), lex.getText("thursday.short"), lex.getText("friday.short"), lex.getText("saturday.short"), lex.getText("sunday.short")};
    private static final String[] WEEKDAYS = new String[]{lex.getText("Mon"), lex.getText("Tue"), lex.getText("Wed"), lex.getText("Thu"), lex.getText("Fri"), lex.getText("Sat"), lex.getText("Sun")};
    static final int TEXT_LENGTH = 14;
    public static final BBacnetDate DEFAULT = new BBacnetDate(-1, -1, -1, -1);
    public static final Type TYPE;
    private byte year;
    private byte month;
    private byte dayOfMonth;
    private byte dayOfWeek;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetDate;

    public static final BBacnetDate make() {
        return new BBacnetDate(-1, -1, -1, -1);
    }

    public static final BBacnetDate make(int n, int n2, int n3, int n4) {
        return new BBacnetDate(n, n2, n3, n4);
    }

    public static final BBacnetDate make(int n, int n2, int n3) {
        if (n == -1 || n2 == -1 || n2 == 13 || n2 == 14 || n3 == -1 || n3 == 32) {
            return BBacnetDate.make(n, n2, n3, -1);
        }
        BAbsTime bAbsTime = BAbsTime.make((int)(n + 1900), (BMonth)BMonth.make((int)(n2 - 1)), (int)n3);
        return BBacnetDate.make(bAbsTime);
    }

    public static final BBacnetDate make(BAbsTime bAbsTime) {
        int n = bAbsTime.getYear() - 1900;
        int n2 = bAbsTime.getMonth().getOrdinal() + 1;
        int n3 = bAbsTime.getDay();
        int n4 = bAbsTime.getWeekday().getOrdinal();
        if (n4 == 0) {
            n4 = 7;
        }
        return new BBacnetDate(n, n2, n3, n4);
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof BBacnetDate) {
            BBacnetDate bBacnetDate = (BBacnetDate)((Object)object);
            boolean bl = false;
            if (this.year == bBacnetDate.year && this.month == bBacnetDate.month && this.dayOfMonth == bBacnetDate.dayOfMonth && this.dayOfWeek == bBacnetDate.dayOfWeek) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final int hashCode() {
        return this.year << 24 | this.month << 16 | this.dayOfMonth << 8 | this.dayOfWeek;
    }

    public final String toString(Context context) {
        return this.toString(context, true);
    }

    private final String toString(Context context, boolean bl) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.year == -1) {
                stringBuffer.append("****-");
            } else {
                stringBuffer.append((this.year & 0xFF) + 1900).append('-');
            }
            if (this.month == -1) {
                stringBuffer.append("**-");
            } else if (this.month == 14) {
                stringBuffer.append("EV-");
            } else if (this.month == 13) {
                stringBuffer.append("OD-");
            } else {
                stringBuffer.append(this.month < 10 ? "0" + this.month : String.valueOf(this.month)).append('-');
            }
            if (this.dayOfMonth == -1) {
                stringBuffer.append("**-");
            } else if (this.dayOfMonth == 32) {
                stringBuffer.append("LD-");
            } else {
                stringBuffer.append(this.dayOfMonth < 10 ? "0" + this.dayOfMonth : String.valueOf(this.dayOfMonth)).append('-');
            }
            if (this.dayOfWeek == -1) {
                stringBuffer.append("***");
            } else if (bl) {
                stringBuffer.append(WEEKDAYS_LEXICONIZED[this.dayOfWeek - 1]);
            } else {
                stringBuffer.append(WEEKDAYS[this.dayOfWeek - 1]);
            }
            return stringBuffer.toString();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.year);
        dataOutput.writeByte(this.month);
        dataOutput.writeByte(this.dayOfMonth);
        dataOutput.writeByte(this.dayOfWeek);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        byte by2 = dataInput.readByte();
        byte by3 = dataInput.readByte();
        byte by4 = dataInput.readByte();
        return new BBacnetDate(by, by2, by3, by4);
    }

    public final String encodeToString() throws IOException {
        return this.toString(null, false);
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            String string2 = stringTokenizer.nextToken();
            int n5 = n = string2.indexOf("*") < 0 ? Integer.parseInt(string2) - 1900 : -1;
            if (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                n2 = string3.indexOf("*") != -1 ? -1 : (string3.indexOf("EV") != -1 ? 14 : (string3.indexOf("OD") != -1 ? 13 : Integer.parseInt(string3)));
                if (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    n3 = string4.indexOf("*") != -1 ? -1 : (string4.indexOf("LD") != -1 ? 32 : Integer.parseInt(string4));
                    if (stringTokenizer.hasMoreTokens()) {
                        String string5 = stringTokenizer.nextToken();
                        n4 = string5.indexOf("*") < 0 ? this.weekday(string5) : -1;
                    }
                }
            }
            return new BBacnetDate(n, n2, n3, n4);
        }
        catch (Exception exception) {
            throw new IOException("Error decoding BBacnetDate:" + string + "; exc=" + exception.toString());
        }
    }

    public final int getYear() {
        if (this.isYearUnspecified()) {
            return -1;
        }
        return (this.year & 0xFF) + 1900;
    }

    public final int getRawYear() {
        return this.year & 0xFF;
    }

    public final int getMonth() {
        return this.month;
    }

    public final BMonth getBMonth() {
        if (this.isMonthUnspecified()) {
            throw new IllegalStateException("Month is unspecified!");
        }
        if (this.isEvenMonths()) {
            throw new IllegalStateException("Month is EVEN MONTHS");
        }
        if (this.isOddMonths()) {
            throw new IllegalStateException("Month is ODD MONTHS");
        }
        return BMonth.make((int)(this.month - 1));
    }

    public final int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public final int getDayOfWeek() {
        return this.dayOfWeek;
    }

    public final BWeekday getBWeekday() {
        if (this.isDayOfWeekUnspecified()) {
            throw new IllegalStateException("DayOfWeek is unspecified!");
        }
        if (this.dayOfWeek == 7) {
            return BWeekday.make((int)0);
        }
        return BWeekday.make((int)this.dayOfWeek);
    }

    public final boolean isYearUnspecified() {
        boolean bl = false;
        if (this.year == -1) {
            bl = true;
        }
        return bl;
    }

    public final boolean isMonthUnspecified() {
        boolean bl = false;
        if (this.month == -1) {
            bl = true;
        }
        return bl;
    }

    public final boolean isOddMonths() {
        boolean bl = false;
        if (this.month == 13) {
            bl = true;
        }
        return bl;
    }

    public final boolean isEvenMonths() {
        boolean bl = false;
        if (this.month == 14) {
            bl = true;
        }
        return bl;
    }

    public final boolean isDayOfMonthUnspecified() {
        boolean bl = false;
        if (this.dayOfMonth == -1) {
            bl = true;
        }
        return bl;
    }

    public final boolean isLastDayOfMonth() {
        boolean bl = false;
        if (this.dayOfMonth == 32) {
            bl = true;
        }
        return bl;
    }

    public final boolean isDayOfWeekUnspecified() {
        boolean bl = false;
        if (this.dayOfWeek == -1) {
            bl = true;
        }
        return bl;
    }

    public final boolean isAnyUnspecified() {
        boolean bl = false;
        if (this.year == -1 || this.month == -1 || this.dayOfMonth == -1 || this.dayOfWeek == -1) {
            bl = true;
        }
        return bl;
    }

    public final boolean dateEquals(Object object) {
        boolean bl = false;
        if (this.compareTo(object) == 0) {
            bl = true;
        }
        return bl;
    }

    public final int compareTo(Object object) {
        if (object == null) {
            throw new ClassCastException();
        }
        BBacnetDate bBacnetDate = (BBacnetDate)((Object)object);
        if (!bBacnetDate.isYearUnspecified() && !this.isYearUnspecified()) {
            int n = this.year & 0xFF;
            int n2 = bBacnetDate.year & 0xFF;
            if (n < n2) {
                return -1;
            }
            if (n > n2) {
                return 1;
            }
        }
        if (!(bBacnetDate.isMonthUnspecified() || this.isMonthUnspecified() || bBacnetDate.isOddMonths() || this.isOddMonths() || bBacnetDate.isEvenMonths() || this.isEvenMonths())) {
            if (this.month < bBacnetDate.month) {
                return -1;
            }
            if (this.month > bBacnetDate.month) {
                return 1;
            }
        }
        if (!(bBacnetDate.isDayOfMonthUnspecified() || this.isDayOfMonthUnspecified() || bBacnetDate.isLastDayOfMonth() || this.isLastDayOfMonth())) {
            if (this.dayOfMonth < bBacnetDate.dayOfMonth) {
                return -1;
            }
            if (this.dayOfMonth > bBacnetDate.dayOfMonth) {
                return 1;
            }
        }
        if (!bBacnetDate.isDayOfWeekUnspecified() && !this.isDayOfWeekUnspecified()) {
            if (this.dayOfWeek < bBacnetDate.dayOfWeek) {
                return -1;
            }
            if (this.dayOfWeek > bBacnetDate.dayOfWeek) {
                return 1;
            }
        }
        return 0;
    }

    public final boolean isBefore(Object object) {
        boolean bl = false;
        if (this.compareTo(object) < 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isAfter(Object object) {
        boolean bl = false;
        if (this.compareTo(object) > 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isNotBefore(Object object) {
        boolean bl = false;
        if (this.compareTo(object) >= 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isNotAfter(Object object) {
        boolean bl = false;
        if (this.compareTo(object) <= 0) {
            bl = true;
        }
        return bl;
    }

    public final BAbsTime makeBAbsTime(BAbsTime bAbsTime) {
        int n = this.isYearUnspecified() ? bAbsTime.getYear() : this.getYear();
        BMonth bMonth = this.isMonthUnspecified() || this.isOddMonths() || this.isEvenMonths() ? bAbsTime.getMonth() : this.getBMonth();
        int n2 = this.isDayOfMonthUnspecified() || this.isLastDayOfMonth() ? bAbsTime.getDay() : this.getDayOfMonth();
        return BAbsTime.make((int)n, (BMonth)bMonth, (int)n2, (int)bAbsTime.getHour(), (int)bAbsTime.getMinute(), (int)bAbsTime.getSecond(), (int)bAbsTime.getMillisecond(), (BTimeZone)bAbsTime.getTimeZone());
    }

    public static final BBacnetDate fromString(String string) {
        try {
            return (BBacnetDate)DEFAULT.decodeFromString(string);
        }
        catch (Exception exception) {
            System.out.println("BBacnetDate.fromString('" + string + "'): error parsing string!!");
            return DEFAULT;
        }
    }

    private final int weekday(String string) {
        int n = 0;
        while (n < WEEKDAYS.length) {
            if (string.equals(WEEKDAYS[n])) {
                return n + 1;
            }
            ++n;
        }
        n = 0;
        while (n < WEEKDAYS_LEXICONIZED.length) {
            if (string.equals(WEEKDAYS_LEXICONIZED[n])) {
                return n + 1;
            }
            ++n;
        }
        throw new IllegalArgumentException("Invalid weekday:" + string);
    }

    public final Type getType() {
        return TYPE;
    }

    public static final void main(String[] stringArray) {
        BBacnetDate bBacnetDate = BBacnetDate.make();
        BBacnetDate bBacnetDate2 = BBacnetDate.make(0, 0, 0, 0);
        BBacnetDate bBacnetDate3 = BBacnetDate.make(128, 1, 2, 3);
        BBacnetDate bBacnetDate4 = BBacnetDate.make(2028, 4, 5, 6);
        BBacnetDate bBacnetDate5 = BBacnetDate.make(2099, 12, -1, -1);
        BBacnetDate bBacnetDate6 = BBacnetDate.make(199, 13, 32, -1);
        BBacnetDate bBacnetDate7 = BBacnetDate.make(107, 4, 17);
        System.out.println("d1=" + (Object)((Object)bBacnetDate));
        System.out.println("d2=" + (Object)((Object)bBacnetDate2));
        System.out.println("d3=" + (Object)((Object)bBacnetDate3));
        System.out.println("d4=" + (Object)((Object)bBacnetDate4));
        System.out.println("d5=" + (Object)((Object)bBacnetDate5));
        System.out.println("d6=" + (Object)((Object)bBacnetDate6));
        System.out.println("d7=" + (Object)((Object)bBacnetDate7));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BBacnetDate(int n, int n2, int n3, int n4) {
        if (n < 0) {
            n = -1;
        }
        if (n >= 1900) {
            n -= 1900;
        }
        if (n2 < 1 || n2 > 14) {
            n2 = -1;
        }
        if (n3 < 1 || n3 > 32) {
            n3 = -1;
        }
        if (n4 < 1 || n4 > 7) {
            n4 = -1;
        }
        this.year = (byte)n;
        this.month = (byte)n2;
        this.dayOfMonth = (byte)n3;
        this.dayOfWeek = (byte)n4;
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetDate;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetDate = BBacnetDate.class("[Ljavax.baja.bacnet.datatypes.BBacnetDate;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

