/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import java.util.GregorianCalendar;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetDateRange;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBacnetCalendarEntry
extends BStruct
implements BIBacnetDataType {
    public static final Property choice = BBacnetCalendarEntry.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)2));
    public static final Property date = BBacnetCalendarEntry.newProperty((int)0, (BValue)BBacnetDate.DEFAULT, null);
    public static final Property dateRange = BBacnetCalendarEntry.newProperty((int)0, (BValue)new BBacnetDateRange(), null);
    public static final Property weekNDay = BBacnetCalendarEntry.newProperty((int)0, (BValue)BBacnetOctetString.BACNET_WEEK_N_DAY, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"bacnet:BacnetWeekNDayFE")));
    public static final Type TYPE;
    public static final int DATE_TAG = 0;
    public static final int DATE_RANGE_TAG = 1;
    public static final int WEEK_N_DAY_TAG = 2;
    private static GregorianCalendar GREG;
    private static int MAX_ITERATIONS;
    public static final int MAX_ENCODED_SIZE = 12;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetCalendarEntry;

    public final int getChoice() {
        return this.getInt(choice);
    }

    public final void setChoice(int n) {
        this.setInt(choice, n, null);
    }

    public final BBacnetDate getDate() {
        return (BBacnetDate)this.get(date);
    }

    public final void setDate(BBacnetDate bBacnetDate) {
        this.set(date, (BValue)bBacnetDate, null);
    }

    public final BBacnetDateRange getDateRange() {
        return (BBacnetDateRange)this.get(dateRange);
    }

    public final void setDateRange(BBacnetDateRange bBacnetDateRange) {
        this.set(dateRange, (BValue)bBacnetDateRange, null);
    }

    public final BBacnetOctetString getWeekNDay() {
        return (BBacnetOctetString)this.get(weekNDay);
    }

    public final void setWeekNDay(BBacnetOctetString bBacnetOctetString) {
        this.set(weekNDay, (BValue)bBacnetOctetString, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final String toString(Context object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BBacnetCalendarEntry:").append(this.getChoice()).append(" ");
        switch (this.getChoice()) {
            case 0: {
                stringBuffer.append(this.getDate().toString((Context)object));
                break;
            }
            case 1: {
                stringBuffer.append(this.getDateRange().toString((Context)object));
                break;
            }
            case 2: {
                object = object != null ? new BasicContext(object, BFacets.make((String)"bacOctetStr", (BIDataValue)BString.make((String)"weekNDay"))) : BFacets.make((String)"bacOctetStr", (BIDataValue)BString.make((String)"weekNDay"));
                stringBuffer.append(this.getWeekNDay().toString((Context)object));
                break;
            }
        }
        return stringBuffer.toString();
    }

    public final BValue getCalendarEntry() {
        switch (this.getChoice()) {
            case 0: {
                return this.getDate();
            }
            case 1: {
                return this.getDateRange();
            }
            case 2: {
                return this.getWeekNDay();
            }
        }
        throw new IllegalStateException();
    }

    public final void setCalendarEntry(BValue bValue) {
        this.setCalendarEntry(bValue, null);
    }

    public final void setCalendarEntry(BValue bValue, Context context) {
        Type type = bValue.getType();
        if (type == BBacnetDate.TYPE) {
            this.setInt(choice, 0, context);
            this.set(date, bValue, context);
        } else if (type == BBacnetDateRange.TYPE) {
            this.setInt(choice, 1, context);
            this.set(dateRange, bValue.newCopy(), context);
        } else if (type == BBacnetOctetString.TYPE) {
            this.setInt(choice, 2, context);
            this.set(weekNDay, bValue, context);
        }
    }

    public final boolean isActive(BAbsTime bAbsTime) {
        BBacnetDate bBacnetDate = BBacnetDate.make(bAbsTime);
        switch (this.getChoice()) {
            case 0: {
                return this.getDate().dateEquals((Object)bBacnetDate);
            }
            case 1: {
                boolean bl = false;
                if (this.getDateRange().getStartDate().isNotAfter((Object)bBacnetDate) && this.getDateRange().getEndDate().isNotBefore((Object)bBacnetDate)) {
                    bl = true;
                }
                return bl;
            }
            case 2: {
                int n = bAbsTime.getMonth().getOrdinal() + 1;
                int n2 = bAbsTime.getDay();
                int n3 = bAbsTime.getWeekday().getOrdinal();
                if (n3 == 0) {
                    n3 = 7;
                }
                byte[] byArray = this.getWeekNDay().getBytes();
                boolean bl = true;
                if (byArray.length < 3) {
                    throw new IllegalStateException();
                }
                if (byArray[0] != -1 && byArray[0] != n) {
                    bl = false;
                }
                if (byArray[1] != -1) {
                    switch (byArray[1]) {
                        case 1: {
                            boolean bl2 = false;
                            if (n2 >= 1 && n2 <= 7) {
                                bl2 = true;
                            }
                            return bl2;
                        }
                        case 2: {
                            boolean bl3 = false;
                            if (n2 >= 8 && n2 <= 14) {
                                bl3 = true;
                            }
                            return bl3;
                        }
                        case 3: {
                            boolean bl4 = false;
                            if (n2 >= 15 && n2 <= 21) {
                                bl4 = true;
                            }
                            return bl4;
                        }
                        case 4: {
                            boolean bl5 = false;
                            if (n2 >= 22 && n2 <= 28) {
                                bl5 = true;
                            }
                            return bl5;
                        }
                        case 5: {
                            boolean bl6 = false;
                            if (n2 >= 29 && n2 <= 31) {
                                bl6 = true;
                            }
                            return bl6;
                        }
                        case 6: {
                            int n4 = GREG.getActualMaximum(5);
                            boolean bl7 = false;
                            if (n2 > n4 - 7 && n2 <= n4) {
                                bl7 = true;
                            }
                            return bl7;
                        }
                    }
                    Log.getLog((String)"bacnet.debug").error("Incorrect weekOfMonth configuration for BBacnetWeekNDay in BBacnetCalendarEntry!");
                    throw new IllegalStateException();
                }
                if (byArray[2] != -1 && byArray[2] != n3) {
                    bl = false;
                }
                return bl;
            }
        }
        throw new IllegalArgumentException("Invalid calendar entry type:" + this.getChoice());
    }

    public final BAbsTime nextDate(BAbsTime bAbsTime) {
        BBacnetDate bBacnetDate = BBacnetDate.make(bAbsTime);
        switch (this.getChoice()) {
            case 0: {
                if (!bBacnetDate.isNotAfter((Object)this.getDate())) break;
                return this.getDate().makeBAbsTime(bAbsTime);
            }
            case 1: {
                if (!bBacnetDate.isNotAfter((Object)this.getDateRange().getEndDate())) break;
                if (bBacnetDate.isNotBefore((Object)this.getDateRange().getStartDate())) {
                    return bAbsTime;
                }
                return this.getDateRange().getStartDate().makeBAbsTime(bAbsTime);
            }
            case 2: {
                int n = 0;
                while (n < MAX_ITERATIONS) {
                    if (this.isActive(bAbsTime)) {
                        return bAbsTime;
                    }
                    bAbsTime = bAbsTime.nextDay();
                    ++n;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return null;
    }

    public final void writeAsn(AsnOutput asnOutput) {
        switch (this.getChoice()) {
            case 0: {
                asnOutput.writeDate(0, this.getDate());
                break;
            }
            case 1: {
                asnOutput.writeOpeningTag(1);
                this.getDateRange().writeAsn(asnOutput);
                asnOutput.writeClosingTag(1);
                break;
            }
            case 2: {
                asnOutput.writeOctetString(2, this.getWeekNDay());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid calendar entry type:" + this.getChoice());
            }
        }
    }

    public final void readAsn(AsnInput asnInput) throws AsnException {
        int n = asnInput.peekTag();
        if (asnInput.isValueTag(0)) {
            this.setCalendarEntry((BValue)asnInput.readDate(0), BacnetConst.noWrite);
        } else if (asnInput.isOpeningTag(1)) {
            asnInput.skipTag();
            this.getDateRange().readAsn(asnInput);
            this.setInt(choice, 1, BacnetConst.noWrite);
            asnInput.skipTag();
        } else if (asnInput.isValueTag(2)) {
            this.setCalendarEntry((BValue)asnInput.readBacnetOctetString(2), BacnetConst.noWrite);
        } else {
            throw new AsnException("Invalid tag: " + n);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BBacnetCalendarEntry() {
    }

    public BBacnetCalendarEntry(BBacnetDate bBacnetDate) {
        this.setChoice(0);
        this.setDate(bBacnetDate);
    }

    public BBacnetCalendarEntry(BBacnetDateRange bBacnetDateRange) {
        this.setChoice(1);
        this.setDateRange(bBacnetDateRange);
    }

    public BBacnetCalendarEntry(BBacnetOctetString bBacnetOctetString) {
        this.setChoice(2);
        this.setWeekNDay(bBacnetOctetString);
    }

    static {
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetCalendarEntry;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetCalendarEntry = BBacnetCalendarEntry.class("[Ljavax.baja.bacnet.datatypes.BBacnetCalendarEntry;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        GREG = new GregorianCalendar();
        MAX_ITERATIONS = 366;
    }
}

