/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.config;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.datatypes.BReadFileConfig;
import com.tridium.bacnet.datatypes.BWriteFileConfig;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetFileAccessMethod;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.FileData;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetFile
extends BBacnetObject {
    public static final Property objectId = BBacnetFile.newProperty((int)8, (BValue)BBacnetObjectIdentifier.make(10), (BFacets)BBacnetFile.makeFacets(75, 12));
    public static final Property objectType = BBacnetFile.newProperty((int)1, (BValue)BDynamicEnum.make((int)10, (BEnumRange)BEnumRange.make((Type)BBacnetObjectType.TYPE)), (BFacets)BBacnetFile.makeFacets(79, 9));
    public static final Property fileType = BBacnetFile.newProperty((int)1, (String)"", (BFacets)BBacnetFile.makeFacets(43, 7));
    public static final Property fileSize = BBacnetFile.newProperty((int)0, (BValue)BBacnetUnsigned.make(0L), (BFacets)BBacnetFile.makeFacets(42, 2));
    public static final Property modificationDate = BBacnetFile.newProperty((int)1, (BValue)new BBacnetDateTime(), (BFacets)BBacnetFile.makeFacets(71, -1));
    public static final Property archive = BBacnetFile.newProperty((int)0, (boolean)false, (BFacets)BBacnetFile.makeFacets(13, 1));
    public static final Property readOnly = BBacnetFile.newProperty((int)1, (boolean)true, (BFacets)BBacnetFile.makeFacets(99, 1));
    public static final Property fileAccessMethod = BBacnetFile.newProperty((int)1, (BValue)BBacnetFileAccessMethod.streamAccess, (BFacets)BBacnetFile.makeFacets(41, 9));
    public static final Property fileOrd = BBacnetFile.newProperty((int)64, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"baja:IFile"));
    public static final Action read = BBacnetFile.newAction((int)0, null);
    public static final Action write = BBacnetFile.newAction((int)0, (BValue)BBlob.DEFAULT, null);
    public static final Action readFile = BBacnetFile.newAction((int)4, (BValue)new BReadFileConfig(), null);
    public static final Action writeFile = BBacnetFile.newAction((int)4, (BValue)new BWriteFileConfig(), null);
    public static final Type TYPE;
    private static final int ACK_HEADER_SIZE = 30;
    private BIFile file;
    static /* synthetic */ Class class$javax$baja$bacnet$config$BBacnetFile;
    static /* synthetic */ Class class$javax$baja$bacnet$datatypes$BBacnetOctetString;

    public String getFileType() {
        return this.getString(fileType);
    }

    public void setFileType(String string) {
        this.setString(fileType, string, null);
    }

    public BBacnetUnsigned getFileSize() {
        return (BBacnetUnsigned)this.get(fileSize);
    }

    public void setFileSize(BBacnetUnsigned bBacnetUnsigned) {
        this.set(fileSize, (BValue)bBacnetUnsigned, null);
    }

    public BBacnetDateTime getModificationDate() {
        return (BBacnetDateTime)this.get(modificationDate);
    }

    public void setModificationDate(BBacnetDateTime bBacnetDateTime) {
        this.set(modificationDate, (BValue)bBacnetDateTime, null);
    }

    public boolean getArchive() {
        return this.getBoolean(archive);
    }

    public void setArchive(boolean bl) {
        this.setBoolean(archive, bl, null);
    }

    public boolean getReadOnly() {
        return this.getBoolean(readOnly);
    }

    public void setReadOnly(boolean bl) {
        this.setBoolean(readOnly, bl, null);
    }

    public BBacnetFileAccessMethod getFileAccessMethod() {
        return (BBacnetFileAccessMethod)this.get(fileAccessMethod);
    }

    public void setFileAccessMethod(BBacnetFileAccessMethod bBacnetFileAccessMethod) {
        this.set(fileAccessMethod, (BValue)bBacnetFileAccessMethod, null);
    }

    public BOrd getFileOrd() {
        return (BOrd)this.get(fileOrd);
    }

    public void setFileOrd(BOrd bOrd) {
        this.set(fileOrd, (BValue)bOrd, null);
    }

    public BBlob read() {
        return (BBlob)this.invoke(read, null, null);
    }

    public void write(BBlob bBlob) {
        this.invoke(write, (BValue)bBlob, null);
    }

    public void readFile(BStruct bStruct) {
        this.invoke(readFile, (BValue)bStruct, null);
    }

    public void writeFile(BStruct bStruct) {
        this.invoke(writeFile, (BValue)bStruct, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.getFile();
    }

    public void stopped() {
        this.file = null;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)fileOrd)) {
            this.getFile();
        }
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getObjectId().toString(context)).append(" local: " + this.getFileOrd());
        return stringBuffer.toString();
    }

    public static byte[] readFile(BBacnetDevice bBacnetDevice, BBacnetObjectIdentifier bBacnetObjectIdentifier) throws BacnetException {
        int n = AsnUtil.fromAsnUnsignedInt(BBacnetFile.client().readProperty(bBacnetDevice.getAddress(), bBacnetObjectIdentifier, 42));
        int n2 = AsnUtil.fromAsnEnumerated(BBacnetFile.client().readProperty(bBacnetDevice.getAddress(), bBacnetObjectIdentifier, 41));
        if (n2 == 1) {
            return BBacnetFile.readFileDataStream(bBacnetDevice, bBacnetObjectIdentifier, n, 0, n);
        }
        int n3 = AsnUtil.fromAsnUnsignedInt(BBacnetFile.client().readProperty(bBacnetDevice.getAddress(), bBacnetObjectIdentifier, 141));
        BBacnetOctetString[] bBacnetOctetStringArray = BBacnetFile.readFileDataRecord(bBacnetDevice, bBacnetObjectIdentifier, n, 0, n3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        int n4 = 0;
        while (n4 < bBacnetOctetStringArray.length) {
            if (bBacnetOctetStringArray[n4] != null) {
                byteArrayOutputStream.write(bBacnetOctetStringArray[n4].getBytes(), 0, bBacnetOctetStringArray[n4].length());
            }
            ++n4;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public BBlob doRead() {
        try {
            byte[] byArray = BBacnetFile.readFile(this.device(), this.getObjectId());
            return BBlob.make((byte[])byArray);
        }
        catch (BacnetException bacnetException) {
            log.error("Unable to read file contents for " + (Object)((Object)this.getObjectId()) + " : " + (Object)((Object)bacnetException), (Throwable)((Object)bacnetException));
            throw new BajaRuntimeException((Throwable)((Object)bacnetException));
        }
    }

    public void doReadFile(BStruct bStruct) {
        BBacnetNetwork.bacnet().postAsync(new ReadFileReq((BReadFileConfig)bStruct, this));
    }

    public void doWriteFile(BStruct bStruct) {
        BBacnetNetwork.bacnet().postAsync(new WriteFileReq((BWriteFileConfig)bStruct, this));
    }

    public static void writeFile(BBacnetDevice bBacnetDevice, BBacnetObjectIdentifier bBacnetObjectIdentifier, byte[] byArray) throws BacnetException {
        BBacnetFile.writeFileDataStream(bBacnetDevice, bBacnetObjectIdentifier, 0, byArray);
    }

    public static void writeFile(BBacnetDevice bBacnetDevice, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, BBacnetOctetString[] bBacnetOctetStringArray) throws BacnetException {
        BBacnetFile.writeFileDataRecord(bBacnetDevice, bBacnetObjectIdentifier, 0, n, bBacnetOctetStringArray);
    }

    public void doWrite(BBlob bBlob) {
        byte[] byArray = bBlob.copyBytes();
        if (this.getFileAccessMethod() == BBacnetFileAccessMethod.streamAccess) {
            try {
                BBacnetFile.writeFileDataStream(this.device(), this.getObjectId(), 0, byArray);
            }
            catch (BacnetException bacnetException) {
                log.error("Unable to write file contents for " + (Object)((Object)this.getObjectId()) + " : " + (Object)((Object)bacnetException), (Throwable)((Object)bacnetException));
                throw new BajaRuntimeException((Throwable)((Object)bacnetException));
            }
        }
        Class clazz = class$javax$baja$bacnet$datatypes$BBacnetOctetString;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$datatypes$BBacnetOctetString = BBacnetFile.class("[Ljavax.baja.bacnet.datatypes.BBacnetOctetString;", false);
        }
        Array array = new Array(clazz);
        AsnInputStream asnInputStream = new AsnInputStream(byArray);
        try {
            while (asnInputStream.available() > 0) {
                array.add((Object)asnInputStream.readBacnetOctetString());
            }
            BBacnetOctetString[] bBacnetOctetStringArray = (BBacnetOctetString[])array.trim();
            BBacnetFile.writeFileDataRecord(this.device(), this.getObjectId(), 0, bBacnetOctetStringArray.length, bBacnetOctetStringArray);
        }
        catch (AsnException asnException) {
            log.error("File data is not in array of encoded BACnetOctetStrings");
            throw new BajaRuntimeException((Throwable)((Object)asnException));
        }
        catch (BacnetException bacnetException) {
            log.error("Unable to write file record contents for " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)bacnetException), (Throwable)((Object)bacnetException));
            throw new BajaRuntimeException((Throwable)((Object)bacnetException));
        }
    }

    private final BIFile getFile() {
        try {
            if (!fileOrd.isEquivalentToDefaultValue((BValue)this.getFileOrd())) {
                BObject bObject = this.getFileOrd().get((BObject)this);
                this.file = bObject instanceof BIFile ? (BIFile)bObject : null;
            }
        }
        catch (Exception exception) {
            log.warning("Unable to resolve file ord for " + this + ": " + this.getFileOrd(), (Throwable)exception);
            this.file = null;
        }
        return this.file;
    }

    private static final BBacnetClientLayer client() {
        return ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient();
    }

    private static final BBacnetOctetString[] readFileDataRecord(BBacnetDevice bBacnetDevice, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, int n3) throws BacnetException {
        if (!bBacnetDevice.isServiceSupported("atomicReadFile")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.atomicReadFile"));
        }
        BBacnetOctetString[] bBacnetOctetStringArray = new BBacnetOctetString[n3];
        int n4 = bBacnetDevice.getMaxAPDULengthAccepted();
        int n5 = BBacnetNetwork.localDevice().getMaxAPDULengthAccepted();
        if (n5 < n4) {
            n4 = n5;
        }
        if (n < (n4 -= 30) || bBacnetDevice.getSegmentationSupported().isSegmentedTransmit()) {
            try {
                FileData fileData = BBacnetFile.client().atomicReadFile(bBacnetDevice.getAddress(), bBacnetObjectIdentifier, 1, n2, n3);
                bBacnetOctetStringArray = fileData.getFileRecordData();
                return bBacnetOctetStringArray;
            }
            catch (BacnetException bacnetException) {}
        }
        FileData fileData = null;
        int n6 = 0;
        while (n6 < n3) {
            fileData = BBacnetFile.client().atomicReadFile(bBacnetDevice.getAddress(), bBacnetObjectIdentifier, 1, n2 + n6, 1L);
            bBacnetOctetStringArray[n6] = fileData.getFileRecordData()[0];
            if (fileData.isEndOfFile()) break;
            ++n6;
        }
        return bBacnetOctetStringArray;
    }

    private static final byte[] readFileDataStream(BBacnetDevice bBacnetDevice, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, int n3) throws BacnetException {
        if (!bBacnetDevice.isServiceSupported("atomicReadFile")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.atomicReadFile"));
        }
        byte[] byArray = new byte[n];
        if (n < n3) {
            n3 = n;
        }
        int n4 = bBacnetDevice.getMaxAPDULengthAccepted();
        int n5 = BBacnetNetwork.localDevice().getMaxAPDULengthAccepted();
        if (n5 < n4) {
            n4 = n5;
        }
        if (n < (n4 -= 30) || bBacnetDevice.getSegmentationSupported().isSegmentedTransmit()) {
            try {
                FileData fileData = BBacnetFile.client().atomicReadFile(bBacnetDevice.getAddress(), bBacnetObjectIdentifier, 0, n2, n3);
                byArray = fileData.getFileData();
                return byArray;
            }
            catch (BacnetException bacnetException) {}
        }
        int n6 = n2;
        int n7 = n4;
        int n8 = n6 + n3;
        FileData fileData = null;
        do {
            fileData = BBacnetFile.client().atomicReadFile(bBacnetDevice.getAddress(), bBacnetObjectIdentifier, 0, n6, n7);
            byte[] byArray2 = fileData.getFileData();
            System.arraycopy(byArray2, 0, byArray, n6, byArray2.length);
        } while (!fileData.isEndOfFile() && (n6 += n7) < n8);
        return byArray;
    }

    private static final int encodedLength(int n) {
        if (n < 4) {
            return n + 1;
        }
        if (n < 254) {
            return n + 2;
        }
        return n + 3;
    }

    private static final void writeFileDataRecord(BBacnetDevice bBacnetDevice, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, BBacnetOctetString[] bBacnetOctetStringArray) throws BacnetException {
        if (!bBacnetDevice.isServiceSupported("atomicWriteFile")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.atomicWriteFile"));
        }
        if (bBacnetOctetStringArray == null) {
            throw new IllegalArgumentException("fileRecordData is null!");
        }
        int n3 = n2;
        if (n + n2 > bBacnetOctetStringArray.length) {
            n3 = bBacnetOctetStringArray.length - n;
        }
        int n4 = 0;
        int n5 = n;
        while (n5 < n3) {
            n4 += BBacnetFile.encodedLength(bBacnetOctetStringArray[n5].length());
            ++n5;
        }
        n5 = bBacnetDevice.getMaxAPDULengthAccepted();
        int n6 = BBacnetNetwork.localDevice().getMaxAPDULengthAccepted();
        if (n6 < n5) {
            n5 = n6;
        }
        if (n4 < (n5 -= 30) || bBacnetDevice.getSegmentationSupported().isSegmentedReceive()) {
            try {
                BBacnetFile.client().atomicWriteFileRecord(bBacnetDevice.getAddress(), bBacnetObjectIdentifier, n, n3, bBacnetOctetStringArray);
                return;
            }
            catch (BacnetException bacnetException) {}
        }
        int n7 = n;
        int n8 = n;
        do {
            int n9 = 0;
            Class clazz = class$javax$baja$bacnet$datatypes$BBacnetOctetString;
            if (clazz == null) {
                clazz = BBacnetFile.class("[Ljavax.baja.bacnet.datatypes.BBacnetOctetString;", false);
            }
            Array array = new Array(clazz);
            do {
                array.add((Object)bBacnetOctetStringArray[n7]);
            } while (++n7 < n3 && (n9 += bBacnetOctetStringArray[n7].length()) + bBacnetOctetStringArray[n7].length() < n5);
            BBacnetOctetString[] bBacnetOctetStringArray2 = (BBacnetOctetString[])array.trim();
            BBacnetFile.client().atomicWriteFileRecord(bBacnetDevice.getAddress(), bBacnetObjectIdentifier, n8, bBacnetOctetStringArray2.length, bBacnetOctetStringArray2);
            n8 = n7;
        } while (n7 < n3);
    }

    private static final void writeFileDataStream(BBacnetDevice bBacnetDevice, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, byte[] byArray) throws BacnetException {
        int n2;
        if (!bBacnetDevice.isServiceSupported("atomicWriteFile")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.atomicWriteFile"));
        }
        int n3 = byArray.length;
        int n4 = bBacnetDevice.getMaxAPDULengthAccepted();
        int n5 = BBacnetNetwork.localDevice().getMaxAPDULengthAccepted();
        if (n5 < n4) {
            n4 = n5;
        }
        if (n3 < (n4 -= 30) || bBacnetDevice.getSegmentationSupported().isSegmentedReceive()) {
            try {
                BBacnetFile.client().atomicWriteFileStream(bBacnetDevice.getAddress(), bBacnetObjectIdentifier, n, byArray);
                return;
            }
            catch (BacnetException bacnetException) {}
        }
        int n6 = n;
        int n7 = n4;
        do {
            if (n6 + (n2 = n7) > n3) {
                n2 = n3 - n6;
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n6, byArray2, 0, n2);
            BBacnetFile.client().atomicWriteFileStream(bBacnetDevice.getAddress(), bBacnetObjectIdentifier, n6, byArray2);
        } while ((n6 += n2) < n3);
    }

    static final /* synthetic */ BBacnetClientLayer access$0() {
        return BBacnetFile.client();
    }

    static final /* synthetic */ byte[] access$1(BBacnetDevice bBacnetDevice, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, int n3) throws BacnetException {
        return BBacnetFile.readFileDataStream(bBacnetDevice, bBacnetObjectIdentifier, n, n2, n3);
    }

    static final /* synthetic */ BBacnetOctetString[] access$2(BBacnetDevice bBacnetDevice, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, int n3) throws BacnetException {
        return BBacnetFile.readFileDataRecord(bBacnetDevice, bBacnetObjectIdentifier, n, n2, n3);
    }

    static /* synthetic */ BIFile access$3(BBacnetFile bBacnetFile) {
        return bBacnetFile.file;
    }

    static final /* synthetic */ void access$4(BBacnetDevice bBacnetDevice, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, byte[] byArray) throws BacnetException {
        BBacnetFile.writeFileDataStream(bBacnetDevice, bBacnetObjectIdentifier, n, byArray);
    }

    static final /* synthetic */ void access$5(BBacnetDevice bBacnetDevice, BBacnetObjectIdentifier bBacnetObjectIdentifier, int n, int n2, BBacnetOctetString[] bBacnetOctetStringArray) throws BacnetException {
        BBacnetFile.writeFileDataRecord(bBacnetDevice, bBacnetObjectIdentifier, n, n2, bBacnetOctetStringArray);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$config$BBacnetFile;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$config$BBacnetFile = BBacnetFile.class("[Ljavax.baja.bacnet.config.BBacnetFile;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ReadFileReq
    implements Runnable {
        BReadFileConfig parms;
        BBacnetFile bacnetFile;

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 450->454)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        ReadFileReq(BReadFileConfig bReadFileConfig, BBacnetFile bBacnetFile2) {
            this.parms = bReadFileConfig;
            this.bacnetFile = bBacnetFile2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class WriteFileReq
    implements Runnable {
        BWriteFileConfig parms;
        BBacnetFile bacnetFile;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            var1_1 = this.parms.getRemoteStart();
            var2_2 = this.parms.getLocalStart();
            var3_3 = null;
            var4_4 = null;
            try {
                try {
                    if (BBacnetFile.access$3(this.bacnetFile) == null) {
                        throw new NullOrdException("No local source file specified for BACnet File " + this.bacnetFile);
                    }
                    var8_5 = ((BLocalFileStore)BBacnetFile.access$3(this.bacnetFile).getStore()).getLocalFile();
                    var9_7 = var8_5.length() - (long)var2_2;
                    if (var9_7 > 0x7FFFFFFFL) {
                        throw new BajaRuntimeException("Local file data length " + var9_7 + " is too long to write to BACnet!");
                    }
                    var11_9 = (int)var9_7;
                    var3_3 = new byte[var11_9];
                    var4_4 = new RandomAccessFile(var8_5, "r");
                    var4_4.seek(var2_2);
                    var4_4.read(var3_3, 0, var11_9);
                }
                catch (IOException var8_6) {
                    BBacnetFile.log.error("IOException reading from local file " + BBacnetFile.access$3(this.bacnetFile), (Throwable)var8_6);
                    throw new BajaRuntimeException((Throwable)var8_6);
                }
            }
            catch (Throwable var5_10) {
                var6_11 = null;
                if (var4_4 == null) throw var5_10;
                try {
                    var4_4.close();
                    throw var5_10;
                }
                catch (IOException v0) {}
                throw var5_10;
            }
            {
                var6_12 = null;
                if (var4_4 == null) ** GOTO lbl-1000
            }
            try {}
            catch (IOException v1) {}
            var4_4.close();
lbl-1000:
            // 3 sources

            {
                if ((var7_13 = AsnUtil.fromAsnEnumerated(BBacnetFile.access$0().readProperty(this.bacnetFile.device().getAddress(), this.bacnetFile.getObjectId(), 41))) == 1) {
                    BBacnetFile.access$4(this.bacnetFile.device(), this.bacnetFile.getObjectId(), var1_1, var3_3);
                    return;
                }
                v2 = BBacnetFile.class$javax$baja$bacnet$datatypes$BBacnetOctetString;
                if (v2 == null) {
                    v2 = BBacnetFile.class$javax$baja$bacnet$datatypes$BBacnetOctetString = BBacnetFile.class("[Ljavax.baja.bacnet.datatypes.BBacnetOctetString;", false);
                }
                var8_5 = new Array(v2);
                var9_8 = new AsnInputStream(var3_3);
                try {
                    while (true) {
                        if (var9_8.available() <= 0) {
                            var10_14 = (BBacnetOctetString[])var8_5.trim();
                            BBacnetFile.access$5(BBacnetFile.this.device(), BBacnetFile.this.getObjectId(), var1_1, var10_14.length, var10_14);
                            return;
                        }
                        var8_5.add((Object)var9_8.readBacnetOctetString());
                    }
                }
                catch (AsnException var10_15) {
                    BBacnetFile.log.error("File data is not in array of encoded BACnetOctetStrings");
                    throw new BajaRuntimeException((Throwable)var10_15);
                }
            }
        }

        WriteFileReq(BWriteFileConfig bWriteFileConfig, BBacnetFile bBacnetFile2) {
            this.parms = bWriteFileConfig;
            this.bacnetFile = bBacnetFile2;
        }
    }
}

