/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.config;

import com.tridium.bacnet.stack.DeviceRegistry;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetAddressBinding;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetDeviceStatus;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetSegmentation;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.naming.BOrd;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetDeviceObject
extends BBacnetObject {
    public static final Property objectId = BBacnetDeviceObject.newProperty((int)8, (BValue)BBacnetObjectIdentifier.make(8), (BFacets)BBacnetDeviceObject.makeFacets(75, 12));
    public static final Property objectType = BBacnetDeviceObject.newProperty((int)1, (BValue)BDynamicEnum.make((int)8, (BEnumRange)BEnumRange.make((Type)BBacnetObjectType.TYPE)), (BFacets)BBacnetDeviceObject.makeFacets(79, 9));
    public static final Property systemStatus = BBacnetDeviceObject.newProperty((int)1, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BBacnetDeviceStatus.TYPE)), (BFacets)BBacnetDeviceObject.makeFacets(112, 9));
    public static final Property vendorName = BBacnetDeviceObject.newProperty((int)1, (String)"", (BFacets)BBacnetDeviceObject.makeFacets(121, 7));
    public static final Property vendorIdentifier = BBacnetDeviceObject.newProperty((int)1, (BValue)new BBacnetUnsigned(-1), (BFacets)BBacnetDeviceObject.makeFacets(120, 2));
    public static final Property modelName = BBacnetDeviceObject.newProperty((int)1, (String)"", (BFacets)BBacnetDeviceObject.makeFacets(70, 7));
    public static final Property firmwareRevision = BBacnetDeviceObject.newProperty((int)1, (String)"", (BFacets)BBacnetDeviceObject.makeFacets(44, 7));
    public static final Property applicationSoftwareVersion = BBacnetDeviceObject.newProperty((int)1, (String)"", (BFacets)BBacnetDeviceObject.makeFacets(12, 7));
    public static final Property protocolVersion = BBacnetDeviceObject.newProperty((int)1, (BValue)new BBacnetUnsigned(1L), (BFacets)BBacnetDeviceObject.makeFacets(98, 2));
    public static final Property protocolRevision = BBacnetDeviceObject.newProperty((int)1, (BValue)new BBacnetUnsigned(0L), (BFacets)BBacnetDeviceObject.makeFacets(139, 2));
    public static final Property protocolServicesSupported = BBacnetDeviceObject.newProperty((int)1, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetServicesSupported")), (BFacets)BBacnetDeviceObject.makeFacets(97, 8, BacnetBitStringUtil.BACNET_SERVICES_SUPPORTED_MAP));
    public static final Property protocolObjectTypesSupported = BBacnetDeviceObject.newProperty((int)1, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetObjectTypesSupported")), (BFacets)BBacnetDeviceObject.makeFacets(96, 8, BacnetBitStringUtil.BACNET_OBJECT_TYPES_SUPPORTED_MAP));
    public static final Property objectList = BBacnetDeviceObject.newProperty((int)5, (BValue)new BBacnetArray(BBacnetObjectIdentifier.TYPE), (BFacets)BBacnetDeviceObject.makeFacets(76, -2));
    public static final Property maxAPDULengthAccepted = BBacnetDeviceObject.newProperty((int)1, (BValue)new BBacnetUnsigned(50L), (BFacets)BBacnetDeviceObject.makeFacets(62, 2));
    public static final Property segmentationSupported = BBacnetDeviceObject.newProperty((int)1, (BValue)BBacnetSegmentation.noSegmentation, (BFacets)BBacnetDeviceObject.makeFacets(107, 9));
    public static final Property apduTimeout = BBacnetDeviceObject.newProperty((int)0, (BValue)new BBacnetUnsigned(3000L), (BFacets)BBacnetDeviceObject.makeFacets(11, 2));
    public static final Property numberOfAPDURetries = BBacnetDeviceObject.newProperty((int)0, (BValue)new BBacnetUnsigned(3), (BFacets)BBacnetDeviceObject.makeFacets(73, 2));
    public static final Property deviceAddressBinding = BBacnetDeviceObject.newProperty((int)0, (BValue)new BBacnetListOf(BBacnetAddressBinding.TYPE), (BFacets)BBacnetDeviceObject.makeFacets(30, -3));
    public static final Property databaseRevision = BBacnetDeviceObject.newProperty((int)1, (BValue)new BBacnetUnsigned(-1), (BFacets)BBacnetDeviceObject.makeFacets(155, 2));
    public static final Type TYPE;
    private BBacnetObjectIdentifier oldId;
    static /* synthetic */ Class class$javax$baja$bacnet$config$BBacnetDeviceObject;

    public BEnum getSystemStatus() {
        return (BEnum)this.get(systemStatus);
    }

    public void setSystemStatus(BEnum bEnum) {
        this.set(systemStatus, (BValue)bEnum, null);
    }

    public String getVendorName() {
        return this.getString(vendorName);
    }

    public void setVendorName(String string) {
        this.setString(vendorName, string, null);
    }

    public BBacnetUnsigned getVendorIdentifier() {
        return (BBacnetUnsigned)this.get(vendorIdentifier);
    }

    public void setVendorIdentifier(BBacnetUnsigned bBacnetUnsigned) {
        this.set(vendorIdentifier, (BValue)bBacnetUnsigned, null);
    }

    public String getModelName() {
        return this.getString(modelName);
    }

    public void setModelName(String string) {
        this.setString(modelName, string, null);
    }

    public String getFirmwareRevision() {
        return this.getString(firmwareRevision);
    }

    public void setFirmwareRevision(String string) {
        this.setString(firmwareRevision, string, null);
    }

    public String getApplicationSoftwareVersion() {
        return this.getString(applicationSoftwareVersion);
    }

    public void setApplicationSoftwareVersion(String string) {
        this.setString(applicationSoftwareVersion, string, null);
    }

    public BBacnetUnsigned getProtocolVersion() {
        return (BBacnetUnsigned)this.get(protocolVersion);
    }

    public void setProtocolVersion(BBacnetUnsigned bBacnetUnsigned) {
        this.set(protocolVersion, (BValue)bBacnetUnsigned, null);
    }

    public BBacnetUnsigned getProtocolRevision() {
        return (BBacnetUnsigned)this.get(protocolRevision);
    }

    public void setProtocolRevision(BBacnetUnsigned bBacnetUnsigned) {
        this.set(protocolRevision, (BValue)bBacnetUnsigned, null);
    }

    public BBacnetBitString getProtocolServicesSupported() {
        return (BBacnetBitString)this.get(protocolServicesSupported);
    }

    public void setProtocolServicesSupported(BBacnetBitString bBacnetBitString) {
        this.set(protocolServicesSupported, (BValue)bBacnetBitString, null);
    }

    public BBacnetBitString getProtocolObjectTypesSupported() {
        return (BBacnetBitString)this.get(protocolObjectTypesSupported);
    }

    public void setProtocolObjectTypesSupported(BBacnetBitString bBacnetBitString) {
        this.set(protocolObjectTypesSupported, (BValue)bBacnetBitString, null);
    }

    public BBacnetArray getObjectList() {
        return (BBacnetArray)this.get(objectList);
    }

    public void setObjectList(BBacnetArray bBacnetArray) {
        this.set(objectList, (BValue)bBacnetArray, null);
    }

    public BBacnetUnsigned getMaxAPDULengthAccepted() {
        return (BBacnetUnsigned)this.get(maxAPDULengthAccepted);
    }

    public void setMaxAPDULengthAccepted(BBacnetUnsigned bBacnetUnsigned) {
        this.set(maxAPDULengthAccepted, (BValue)bBacnetUnsigned, null);
    }

    public BBacnetSegmentation getSegmentationSupported() {
        return (BBacnetSegmentation)this.get(segmentationSupported);
    }

    public void setSegmentationSupported(BBacnetSegmentation bBacnetSegmentation) {
        this.set(segmentationSupported, (BValue)bBacnetSegmentation, null);
    }

    public BBacnetUnsigned getApduTimeout() {
        return (BBacnetUnsigned)this.get(apduTimeout);
    }

    public void setApduTimeout(BBacnetUnsigned bBacnetUnsigned) {
        this.set(apduTimeout, (BValue)bBacnetUnsigned, null);
    }

    public BBacnetUnsigned getNumberOfAPDURetries() {
        return (BBacnetUnsigned)this.get(numberOfAPDURetries);
    }

    public void setNumberOfAPDURetries(BBacnetUnsigned bBacnetUnsigned) {
        this.set(numberOfAPDURetries, (BValue)bBacnetUnsigned, null);
    }

    public BBacnetListOf getDeviceAddressBinding() {
        return (BBacnetListOf)this.get(deviceAddressBinding);
    }

    public void setDeviceAddressBinding(BBacnetListOf bBacnetListOf) {
        this.set(deviceAddressBinding, (BValue)bBacnetListOf, null);
    }

    public BBacnetUnsigned getDatabaseRevision() {
        return (BBacnetUnsigned)this.get(databaseRevision);
    }

    public void setDatabaseRevision(BBacnetUnsigned bBacnetUnsigned) {
        this.set(databaseRevision, (BValue)bBacnetUnsigned, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.oldId = this.getObjectId();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning() || context == BacnetConst.fallback) {
            return;
        }
        if (property.equals((Object)objectId)) {
            BBacnetObjectIdentifier bBacnetObjectIdentifier = this.getObjectId();
            BBacnetNetwork bBacnetNetwork = BBacnetNetwork.bacnet();
            if (bBacnetObjectIdentifier.equals((Object)this.oldId)) {
                return;
            }
            BBacnetDevice bBacnetDevice = bBacnetNetwork.doLookupDeviceById(bBacnetObjectIdentifier);
            if (bBacnetDevice != null && bBacnetDevice != this.device()) {
                log.error("Duplicate Object ID:" + (Object)((Object)bBacnetObjectIdentifier) + ", used by " + bBacnetDevice.getName() + "!\n  Resetting to old id:" + (Object)((Object)this.oldId));
                this.set(objectId, (BValue)this.oldId, BacnetConst.fallback);
            } else {
                if (log.isTraceOn()) {
                    log.trace("Object ID changed from " + (Object)((Object)this.oldId) + " to " + (Object)((Object)bBacnetObjectIdentifier));
                }
                this.device().objectIdChanged();
                bBacnetNetwork.getLocalDevice().updateAddressBinding(this.oldId, bBacnetObjectIdentifier);
                bBacnetNetwork.updateDevice(this.device());
                DeviceRegistry.update(this.device());
                this.oldId = bBacnetObjectIdentifier;
            }
        } else if (property.equals((Object)protocolRevision)) {
            DeviceRegistry.update(this.device());
        } else if (property.equals((Object)segmentationSupported)) {
            DeviceRegistry.update(this.device());
        } else if (property.equals((Object)maxAPDULengthAccepted)) {
            DeviceRegistry.update(this.device());
        }
        if (property.equals((Object)protocolServicesSupported)) {
            this.device().updateServicesSupported();
        }
    }

    public String toString(Context context) {
        return this.getObjectName() + " [" + this.getObjectId().toString(context) + ']';
    }

    protected boolean shouldPoll(int n) {
        switch (n) {
            case 24: 
            case 56: 
            case 57: 
            case 112: {
                return true;
            }
        }
        return false;
    }

    public void doUpload(BUploadParameters bUploadParameters, Context context) {
        block7: {
            if (!this.device().getEnabled() || this.getStatus().isDown()) {
                return;
            }
            if (!this.getObjectId().isValid()) {
                return;
            }
            try {
                this.readProperty(maxAPDULengthAccepted);
                this.readProperty(segmentationSupported);
                this.readProperty(vendorIdentifier);
                this.readProperty(modelName);
                this.readProperty(firmwareRevision);
                this.readProperty(applicationSoftwareVersion);
                if (this.getVendorIdentifier().getInt() != 36 || !this.getFirmwareRevision().startsWith("3")) break block7;
                try {
                    BOrd bOrd = (BOrd)this.device().get("vendorObjectTypesFile");
                    if (bOrd != null && !bOrd.equals((Object)BOrd.NULL)) {
                        this.device().set("vendorObjectTypesFile", (BValue)BOrd.make((String)"file:!lib/niagaraAxBacnetObjectTypes.xml"));
                    }
                }
                catch (Exception exception) {
                    log.trace("Exception setting vendorObjectTypesFile for BACnet deviceObject " + this + ':' + exception, (Throwable)exception);
                }
            }
            catch (Exception exception) {
                log.trace("Exception uploading BACnet deviceObject " + this + ':' + exception, (Throwable)exception);
            }
        }
        super.doUpload(bUploadParameters, context);
    }

    public int getMaxSegmentsAccepted() {
        BBacnetUnsigned bBacnetUnsigned = (BBacnetUnsigned)this.get(BBacnetPropertyIdentifier.maxSegmentsAccepted.getTag());
        if (bBacnetUnsigned != null) {
            return bBacnetUnsigned.getInt();
        }
        return 0;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetDeviceObject", 2);
        spyWriter.prop((Object)"oldId", (Object)this.oldId);
        spyWriter.endProps();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$config$BBacnetDeviceObject;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$config$BBacnetDeviceObject = BBacnetDeviceObject.class("[Ljavax.baja.bacnet.config.BBacnetDeviceObject;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

