/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.config;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BBacnetAnalog
extends BBacnetObject {
    public static final Property presentValue = BBacnetAnalog.newProperty((int)0, (int)0, (BFacets)BBacnetAnalog.makeFacets(85, 4));
    public static final Property facets = BBacnetAnalog.newProperty((int)1, (BValue)BFacets.DEFAULT, null);
    public static final Property statusFlags = BBacnetAnalog.newProperty((int)1, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), (BFacets)BBacnetAnalog.makeFacets(111, 8, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP));
    public static final Property eventState = BBacnetAnalog.newProperty((int)1, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BBacnetEventState.TYPE)), (BFacets)BBacnetAnalog.makeFacets(36, 9));
    public static final Property outOfService = BBacnetAnalog.newProperty((int)0, (boolean)false, (BFacets)BBacnetAnalog.makeFacets(81, 1));
    public static final Property units = BBacnetAnalog.newProperty((int)1, (BValue)BDynamicEnum.make((int)95, (BEnumRange)BEnumRange.make((Type)BBacnetEngineeringUnits.TYPE)), (BFacets)BBacnetAnalog.makeFacets(117, 9));
    public static final Type TYPE;
    private static final double LN_10;
    static /* synthetic */ Class class$javax$baja$bacnet$config$BBacnetAnalog;

    public float getPresentValue() {
        return this.getFloat(presentValue);
    }

    public void setPresentValue(float f) {
        this.setFloat(presentValue, f, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public BBacnetBitString getStatusFlags() {
        return (BBacnetBitString)this.get(statusFlags);
    }

    public void setStatusFlags(BBacnetBitString bBacnetBitString) {
        this.set(statusFlags, (BValue)bBacnetBitString, null);
    }

    public BEnum getEventState() {
        return (BEnum)this.get(eventState);
    }

    public void setEventState(BEnum bEnum) {
        this.set(eventState, (BValue)bEnum, null);
    }

    public boolean getOutOfService() {
        return this.getBoolean(outOfService);
    }

    public void setOutOfService(boolean bl) {
        this.setBoolean(outOfService, bl, null);
    }

    public BEnum getUnits() {
        return (BEnum)this.get(units);
    }

    public void setUnits(BEnum bEnum) {
        this.set(units, (BValue)bEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getObjectId().toString(context)).append(" = " + this.getPresentValue());
        return stringBuffer.toString();
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)presentValue)) {
            return this.getFacets();
        }
        if (slot.getName().equals("highLimit")) {
            return this.getFacets();
        }
        if (slot.getName().equals("lowLimit")) {
            return this.getFacets();
        }
        if (slot.getName().equals("deadband")) {
            return this.getFacets();
        }
        if (slot.getName().equals("resolution")) {
            return this.getFacets();
        }
        if (slot.getName().equals("covIncrement")) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void setOutputFacets() {
        try {
            BUnit bUnit = null;
            try {
                bUnit = BBacnetEngineeringUnits.getNiagaraUnits(this.getUnits().getOrdinal());
            }
            catch (Exception exception) {
                log.message(this + ":Can't make BUnits from BacnetEngineeringUnits:" + this.getUnits());
            }
            BFloat bFloat = (BFloat)this.get("resolution");
            BInteger bInteger = BInteger.make((int)2);
            if (bFloat != null) {
                bInteger = BInteger.make((int)((int)Math.ceil(-(Math.log(bFloat.getFloat()) / LN_10))));
            }
            BFloat bFloat2 = (BFloat)this.get("minPresValue");
            BFloat bFloat3 = (BFloat)this.get("maxPresValue");
            if (bFloat2 == null) {
                bFloat2 = BFloat.make((float)Float.NEGATIVE_INFINITY);
            }
            if (bFloat3 == null) {
                bFloat3 = BFloat.make((float)Float.POSITIVE_INFINITY);
            }
            if (bFloat2.getFloat() == -3.4028235E38f) {
                bFloat2 = BFloat.make((float)Float.NEGATIVE_INFINITY);
            }
            if (bFloat3.getFloat() == Float.MAX_VALUE) {
                bFloat3 = BFloat.make((float)Float.POSITIVE_INFINITY);
            }
            BFacets bFacets = BFacets.makeNumeric((BUnit)bUnit, (BInteger)bInteger, (BNumber)bFloat2, (BNumber)bFloat3);
            this.setFacets(bFacets);
        }
        catch (Exception exception) {
            log.message(this + ":Exception in setOutputFacets()", (Throwable)exception);
        }
    }

    public Property getPresentValueProperty() {
        return presentValue;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$bacnet$config$BBacnetAnalog;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$config$BBacnetAnalog = BBacnetAnalog.class("[Ljavax.baja.bacnet.config.BBacnetAnalog;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        LN_10 = Math.log(10.0);
    }
}

