/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NBacnetPropertyReference;
import com.tridium.bacnet.asn.NReadAccessResult;
import com.tridium.bacnet.asn.NReadAccessSpec;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.asn.NWriteAccessSpec;
import com.tridium.bacnet.stack.BBacnetPoll;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import com.tridium.bacnet.stack.transport.TransactionException;
import java.io.ByteArrayOutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.config.BBacnetConfigDeviceExt;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BExtensibleEnumList;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.util.BIBacnetPollable;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.bacnet.util.PollListEntry;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.data.BIDataValue;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BLoadable;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.IntHashMap;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBacnetObject
extends BLoadable
implements BacnetConst,
BIBacnetPollable {
    public static final Action download = BBacnetObject.newAction((int)20, (BValue)new BDownloadParameters(), null);
    public static final Property pollFrequency = BBacnetObject.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property status = BBacnetObject.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BBacnetObject.newProperty((int)3, (String)"", null);
    public static final Property objectId = BBacnetObject.newProperty((int)8, (BValue)BBacnetObjectIdentifier.DEFAULT, (BFacets)BBacnetObject.makeFacets(75, 12));
    public static final Property objectName = BBacnetObject.newProperty((int)0, (String)"", (BFacets)BBacnetObject.makeFacets(77, 7));
    public static final Property objectType = BBacnetObject.newProperty((int)1, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BBacnetObjectType.TYPE)), (BFacets)BBacnetObject.makeFacets(79, 9));
    public static final Action readBacnetProperty = BBacnetObject.newAction((int)4, (BValue)BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.presentValue), null);
    public static final Action writeBacnetProperty = BBacnetObject.newAction((int)4, (BValue)BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.presentValue), null);
    public static final Type TYPE;
    private static final BIcon icon;
    protected static final Lexicon lex;
    public static final Log log;
    public static final Log plog;
    private static IntHashMap byObjectType;
    private static boolean initialized;
    private static final BRelTime WPM_DELAY;
    public static final String PID = "pId";
    public static final String ASN_TYPE = "asn";
    private static final BacnetPropertyData NOT_BACNET_PROPERTY;
    protected Vector polledProperties;
    private BBacnetConfigDeviceExt config;
    private HashMap propDataMap;
    private HashSet wpmList;
    private Clock.Ticket wpmTkt;
    static /* synthetic */ Class class$javax$baja$bacnet$BBacnetObject;
    static /* synthetic */ Class class$javax$baja$registry$TypeInfo;

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        this.set(objectId, (BValue)bBacnetObjectIdentifier, null);
    }

    public String getObjectName() {
        return this.getString(objectName);
    }

    public void setObjectName(String string) {
        this.setString(objectName, string, null);
    }

    public BEnum getObjectType() {
        return (BEnum)this.get(objectType);
    }

    public void setObjectType(BEnum bEnum) {
        this.set(objectType, (BValue)bEnum, null);
    }

    public BValue readBacnetProperty(BEnum bEnum) {
        return this.invoke(readBacnetProperty, (BValue)bEnum, null);
    }

    public void writeBacnetProperty(BEnum bEnum) {
        this.invoke(writeBacnetProperty, (BValue)bEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BBacnetObject make(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        Object object;
        Array array;
        if (!initialized) {
            BBacnetObject.init();
        }
        Object object2 = byObjectType.get(bBacnetObjectIdentifier.getObjectType());
        TypeInfo typeInfo = null;
        if (object2 != null && object2 instanceof Array && (array = (Array)object2).size() > 0 && (object = array.get(0)) instanceof TypeInfo) {
            typeInfo = (TypeInfo)object;
            BBacnetObject bBacnetObject = (BBacnetObject)typeInfo.getInstance();
            bBacnetObject.setObjectId(bBacnetObjectIdentifier);
            return bBacnetObject;
        }
        return new BBacnetObject();
    }

    public static TypeInfo getTypeInfo(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        Array array;
        if (!initialized) {
            BBacnetObject.init();
        }
        if ((array = (Array)byObjectType.get(bBacnetObjectIdentifier.getObjectType())) != null) {
            return (TypeInfo)array.first();
        }
        return TYPE.getTypeInfo();
    }

    public static TypeInfo[] getTypeInfos(BBacnetObjectIdentifier bBacnetObjectIdentifier) {
        Array array;
        if (!initialized) {
            BBacnetObject.init();
        }
        if ((array = (Array)byObjectType.get(bBacnetObjectIdentifier.getObjectType())) != null) {
            return (TypeInfo[])array.trim();
        }
        return new TypeInfo[]{TYPE.getTypeInfo()};
    }

    public void started() throws Exception {
        this.checkConfig();
        this.buildPolledProperties();
        BBacnetObject bBacnetObject = this.config().lookupBacnetObject(this.getObjectId());
        if (bBacnetObject != null && bBacnetObject != this) {
            log.error("Duplicate Bacnet Object ID for config object " + this + " in " + this.device() + "; defaulting objectId!");
            this.setObjectId(BBacnetObjectIdentifier.make(this.getObjectType().getOrdinal()));
        }
    }

    public void stopped() throws Exception {
        try {
            ((BBacnetPoll)this.network().getPollService(this)).unsubscribe(this);
        }
        catch (NotRunningException notRunningException) {
            System.out.println("BBacnetObject.stopped:NotRunningException unsubscribing from polling on " + this);
        }
        this.polledProperties = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changed(Property property, Context context) {
        Object object;
        super.changed(property, context);
        if (!this.isRunning()) return;
        if (context == BacnetConst.noWrite) {
            return;
        }
        if (property.equals((Object)objectId)) {
            this.removeAll(null);
            this.upload(new BUploadParameters());
            if (!this.isSubscribed()) return;
            BBacnetPoll bBacnetPoll = (BBacnetPoll)this.network().getPollService(this);
            bBacnetPoll.unsubscribe(this);
            this.buildPolledProperties();
            bBacnetPoll.subscribe(this);
            return;
        }
        if (property.equals((Object)pollFrequency) && this.isSubscribed()) {
            object = (BBacnetPoll)this.network().getPollService(this);
            ((BBacnetPoll)object).unsubscribe(this);
            ((BBacnetPoll)object).subscribe(this);
        }
        if (context == BacnetConst.noWrite) return;
        if (Flags.isReadonly((BComplex)this, (Slot)property)) return;
        if (property.getFacets().getFacet(PID) == null) return;
        if (this.device().isServiceSupported("writePropertyMultiple")) {
            object = this.wpmList;
            synchronized (object) {
                this.wpmList.add(property);
                if (this.wpmTkt != null) return;
                this.wpmTkt = Clock.schedule((BComponent)this, (BRelTime)WPM_DELAY, (Action)download, (BValue)new BDownloadParameters());
                return;
            }
        }
        try {
            this.writeProperty(property);
            return;
        }
        catch (BacnetException bacnetException) {
            log.warning("Unable to write BACnet property " + property + " in " + this + ':' + (Object)((Object)bacnetException));
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        Object object;
        Object object2;
        if (slot.equals((Object)objectId)) {
            BExtensibleEnumList bExtensibleEnumList;
            if (!this.isMounted()) {
                return super.getSlotFacets(slot);
            }
            object2 = BBacnetObjectType.getObjectIdFacets(this.getObjectType().getOrdinal());
            if (object2 != null) {
                return object2;
            }
            object = this.device();
            if (object != null && (bExtensibleEnumList = ((BBacnetDevice)object).getEnumerationList()) != null) {
                return bExtensibleEnumList.getObjectTypeFacets();
            }
        }
        if (slot.equals((Object)objectType) && (object2 = (BBacnetDevice)this.getDevice()) != null && (object = ((BBacnetDevice)object2).getEnumerationList()) != null) {
            return ((BExtensibleEnumList)((Object)object)).getObjectTypeFacets();
        }
        if (slot.getName().equals(BBacnetPropertyIdentifier.statusFlags.getTag())) {
            return BacnetBitStringUtil.BACNET_STATUS_FLAGS_FACETS;
        }
        if (slot.getName().equals(BBacnetPropertyIdentifier.eventEnable.getTag())) {
            return BacnetBitStringUtil.BACNET_EVENT_TRANSITION_BITS_FACETS;
        }
        if (slot.getName().equals(BBacnetPropertyIdentifier.ackedTransitions.getTag())) {
            return BacnetBitStringUtil.BACNET_EVENT_TRANSITION_BITS_FACETS;
        }
        if (slot.getName().equals(BBacnetPropertyIdentifier.limitEnable.getTag())) {
            return BacnetBitStringUtil.BACNET_LIMIT_ENABLE_FACETS;
        }
        return super.getSlotFacets(slot);
    }

    public void subscribed() {
        if (!this.isRunning()) {
            return;
        }
        ((BBacnetPoll)this.network().getPollService(this)).subscribe(this);
        this.upload(new BUploadParameters(false));
    }

    public void unsubscribed() {
        if (!this.isRunning()) {
            return;
        }
        ((BBacnetPoll)this.network().getPollService(this)).unsubscribe(this);
    }

    public void doUpload(BUploadParameters bUploadParameters, Context context) {
        BComponentSpace bComponentSpace;
        BStatus bStatus = this.getStatus();
        if (!this.device().getEnabled() || bStatus.isDown()) {
            return;
        }
        if (!this.getObjectId().isValid()) {
            return;
        }
        this.setStatus(BStatus.make((int)(bStatus.getBits() | 0x10), (BFacets)BFacets.make((String)"upload", (String)"PENDING")));
        if (!this.device().isServiceSupported("readPropertyMultiple")) {
            this.uploadIndividual(new NReadAccessSpec(this.getObjectId(), this.device().getPossibleProperties(this.getObjectId())));
        } else {
            ListIterator listIterator;
            bComponentSpace = new Vector();
            bComponentSpace.add(new NReadAccessSpec(this.getObjectId(), 8));
            Vector vector = null;
            boolean bl = false;
            try {
                vector = BBacnetObject.client().readPropertyMultiple(this.device().getAddress(), (Vector)bComponentSpace);
                if (vector == null) {
                    return;
                }
                listIterator = ((NReadAccessResult)vector.elementAt(0)).getResults();
                this.updateProperties(listIterator);
                bl = true;
            }
            catch (Exception exception) {
                log.trace("Exception uploading " + this + " using rpm(ALL):" + exception);
            }
            if (!bl) {
                try {
                    bComponentSpace.clear();
                    bComponentSpace.add(new NReadAccessSpec(this.getObjectId(), 105));
                    vector = BBacnetObject.client().readPropertyMultiple(this.device().getAddress(), (Vector)bComponentSpace);
                    listIterator = ((NReadAccessResult)vector.elementAt(0)).getResults();
                    this.updateProperties(listIterator);
                    bComponentSpace.clear();
                    bComponentSpace.add(new NReadAccessSpec(this.getObjectId(), 80));
                    vector = BBacnetObject.client().readPropertyMultiple(this.device().getAddress(), (Vector)bComponentSpace);
                    listIterator = ((NReadAccessResult)vector.elementAt(0)).getResults();
                    this.updateProperties(listIterator);
                    bl = true;
                }
                catch (Exception exception) {
                    log.trace("Exception uploading " + this + " using rpm(REQ/OPT):" + exception);
                }
            }
            if (!bl) {
                this.uploadIndividual(new NReadAccessSpec(this.getObjectId(), this.device().getPossibleProperties(this.getObjectId())));
            }
        }
        this.setOutputFacets();
        bComponentSpace = this.getComponentSpace();
        if (bComponentSpace != null) {
            bComponentSpace.update((BComponent)this, 0);
        }
        this.buildPolledProperties();
        this.setStatus(BStatus.ok);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doDownload(BDownloadParameters bDownloadParameters, Context context) {
        int n;
        boolean bl;
        Property[] propertyArray;
        block16: {
            Object object;
            propertyArray = null;
            HashSet hashSet = this.wpmList;
            synchronized (hashSet) {
                if (this.wpmTkt != null) {
                    this.wpmTkt.cancel();
                }
                this.wpmTkt = null;
                propertyArray = new Property[this.wpmList.size()];
                this.wpmList.toArray(propertyArray);
                this.wpmList.clear();
                // MONITOREXIT @DISABLED, blocks:[0, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var4_4
                bl = false;
                n = -1;
                if (!this.device().isServiceSupported("writePropertyMultiple")) break block16;
            }
            try {
                NWriteAccessSpec nWriteAccessSpec = new NWriteAccessSpec(this.getObjectId());
                int n2 = 0;
                while (true) {
                    if (n2 >= propertyArray.length) {
                        object = new Vector();
                        ((Vector)object).add(nWriteAccessSpec);
                        BBacnetObject.client().writePropertyMultiple(this.device().getAddress(), (Vector)object);
                        return;
                    }
                    Property property = propertyArray[n2];
                    BacnetPropertyData bacnetPropertyData = this.getPropertyData(property);
                    if (bacnetPropertyData != NOT_BACNET_PROPERTY && bacnetPropertyData.propertyId != 75 && bacnetPropertyData.propertyId != 79) {
                        nWriteAccessSpec.addPropertyValue(bacnetPropertyData.propertyId, AsnUtil.toAsn(this.get(property)));
                    }
                    ++n2;
                }
            }
            catch (ErrorException errorException) {
                object = MessageFormat.format("BACnet Error downloading " + this + ":\nFailed write for {0}:", errorException.getErrorParameters());
                n = ((BBacnetObjectPropertyReference)errorException.getErrorParameters()[0]).getPropertyId();
                log.message((String)object + (Object)((Object)errorException));
            }
            catch (BacnetException bacnetException) {
                log.message("BacnetException downloading " + this + ':', (Throwable)((Object)bacnetException));
            }
        }
        if (bl) return;
        boolean bl2 = true;
        int n3 = 0;
        while (n3 < propertyArray.length) {
            block18: {
                block17: {
                    if (!bl2) break block17;
                    if (n != ((BInteger)propertyArray[n3].getFacets().getFacet(PID)).getInt()) break block18;
                    bl2 = false;
                }
                try {
                    this.writeProperty(propertyArray[n3]);
                }
                catch (Exception exception) {
                    System.out.println("Cannot write property " + propertyArray[n3] + " in " + this + ':' + exception);
                }
            }
            ++n3;
        }
    }

    public BValue doReadBacnetProperty(BEnum bEnum) throws BacnetException {
        Property property = this.lookupBacnetProperty(bEnum.getOrdinal());
        if (property != null) {
            this.readProperty(property);
            return this.get(property);
        }
        return null;
    }

    public void doWriteBacnetProperty(BEnum bEnum) throws BacnetException {
        Property property = this.lookupBacnetProperty(bEnum.getOrdinal());
        if (property != null) {
            this.writeProperty(property);
        }
    }

    protected final BBacnetNetwork network() {
        return this.config != null ? this.config.network() : null;
    }

    public final BBacnetDevice device() {
        return this.config != null ? this.config.device() : null;
    }

    protected final BBacnetConfigDeviceExt config() {
        return this.config;
    }

    private static final BBacnetClientLayer client() {
        return ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient();
    }

    public String toString(Context context) {
        return this.getName() + " [" + this.getObjectId().toString(context) + ']';
    }

    public Property getPresentValueProperty() {
        return null;
    }

    protected void setOutputFacets() {
    }

    protected boolean shouldPoll(int n) {
        return true;
    }

    protected byte[] toEncodedValue(BacnetPropertyData bacnetPropertyData, Property property) {
        return AsnUtil.toAsn(bacnetPropertyData.getAsnType(), this.get(property));
    }

    public void readProperty(Property property) throws BacnetException {
        BacnetPropertyData bacnetPropertyData = this.getPropertyData(property);
        if (bacnetPropertyData == NOT_BACNET_PROPERTY) {
            return;
        }
        if (property.getType() == BBacnetArray.TYPE) {
            this.readArrayProperty(property, bacnetPropertyData);
        } else {
            byte[] byArray = null;
            byArray = BBacnetObject.client().readProperty(this.device().getAddress(), this.getObjectId(), bacnetPropertyData.getPropertyId());
            this.set(property, AsnUtil.fromAsn(bacnetPropertyData.getAsnType(), byArray, this.get(property)), BacnetConst.noWrite);
        }
    }

    public void writeProperty(Property property) throws BacnetException {
        BacnetPropertyData bacnetPropertyData = this.getPropertyData(property);
        if (bacnetPropertyData == NOT_BACNET_PROPERTY) {
            return;
        }
        if (!this.device().isServiceSupported("writeProperty")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.writeProperty"));
        }
        BBacnetObject.client().writeProperty(this.device().getAddress(), this.getObjectId(), bacnetPropertyData.getPropertyId(), -1, this.toEncodedValue(bacnetPropertyData, property), -1);
    }

    public void writeProperty(Property property, int n, byte[] byArray) throws BacnetException {
        BacnetPropertyData bacnetPropertyData = this.getPropertyData(property);
        if (bacnetPropertyData == NOT_BACNET_PROPERTY) {
            return;
        }
        if (!this.device().isServiceSupported("writeProperty")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.writeProperty"));
        }
        BBacnetObject.client().writeProperty(this.device().getAddress(), this.getObjectId(), bacnetPropertyData.getPropertyId(), n, byArray);
    }

    public void addListElement(Property property, BValue bValue) throws BacnetException {
        BacnetPropertyData bacnetPropertyData = this.getPropertyData(property);
        if (bacnetPropertyData == NOT_BACNET_PROPERTY) {
            return;
        }
        if (!this.get(property).getType().is(BBacnetListOf.TYPE)) {
            return;
        }
        if (!this.device().isServiceSupported("writeProperty")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.addListElement"));
        }
        byte[] byArray = AsnUtil.toAsn(bValue);
        BBacnetObject.client().addListElement(this.device().getAddress(), this.getObjectId(), bacnetPropertyData.getPropertyId(), -1, byArray);
    }

    public void removeListElement(Property property, BValue bValue) throws BacnetException {
        BacnetPropertyData bacnetPropertyData = this.getPropertyData(property);
        if (bacnetPropertyData == NOT_BACNET_PROPERTY) {
            return;
        }
        if (!this.get(property).getType().is(BBacnetListOf.TYPE)) {
            return;
        }
        if (!this.device().isServiceSupported("writeProperty")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.removeListElement"));
        }
        byte[] byArray = AsnUtil.toAsn(bValue);
        BBacnetObject.client().removeListElement(this.device().getAddress(), this.getObjectId(), bacnetPropertyData.getPropertyId(), -1, byArray);
    }

    public final int getPollableType() {
        return 2;
    }

    public final boolean poll() {
        System.out.println("BBacnetObject.poll() is DEPRECATED!!!");
        return false;
    }

    public final void readOk() {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        this.setFaultCause("");
    }

    public final void readFail(String string) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(string);
    }

    public final void fromEncodedValue(byte[] byArray, BStatus bStatus, Context context) {
        try {
            Property property = this.lookupBacnetProperty(((PollListEntry)context).getPropertyId());
            BInteger bInteger = (BInteger)property.getFacets().getFacet(ASN_TYPE);
            BValue bValue = AsnUtil.fromAsn(bInteger.getInt(), byArray, this.get(property));
            BacUtil.set((BComponent)this, property, bValue, BacnetConst.noWrite);
            this.readOk();
        }
        catch (AsnException asnException) {
            this.readFail(asnException.toString());
            if (log.isTraceOn()) {
                asnException.printStackTrace();
                log.trace("Exception decoding value for " + this + " [" + context + "]:" + ByteArrayUtil.toHexString((byte[])byArray), (Throwable)((Object)asnException));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public final PollListEntry[] getPollListEntries() {
        Object[] objectArray = new PollListEntry[this.polledProperties.size()];
        this.polledProperties.copyInto(objectArray);
        return objectArray;
    }

    private final void checkConfig() {
        BBacnetConfigDeviceExt bBacnetConfigDeviceExt = null;
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BBacnetConfigDeviceExt) {
                bBacnetConfigDeviceExt = (BBacnetConfigDeviceExt)bComplex;
                break;
            }
            bComplex = bComplex.getParent();
        }
        this.config = bBacnetConfigDeviceExt;
    }

    private final void readArrayProperty(Property property, BacnetPropertyData bacnetPropertyData) throws BacnetException {
        block10: {
            Object object;
            int n;
            ByteArrayOutputStream byteArrayOutputStream;
            boolean bl;
            int n2;
            int n3;
            BBacnetObjectIdentifier bBacnetObjectIdentifier;
            BBacnetAddress bBacnetAddress;
            block11: {
                bBacnetAddress = this.device().getAddress();
                bBacnetObjectIdentifier = this.getObjectId();
                n3 = bacnetPropertyData.getPropertyId();
                byte[] byArray = null;
                try {
                    byArray = BBacnetObject.client().readProperty(bBacnetAddress, bBacnetObjectIdentifier, n3);
                    this.set(property, AsnUtil.fromAsn(bacnetPropertyData.getAsnType(), byArray, this.get(property)), BacnetConst.noWrite);
                    break block10;
                }
                catch (Exception exception) {
                    log.trace("Exception reading property " + property + " in object " + this + ": " + exception + "\n building array in groups...");
                    n2 = AsnUtil.fromAsnInteger(BBacnetObject.client().readProperty(bBacnetAddress, bBacnetObjectIdentifier, n3, 0));
                    bl = false;
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    n = 1;
                    if (!this.device().isServiceSupported("readPropertyMultiple")) break block11;
                    try {
                        BBacnetArray bBacnetArray = (BBacnetArray)this.get(property);
                        object = bBacnetArray.getArrayTypeSpec();
                        int n4 = AsnUtil.getSize(object);
                        int n5 = 9;
                        int n6 = 8;
                        int n7 = this.device().getMaxAPDULengthAccepted();
                        int n8 = BBacnetNetwork.localDevice().getMaxAPDULengthAccepted();
                        if (n7 > n8) {
                            n7 = n8;
                        }
                        int n9 = 10;
                        int n10 = (n7 - n5 - n9) / (n4 + n6);
                        do {
                            Vector<NBacnetPropertyReference> vector = new Vector<NBacnetPropertyReference>();
                            int n11 = n;
                            while (n11 < n + n10 && n11 <= n2) {
                                vector.add(new NBacnetPropertyReference(n3, n11));
                                ++n11;
                            }
                            Vector vector2 = BBacnetObject.client().readPropertyMultiple(bBacnetAddress, bBacnetObjectIdentifier, vector);
                            int n12 = 0;
                            while (n12 < vector2.size()) {
                                NReadPropertyResult nReadPropertyResult = (NReadPropertyResult)vector2.get(n12);
                                byte[] byArray2 = nReadPropertyResult.getPropertyValue();
                                byteArrayOutputStream.write(byArray2, 0, byArray2.length);
                                ++n;
                                ++n12;
                            }
                        } while (n <= n2);
                        bl = true;
                    }
                    catch (Exception exception2) {
                        log.trace("Exception reading property " + property + " in object " + this + " in groups: " + exception2 + "\n building array element by element...");
                    }
                }
            }
            if (!bl) {
                int n13 = n;
                while (n13 <= n2) {
                    object = BBacnetObject.client().readProperty(bBacnetAddress, bBacnetObjectIdentifier, n3, n13);
                    byteArrayOutputStream.write((byte[])object, 0, ((BTypeSpec)object).length);
                    ++n13;
                }
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.set(property, AsnUtil.fromAsn(bacnetPropertyData.getAsnType(), byArray, this.get(property)), BacnetConst.noWrite);
        }
    }

    private final boolean readArray(BBacnetArray bBacnetArray, int n, PropertyInfo propertyInfo) {
        try {
            BBacnetAddress bBacnetAddress = this.device().getAddress();
            BBacnetObjectIdentifier bBacnetObjectIdentifier = this.getObjectId();
            int n2 = 0;
            try {
                n2 = AsnUtil.fromAsnUnsignedInt(BBacnetObject.client().readProperty(bBacnetAddress, bBacnetObjectIdentifier, n, 0));
            }
            catch (Exception exception) {
                log.trace("Cannot get array size", (Throwable)exception);
                return false;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n3 = 1;
            try {
                byte[] byArray;
                n3 = 1;
                while (n3 <= n2) {
                    byArray = BBacnetObject.client().readProperty(bBacnetAddress, bBacnetObjectIdentifier, n, n3);
                    byteArrayOutputStream.write(byArray, 0, byArray.length);
                    ++n3;
                }
                byArray = byteArrayOutputStream.toByteArray();
                AsnInputStream asnInputStream = new AsnInputStream(byArray);
                bBacnetArray.readAsn(asnInputStream);
                return true;
            }
            catch (Exception exception) {
                log.trace("Exception reading array element " + n3 + ':', (Throwable)exception);
                return false;
            }
        }
        catch (Throwable throwable) {
            log.trace("Unable to build BacnetArray for property " + n, throwable);
            return false;
        }
    }

    protected void buildPolledProperties() {
        BBacnetPoll bBacnetPoll = (BBacnetPoll)this.network().getPollService(this);
        if (this.isSubscribed()) {
            bBacnetPoll.unsubscribe(this);
        }
        SlotCursor slotCursor = this.getProperties();
        BInteger bInteger = null;
        this.polledProperties = new Vector();
        while (slotCursor.next()) {
            Property property = slotCursor.property();
            bInteger = (BInteger)property.getFacets().getFacet(PID);
            if (bInteger == null || !this.shouldPoll(bInteger.getInt())) continue;
            this.polledProperties.add(new PollListEntry(this.getObjectId(), bInteger.getInt(), this.device(), this));
        }
        if (this.isSubscribed()) {
            bBacnetPoll.subscribe(this);
        }
    }

    private final void updateProperties(Iterator iterator) {
        while (iterator.hasNext()) {
            NReadPropertyResult nReadPropertyResult = (NReadPropertyResult)iterator.next();
            int n = nReadPropertyResult.getPropertyId();
            Property property = this.lookupBacnetProperty(n);
            try {
                if (property == null) {
                    if (nReadPropertyResult.isError()) continue;
                    PropertyInfo propertyInfo = this.getPropertyInfo(n);
                    BValue bValue = AsnUtil.asnToValue(propertyInfo, nReadPropertyResult.getPropertyValue());
                    String string = SlotPath.escape((String)propertyInfo.getName());
                    property = this.add(string, bValue, 0, BBacnetObject.makeFacets(propertyInfo, bValue), null);
                    if (this.shouldPoll(n)) {
                        this.polledProperties.add(new PollListEntry(this.getObjectId(), n, this.device(), this));
                    }
                    if (this.device().getEnumerationList().getPropertyIdRange().isOrdinal(n)) continue;
                    this.device().getEnumerationList().addNewPropertyId(propertyInfo.getName(), n);
                    continue;
                }
                if (nReadPropertyResult.isError()) {
                    log.trace("Error uploading property " + property + ':' + nReadPropertyResult.getPropertyAccessError());
                    continue;
                }
                this.set(property, AsnUtil.fromAsn(((BInteger)property.getFacets().getFacet(ASN_TYPE)).getInt(), nReadPropertyResult.getPropertyValue(), this.get(property)), BacnetConst.noWrite);
            }
            catch (AsnException asnException) {
                log.message("Unable to convert encoded value: prop=" + property + ", id=" + n + ", val=" + ByteArrayUtil.toHexString((byte[])nReadPropertyResult.getPropertyValue()) + '\n' + (Object)((Object)asnException));
            }
            catch (Exception exception) {
                if (log.isTraceOn()) {
                    exception.printStackTrace();
                }
                log.message("Unable to add/update property: prop=" + property + ", id=" + n + ", val=" + ByteArrayUtil.toHexString((byte[])nReadPropertyResult.getPropertyValue()) + '\n' + exception);
            }
        }
    }

    private final void uploadIndividual(NReadAccessSpec nReadAccessSpec) {
        PropertyReference[] propertyReferenceArray = nReadAccessSpec.getListOfPropertyReferences();
        int n = 0;
        while (n < propertyReferenceArray.length) {
            block10: {
                int n2 = propertyReferenceArray[n].getPropertyId();
                try {
                    Property property = this.lookupBacnetProperty(n2);
                    if (property != null) {
                        this.readProperty(property);
                        break block10;
                    }
                    byte[] byArray = null;
                    PropertyInfo propertyInfo = this.getPropertyInfo(n2);
                    String string = SlotPath.escape((String)propertyInfo.getName());
                    try {
                        byArray = BBacnetObject.client().readProperty(this.device().getAddress(), this.getObjectId(), n2);
                        BValue bValue = AsnUtil.asnToValue(propertyInfo, byArray);
                        property = this.add(string, bValue, 0, BBacnetObject.makeFacets(propertyInfo, bValue), BacnetConst.noWrite);
                    }
                    catch (BacnetException bacnetException) {
                        if (bacnetException instanceof ErrorException && ((ErrorException)bacnetException).getErrorType().getErrorCode() == 32) {
                            log.trace("Unknown Property " + n2 + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)bacnetException));
                            break block10;
                        }
                        if (propertyInfo.isArray()) {
                            BBacnetArray bBacnetArray = new BBacnetArray();
                            bBacnetArray.setArrayTypeSpec(BTypeSpec.make((String)propertyInfo.getType()));
                            this.readArray(bBacnetArray, n2, propertyInfo);
                            property = this.add(string, (BValue)bBacnetArray, 0, BBacnetObject.makeFacets(propertyInfo, (BValue)bBacnetArray), BacnetConst.noWrite);
                        }
                        log.message("BacnetException uploading propertyId " + n2 + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)bacnetException));
                    }
                    if (this.shouldPoll(n2)) {
                        this.polledProperties.add(new PollListEntry(this.getObjectId(), n2, this.device(), this));
                    }
                }
                catch (TransactionException transactionException) {
                    this.device().ping();
                    log.trace("TransactionException uploading object " + (Object)((Object)this.getObjectId()) + " in " + this.device() + ": " + transactionException);
                    break;
                }
                catch (Exception exception) {
                    log.trace("Exception uploading propertyId " + n2 + " in object " + (Object)((Object)this.getObjectId()) + ": " + exception);
                }
            }
            ++n;
        }
    }

    private final PropertyInfo getPropertyInfo(int n) {
        PropertyInfo propertyInfo = this.device().getPropertyInfo(this.getObjectId().getObjectType(), n);
        if (propertyInfo == null) {
            propertyInfo = new PropertyInfo(BBacnetPropertyIdentifier.tag(n), n, -6);
        }
        return propertyInfo;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BacnetObject", 2);
        spyWriter.prop((Object)"config", (Object)this.config);
        if (this.polledProperties != null) {
            int n = this.polledProperties.size();
            spyWriter.prop((Object)"polledProperties", n);
            int n2 = 0;
            while (n2 < n) {
                spyWriter.prop((Object)("polledProperties[" + n2 + "]:"), (Object)((PollListEntry)this.polledProperties.get(n2)).debugString());
                ++n2;
            }
        } else {
            spyWriter.prop((Object)"polledProperties", (Object)"NULL");
        }
        spyWriter.prop((Object)"propDataMap", this.propDataMap.size());
        Iterator iterator = this.propDataMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            spyWriter.prop(k, this.propDataMap.get(k));
        }
        spyWriter.endProps();
    }

    private final Property lookupBacnetProperty(int n) {
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.next()) {
            try {
                if (n != ((BInteger)slotCursor.property().getFacets().getFacet(PID)).getInt()) continue;
                return slotCursor.property();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }

    static void init() {
        TypeInfo typeInfo = TYPE.getTypeInfo();
        TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(typeInfo);
        int n = 0;
        while (n < typeInfoArray.length) {
            if (!typeInfoArray[n].equals(typeInfo)) {
                BBacnetObject bBacnetObject = (BBacnetObject)typeInfoArray[n].getInstance();
                int n2 = bBacnetObject.getObjectType().getOrdinal();
                Array array = (Array)byObjectType.get(n2);
                if (array == null) {
                    Class clazz = class$javax$baja$registry$TypeInfo;
                    if (clazz == null) {
                        clazz = BBacnetObject.class("[Ljavax.baja.registry.TypeInfo;", false);
                    }
                    array = new Array(clazz);
                }
                array.add((Object)typeInfoArray[n]);
                byObjectType.put(n2, (Object)array);
            }
            ++n;
        }
        initialized = true;
    }

    protected static BFacets makeFacets(int n, int n2) {
        HashMap<String, BInteger> hashMap = new HashMap<String, BInteger>();
        hashMap.put(PID, BInteger.make((int)n));
        hashMap.put(ASN_TYPE, BInteger.make((int)n2));
        return BFacets.make(hashMap);
    }

    protected static BFacets makeFacets(int n, int n2, Map map) {
        HashMap<String, BInteger> hashMap = new HashMap<String, BInteger>(map);
        hashMap.put(PID, BInteger.make((int)n));
        hashMap.put(ASN_TYPE, BInteger.make((int)n2));
        return BFacets.make(hashMap);
    }

    protected static BFacets makeFacets(int n, int n2, String[] stringArray, BIDataValue[] bIDataValueArray) {
        if (stringArray.length != bIDataValueArray.length) {
            throw new IllegalArgumentException();
        }
        String[] stringArray2 = new String[stringArray.length + 2];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = PID;
        stringArray2[stringArray.length + 1] = ASN_TYPE;
        BIDataValue[] bIDataValueArray2 = new BIDataValue[bIDataValueArray.length + 2];
        System.arraycopy(bIDataValueArray, 0, bIDataValueArray2, 0, bIDataValueArray.length);
        bIDataValueArray2[bIDataValueArray.length] = BInteger.make((int)n);
        bIDataValueArray2[bIDataValueArray.length + 1] = BInteger.make((int)n2);
        return BFacets.make((String[])stringArray2, (BIDataValue[])bIDataValueArray2);
    }

    protected static BFacets makeFacets(PropertyInfo propertyInfo, BValue bValue) {
        HashMap<String, Object> hashMap = propertyInfo.isBitString() ? new HashMap(BacnetBitStringUtil.getBitStringMap(propertyInfo.getBitStringName())) : new HashMap<String, BInteger>();
        hashMap.put(PID, BInteger.make((int)propertyInfo.getId()));
        hashMap.put(ASN_TYPE, BInteger.make((int)propertyInfo.getAsnType()));
        return BFacets.make(hashMap);
    }

    private final BacnetPropertyData getPropertyData(Property property) {
        BFacets bFacets = property.getFacets();
        if (bFacets == null) {
            return NOT_BACNET_PROPERTY;
        }
        if (bFacets.geti(PID, -1) == -1) {
            return NOT_BACNET_PROPERTY;
        }
        BacnetPropertyData bacnetPropertyData = null;
        if (property.isDynamic()) {
            bacnetPropertyData = (BacnetPropertyData)bFacets.getPickle();
            if (bacnetPropertyData == null) {
                bacnetPropertyData = BBacnetObject.makePropertyData(bFacets);
                this.setFacets((Slot)property, BFacets.makePickle((BFacets)bFacets, (Object)bacnetPropertyData));
            }
        } else {
            bacnetPropertyData = (BacnetPropertyData)this.propDataMap.get(bFacets);
            if (bacnetPropertyData == null) {
                bacnetPropertyData = BBacnetObject.makePropertyData(bFacets);
                this.propDataMap.put(bFacets, bacnetPropertyData);
            }
        }
        return bacnetPropertyData;
    }

    private static final BacnetPropertyData makePropertyData(BFacets bFacets) {
        int n = -1;
        int n2 = 0;
        BObject bObject = bFacets.getFacet(PID);
        if (bObject != null) {
            n = ((BInteger)bObject).getInt();
        }
        if ((bObject = bFacets.getFacet(ASN_TYPE)) != null) {
            n2 = ((BInteger)bObject).getInt();
        }
        return BacnetPropertyData.make(n, n2);
    }

    static void d(Object object) {
        System.out.println("" + object);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.polledProperties = null;
        this.propDataMap = new HashMap();
        this.wpmList = new HashSet();
        this.wpmTkt = null;
    }

    public BBacnetObject() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$bacnet$BBacnetObject;
        if (clazz == null) {
            clazz = class$javax$baja$bacnet$BBacnetObject = BBacnetObject.class("[Ljavax.baja.bacnet.BBacnetObject;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://bacnet/com/tridium/bacnet/ui/icons/bacObject.png");
        lex = Lexicon.make((String)"bacnet");
        log = Log.getLog((String)"bacnet.client");
        plog = Log.getLog((String)"bacnet.point");
        byObjectType = new IntHashMap();
        initialized = false;
        WPM_DELAY = BRelTime.make((long)20L);
        NOT_BACNET_PROPERTY = new BacnetPropertyData(-1, 0);
    }

    public static class BacnetPropertyData {
        int propertyId;
        int asnType;

        static BacnetPropertyData make(int n, int n2) {
            if (n == -1 && n2 == 0) {
                return NOT_BACNET_PROPERTY;
            }
            return new BacnetPropertyData(n, n2);
        }

        public int getPropertyId() {
            return this.propertyId;
        }

        public int getAsnType() {
            return this.asnType;
        }

        private BacnetPropertyData(int n, int n2) {
            this.propertyId = n;
            this.asnType = n2;
        }
    }
}

